/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.ip;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class InsertVRRPOpV6
extends InsertForm {
    static final int INTERFACE = 2;
    static final int PREEMPT = 5;

    public InsertVRRPOpV6(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 2) {
            return new JLabel("Interface:", 4);
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected void buildForm() {
        super.buildForm();
        ((FieldPanel)this._values[2]).getField().addFocusListener(new PreemptListener());
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 2) {
            FieldPanel f = new FieldPanel(mibNode.getMaxWidth(), (JComponent)new MyInterfaceMenuButton(null, this.getPeer(), 2));
            return f;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    private void updatePreempt() {
        String ifIndex = this.getComponentText(2);
        if (ifIndex.equals("")) {
            return;
        }
        try {
            int type = IfIndexUtil.getType(Discover.getRoot().nameToIfIndex(ifIndex));
            ((JCheckBox)this._values[5]).setEnabled(type == 8 || type == 5);
        }
        catch (IllegalArgumentException ex) {
            Util.errorMessage((Component)this._parent, ex.getMessage());
        }
    }

    class MyInterfaceMenuButton
    extends VsanIdMenuButton {
        MyInterfaceMenuButton(JMenu menu, SnmpPeer peer, int type) {
            super(menu, peer, type, Discover.getRoot());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            if (e.getSource() instanceof JMenuItem && this.getParent() instanceof FieldPanel) {
                InsertVRRPOpV6.this.updatePreempt();
            }
        }
    }

    class PreemptListener
    extends FocusAdapter {
        @Override
        public void focusLost(FocusEvent e) {
            InsertVRRPOpV6.this.updatePreempt();
        }
    }
}

