/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DMPanel;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.SharedUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.Cell;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;

public class EditEthForm
extends EditForm {
    protected int _ipAddress;
    String _oldIpAddress;
    static final int[] _ciiIPIfAddressStatusOid = MibNode.get("ciiIPIfAddressStatus").getOid();
    static final int[] _ipAddressOid = MibNode.get("ciiIPIfAddressPrefixLength").getOid();
    static final int[] _isnsProfileOid = MibNode.get("iscsiGigEIfIsnsServerProfileName").getOid();
    SnmpPDU _ipAddressPDU;
    boolean _showIpAddressCol = Discover.isSysVersionlessThan("3.0(0)");

    public EditEthForm(String[] vars, boolean showIpAddressCol) {
        super(vars);
        this._ipAddress = this.getVarIndex("ciiIPIfAddressPrefixLength");
        if (!this._showIpAddressCol && this._ipAddress != -1) {
            this.setRemoveMibVars(new String[]{"ciiIPIfAddressPrefixLength"});
        }
    }

    @Override
    protected void buildTable() {
        super.buildTable();
        boolean[] isEditable = this._tableModel.getEditable();
        isEditable[this._ipAddress + 1] = true;
        this._tableModel.setEditable(isEditable);
        this._table.getSelectionModel().setSelectionMode(2);
    }

    @Override
    protected void build() {
        super.build();
        this._buttons[0].setVisible(Discover.isSysVersionGreaterThanEqual("3.0(0)"));
    }

    @Override
    protected boolean isEditable(MibNode mibNode) {
        if (DmId.isN5K(Discover.getSysObjectID()) && (Discover.getRoot().getType(this.getIndex()[0]) == 2 || Discover.getRoot().getType(this.getIndex()[0]) == 26 || Discover.getRoot().getType(this.getIndex()[0]) == 31)) {
            return false;
        }
        if (SnmpOID.equals(mibNode.getOid(), _ipAddressOid)) {
            return true;
        }
        return super.isEditable(mibNode);
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt("IP Address(es)...", 0);
        return btns;
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("x");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.enableButton('x', this._table.getSelectedRowCount() > 0);
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        super.callback(session, reqid, pdu, timedOut);
        this.enableButton('x', !this.isMultiple());
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == this._ipAddress) {
            return new JTextField();
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void showError(int index, boolean isError) {
        if (index >= this._ipAddress) {
            ++index;
        }
        super.showError(index, isError);
    }

    @Override
    protected void setComponentValue(int i, SnmpVar v) {
        if (i >= this._ipAddress) {
            ++i;
        }
        super.setComponentValue(i, v);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this._ipAddress) {
            String ipAddress = ((JTextField)this._values[index]).getText();
            int slash = ipAddress.indexOf(47);
            if (!ipAddress.equals("n/a") && !ipAddress.equals("")) {
                if (slash != -1) {
                    ipAddress = ipAddress.substring(0, slash);
                }
                try {
                    byte[] b = SnmpIpAddress.parse(ipAddress);
                }
                catch (NumberFormatException ex) {
                    throw new NumberFormatException(this.trim(this._vars[index]) + ' ' + ex.getMessage());
                }
            }
            return new SnmpString(((JTextField)this._values[index]).getText());
        }
        return super.getComponentValue(index);
    }

    @Override
    protected void updateForm(SnmpPDU pdu) {
        super.updateForm(pdu);
        int[][] ipAddressIdx = new int[][]{this.getIndex()};
        try {
            String[] ipAddress = EditEthForm.getIpAddress(this.getPeer(), ipAddressIdx, this._mibNodes[this._ipAddress].getOid());
            this._oldIpAddress = ipAddress[0];
            if (this._values[this._ipAddress] instanceof JTextField) {
                ((JTextField)this._values[this._ipAddress]).setText(ipAddress[0]);
            } else if (this._values[this._ipAddress] instanceof JLabel) {
                ((JLabel)this._values[this._ipAddress]).setText(ipAddress[0]);
            }
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this.getParent(), ex.getMessage());
        }
    }

    @Override
    protected void updateTable() {
        if (this._data.size() > 0) {
            int[][] ipAddressIdx = new int[this._data.size()][];
            for (int i = 0; i < this._data.size(); ++i) {
                ipAddressIdx[i] = this._tableModel.getIndex(i);
            }
            try {
                String[] ipAddress = EditEthForm.getIpAddress(this.getPeer(), ipAddressIdx, this._mibNodes[this._ipAddress + 1].getOid());
                for (int i = 0; i < this._data.size() && i < ipAddress.length; ++i) {
                    Object[] row = (Object[])this._data.elementAt(i);
                    row[this._ipAddress + 1] = ipAddress[i];
                }
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this.getParent(), ex.getMessage());
            }
        }
        super.updateTable();
    }

    @Override
    protected void buildRow(Object[] row, SnmpPDU pdu, int rowNo) {
        for (int i = 1; i < this._mibNodes.length && i <= pdu.getVariables().size(); ++i) {
            int varIdx = i > this._ipAddress ? i + 1 : i;
            row[varIdx] = this._tableModel.toCellEditTable(this._mibNodes[varIdx], pdu, pdu.getVariables().get(i - 1), this._vars[varIdx - 1], null, rowNo, i);
        }
    }

    @Override
    protected void sendGetPdu(SnmpPDU pdu) throws SnmpException {
        pdu.getVariables().remove(this._ipAddress);
        this.getPeer().send(pdu, this);
    }

    @Override
    protected void sendGetMultiPdu(SnmpPDU pdu, int rowNo) throws SnmpException {
        pdu.getVariables().remove(this._ipAddress);
        this.getPeer().send(pdu, this);
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        Array changedCells = null;
        this._ipAddressPDU = new SnmpPDU(-93, new VarBindList());
        if (this.isMultiple()) {
            changedCells = this._tableModel.getChanged();
        }
        for (int i = pdu.getVariables().size() - 1; i >= 0; --i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            SnmpOID oid = vb.getOid();
            if (oid.startsWith(_ipAddressOid)) {
                pdu.getVariables().remove(i);
                int index = oid.getValue()[oid.getValue().length - 1];
                String newIpAddress = ((SnmpString)vb.getVar()).toString();
                if (newIpAddress.equals("")) {
                    newIpAddress = "n/a";
                }
                if (this.isMultiple() && changedCells != null) {
                    Cell cell = (Cell)changedCells.elementAt(i);
                    Object[] values = (Object[])this._data.elementAt(cell._row);
                    Object[] changed = (Object[])values[this._tableModel.getHeaders().length];
                    String oldIpAddress = (String)changed[this._ipAddress + 1];
                    SharedUtil.getSetIpAddressPDU(pdu, this._ipAddressPDU, index, newIpAddress, oldIpAddress);
                    continue;
                }
                SharedUtil.getSetIpAddressPDU(pdu, this._ipAddressPDU, index, newIpAddress, this._oldIpAddress);
                continue;
            }
            if (!oid.startsWith(_isnsProfileOid)) continue;
            SnmpVarBind profileVb = pdu.getVariables().get(i);
            SnmpVar profileVar = profileVb.getVar();
            profileVb.setVar(new SnmpString(""));
            VarBindList vbl = pdu.getVariables();
            vbl.add(i + 1, new SnmpVarBind(profileVb.getOid(), profileVar));
        }
        if (pdu.getVariables().size() > 0) {
            super.sendPdu(pdu);
        }
        if (this._ipAddressPDU.getVariables().size() > 0) {
            this.getPeer().set(this._ipAddressPDU);
        }
    }

    public static String[] getIpAddress(SnmpPeer peer, int[][] index, int[] ipAddressOid) throws SnmpException {
        VarBindList vbl = new VarBindList(index.length);
        for (int i = 0; i < index.length; ++i) {
            vbl.add(new SnmpVarBind(new SnmpOID(ipAddressOid, index[i]), null));
        }
        SnmpPDU resp = SnmpFetch.next(peer, vbl);
        String[] ipAddress = new String[resp.getVariables().size()];
        for (int i = 0; i < resp.getVariables().size(); ++i) {
            SnmpVarBind vb = resp.getVariables().get(i);
            int[] oid = vb.getOid().getValue();
            ipAddress[i] = "n/a";
            if (oid.length < _ipAddressOid.length || oid[_ipAddressOid.length] != index[i][0]) continue;
            if (oid[_ipAddressOid.length + 1] == 1) {
                ipAddress[i] = SnmpOID.toString(oid, _ipAddressOid.length + 3, oid.length) + '/' + vb.getVar().toString();
                continue;
            }
            if (oid[_ipAddressOid.length + 1] == 2) {
                int[] addr = new int[16];
                System.arraycopy(oid, _ipAddressOid.length + 3, addr, 0, addr.length);
                ipAddress[i] = SnmpIpAddress.toHexString(oid, _ipAddressOid.length + 3, oid.length) + '/' + vb.getVar().toString();
                continue;
            }
            DefaultLogger._DefLogger.debug((Object)("unknown InetAddressType :" + oid[_ipAddressOid.length + 1]));
        }
        return ipAddress;
    }

    @Override
    protected void fetchSetForm() {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.fetchSetForm();
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'x') {
            DMDialog dlg = null;
            String interfaceInfo = "";
            if (this.isMultiple()) {
                Object gigEIndex;
                int[] selectedRows = this._table.getSelectedRows();
                if (selectedRows.length == 1) {
                    gigEIndex = ((SnmpOID)this._tableModel.getValueAt(selectedRows[0], 0)).getValue();
                    dlg = DialogListener.getInstance().dialogAction("IP_Address", (int[])gigEIndex);
                    interfaceInfo = Discover.getRoot().ifIndexToName((int)gigEIndex[0]);
                } else {
                    gigEIndex = new int[selectedRows.length][0];
                    for (int i = 0; i < selectedRows.length; ++i) {
                        gigEIndex[i] = ((SnmpOID)this._tableModel.getValueAt(selectedRows[i], 0)).getValue();
                    }
                    dlg = DialogListener.getInstance().dialogAction("IP_Address", (int[][])gigEIndex);
                }
            } else {
                int[] gigEIndex = this.getIndex();
                dlg = DialogListener.getInstance().dialogAction("IP_Address", gigEIndex);
                interfaceInfo = Discover.getRoot().ifIndexToName(gigEIndex[0]);
            }
            if (dlg != null) {
                InsertDialog insertD;
                DMPanel p = dlg.getPanel(0);
                if (p != null && (insertD = ((EditTable)p).getInsertDialog()) != null) {
                    insertD.dispose();
                }
                dlg.setParentTable(this);
                dlg.setTitle(Discover.getDeviceName() + " - IPAddress  " + interfaceInfo);
                dlg.setLocation(DialogUtil.getPointOnScreen(new Point(0, 0), (JComponent)e.getSource(), dlg.getSize()));
            }
        } else {
            super.doIt(ch, e);
        }
    }

    @Override
    protected void fetchAllSetRows(Array cells, DmTableModel model) throws SnmpException {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.fetchAllSetRows(cells, model);
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpEthTableModel();
    }

    class SnmpEthTableModel
    extends DmTableModel {
        SnmpEthTableModel() {
        }

        @Override
        protected Object getTextConventionFormat(MibNode mibNode, String tc, SnmpVar v, int row) {
            if (DmId.isN5K(Discover.getSysObjectID()) && tc.equals("TruthValue")) {
                return null;
            }
            return super.getTextConventionFormat(mibNode, tc, v, row);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (DmId.isN5K(Discover.getSysObjectID())) {
                return false;
            }
            return super.isCellEditable(row, col);
        }

        @Override
        public void setNoSuchInstance(int row, int col, boolean isNoSuchInstance) {
            int newCol = col > EditEthForm.this._ipAddress ? col + 1 : col;
            super.setNoSuchInstance(row, newCol, isNoSuchInstance);
        }

        @Override
        protected SnmpVar getChangedCell(int row, int col, MibNode[] mibNodes) throws Exception {
            Object o;
            if (col == EditEthForm.this._ipAddress + 1 && (o = this.getValueAt(row, col)) instanceof String) {
                return new SnmpString((String)o);
            }
            return super.getChangedCell(row, col, mibNodes);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            if (!EditEthForm.this._showIpAddressCol && col == EditEthForm.this._ipAddress + 1) {
                ++col;
            }
            super.setValueAt(aValue, row, col);
        }
    }
}

