/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.EditFormTable;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.EditFc2IscsiTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.EditIscsi2FcTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;

public class EditIscsiNodeTable
extends EditFormTable {
    public int[] _iscsiIndex = new int[2];
    static final int PERMITALL = 0;

    public EditIscsiNodeTable(String[] vars, String[] formVariables) {
        super(vars, formVariables);
    }

    @Override
    protected void setIndex(int[] index) {
        System.arraycopy(index, 0, this._iscsiIndex, 0, this._iscsiIndex.length);
        int[] newIndex = new int[]{index[2]};
        super.setIndex(newIndex);
    }

    @Override
    protected void get(SnmpPDU pdu, int[] index) {
        try {
            int[] newIndex = new int[]{this._iscsiIndex[0], this._iscsiIndex[1], this.getListIndex(this.getListIndexOid())};
            this.setIndex(newIndex);
            index = this.getIndex();
        }
        catch (SnmpException ex) {
            // empty catch block
        }
        if (index[0] == 0) {
            this._data.clear();
            this.setStatus("0 row(s)");
            Dimension d = this._table.calcPreferredSize();
            this._scrollPane.setPreferredSize(d);
            if (d.width > 1008) {
                this._table.setAutoResizeMode(0);
            }
            this._table.getTableHeader().resizeAndRepaint();
            this._tableModel.fireTableDataChanged();
            this.enableButton('A', false);
            this.enableButton('u', false);
            this.enableButton('P', false);
            this.enableButton('c', false);
            this.enableButton('E', false);
            this.enableButton('p', false);
            this.enableButton('D', false);
            this.setCFSButton();
            return;
        }
        super.get(pdu, index);
    }

    @Override
    protected void formGet() {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
        pdu.addNull(new SnmpOID(MibNode.get(this._formVariables[0]).getOid(), this._iscsiIndex));
        try {
            this.sendGetPdu(pdu);
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
        }
    }

    @Override
    protected void formSet() throws Exception {
        int permitAll = ((RadioButtonPanel)this._formVars[0]).getSelected() + 1;
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(MibNode.get(this._formVariables[0]).getOid(), this._iscsiIndex), new SnmpInt(permitAll));
        this.getPeer().set(pdu);
    }

    @Override
    protected void delete() throws SnmpException {
        super.delete();
        if (this._data.size() == 0) {
            this.unSetListIndex(this.getListIndexOid());
            this.unSetPersistent(this.getPersistentOid());
            this.updateCFSStatus();
        }
    }

    int[] getListIndexOid() {
        return MibNode.get("fc2IscsiNodePermitListIndex").getOid();
    }

    int[] getPersistentOid() {
        return null;
    }

    int getListIndex(int[] listIndexOid) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
        pdu.addVar(new SnmpOID(listIndexOid, this._iscsiIndex));
        SnmpPDU resp = this.getPeer().send(pdu);
        return ((SnmpInt)resp.getVariables().get(0).getVar()).getValue();
    }

    void unSetListIndex(int[] listIndexOid) throws SnmpException {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(1));
        pdu.addVar(new SnmpOID(listIndexOid, this._iscsiIndex), new SnmpInt(0));
        this.sendPdu(pdu);
    }

    void unSetPersistent(int[] persistentOid) throws SnmpException {
        if (persistentOid == null) {
            return;
        }
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(1));
        pdu.addVar(new SnmpOID(persistentOid, this._iscsiIndex), new SnmpInt(2));
        this.sendPdu(pdu);
    }

    @Override
    protected void get() {
        this.updateCFSStatus();
        super.get();
    }

    @Override
    public void fetchRow(int[] index) throws SnmpException {
        this.updateCFSStatus();
        super.fetchRow(index);
        if (this._parentTable != null) {
            this._parentTable.panelGet();
        }
    }

    protected void updateCFSStatus() {
        if (this.getParentTable() != null && (this.getParentTable() instanceof EditFc2IscsiTable && ((EditFc2IscsiTable)this.getParentTable()).isISLB() || this.getParentTable() instanceof EditIscsi2FcTable && ((EditIscsi2FcTable)this.getParentTable()).isISLB())) {
            DmSystem.isCFSEnabled(DeviceManager.getInstance(), this.getPeer(), new int[][]{DmSystem.CFS_ISLB_INDEX}, null, false);
        }
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        super.doIt(ch, e);
        if (ch == 'D' && this._parentTable != null) {
            this._parentTable.panelGet();
        }
    }
}

