/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import java.awt.event.ActionEvent;
import javax.swing.event.ListSelectionEvent;

public class EditIscsiSessTable
extends EditTable {
    private static final int NAME = 1;
    private static final int ALIAS = 2;

    public EditIscsiSessTable(String[] vars) {
        super(vars);
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt("Details...", 0);
        return btns;
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("N");
        this._buttons[0].setEnabled(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.enableButton('N', this._table.getSelectedRowCount() == 1);
    }

    @Override
    protected void sendGetPdu(SnmpPDU pdu) throws SnmpException {
        if (pdu.getCommand() == -95 && this._data.size() > 0) {
            VarBindList vbl = pdu.getVariables();
            for (int i = 0; i < vbl.size(); ++i) {
                int[] oid = vbl.getVb(i).getOid().getValue();
                oid[oid.length - 1] = 0;
                int n = oid.length - 2;
                oid[n] = oid[n] + 1;
            }
        }
        this.getPeer().send(pdu, this);
    }

    @Override
    public void dispose() {
        super.dispose();
        DMDialog d = DialogListener.getInstance().getDialog("iSCSI_Session_Detail");
        if (d != null) {
            DialogListener.getInstance().remove("iSCSI_Session_Detail");
            d.dispose();
        }
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'N') {
            int[] sessIndex = ((SnmpOID)this._tableModel.getValueAt(this._table.getSelectedRow(), 0)).getValue();
            DMDialog dlg = DialogListener.getInstance().dialogAction("iSCSI_Session_Detail", new int[]{sessIndex[0], sessIndex[1]});
            String name = this._tableModel.getValueAt(this._table.getSelectedRow(), 2).toString();
            if (name.length() == 0) {
                name = this._tableModel.getValueAt(this._table.getSelectedRow(), 1).toString();
            }
            if (dlg != null) {
                dlg.setTitle(Discover.getDeviceName() + " - " + name + " Sessions");
            }
        } else {
            super.doIt(ch, e);
        }
    }
}

