/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.Cursor;

public class EditIscsiTargetLunMappingTable
extends EditTable {
    int[] scsiLuExtLocalTargetAddress = MibNode.get("scsiLuExtLocalTargetAddress").getOid();
    int[] scsiLuExtRemotePortFcAddress = MibNode.get("scsiLuExtRemotePortFcAddress").getOid();
    int[] _iscsiIndex = new int[2];
    byte[] _iscsiName;
    byte[] _pWWN;
    SnmpFetch _fetcher = new SnmpFetch();

    public EditIscsiTargetLunMappingTable(String[] vars) {
        super(vars);
    }

    @Override
    protected void setIndex(int[] index) {
        int i;
        this._iscsiName = new byte[index[0]];
        int indexSize = 1;
        for (i = 0; i < this._iscsiName.length; ++i) {
            this._iscsiName[i] = (byte)index[indexSize++];
        }
        this._pWWN = new byte[index.length - index[0] - 1];
        for (i = 0; i < this._pWWN.length; ++i) {
            this._pWWN[i] = (byte)index[indexSize++];
        }
        int[] newIndex = new int[]{0};
        super.setIndex(newIndex);
    }

    @Override
    protected void get() {
        this.enableButton('R', false);
        VarBindList vbl = new VarBindList(4);
        vbl.add(new SnmpVarBind(new SnmpOID(this.scsiLuExtLocalTargetAddress)));
        vbl.add(new SnmpVarBind(new SnmpOID(this.scsiLuExtRemotePortFcAddress)));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("scsiLuExtRemoteLun").getOid())));
        vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("scsiLuExtLocalLun").getOid())));
        try {
            this._fetcher.getBulk(this.getPeer(), vbl, (SnmpCallbackIf)this);
            this._parent.setCursor(Cursor.getPredefinedCursor(3));
        }
        catch (SnmpException ex) {
            DefaultLogger._DefLogger.debug((Object)(this.getPeer().getAddress().getHostAddress() + ": " + ex));
        }
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        super.callback(session, reqid, pdu, timedOut);
        VarBindList vbl = pdu.getVariables();
        for (int i = 0; i < vbl.size(); i += 4) {
            SnmpString localTarget = (SnmpString)vbl.get(i).getVar();
            SnmpString remoteAddress = (SnmpString)vbl.get(i + 1).getVar();
            if (!SnmpString.equals(localTarget.getValue(), this._iscsiName) || !SnmpString.equals(remoteAddress.getValue(), this._pWWN)) continue;
            Object[] row = this.buildLunMappingRow(vbl, pdu, i, this._data.size());
            this._data.addElement(row);
            break;
        }
        this._parent.setCursor(Cursor.getDefaultCursor());
        this.setStatus(this._data.size() + " row(s)");
        this.updateTable();
    }

    protected Object[] buildLunMappingRow(VarBindList vbl, SnmpPDU pdu, int offset, int rowNo) {
        Object[] row = new Object[this._vars.length + 2];
        int[] responseOid = vbl.get(offset).getOid().getValue();
        for (int i = offset; i < offset + 4; ++i) {
            SnmpVarBind vb = vbl.get(i);
            row[i + 1] = this._tableModel.toCellEditTable(this._mibNodes[i + 1], pdu, vb, this._vars[i], null, rowNo, 0);
            vb.setVar(null);
        }
        SnmpOID index = new SnmpOID(responseOid, this.scsiLuExtLocalTargetAddress.length, responseOid.length - this.scsiLuExtLocalTargetAddress.length);
        row[0] = index;
        return row;
    }

    @Override
    protected void sendInsertPdu(SnmpPDU pdu) throws SnmpException {
        VarBindList vbl = pdu.getVariables();
        for (int i = 0; i < vbl.size(); ++i) {
            SnmpVarBind vb = vbl.get(i);
            if (vb.getOid().startsWith(this.scsiLuExtLocalTargetAddress)) {
                vb.setVar(new SnmpString(this._iscsiName));
                continue;
            }
            if (!vb.getOid().startsWith(this.scsiLuExtRemotePortFcAddress)) continue;
            vb.setVar(new SnmpString(this._pWWN));
        }
        super.sendInsertPdu(pdu);
    }
}

