/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;

public class InsertISNS
extends InsertForm {
    int _addrType;
    protected int _addrIndex = 1;
    protected String _addrTypeVar = "cIsnsClntServerProfileAddrType";

    public InsertISNS(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) {
        String name = this.getComponentText(0);
        int[] index = new int[name.length() + 2];
        index[0] = name.length();
        for (int i = 0; i < name.length(); ++i) {
            index[i + 1] = name.charAt(i);
        }
        index[index.length - 1] = 1;
        return index;
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this._addrIndex) {
            String addr = this.getComponentText(index);
            if (this._mibNodes[index].getMaxWidth() < addr.length()) {
                throw new NumberFormatException(this.trim(this._vars[index]) + " maximum length is " + this._mibNodes[index].getMaxWidth());
            }
            if (this._mibNodes[index].getMinWidth() > addr.length()) {
                throw new NumberFormatException(this.trim(this._vars[index]) + " minimum length is " + this._mibNodes[index].getMinWidth());
            }
            this._addrType = 1;
            byte[] addrB = SnmpIpAddress.parse(addr);
            if (addrB.length == 16) {
                this._addrType = 2;
            }
            return new SnmpString(addrB);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = super.buildInsertPDU(index, values);
        SnmpVarBind vb = new SnmpVarBind(new SnmpOID(MibNode.get(this._addrTypeVar).getOid(), index), new SnmpInt(this._addrType));
        pdu.getVariables().add(1, vb);
        return pdu;
    }
}

