/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi;

import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.EditFc2IscsiTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.EditIscsiTargetTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.InsertFc2Iscsi;
import com.cisco.dcbu.dmdb.andiamo.dialogs.iscsi.InsertIscsi2FcNode;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import javax.swing.JComponent;

public class InsertIscsiTarget
extends InsertForm {
    static final int INST_INDEX = 0;
    static final int INIT_INDEX = 1;
    static final int TARGET_INDEX = 2;
    static final int PORT_WWN = 3;
    static final int TARGET_NAME = 4;
    static final int PRIMARY_VSAN = 8;
    String[] _portWWN;
    int _addrListIdx;
    int[] _tableIndex;

    public InsertIscsiTarget(InsertDialog parent, EditTable table) {
        super(parent, table);
        this._tableIndex = ((EditIscsiTargetTable)table).getTableIndex();
    }

    @Override
    protected void build() {
        super.build();
        int nextValue = 1;
        int[] index = this.getLastIndex();
        if (index != null) {
            nextValue += index[2];
        }
        this.setComponentText(0, "1");
        this.setComponentText(1, Integer.toString(this._tableIndex[1]));
        this.setComponentText(2, Integer.toString(nextValue));
        this.setComponentVisibleAt(0, false);
        this.setComponentVisibleAt(1, false);
        this.setComponentVisibleAt(2, false);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 3) {
            return new FieldPanel(15, (JComponent)new InsertFc2Iscsi.PortWWNMenuButton(null, this.getPeer()));
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected boolean toGetComponentValue(int index) {
        if (index == 4) {
            return !((KTextField)this._values[index]).getText().equals("");
        }
        return super.toGetComponentValue(index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 3) {
            this._portWWN = new String[1];
            this._portWWN[0] = ((FieldPanel)this._values[index]).getText();
            if (this._portWWN[0].equals("")) {
                throw new NumberFormatException("Port WWN cannot be blank.");
            }
            return new SnmpInt(0);
        }
        if (index == 8 && ((FieldPanel)this._values[index]).getText().equals("")) {
            return null;
        }
        return super.getComponentValue(index);
    }

    @Override
    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        this._addrListIdx = -1;
        if (this._portWWN != null && this._portWWN.length > 0 && !this._portWWN[0].equals("")) {
            this._addrListIdx = InsertIscsi2FcNode.insertAddressList(this.getPeer(), null, this._portWWN, null, null, null, -1);
        }
        try {
            super.tableInsert(values, index);
        }
        catch (Exception ex) {
            if (this._addrListIdx != -1) {
                SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
                EditFc2IscsiTable.deleteAddressList(this.getPeer(), pdu, this._addrListIdx, 1);
                this.getPeer().set(pdu);
            }
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    protected SnmpPDU buildInsertPDU(int[] index, SnmpVar[] values) {
        SnmpPDU pdu = super.buildInsertPDU(index, values);
        int[] FCAddrListIndexOid = MibNode.get("cigIscsiInitTgtFCAddrListIndex").getOid();
        for (int i = pdu.getVariables().size() - 1; i > 0; --i) {
            SnmpVarBind vb = pdu.getVariables().get(i);
            int[] oid = vb.getOid().getValue();
            if (!SnmpOID.startsWith(oid, FCAddrListIndexOid) || this._addrListIdx == -1) continue;
            vb.setVar(new SnmpInt(this._addrListIdx));
            pdu.removeVarAt(i);
            pdu.addVar(vb);
        }
        return pdu;
    }

    @Override
    protected void insert() throws Exception {
        super.insert();
        int max = MibNode.get("cigIscsiInitTgtNodeIndex").getHi();
        int linkId = Integer.parseInt(this.getComponentText(2));
        if (linkId < max && max != 0) {
            int index = Integer.parseInt(this.getComponentText(2)) + 1;
            this.setComponentText(2, Integer.toString(index));
        } else {
            this.setComponentText(2, "");
        }
    }
}

