/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.physical;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_1;
import com.cisco.dcbu.lib.jnm.SnmpDateAndTime;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class EditChassisForm
extends EditForm {
    static final int SYSNAME = 2;
    static final int CONTACT = 4;
    static final int WWN = 5;
    static final int CLOCK = 6;
    static final int TIMEZONE = 7;
    static final int RAM = 8;
    static final int NVRAM = 9;
    boolean _isSysNameChanged;
    SnmpVar _nvramSize;
    JTextArea _sysDescr;

    public EditChassisForm(String[] vars) {
        super(vars);
    }

    @Override
    protected void build() {
        super.build();
        ((JLabel)this._values[10]).setVisible(false);
        this._labels[10].setVisible(false);
    }

    @Override
    protected void preGet() throws SnmpException {
        try {
            VarBindList vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cRFStatusUnitId").getOid(), 0)));
            SnmpPDU resp = SnmpFetch.get(this.getPeer(), vbl);
            vbl = resp.getVariables();
            if (vbl.size() == 0) {
                return;
            }
            int activeSup = vbl.intValue(0);
            Array elements = DeviceManager.getInstance().getView().getElements();
            for (int i = elements.size() - 1; i >= 0; --i) {
                PhysicalElement e = (PhysicalElement)elements.elementAt(i);
                if (!(e instanceof Card_1)) continue;
                ((Card_1)e)._activeSup = e.getIndex()[0] == activeSup ? activeSup : -1;
            }
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    @Override
    protected int[] getIndex(int varIndex) {
        if (varIndex == 8 || varIndex == 9 || varIndex == 10) {
            int[] index = new int[]{DmSystem.getProcessorId()};
            return index;
        }
        return this.getIndex();
    }

    @Override
    protected JComponent buildNonEditableComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            this._sysDescr = new JTextArea();
            this._sysDescr.setEditable(false);
            this._sysDescr.setWrapStyleWord(true);
            this._sysDescr.setLineWrap(true);
            this._sysDescr.setBackground((Color)UIManager.getDefaults().get("Label.background"));
            this._sysDescr.setFont(ChangedCellRenderer.getNormalFont());
            JScrollPane sp = new JScrollPane(this._sysDescr);
            sp.setPreferredSize(new Dimension(320, 70));
            return sp;
        }
        if (index == 5) {
            JTextField t = new JTextField();
            t.setEditable(false);
            return t;
        }
        return super.buildNonEditableComponent(mibVar, mibNode, index);
    }

    @Override
    protected String getFormLabel(String mibVar, int index) {
        if (index == 7) {
            return "TimeZone";
        }
        return super.getFormLabel(mibVar, index);
    }

    @Override
    protected void setComponentValue(int i, SnmpVar v) {
        switch (i) {
            case 0: {
                this._sysDescr.setText(v.toString());
                break;
            }
            case 7: {
                byte[] b = ((SnmpString)v).getValue();
                for (int j = 0; j < b.length && j < 8; ++j) {
                    b[j] = 0;
                }
                SnmpDateAndTime timeZone = new SnmpDateAndTime(b);
                ((JTextField)this._values[7]).setText(timeZone.toString());
                break;
            }
            case 8: {
                ((JLabel)this._values[8]).setText(MibVariableFormat.ceExtProcessorRam(v).toString());
                break;
            }
            case 9: {
                this._nvramSize = v;
                super.setComponentValue(i, v);
                break;
            }
            case 10: {
                String size = ((JLabel)this._values[9]).getText();
                StringBuffer sb = new StringBuffer();
                if (this._nvramSize instanceof SnmpGauge && v instanceof SnmpGauge) {
                    sb.append(" (");
                    long ratio = ((SnmpGauge)v).getValue() * 100L / ((SnmpGauge)this._nvramSize).getValue();
                    sb.append(ratio);
                    sb.append("% used)");
                }
                ((JLabel)this._values[9]).setText(MibVariableFormat.ceExtNVRAMUsed(v) + " / " + size + sb.toString());
                break;
            }
            default: {
                super.setComponentValue(i, v);
            }
        }
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == 6) {
            return new SnmpDateAndTime(super.getComponentText(index));
        }
        if (index == 7) {
            return new SnmpDateAndTime(super.getComponentText(index), true);
        }
        if (index == 4) {
            return new SnmpString(super.getComponentText(index), true);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected SnmpPDU getSetPDU() throws Exception {
        this._isSysNameChanged = this.isChanged(2);
        return super.getSetPDU();
    }

    @Override
    protected void set() throws Exception {
        super.set();
        if (this._isSysNameChanged) {
            Discover.getInstance();
            Discover.setSystemName(this.getComponentText(2));
        }
    }
}

