/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.physical;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTable;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditFormTable;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class EditPowerSupplyTable
extends EditFormTable {
    static final int TOTAL_AVAILABLE = 0;
    static final int MODE = 1;
    static final int TLAVALCURRENT = 3;
    static final int TLDRAWNCURRENT = 4;
    static final int UNIT = 5;
    static final int REDUNDANT = 2;
    protected int _powerSupplyOffset;
    protected int _numOfPowerSupply;
    protected int _units;
    protected SnmpVar _TotalAvailable;
    protected FieldPanel _redundantPanel;
    protected MenuButton _redundantMenuButton;
    static final MibEnum[] CefcPowerRedundancyModeEnums = MibNode.get("cefcPowerRedundancyMode").getEnums();
    int _redundancyMode = -1;
    boolean _is6_2_7 = Discover.isSysVersionGreaterThanEqual("6.2(7)");

    public EditPowerSupplyTable(String[] vars, String[] formVars) {
        super(vars, formVars);
    }

    private int[] getPowerSupplyStartingIndex(int index) {
        this._powerSupplyOffset = FRUConstants.getPowerSupplyOffset(Discover.isSysVersionGreaterThanEqual("3.0(0)"));
        this._numOfPowerSupply = DmSystem.getNumOfPowerSupply();
        if (index != 0) {
            int satOffset = FRUConstants.getSatelliteSwitchComponentOffset(index);
            this._powerSupplyOffset = satOffset + this._powerSupplyOffset;
        }
        return new int[]{this._powerSupplyOffset - 1};
    }

    @Override
    protected int[] getIndex() {
        return this.getPowerSupplyStartingIndex(0);
    }

    @Override
    protected int[] getMultipleIndex(int row) {
        return this.getPowerSupplyStartingIndex(this._parent._multipleIndeces[row][0]);
    }

    @Override
    protected void preGet() {
        this._units = 0;
        this._TotalAvailable = null;
    }

    @Override
    protected void get() {
        super.get();
    }

    @Override
    protected void formGet() {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(2));
        pdu.addNull(new SnmpOID(MibNode.get(this._formVariables[0]).getOid(), 0));
        try {
            this.sendGetPdu(pdu);
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
        }
    }

    @Override
    protected boolean isFormVariables(SnmpPDU pdu) {
        return SnmpOID.startsWith(pdu.getVariables().get(0).getOid().getValue(), MibNode.get(this._formVariables[0]).getOid()) || SnmpOID.startsWith(pdu.getVariables().get(0).getOid().getValue(), MibNode.get(this._formVariables[1]).getOid());
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt("Apply", 0);
        return btns;
    }

    @Override
    protected boolean isEnd(int[] req, SnmpVarBind vb) {
        if (vb.getError() == 21) {
            return true;
        }
        int[] firstOid = new int[req.length - 1];
        System.arraycopy(req, 0, firstOid, 0, firstOid.length);
        if (super.isEnd(firstOid, vb)) {
            return true;
        }
        int[] oid = vb.getOid().getValue();
        return oid[oid.length - 1] >= this._powerSupplyOffset + this._numOfPowerSupply;
    }

    @Override
    protected boolean isEnd(int[] req, SnmpVarBind vb, int[] index) {
        return this.isEnd(req, vb);
    }

    @Override
    protected boolean isChanged(int index) {
        if (index == 1) {
            return this.isModeChanged(this._redundantPanel.getField().getText());
        }
        return super.isChanged(index);
    }

    @Override
    protected JComponent buildFormComponent(int index) {
        if (index == 1) {
            JPanel pane = new JPanel();
            this._redundantMenuButton = new redundantMenu(null, CefcPowerRedundancyModeEnums, this);
            this._redundantPanel = new FieldPanel(15, (JComponent)this._redundantMenuButton);
            this._redundantPanel.getField().setEnabled(false);
            pane.add(new JLabel("Redundancy Mode: "));
            pane.add(this._redundantPanel);
            return pane;
        }
        JComponent comp = super.buildFormComponent(index);
        if (DmId.isN5K(Discover.getSysObjectID()) && index == 0) {
            comp.setVisible(false);
        }
        return comp;
    }

    @Override
    protected void callbackForm(SnmpPDU pdu) {
        this.updateFormComponent(0, pdu.getVar(0));
        this._TotalAvailable = pdu.getVariables().get(0).getVar();
    }

    @Override
    protected void postProcessing() throws SnmpException {
        String mibVarString = this._is6_2_7 ? "cefcMaxDefaultHighInLinePowerWithUnit" : "cefcMaxDefaultInLinePowerWithUnit";
        SnmpVar[] values = new SnmpVar[]{this._TotalAvailable, new SnmpInt(this._units)};
        Object o = null;
        if (this._TotalAvailable != null) {
            o = DmTableModel.getMibVariableFormat(mibVarString, values, DmTableModel._MibVariableFormatMethods, DmTableModel._MibVariableFormatClass);
        }
        String totalAvailabeString = o != null ? o.toString() : "";
        JLabel l = (JLabel)this._formVars[0];
        String display = this.trim(this._formVariables[0]) + ": " + totalAvailabeString + " ";
        l.setText(display);
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(this._tableModel.getRowCount()));
        for (int i = 0; i < this._tableModel.getRowCount(); ++i) {
            int[] index = this._tableModel.getIndex(i);
            pdu.addNull(new SnmpOID(MibNode.get(this._formVariables[1]).getOid(), index));
        }
        try {
            this._redundancyMode = -1;
            SnmpPDU resp = this.getPeer().send(pdu);
            if (resp.getVar(0).getType() == 2) {
                this._redundancyMode = resp.getVariables().intValue(0);
                this._redundantPanel.getField().setText(MibEnum.getLabel(CefcPowerRedundancyModeEnums, resp.getVariables().intValue(0)));
                this._redundantPanel.getField().setFont(null);
            }
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)DeviceManager.getInstance(), ex.getMessage());
        }
    }

    @Override
    protected void formSet() throws Exception {
        int mode = MibEnum.getValue(CefcPowerRedundancyModeEnums, this._redundantPanel.getField().getText());
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        for (int i = 0; i < this._tableModel.getRowCount(); ++i) {
            int[] index = this._tableModel.getIndex(i);
            pdu.addVar(new SnmpOID(MibNode.get("cefcPowerRedundancyMode").getOid(), index), new SnmpInt(mode));
        }
        this.sendPdu(pdu);
        this._redundantPanel.getField().setFont(null);
        this._redundancyMode = mode;
    }

    @Override
    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        String unit = pdu.getVariables().stringValue(5);
        int totalCurrent = pdu.getVariables().intValue(3);
        int totalDrawn = pdu.getVariables().intValue(4);
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        this._units = 4200;
        int pos = unit.indexOf(64);
        if (pos != -1) {
            try {
                this._units = Integer.parseInt(unit.substring(pos + 2, unit.indexOf(86))) * 100;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        row[4] = this.getCurrent(totalCurrent, this._units, row);
        row[5] = this.getCurrent(totalDrawn, this._units, row);
        return row;
    }

    private String getCurrent(int current, int units, Object[] row) {
        if (current == 0) {
            return "n/a";
        }
        double amp = (double)current / 100.0;
        double amps = (double)units * 1.0;
        int watt = (int)(amp * amps);
        return units == 0 ? amp + "A" : (double)watt / 100.0 + "W / " + amp + "A";
    }

    Object toCellEMTable(MibNode mibNode, SnmpVar[] values, String var) {
        if ((var.equals("cefcTotalAvailableCurrent") || var.equals("cefcTotalDrawnCurrent")) && values[0].getType() != 5) {
            Object o = DmTableModel.getMibVariableFormat("cefcTotalAvailableCurrentWithAmps", values, DmTableModel._MibVariableFormatMethods, DmTableModel._MibVariableFormatClass);
            if (o != null) {
                return o;
            }
        }
        return this._tableModel.toCell(mibNode, values[0], var, 0);
    }

    @Override
    protected Object getFormVar(int index) {
        int mode = MibEnum.getValue(CefcPowerRedundancyModeEnums, this._redundantPanel.getField().getText());
        return new Integer(mode);
    }

    @Override
    protected boolean isIgnoreWarning(String message, Object value) {
        boolean isRedundant = (Integer)value == 2;
        String msg4Redundant = "In redundant mode, the total power is the lesser of the two power supply capacities.\nContinue?";
        return this.isIgnoreWarning(isRedundant ? msg4Redundant : message);
    }

    public void enableBtn(char index, boolean enable) {
        this.enableButton(index, enable);
    }

    public boolean isModeChanged(String newModeString) {
        int newMode = MibEnum.getValue(CefcPowerRedundancyModeEnums, newModeString);
        return newMode != this._redundancyMode;
    }

    @Override
    protected DmTable createTable(DmTableModel tableModel) {
        return new PowerSupplyTable(tableModel);
    }

    class PowerSupplyTable
    extends DmTable
    implements ActionListener {
        DmTableModel _model;

        public PowerSupplyTable(DmTableModel model) {
            super(model);
            this._model = model;
        }

        @Override
        public Dimension calcPreferredSize() {
            Dimension d = super.calcPreferredSize();
            return new Dimension(d.width, d.height + 5);
        }
    }

    static class redundantMenu
    extends MenuButton {
        Object[] _options;
        EditPowerSupplyTable _parent;

        public redundantMenu(JMenu menu, Object[] options, EditPowerSupplyTable parent) {
            super(menu);
            this._options = options;
            this._parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._menu == null) {
                this._menu = new JMenu();
                this.buildMenu(this._options);
            }
            if (e.getSource() instanceof JMenuItem) {
                ((FieldPanel)this.getParent()).getField().setText(((JMenuItem)e.getSource()).getText());
                boolean isChanged = this._parent.isModeChanged(((JMenuItem)e.getSource()).getText());
                ((FieldPanel)this.getParent()).getField().setFont(isChanged ? ChangedCellRenderer.getChangeFont() : null);
                this._parent.enableBtn('A', isChanged);
            }
            super.actionPerformed(e);
        }
    }
}

