/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.portchannel;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.renderers.PortIndexRenderer;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class EditEthernetChannelTable
extends EditTable {
    private static final int MEMBERLIST = 6;
    boolean _is6dot2_8 = Discover.isSysVersionGreaterThanEqual("6.2(8)");

    public EditEthernetChannelTable(String[] vars) {
        super(vars);
    }

    @Override
    protected int[] getIndex() {
        if (this.isSpecificInstance()) {
            if (this.isMultiple()) {
                return new int[]{0x16000000 + this.getMultipleIndex(0)[0] - 1};
            }
            if (super.getIndex() != null) {
                return new int[]{0x16000000 + super.getIndex()[0] - 1};
            }
        }
        return new int[]{0x15FFFFFF};
    }

    @Override
    protected int[] getIndexFor(MibNode mibNode, int[] index) {
        if (this.isSpecificInstance()) {
            String channelIfString = "eth-channel" + index[0];
            int channelIf = Discover.getRoot().nameToIfIndex(channelIfString);
            int[] newIndex = new int[index.length];
            newIndex[0] = channelIf - 1;
            return newIndex;
        }
        return super.getIndexFor(mibNode, index);
    }

    @Override
    protected void build() {
        super.build();
        this._table.getColumnModel().getColumn(0).setCellRenderer(new PortIndexRenderer(this.getPeer()));
    }

    @Override
    protected boolean isEnd(int[] req, SnmpVarBind vb) {
        if (vb.getError() == 21) {
            return true;
        }
        int[] oid = vb.getOid().getValue();
        int[] firstOid = new int[req.length - 1];
        System.arraycopy(req, 0, firstOid, 0, firstOid.length);
        return !SnmpOID.startsWith(firstOid, vb.getOid().getValue()) || IfIndexUtil.getType(oid[oid.length - 1]) != 22;
    }

    @Override
    protected void postProcessing() throws SnmpException {
        VarBindList vbl = new VarBindList();
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row = (Object[])this._data.elementAt(i);
            int eChannelIfIndex = ((SnmpOID)row[0]).getValue()[0];
            vbl.add(this._is6dot2_8 ? MibNode.get("clagAggPortListInterfaceIndexList").getOid() : MibNode.get("clagAggPortListPorts").getOid(), eChannelIfIndex);
        }
        SnmpPDU resp = SnmpFetch.get(this.getPeer(), vbl);
        if (resp == null || resp.getVariables().size() == 0) {
            return;
        }
        vbl = resp.getVariables();
        for (int i = 0; i < vbl.size(); ++i) {
            int[] memberIfindexes = this._is6dot2_8 ? IfIndexUtil.interfaceIndexList2ifIndexes(vbl.byteValue(i)) : IfIndexUtil.dot1Indexes2IfIndexes(vbl.byteValue(i));
            String memebers = SnmpIntList.toString(memberIfindexes, MibVariableFormat._IfIndexIf, false);
            ((Object[])this._tableModel.getData().elementAt((int)i))[6] = memebers;
        }
    }
}

