/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.CfsStatusCache;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;

public class EditCommunityTable
extends EditTable {
    public boolean _isMultipleRoleSupported = false;
    public static final int V1 = 1;
    public static final int V2 = 2;
    static final int ROLECOLUMN = 2;
    static final int EXTENDED_ROLECOLUMN = 3;
    int SECURITYNAME = this._isMultipleRoleSupported ? 5 : 4;
    final SnmpInt _DESTROY = new SnmpInt(6);
    SnmpFetch _fetcher = new SnmpFetch();
    public static final int[] DELETEVAR_OID = MibNode.get("vacmSecurityToGroupStatus").getOid();
    public static final int[] EXTENDED_DELETEVAR_OID = MibNode.get("cvacmSecurityGrpStatus").getOid();
    public static final int[] GROUPNAME_OID = MibNode.get("vacmGroupName").getOid();
    public static final int[] EXTENDED_GROUPNAME_OID = MibNode.get("cvacmSecurityGrpStatus").getOid();

    public EditCommunityTable(String[] vars) {
        super(vars);
    }

    @Override
    protected void buildModel() {
        super.buildModel();
    }

    @Override
    protected Object[] buildRow(SnmpPDU pdu, int[] responseOid, int rowNo) {
        Object[] row = super.buildRow(pdu, responseOid, rowNo);
        Object[] nRow = new Object[row.length + 1];
        System.arraycopy(row, 0, nRow, 0, row.length);
        nRow[nRow.length - 1] = nRow[nRow.length - 3];
        return nRow;
    }

    @Override
    protected void postProcessing() throws SnmpException {
        this.fetchVcam();
    }

    void fetchVcam() throws SnmpException {
        Object[] row;
        int rowNo;
        int[] userName;
        SnmpVarBind vb;
        int[] oid;
        int indexOffset = GROUPNAME_OID.length;
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row2 = (Object[])this._data.elementAt(i);
            row2[2] = "";
            if (!this._isMultipleRoleSupported) continue;
            row2[3] = "";
        }
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(new SnmpOID(GROUPNAME_OID)));
        SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return;
        }
        int i = 0;
        while (i < vbl.size()) {
            if ((oid = (vb = vbl.get(i++)).getOid().getValue())[indexOffset] != 2) continue;
            userName = new int[oid[indexOffset + 1]];
            System.arraycopy(oid, indexOffset + 2, userName, 0, userName.length);
            rowNo = this.findRow(userName);
            if (rowNo == -1) continue;
            row = (Object[])this._data.elementAt(rowNo);
            row[2] = vb.getVar().getType() == 5 ? "" : vb.getVar().toString();
            this._tableModel.setNoSuchInstance(i, 2, false);
        }
        if (!this._isMultipleRoleSupported) {
            return;
        }
        indexOffset = EXTENDED_GROUPNAME_OID.length;
        vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(new SnmpOID(EXTENDED_GROUPNAME_OID)));
        resp = SnmpFetch.getBulk(this.getPeer(), vbl);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return;
        }
        i = 0;
        while (i < vbl.size()) {
            if ((oid = (vb = vbl.get(i++)).getOid().getValue())[indexOffset] != 2) continue;
            userName = new int[oid[indexOffset + 1]];
            System.arraycopy(oid, indexOffset + 2, userName, 0, userName.length);
            rowNo = this.findRow(userName);
            if (rowNo == -1) continue;
            row = (Object[])this._data.elementAt(rowNo);
            StringBuffer sb = new StringBuffer((String)row[3]);
            if (!sb.toString().equals("")) {
                sb.append(", ");
            }
            int userNameLength = oid[indexOffset + 1];
            int groupNameOffset = indexOffset + 1 + userNameLength + 2;
            int groupNameLength = oid[groupNameOffset - 1];
            sb.append(SnmpString.toString(oid, groupNameOffset, groupNameOffset + groupNameLength));
            row[3] = sb.toString();
        }
    }

    int findRow(int[] user) {
        for (int i = 0; i < this._data.size(); ++i) {
            Object securityName = this.getValueAt(i, this.SECURITYNAME);
            if (securityName == null || securityName instanceof SnmpNull) {
                return -1;
            }
            byte[] b = ((SnmpString)this.getValueAt(i, this.SECURITYNAME)).getValue();
            int[] index = new int[b.length];
            for (int j = 0; j < b.length; ++j) {
                index[j] = b[j] & 0xFF;
            }
            if (!SnmpOID.equals(user, 0, index, 0)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void insert(SnmpPDU pdu, int[] index) throws SnmpException {
    }

    @Override
    protected void delete() throws SnmpException {
        int[] selected = this._table.getSelectedRows();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(selected.length));
        for (int i = 0; i < selected.length; ++i) {
            String groups;
            String newSecurity = ((SnmpString)this.getValueAt(selected[i], this.SECURITYNAME)).toString();
            int[] groupIndex = new int[newSecurity.length() + 2];
            groupIndex[0] = 1;
            groupIndex[1] = newSecurity.length();
            int pos = 2;
            for (int j = 0; j < newSecurity.length(); ++j) {
                groupIndex[pos++] = newSecurity.charAt(j);
            }
            if (this._isMultipleRoleSupported && (groups = (String)this.getValueAt(selected[i], 3)) != null && !groups.equals("")) {
                StringTokenizer st = new StringTokenizer(groups, ",", true);
                while (st.hasMoreTokens()) {
                    String group = st.nextToken().trim();
                    int[] cvacmIndex = new int[groupIndex.length + group.length() + 1];
                    System.arraycopy(groupIndex, 0, cvacmIndex, 0, groupIndex.length);
                    int j = groupIndex.length;
                    cvacmIndex[j++] = group.length();
                    for (int k = 0; j < cvacmIndex.length && k < group.length(); ++j, ++k) {
                        cvacmIndex[j] = group.charAt(k);
                    }
                    pdu.addVar(new SnmpOID(EXTENDED_DELETEVAR_OID, cvacmIndex), this._DESTROY);
                    cvacmIndex[0] = 2;
                    pdu.addVar(new SnmpOID(EXTENDED_DELETEVAR_OID, cvacmIndex), this._DESTROY);
                }
            }
            pdu.addVar(new SnmpOID(DELETEVAR_OID, groupIndex), this._DESTROY);
            groupIndex[0] = 2;
            pdu.addVar(new SnmpOID(DELETEVAR_OID, groupIndex), this._DESTROY);
        }
        super.delete();
        this.getPeer().set(pdu);
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (Discover.isSysVersionGreaterThanEqual("2.0(0)") && ch == 'C' && e.getActionCommand().charAt(1) == 'r') {
            boolean isPending = false;
            if (this.getCFSStatus() == null) {
                int[] cfsStatus = DmSystem.isCFSEnabled(DeviceManager.getInstance(), this.getPeer(), new int[][]{DmSystem.CFS_ROLE_INDEX}, new String[]{"role"}, false);
                CfsStatusCache.getInstance().setCFSStatus(DmSystem.CFS_ROLE_INDEX, cfsStatus[0]);
                isPending = cfsStatus[0] == 2;
            } else {
                boolean bl = isPending = this.getCFSStatus()[0] == 2;
            }
            if (isPending) {
                Util.errorMessage((Component)this._parent, "Please commit Common Roles pending changes before creation.");
                return;
            }
        }
        super.doIt(ch, e);
    }
}

