/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;

public class EditIpFilterProfileTable
extends EditTable {
    DMDialog _IpFilterlg;
    static final int TYPE_COL = 1;

    public EditIpFilterProfileTable(String[] vars) {
        super(vars);
    }

    @Override
    protected void build() {
        super.build();
        this._table.removeColumn(this._table.getColumnModel().getColumn(1));
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt("Rules...", 0);
        return btns;
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("L");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.enableButton('L', this._table.getSelectedRowCount() > 0);
    }

    @Override
    public void dispose() {
        if (this._IpFilterlg != null) {
            this._IpFilterlg.dispose();
        }
        super.dispose();
    }

    @Override
    protected void updateTable() {
        super.updateTable();
        this.enableButton('L', false);
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'L') {
            boolean isBuilt = false;
            if (this._IpFilterlg != null) {
                isBuilt = true;
            }
            int[] index = ((SnmpOID)this._tableModel.getValueAt(this._table.getSelectedRow(), 0)).getValue();
            this._IpFilterlg = DialogListener.getInstance().dialogAction("IPFilter", index);
            if (this._IpFilterlg != null) {
                if (!isBuilt) {
                    this._IpFilterlg.setLocation(DialogUtil.getPointOnScreen(new Point(0, 0), (JComponent)e.getSource(), this._IpFilterlg.getSize()));
                }
                String filterName = SnmpString.toString(index, 1, index.length);
                this._IpFilterlg.setTitle(Discover.getDeviceName() + " - IP ACL Profile " + filterName);
            }
        } else {
            super.doIt(ch, e);
        }
    }

    @Override
    protected boolean isOkToDelete() {
        return this.isIgnoreWarning("<html>Deleting profiles would cause an implicit deny if there are interfaces using them, <br>possibly locking you out of the switch.<br><br>Please unbind interfaces before deleting profiles.<br>Continue?");
    }
}

