/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;

public class EditPsmActionTable
extends EditTable {
    static final int CLEAR_AUTOLEARN_IF = 2;
    static final int CLEAR_AUTOLEARN_ACTION_COL = 7;
    static final int CLEAR_AUTOLEARN_IF_COL = 8;
    private static final int[] _cpsmPortBindClearAutoLearnDbOid = MibNode.get("cpsmPortBindClearAutoLearnDb").getOid();
    private static final int[] _cpsmPortBindClearAutoLearnIntfOid = MibNode.get("cpsmPortBindClearAutoLearnIntf").getOid();

    public EditPsmActionTable(String[] vars) {
        super(vars);
    }

    @Override
    protected void buildTable() {
        super.buildTable();
        this._table.setMultiLineColumn(5, new String[]{"CopyActive", "ToConfig"});
    }

    @Override
    protected void sendPdu(SnmpPDU pdu) throws SnmpException {
        super.sendPdu(pdu);
        for (int i = pdu.getVariables().size() - 1; i >= 0; --i) {
            int[] oid = pdu.getVariables().get(i).getOid().getValue();
            if (SnmpOID.startsWith(oid, _cpsmPortBindClearAutoLearnDbOid) || SnmpOID.startsWith(oid, _cpsmPortBindClearAutoLearnIntfOid)) continue;
            this.setCFSPending(this.getPeer());
            break;
        }
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new SnmpPsmActionTableModel();
    }

    static class SnmpPsmActionTableModel
    extends DmTableModel {
        SnmpPsmActionTableModel() {
        }

        @Override
        public boolean isCellActive(int row, int col) {
            if (col == 8) {
                Object autoLearnAction = this.getValueAt(row, 7);
                return autoLearnAction != null && ((JnmMibEnum)autoLearnAction).getValue() == 2;
            }
            return super.isCellActive(row, col);
        }
    }
}

