/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.dialogs.CfsStatusCache;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.SnmpUserPasswordChange;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.PasswordCellRenderer;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;

public class EditUserTable
extends EditTable {
    public static final String MULTIPLE_ROLE_SUPPORT_REL = "2.0";
    public boolean _isMultipleRoleSupported = Discover.isSysVersionGreaterThanEqual("2.0");
    public static final int ANY = 0;
    public static final int V1 = 1;
    public static final int V2 = 2;
    public static final int USM = 3;
    static final int USERCOLUMN = 0;
    static final int ROLECOLUMN = 1;
    static final int EXTENDED_ROLECOLUMN = 2;
    int DIGESTCOLUMN = this._isMultipleRoleSupported ? 3 : 2;
    int ENCRYCOLUMN = this._isMultipleRoleSupported ? 4 : 3;
    int STATUSCOLUMN = this._isMultipleRoleSupported ? 5 : 4;
    final int[] _authPwdOid = MibNode.get("usmUserOwnAuthKeyChange").getOid();
    final int[] _privPwdOid = MibNode.get("usmUserOwnPrivKeyChange").getOid();
    final SnmpInt _DESTROY = new SnmpInt(6);
    byte[] _engineId;
    private boolean _isV3;
    SnmpUserPasswordChange _passwordDlg;
    public static final int[] DELETEVAR_OID = MibNode.get("vacmSecurityToGroupStatus").getOid();
    public static final int[] EXTENDED_DELETEVAR_OID = MibNode.get("cvacmSecurityGrpStatus").getOid();
    public static final int[] GROUPNAME_OID = MibNode.get("vacmGroupName").getOid();
    public static final int[] EXTENDED_GROUPNAME_OID = MibNode.get("cvacmSecurityGrpStatus").getOid();

    public EditUserTable(String[] vars) {
        super(vars);
    }

    @Override
    protected void build() {
        super.build();
        this._engineId = this.getPeer().getEngineId();
        boolean bl = this._isV3 = this._engineId != null && this.getPeer().getVersion() == 3;
        if (!this._isV3) {
            boolean[] isEditable = this._tableModel.getEditable();
            isEditable[this.STATUSCOLUMN] = false;
            this._tableModel.setEditable(isEditable);
            this.enableButton("Create", false);
            this.enableButton('D', false);
            this.enableButton('W', false);
            this._rowStatus = null;
        }
        PasswordCellRenderer passwordRenderer = new PasswordCellRenderer();
    }

    @Override
    protected void buildModel() {
        super.buildModel();
    }

    @Override
    protected Array getButtons() {
        Array btns = super.getButtons();
        btns.insertElementAt("Change Password...", 0);
        return btns;
    }

    @Override
    protected void buildButtons() {
        super.buildButtons();
        this._buttons[0].setActionCommand("Word");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.enableButton('W', this._table.getSelectedRowCount() == 1 && this._isV3);
    }

    @Override
    protected boolean isSkip(SnmpPDU pdu) {
        if (!this._isV3) {
            return false;
        }
        SnmpVarBind vb = pdu.getVariables().get(0);
        return !SnmpOID.startsWith(vb.getOid().getValue(), SnmpString.valueOf(this.getPeer().getEngineId(), true), this._mibNodes[1].getOid().length);
    }

    @Override
    protected void updateTable() {
        if (this.getStatus().startsWith("timeout")) {
            super.updateTable();
        } else {
            block4: {
                try {
                    this.fetchVcam();
                }
                catch (Exception ex) {
                    if (!SnmpSession.isTrace()) break block4;
                    ex.printStackTrace();
                }
            }
            super.updateTable();
        }
        this.enableButton('W', false);
    }

    void fetchVcam() throws SnmpException {
        Object[] row;
        int rowNo;
        int[] userName;
        SnmpVarBind vb;
        int[] oid;
        int indexOffset = GROUPNAME_OID.length;
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] row2 = (Object[])this._data.elementAt(i);
            row2[1] = "";
            this._tableModel.setNoSuchInstance(i, 1, false);
            if (!this._isMultipleRoleSupported) continue;
            row2[2] = "";
            this._tableModel.setNoSuchInstance(i, 2, false);
        }
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(new SnmpOID(GROUPNAME_OID)));
        SnmpPDU resp = SnmpFetch.getBulk(this.getPeer(), vbl);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return;
        }
        int i = 0;
        while (i < vbl.size()) {
            if ((oid = (vb = vbl.get(i++)).getOid().getValue())[indexOffset] != 3) continue;
            userName = new int[oid[indexOffset + 1]];
            System.arraycopy(oid, indexOffset + 2, userName, 0, userName.length);
            rowNo = this.findRow(this._data, userName, this._table);
            if (rowNo == -1) continue;
            row = (Object[])this._data.elementAt(rowNo);
            row[1] = vb.getVar().getType() == 5 ? "" : vb.getVar().toString();
        }
        if (!this._isMultipleRoleSupported) {
            return;
        }
        indexOffset = EXTENDED_GROUPNAME_OID.length;
        vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(new SnmpOID(EXTENDED_GROUPNAME_OID)));
        resp = SnmpFetch.getBulk(this.getPeer(), vbl);
        vbl = resp.getVariables();
        if (vbl.size() == 0) {
            return;
        }
        i = 0;
        while (i < vbl.size()) {
            if ((oid = (vb = vbl.get(i++)).getOid().getValue())[indexOffset] != 3) continue;
            userName = new int[oid[indexOffset + 1]];
            System.arraycopy(oid, indexOffset + 2, userName, 0, userName.length);
            rowNo = this.findRow(this._data, userName, this._table);
            if (rowNo == -1) continue;
            row = (Object[])this._data.elementAt(rowNo);
            StringBuffer sb = new StringBuffer((String)row[2]);
            if (!sb.toString().equals("")) {
                sb.append(", ");
            }
            int userNameLength = oid[indexOffset + 1];
            int groupNameOffset = indexOffset + 1 + userNameLength + 2;
            int groupNameLength = oid[groupNameOffset - 1];
            sb.append(SnmpString.toString(oid, groupNameOffset, groupNameOffset + groupNameLength));
            row[2] = sb.toString();
        }
    }

    int findRow(Array _data, int[] user, SnmpKTable _table) {
        for (int i = 0; i < _data.size(); ++i) {
            int[] rowIndex = ((SnmpOID)_table.getValueAt(i, 0)).getValue();
            if (!SnmpOID.equals(user, 0, rowIndex, rowIndex[0] + 2)) continue;
            return i;
        }
        return -1;
    }

    void fetchPasswords() throws SnmpException {
        for (int i = 0; i < this._data.size(); ++i) {
            Object[] objectArray = (Object[])this._data.elementAt(i);
        }
    }

    @Override
    protected void insert(SnmpPDU pdu, int[] index) throws SnmpException {
        this.fetchRow(index);
    }

    @Override
    public void fetchRow(int[] index) throws SnmpException {
        int i;
        byte[] engineId = this.getPeer().getEngineId();
        int[] userIndex = new int[engineId.length + index.length];
        userIndex[0] = engineId.length;
        for (i = 1; i <= engineId.length; ++i) {
            userIndex[i] = engineId[i - 1] & 0xFF;
        }
        for (int j = 1; i <= userIndex.length && j < index.length; ++i, ++j) {
            userIndex[i] = index[j];
        }
        super.fetchRow(userIndex);
    }

    @Override
    protected void delete() throws SnmpException {
        String sessionUser = this.getPeer().getUserName();
        this._engineId = this.getPeer().getEngineId();
        int[] selected = this._table.getSelectedRows();
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(selected.length));
        for (int i = 0; i < selected.length; ++i) {
            String groups;
            int[] rowIndex = ((SnmpOID)this.getValueAt(selected[i], 0)).getValue();
            String newUser = SnmpString.toString(rowIndex, rowIndex[0] + 2, rowIndex.length);
            if (newUser.equals(sessionUser)) {
                throw new SnmpException("Cannot delete current user");
            }
            if (((String)this.getValueAt(selected[i], 1)).equals("")) continue;
            int[] vacmIndex = new int[rowIndex[rowIndex[0] + 1] + 2];
            vacmIndex[0] = 3;
            vacmIndex[1] = rowIndex[rowIndex[0] + 1];
            System.arraycopy(rowIndex, rowIndex[0] + 2, vacmIndex, 2, vacmIndex.length - 2);
            if (this._isMultipleRoleSupported && (groups = (String)this.getValueAt(selected[i], 2)) != null && !groups.equals("")) {
                StringTokenizer st = new StringTokenizer(groups, ",", false);
                while (st.hasMoreTokens()) {
                    String group = st.nextToken().trim();
                    int[] cvacmIndex = new int[vacmIndex.length + group.length() + 1];
                    System.arraycopy(vacmIndex, 0, cvacmIndex, 0, vacmIndex.length);
                    int j = vacmIndex.length;
                    cvacmIndex[j++] = group.length();
                    for (int k = 0; j < cvacmIndex.length && k < group.length(); ++j, ++k) {
                        cvacmIndex[j] = group.charAt(k);
                    }
                    pdu.addVar(new SnmpOID(EXTENDED_DELETEVAR_OID, cvacmIndex), this._DESTROY);
                }
            }
            pdu.addVar(new SnmpOID(DELETEVAR_OID, vacmIndex), this._DESTROY);
        }
        if (pdu.getVariables().size() > 0) {
            this.getPeer().set(pdu);
        }
        super.delete();
    }

    public static int[] getUserIndex(byte[] engineId, String newUser) {
        int[] index = new int[engineId.length + newUser.length() + 2];
        index[0] = engineId.length;
        for (int i = 1; i <= engineId.length; ++i) {
            index[i] = engineId[i - 1] & 0xFF;
        }
        index[i++] = newUser.length();
        for (int j = 0; j < newUser.length(); ++j) {
            index[i++] = newUser.charAt(j);
        }
        return index;
    }

    String findRole(String userName) {
        for (int i = 0; i < this._data.size(); ++i) {
            int[] oid = ((SnmpOID)((Object[])this._data.elementAt(i))[0]).getValue();
            String user = SnmpString.toString(oid, oid[0] + 2, oid.length);
            Object role = ((Object[])this._data.elementAt(i))[1];
            if (!user.equals(userName)) continue;
            return role.toString();
        }
        return "";
    }

    @Override
    public void dispose() {
        if (this._passwordDlg != null) {
            this._passwordDlg.dispose();
        }
        super.dispose();
    }

    @Override
    protected void doIt(char ch, ActionEvent e) throws Exception {
        if (ch == 'W') {
            boolean isBuilt = false;
            if (this._passwordDlg != null) {
                this._passwordDlg.dispose();
            }
            int[] oid = ((SnmpOID)this._tableModel.getValueAt(this._table.getSelectedRow(), 0)).getValue();
            String user = SnmpString.toString(oid, oid[0] + 2, oid.length);
            boolean isSHA = ((String)this._tableModel.getValueAt(this._table.getSelectedRow(), this.DIGESTCOLUMN)).equals("SHA");
            boolean isAES = ((String)this._tableModel.getValueAt(this._table.getSelectedRow(), this.ENCRYCOLUMN)).equals("AES");
            this._passwordDlg = new MysnmpUserPasswordChange((JFrame)this._parent.getParent(), this.getPeer(), user, isSHA, isAES);
            if (this._passwordDlg != null) {
                this._passwordDlg.setLocation(DialogUtil.getPointOnScreen(new Point(0, 0), (JComponent)e.getSource(), this._passwordDlg.getSize()));
                this._passwordDlg.setTitle(Discover.getDeviceName() + " - Change Password " + user);
                this._passwordDlg.setVisible(true);
            }
            return;
        }
        if (Discover.isSysVersionGreaterThanEqual("2.0(0)") && ch == 'C' && e.getActionCommand().charAt(1) == 'r') {
            boolean isPending = false;
            if (this.getCFSStatus() == null) {
                int[] cfsStatus = DmSystem.isCFSEnabled(DeviceManager.getInstance(), this.getPeer(), new int[][]{DmSystem.CFS_ROLE_INDEX}, new String[]{"role"}, false);
                CfsStatusCache.getInstance().setCFSStatus(DmSystem.CFS_ROLE_INDEX, cfsStatus[0]);
                isPending = cfsStatus[0] == 2;
            } else {
                boolean bl = isPending = this.getCFSStatus()[0] == 2;
            }
            if (isPending) {
                Util.errorMessage((Component)this._parent, "Please commit Common Roles pending changes before creation.");
                return;
            }
        }
        super.doIt(ch, e);
    }

    @Override
    protected DmTableModel buildTableModel() {
        return new DmUserTableModel();
    }

    static class DmUserTableModel
    extends DmTableModel {
        DmUserTableModel() {
        }

        @Override
        public boolean isCellActive(int row, int col) {
            return super.isCellActive(row, col);
        }

        @Override
        public int compare(Object first, Object second) {
            if (this._sortColumn == 0) {
                int[] firstOid = ((SnmpOID)first).getValue();
                int[] firstUserName = new int[firstOid[firstOid[0] + 1]];
                System.arraycopy(firstOid, firstOid[0] + 2, firstUserName, 0, firstUserName.length);
                int[] secondOid = ((SnmpOID)second).getValue();
                int[] secondUserName = new int[secondOid[firstOid[0] + 1]];
                System.arraycopy(secondOid, secondOid[0] + 2, secondUserName, 0, secondUserName.length);
                return MibNode.equals(firstUserName, secondUserName);
            }
            return super.compare(first, second);
        }
    }

    class MysnmpUserPasswordChange
    extends SnmpUserPasswordChange {
        public MysnmpUserPasswordChange(JFrame parent, SnmpPeer peer, String userName, boolean isSHA, boolean isAES) {
            super(parent, peer, userName, isSHA, isAES);
        }

        @Override
        public void dispose() {
            super.dispose();
            EditUserTable.this._passwordDlg = null;
        }
    }
}

