/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.CommonRoleFeatureCache;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.CommonRoleRuleSummary;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.CommonRoleFeature;
import com.cisco.dcbu.lib.mds.CommonRoleUtil;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class InsertCommonRoleRule
extends JDialog
implements ActionListener,
ItemListener {
    private static final String[] LABELS = new String[]{"CLI Command", "Clear", "Config", "Debug", "Show", "Exec"};
    private static final String[] SELECT_LABELS = new String[]{"", "Clear", "Config", "Debug", "Show", "Exec"};
    JFrame _parent;
    SnmpPeer _peer;
    String _roleName;
    SnmpTableModel _tableModel;
    boolean _isCreateRule;
    static CommonRoleFeature _ruleTable;
    CommonRoleFeature _applyRuleTable;
    JCheckBox[] _selectAllButtons;
    CommonRoleRuleSummary _summaryDialog;
    EditTable _table;

    public InsertCommonRoleRule(JFrame parent, EditTable table, SnmpPeer peer, String roleName, CommonRoleFeature ruleTable, boolean isCreateRule) {
        super(parent);
        this.setDefaultCloseOperation(2);
        this._parent = parent;
        this._table = table;
        this._peer = peer;
        this._roleName = roleName;
        _ruleTable = ruleTable == null ? CommonRoleUtil.getInstance().getFeatureData(this._peer, CommonRoleFeatureCache.getInstance().getCommonRoleFeatures()) : ruleTable;
        this._isCreateRule = isCreateRule;
        this._applyRuleTable = null;
        String[] bLabels = new String[]{"Summary...", "Apply", "Close"};
        JLabel status = new JLabel();
        JPanel statusPanel = DialogUtil.buildStatusPanel(DialogUtil.buildButtons(bLabels, (ActionListener)this), status);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)this.buildRulePanel(), statusPanel);
        status.setText("NOTE: SNMP maps CLI commands to SET or GET.");
        this.setResizable(true);
    }

    JPanel buildRulePanel() {
        JPanel pane = new JPanel(new BorderLayout());
        JPanel btnPanel = new JPanel(new FlowLayout(2, 1, 2));
        pane.add("North", this.buildBtnPanel(btnPanel));
        JPanel tablePane = new JPanel(new BorderLayout());
        this._tableModel = new SnmpCmnRoleRuleTableModel();
        tablePane.add("Center", this.buildScrollPane(this._tableModel));
        pane.add("Center", tablePane);
        return pane;
    }

    JPanel buildBtnPanel(JPanel btnPanel) {
        btnPanel.add(new JLabel("Select All: "));
        this._selectAllButtons = new JCheckBox[LABELS.length];
        for (int i = 1; i < this._selectAllButtons.length; ++i) {
            this._selectAllButtons[i] = new JCheckBox(SELECT_LABELS[i]);
            this._selectAllButtons[i].addItemListener(this);
            btnPanel.add(this._selectAllButtons[i]);
        }
        return btnPanel;
    }

    JScrollPane buildScrollPane(KTableModel tableModel) {
        tableModel.setData(_ruleTable.getData());
        tableModel.setEditable(new boolean[]{false, true, true, true, true, true});
        tableModel.setHeaders(LABELS);
        SnmpKTable table = new SnmpKTable(tableModel);
        table.getTableHeader().addMouseListener(new HeaderListener());
        table.setSortable(true);
        JScrollPane pane = new JScrollPane(table);
        pane.setPreferredSize(table.calcPreferredSize());
        return pane;
    }

    public void refresh(CommonRoleFeature ruleTable) {
        _ruleTable = ruleTable == null ? CommonRoleUtil.getInstance().getFeatureData(this._peer, CommonRoleFeatureCache.getInstance().getCommonRoleFeatures()) : ruleTable;
        this._tableModel.setData(_ruleTable.getData());
        this._tableModel.fireTableDataChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean isSelected = e.getStateChange() == 1;
        for (int i = 1; i < this._selectAllButtons.length; ++i) {
            if (e.getSource() != this._selectAllButtons[i]) continue;
            this.selectAll(isSelected, i);
        }
    }

    private void selectAll(boolean isSelected, int col) {
        Boolean val = isSelected ? Boolean.TRUE : Boolean.FALSE;
        for (int row = 0; row < this._tableModel.getData().size(); ++row) {
            if (!this._tableModel.isCellActive(row, col)) continue;
            this._tableModel.setValueAt(val, row, col);
        }
    }

    @Override
    public void dispose() {
        if (this._summaryDialog != null) {
            this._summaryDialog.dispose();
        }
        super.dispose();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.gc();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (((AbstractButton)e.getSource()).getText().charAt(0)) {
            case 'S': {
                if (this._summaryDialog != null && this._summaryDialog.isVisible()) {
                    this._summaryDialog.refresh(_ruleTable.getData());
                    this._summaryDialog.toFront();
                    break;
                }
                this._summaryDialog = new CommonRoleRuleSummary(this._parent, _ruleTable.getData());
                this._summaryDialog.setTitle(Discover.getDeviceName() + " -" + (this._roleName == null ? "" : " " + this._roleName) + " Role Summary");
                this._summaryDialog.setLocation(DialogUtil.getPointOnScreen(new Point(0, 0), (JComponent)e.getSource(), this._summaryDialog.getSize()));
                this._summaryDialog.setVisible(true);
                break;
            }
            case 'A': {
                this._applyRuleTable = _ruleTable;
                if (!this._isCreateRule) break;
                Array rollbackPduList = new Array();
                try {
                    Array pduList = new Array();
                    boolean isExceedMaxRules = CommonRoleUtil.getInstance().getSetRulePDU(pduList, rollbackPduList, this._peer, null, this._roleName, _ruleTable, CommonRoleFeatureCache.getInstance().getMaxRulePerRole(), Discover.getSysVersionObject());
                    if (isExceedMaxRules) {
                        throw new SnmpException("Max rules per role is " + CommonRoleFeatureCache.getInstance().getMaxRulePerRole());
                    }
                    for (int pduP = 0; pduP < pduList.size(); ++pduP) {
                        this._peer.set((SnmpPDU)pduList.elementAt(pduP));
                    }
                    this._table.setCFSPending(this._peer);
                }
                catch (SnmpException ex) {
                    Util.errorMessage((Component)DeviceManager.getInstance(), ex);
                    if (SnmpSession.isTrace()) {
                        ex.printStackTrace();
                    }
                    try {
                        for (int i = pduP - 1; i >= 0; --i) {
                            SnmpFetch.set(this._peer, (SnmpPDU)rollbackPduList.elementAt(i));
                        }
                    }
                    catch (SnmpException ex1) {
                        Util.errorMessage((Component)DeviceManager.getInstance(), "Rollback failed: " + ex1);
                        if (!SnmpSession.isTrace()) break;
                        ex1.printStackTrace();
                    }
                }
                break;
            }
            case 'C': {
                super.setVisible(false);
                return;
            }
        }
    }

    CommonRoleFeature getRuleTable() {
        return this._applyRuleTable;
    }

    class SnmpCmnRoleRuleTableModel
    extends DmTableModel {
        SnmpCmnRoleRuleTableModel() {
        }

        @Override
        public boolean isCellActive(int row, int col) {
            if (col >= 1 && col <= 5) {
                int[] cellActive = (int[])this.getValueAt(row, 7);
                return cellActive != null && cellActive[col] == 1;
            }
            return super.isCellActive(row, col);
        }
    }
}

