/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.EditCommonUserTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.InsertUser;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.CheckBoxListPanel;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class InsertCommonUser
extends InsertForm {
    private int NAME = 0;
    private int PASSWORD = 1;
    private int ROLE = 2;
    private int AUTH = 2;
    private int PRIV = 3;
    private int EXPIRYDATE = 5;
    private CheckBoxListPanel _listPanel;
    String[] _roles;

    public InsertCommonUser(InsertDialog parent, EditTable table) {
        super(parent, table);
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == this.PASSWORD) {
            return new JPasswordField(20);
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected void layoutForm() {
        JComponent[] labels = new JLabel[this._labels.length + 1];
        System.arraycopy(this._labels, 0, labels, 0, 2);
        System.arraycopy(this._labels, 2, labels, 3, this._labels.length - 2);
        labels[this.ROLE] = new JLabel("Roles:", 4);
        JComponent[] values = new JComponent[this._values.length + 1];
        System.arraycopy(this._values, 0, values, 0, 2);
        System.arraycopy(this._values, 2, values, 3, this._values.length - 2);
        Object[] list = InsertUser.getCommonRoles(this.getPeer());
        this._listPanel = new CheckBoxListPanel(list);
        this._listPanel.clearSelection();
        JScrollPane sp = new JScrollPane(this._listPanel);
        this._listPanel.setUnitIncrement(sp);
        sp.setPreferredSize(new Dimension(170, 100));
        values[this.ROLE] = sp;
        DialogUtil.buildPanel(this._container, labels, values);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (index == this.AUTH || index == this.PRIV) {
            int selected = ((RadioButtonPanel)this._values[index]).getSelected();
            if (index == this.PRIV) {
                selected += 3;
            }
            return SnmpTableModel.getMibVariableSet(this._vars[index], MibVariableFormat._UsmUserProtocolEnums[selected], this.getMibVariableSet(), this.getMibVariableSetClass());
        }
        if (index == this.NAME) {
            if (((JTextField)this._values[index]).getText().equals("")) {
                throw new SnmpException("Please enter User Name");
            }
        } else if (index == this.EXPIRYDATE) {
            String date = ((JTextField)this._values[index]).getText();
            if (date.indexOf(45) != -1) {
                throw new SnmpException("Expected yyyy/mm/dd format");
            }
            return this.getVarFromString(date.length() == 0 ? date : date + "-00:00:00", index);
        }
        return super.getComponentValue(index);
    }

    @Override
    protected SnmpVar[] getInsertValue() throws Exception {
        this._roles = new String[0];
        if (!(this._values[this.ROLE] instanceof JLabel)) {
            Object[] selected = this._listPanel.getSelectedValues();
            this._roles = new String[selected.length];
            for (int i = 0; i < selected.length; ++i) {
                this._roles[i] = selected[i].toString();
            }
        }
        return super.getInsertValue();
    }

    @Override
    protected void tableInsert(SnmpVar[] values, int[] index) throws Exception {
        SnmpPDU pdu = this.buildInsertPDU(index, values);
        SnmpPDU rolePdu = new SnmpPDU(-93, new VarBindList());
        for (int j = 0; j < this._roles.length; ++j) {
            int[] roleIndex = new int[index.length + this._roles[j].length() + 1];
            System.arraycopy(index, 0, roleIndex, 0, index.length);
            roleIndex[index.length] = this._roles[j].length();
            int l = index.length + 1;
            for (int m = 0; l < roleIndex.length && m < this._roles[j].length(); ++l, ++m) {
                roleIndex[l] = this._roles[j].charAt(m);
            }
            rolePdu.addVar(new SnmpOID(MibNode.get("ccmCommonUserRoleRowStatus").getOid(), roleIndex), new SnmpInt(4));
        }
        if (rolePdu.getVariables().size() > 0) {
            pdu.addVar(rolePdu.getVariables().get(0));
            rolePdu.removeVarAt(0);
        }
        boolean encryptedNodes = false;
        if (Discover.getPeer().getPrivPassword() == null) {
            Discover.getPeer().setPrivPassword(Discover.getPeer().getAuthPassword());
            Discover.getPeer().setPrivProtocol(0);
            Discover.getPeer().calcLocalizedKey();
            encryptedNodes = true;
        }
        for (int i = 0; i < pdu.getVariables().size(); ++i) {
            if (!pdu.getVariables().get(i).getOid().startsWith(EditCommonUserTable.CcmCommonUserPasswordOid)) continue;
            pdu.setVarBindMask(new int[]{i});
            break;
        }
        try {
            this.getPeer().set(pdu);
        }
        catch (Exception ex) {
            if (encryptedNodes) {
                Discover.getPeer().setPrivPassword(null);
                Discover.getPeer().setPrivKey(null);
                encryptedNodes = false;
            }
            throw new Exception(ex.getMessage());
        }
        if (encryptedNodes) {
            Discover.getPeer().setPrivPassword(null);
            Discover.getPeer().setPrivKey(null);
            encryptedNodes = false;
        }
        if (rolePdu.getVariables().size() > 0) {
            try {
                this.getPeer().set(rolePdu);
            }
            catch (SnmpException ex) {
                try {
                    SnmpPDU rollbackPdu = new SnmpPDU(-93, new VarBindList(1));
                    rollbackPdu.addVar(new SnmpOID(this.getRowStatus(), index), new SnmpInt(6));
                    this.getPeer().set(rollbackPdu);
                }
                catch (SnmpException ex1) {
                    throw new SnmpException(ex.getMessage() + "failed to remove user-" + ex1.getMessage());
                }
                throw new SnmpException(ex.getMessage());
            }
        }
    }
}

