/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertDialog;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.dmdb.andiamo.dialogs.DeviceAlias;
import com.cisco.dcbu.dmdb.andiamo.dialogs.EndPort;
import com.cisco.dcbu.dmdb.andiamo.dialogs.IslLink;
import com.cisco.dcbu.dmdb.andiamo.dialogs.Switch;
import com.cisco.dcbu.dmdb.andiamo.dialogs.SwitchMapUtil;
import com.cisco.dcbu.lib.jnm.SnmpTableModel;
import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.mds.VsanIdMenuButton;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.KTextField;
import com.cisco.dcbu.lib.ui.RadioButtonPanel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InsertPSMDBConfig
extends InsertForm
implements ItemListener,
ListSelectionListener {
    static final int INTERFACE = 0;
    static final int INDEX = 1;
    static final int DEVTYPE = 3;
    static final int WWN = 4;
    static final int TYPE = 6;
    static final int IFINDEX = 7;
    static final int NWWN_TYPE = 0;
    static final int PWWN_TYPE = 1;
    static final int SWWN_TYPE = 2;
    static final int ALIAS_TYPE = 4;
    static final int ANY = 3;
    boolean _isPortSecurity;
    private JTextField _wwn;
    private JList _list;
    private JLabel _wwnLabel;
    private JList _islList;
    private JTextField _islIfIndex;
    private JLabel _ifIndexLabel;
    ArrayList _switchList = null;
    HashMap _switchHash = null;
    HashMap _endPortHash = null;
    ArrayList _endPortList = null;
    ArrayList _npvISLList = null;
    ArrayList _deviceAliasList = null;

    public InsertPSMDBConfig(InsertDialog parent, EditTable table) {
        super(parent, table);
        this._isPortSecurity = table._insertVars[0].startsWith("cpsmPortBind");
    }

    @Override
    protected void build() {
        super.build();
        ((FieldPanel)this._values[1]).setVisible(false);
        this._labels[1].setVisible(false);
        this._islList.setEnabled(false);
        if (this._wwnLabel != null) {
            DialogUtil.constrain(this._container, this._wwnLabel, new GridBagConstraints(), 0, 5, 0, 14);
        }
        if (this._ifIndexLabel != null) {
            DialogUtil.constrain(this._container, this._ifIndexLabel, new GridBagConstraints(), 0, 8, 0, 14);
        }
        if (this._isPortSecurity) {
            ((RadioButtonPanel)this._values[3]).addChangeListener(this);
            ((RadioButtonPanel)this._values[6]).addChangeListener(this);
        }
    }

    @Override
    protected JComponent buildComponent(String mibVar, MibNode mibNode, int index) {
        if (index == 0) {
            VsanIdMenuButton vsanBtn = new VsanIdMenuButton(null, this.getPeer(), 1, Discover.getRoot());
            vsanBtn.setParent(this);
            FieldPanel vsanPanel = new FieldPanel(mibNode.getMaxWidth(), (JComponent)vsanBtn);
            vsanPanel.getField().setEditable(false);
            vsanPanel.setRange(1, 4093);
            return vsanPanel;
        }
        if (index == 4) {
            JPanel panel = new JPanel(new BorderLayout(1, 2));
            ArrayList endPortList = this.getInsertInfo(1);
            this._list = new JList<EndPort>(endPortList.toArray(new EndPort[endPortList.size()]));
            this._list.addListSelectionListener(this);
            this._list.setSelectionMode(1);
            this._list.setCellRenderer(new DmPsmFabricBindCellRenderer());
            JScrollPane sp = new JScrollPane(this._list);
            sp.setPreferredSize(new Dimension(300, 100));
            panel.add("Center", sp);
            this._wwn = new KTextField();
            panel.add("South", this._wwn);
            return panel;
        }
        if (index == 7) {
            JPanel panel = new JPanel(new BorderLayout(1, 2));
            ArrayList islList = this.getInsertIslInfo(1, null);
            this._islList = new JList<IslLink>(islList.toArray(new IslLink[islList.size()]));
            this._islList.addListSelectionListener(this);
            this._islList.setSelectionMode(1);
            this._islList.setCellRenderer(new DmPsmFabricBindCellRenderer());
            JScrollPane sp = new JScrollPane(this._islList);
            sp.setPreferredSize(new Dimension(300, 100));
            panel.add("Center", sp);
            this._islIfIndex = new KTextField();
            panel.add("South", this._islIfIndex);
            return panel;
        }
        return super.buildComponent(mibVar, mibNode, index);
    }

    @Override
    protected int[] getInsertIndex(SnmpVar[] values) throws Exception {
        int[] index = new int[]{1, Integer.parseInt(this.getComponentText(0)), Integer.parseInt(this.getComponentText(1))};
        return index;
    }

    @Override
    protected JLabel createFormLabel(String mibVar, int index) {
        if (index == 4) {
            this._wwnLabel = new JLabel("<html><div align=right>Available<br>(WWN, Interface)<br>WWN:</html>", 4);
            return this._wwnLabel;
        }
        if (index == 7) {
            this._ifIndexLabel = new JLabel("<html><div align=right>Available<br>(IpAddress, Interface)<br>Interface:</html>", 4);
            return this._ifIndexLabel;
        }
        return super.createFormLabel(mibVar, index);
    }

    @Override
    protected SnmpVar getComponentValue(int index) throws NumberFormatException, Exception {
        if (this._isPortSecurity && index == 7) {
            int typeSelection = ((RadioButtonPanel)this._values[6]).getSelected() + 1;
            if (typeSelection == 2) {
                int ifIndex = Discover.getRoot().nameToIfIndex(this._islIfIndex.getText());
                byte[] b = new byte[4];
                b[3] = (byte)(ifIndex & 0xFF);
                b[2] = (byte)(ifIndex >> 8 & 0xFF);
                b[1] = (byte)(ifIndex >> 16 & 0xFF);
                b[0] = (byte)(ifIndex >> 24 & 0xFF);
                return new SnmpString(b);
            }
            if (typeSelection == 1) {
                return new SnmpWWN(this._islIfIndex.getText(), false);
            }
            return super.getComponentValue(index);
        }
        if (index == 4) {
            if (this._wwn.getText().length() == 0) {
                throw new Exception("Peer WWN: invalid entry");
            }
            if (((RadioButtonPanel)this._values[3]).getSelected() == 4) {
                return new SnmpString(this._wwn.getText());
            }
            return new SnmpWWN(this._wwn.getText(), false);
        }
        return super.getComponentValue(index);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        boolean isWildCard = ((JToggleButton)e.getSource()).getText().equals("any");
        if (((JToggleButton)e.getSource()).getParent() == this._values[3]) {
            int portType = ((RadioButtonPanel)this._values[6]).getSelected();
            this.setEnabled(4, !isWildCard);
            this._wwnLabel.setEnabled(!isWildCard);
            if (this._wwn != null) {
                this._wwn.setEnabled(!isWildCard);
            }
            if (this._list != null) {
                this._list.setEnabled(!isWildCard);
            }
            if (this._islList != null) {
                this._islList.setEnabled(!isWildCard && portType != 2);
            }
            if (!isWildCard) {
                this.getWWNInfo();
            } else {
                this._wwn.setText("");
                this._islIfIndex.setText("");
            }
        } else {
            int devType = ((RadioButtonPanel)this._values[3]).getSelected();
            boolean isEndPort = devType == 0 || devType == 1;
            boolean isSwitch = devType == 2;
            int selected = ((RadioButtonPanel)this._values[6]).getSelected();
            this._ifIndexLabel.setEnabled(!isWildCard && !isEndPort);
            this._islList.setEnabled(!isWildCard && !isEndPort && devType != 3);
            this._islIfIndex.setEnabled(!isWildCard);
            if (!isWildCard && devType != 3) {
                if (isEndPort) {
                    EndPort dmEndPort = (EndPort)this._list.getSelectedValue();
                    this._islIfIndex.setText(dmEndPort == null ? "" : (selected == 0 ? SnmpString.toHexString(dmEndPort.getfWwn()) : Discover.getRoot().ifIndexToName(dmEndPort.getIfIndex())));
                } else if (isSwitch) {
                    IslLink dmIslLink = (IslLink)this._islList.getSelectedValue();
                    this._islIfIndex.setText(dmIslLink == null ? "" : (selected == 0 ? SnmpString.toHexString(dmIslLink.getfWwn()) : Discover.getRoot().ifIndexToName(dmIslLink.getIslIfIndex())));
                } else {
                    this._islIfIndex.setText("");
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if ((JList)e.getSource() == this._list) {
            DeviceAlias alias;
            int devType = ((RadioButtonPanel)this._values[3]).getSelected();
            if (devType == 0 || devType == 1) {
                EndPort dmEndPort = (EndPort)this._list.getSelectedValue();
                int selected = ((RadioButtonPanel)this._values[6]).getSelected();
                if (dmEndPort != null) {
                    this._wwn.setText(SnmpString.toHexString(dmEndPort.getWWN().getValue()));
                }
                this._islIfIndex.setText(dmEndPort == null ? "" : (selected == 0 ? SnmpString.toHexString(dmEndPort.getfWwn()) : Discover.getRoot().ifIndexToName(dmEndPort.getIfIndex())));
            } else if (devType == 2) {
                this._islIfIndex.setText("");
                Switch dmSwitch = (Switch)this._list.getSelectedValue();
                if (dmSwitch != null) {
                    this._wwn.setText(SnmpString.toHexString(dmSwitch.getWWN().getValue()));
                    this._islList.setEnabled(true);
                    ArrayList islList = this.getInsertIslInfo(devType, dmSwitch.getInetAddr());
                    this._islList.setListData(islList.toArray(new IslLink[islList.size()]));
                }
            } else if (devType == 4 && (alias = (DeviceAlias)this._list.getSelectedValue()) != null) {
                this._wwn.setText(alias.getAlias());
                int selected = ((RadioButtonPanel)this._values[6]).getSelected();
                EndPort dmEndPort = alias.getEndPort();
                this._islIfIndex.setText(dmEndPort == null ? "" : (selected == 0 ? SnmpString.toHexString(dmEndPort.getfWwn()) : Discover.getRoot().ifIndexToName(dmEndPort.getIfIndex())));
            }
        } else if ((JList)e.getSource() == this._islList) {
            int portType = ((RadioButtonPanel)this._values[6]).getSelected();
            IslLink dmIslLink = (IslLink)this._islList.getSelectedValue();
            this._islIfIndex.setText(dmIslLink == null ? "" : (portType == 0 ? SnmpString.toHexString(dmIslLink.getfWwn()) : Discover.getRoot().ifIndexToName(dmIslLink.getIslIfIndex())));
        }
    }

    @Override
    public void setChanged(JComponent c) {
        this._endPortList = null;
        this._switchList = null;
        int devType = ((RadioButtonPanel)this._values[3]).getSelected();
        if (devType != 3) {
            this.getWWNInfo();
        }
    }

    private void getWWNInfo() {
        String msg = this.getCreateStatus();
        this.setCreateStatus("Retrieving features, please wait...");
        this._parent.setCursor(Cursor.getPredefinedCursor(3));
        SwingUtilities.invokeLater(new PsmFabricBindWorker(msg));
    }

    ArrayList getInsertInfo(int type) {
        String strVsan = this.getComponentText(0);
        if (strVsan != null && !strVsan.equals("")) {
            int vsanId = Integer.parseInt(strVsan);
            if (this._switchList == null) {
                this._switchList = new ArrayList();
                this._switchHash = SwitchMapUtil.getSwitchMapHash(this.getPeer(), vsanId, this._switchList);
            }
            if (this._endPortList == null || this._endPortHash == null || this._npvISLList == null) {
                this._endPortList = new ArrayList();
                this._npvISLList = new ArrayList();
                this._endPortHash = SwitchMapUtil.getEndPortHash(this._switchHash, this.getPeer(), vsanId, this.getPeer().getAddress(), this._endPortList, this._switchList, this._npvISLList);
            }
            if (type == 2) {
                return this._switchList;
            }
            if (type == 4) {
                this._deviceAliasList = new ArrayList();
                SwitchMapUtil.getDeviceAliasHash(this._switchHash, this._endPortHash, this.getPeer(), vsanId, this.getPeer().getAddress(), this._endPortList, this._switchList, this._deviceAliasList);
                return this._deviceAliasList;
            }
            return this._endPortList;
        }
        return new ArrayList();
    }

    ArrayList getInsertIslInfo(int type, InetAddress nbrSwitch) {
        String strVsan = this.getComponentText(0);
        if (strVsan != null && !strVsan.equals("") && type == 2 && nbrSwitch != null) {
            int vsanId = Integer.parseInt(strVsan);
            if (this._switchList == null) {
                this._switchList = new ArrayList();
                this._switchHash = SwitchMapUtil.getSwitchMapHash(this.getPeer(), vsanId, this._switchList);
            }
            if (this._endPortList == null || this._endPortHash == null || this._npvISLList == null) {
                this._endPortList = new ArrayList();
                this._npvISLList = new ArrayList();
                this._endPortHash = SwitchMapUtil.getEndPortHash(this._switchHash, this.getPeer(), vsanId, this.getPeer().getAddress(), this._endPortList, this._switchList, this._npvISLList);
            }
            return SwitchMapUtil.getIslArray(this._switchHash, this._npvISLList, this.getPeer(), vsanId, this.getPeer().getAddress(), nbrSwitch, 1);
        }
        return new ArrayList();
    }

    @Override
    protected void insert() throws Exception {
        this.setComponentText(1, Integer.toString(this.getPort()));
        super.insert();
    }

    int getPort() {
        String vsanString = this.getComponentText(0);
        if (vsanString.equals("")) {
            return 0;
        }
        int vsan = Integer.parseInt(vsanString);
        SnmpTableModel model = this.getTableModel();
        Array data = model.getData();
        int port = 0;
        for (int i = 0; i < data.size(); ++i) {
            SnmpOID oid = (SnmpOID)((Object[])data.elementAt(i))[0];
            if (oid.getValue()[1] != vsan || oid.getValue()[2] <= port) continue;
            port = oid.getValue()[2];
        }
        return ++port;
    }

    static class DmPsmFabricBindCellRenderer
    extends DefaultListCellRenderer {
        DmPsmFabricBindCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof EndPort) {
                EndPort dmEndPort = (EndPort)value;
                this.setText(dmEndPort.toString());
            } else if (value instanceof Switch) {
                Switch dmSwitch = (Switch)value;
                this.setText(dmSwitch.toString());
            } else if (value instanceof DeviceAlias) {
                DeviceAlias das = (DeviceAlias)value;
                this.setText(das.toString());
            } else {
                IslLink dmIslLink = (IslLink)value;
                this.setText(dmIslLink.toString());
            }
            return retValue;
        }
    }

    class PsmFabricBindWorker
    implements Runnable {
        String _message;

        public PsmFabricBindWorker(String message) {
            this._message = message;
        }

        @Override
        public void run() {
            int devType = ((RadioButtonPanel)InsertPSMDBConfig.this._values[3]).getSelected();
            int portType = ((RadioButtonPanel)InsertPSMDBConfig.this._values[6]).getSelected();
            ArrayList wwnList = InsertPSMDBConfig.this.getInsertInfo(devType);
            if (devType == 0 || devType == 1) {
                InsertPSMDBConfig.this._list.setListData(wwnList.toArray(new EndPort[wwnList.size()]));
                InsertPSMDBConfig.this._islList.setEnabled(false);
            } else if (devType == 2) {
                for (int i = wwnList.size() - 1; i >= 0; --i) {
                    Switch sw = (Switch)wwnList.get(i);
                    InetAddress myIpAddress = InsertPSMDBConfig.this.getPeer().getAddress();
                    if (!myIpAddress.equals(sw.getInetAddr())) continue;
                    wwnList.remove(i);
                }
                InsertPSMDBConfig.this._list.setListData(wwnList.toArray(new Switch[wwnList.size()]));
            } else if (devType == 4) {
                InsertPSMDBConfig.this._list.setListData(wwnList.toArray(new DeviceAlias[wwnList.size()]));
                InsertPSMDBConfig.this._islList.setEnabled(false);
            }
            InsertPSMDBConfig.this.setCreateStatus(this._message);
            InsertPSMDBConfig.this._parent.setCursor(Cursor.getDefaultCursor());
        }
    }
}

