/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.security;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.EditUserTable;
import com.cisco.dcbu.dmdb.andiamo.dialogs.security.InsertUser;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class SnmpUserPasswordChange
extends JDialog
implements ActionListener {
    static final int NO_AUTH_NO_PRIV = 1;
    static final int AUTH_NO_PRIV = 2;
    static final int AUTH_PRIV = 3;
    static final String[] _Labels = new String[]{null, "Old Password:", "New Password:", "Confirm Password:", null, "Old Password:", "New Password:", "Confirm Password:"};
    static final int AUTH_PANEL = 0;
    static final int OLD_AUTHPWD = 1;
    static final int NEW_AUTHPWD = 2;
    static final int CONFIRM_AUTHPWD = 3;
    static final int PRIV_PANEL = 4;
    static final int OLD_PRIVPWD = 5;
    static final int NEW_PRIVPWD = 6;
    static final int CONFIRM_PRIVPWD = 7;
    static final int[] USM_NO_AUTH_PROTOCOL = new int[]{1, 3, 6, 1, 6, 3, 10, 1, 1, 1};
    static final int[] USM_NO_PRIV_PROTOCOL = new int[]{1, 3, 6, 1, 6, 3, 10, 1, 2, 1};
    protected JCheckBox _privLevel;
    protected JCheckBox _authLevel;
    protected JCheckBox _authSHA;
    protected JCheckBox _privAES;
    boolean _isPrivEnabled = false;
    boolean _isAuthEnabled = true;
    public static final int AUTH = 1;
    public static final int PRIV = 2;
    public static final int AUTHPRIV = 3;
    static final int NONE = 4;
    JComponent[] _values;
    JLabel[] _labels;
    JFrame _parent;
    SnmpPeer _peer;
    String _userName;
    JLabel _status;
    boolean _isSHA;
    boolean _isAES;

    public SnmpUserPasswordChange(JFrame parent, SnmpPeer peer, String userName, boolean isSHA, boolean isAES) {
        super(parent);
        this.setDefaultCloseOperation(2);
        this._parent = parent;
        this._peer = peer;
        this._userName = userName;
        this._isSHA = isSHA;
        this._isAES = isAES;
        this._labels = DialogUtil.buildLabels(_Labels);
        this._values = new JComponent[_Labels.length];
        JPanel authPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._authLevel = new JCheckBox("Authentication", false);
        authPanel.add(this._authLevel);
        this._authSHA = new JCheckBox("SHA", false);
        authPanel.add(this._authSHA);
        this._values[0] = authPanel;
        JPanel privacyPanel = new JPanel(new FlowLayout(0, 0, 0));
        this._privLevel = new JCheckBox("Privacy", false);
        privacyPanel.add(this._privLevel);
        this._privAES = new JCheckBox("AES", false);
        privacyPanel.add(this._privAES);
        this._values[4] = privacyPanel;
        this._authSHA.setSelected(this._isSHA);
        this._privAES.setSelected(this._isAES);
        this._authSHA.setVisible(false);
        this._privAES.setVisible(false);
        for (int i = 0; i < this._values.length; ++i) {
            if (this._values[i] != null) continue;
            this._values[i] = new JPasswordField(20);
        }
        String[] bLabels = new String[]{"Apply", "Close"};
        JPanel bottom = new JPanel(new BorderLayout());
        this._status = new JLabel(" ");
        this._status.setFont(ChangedCellRenderer.getNormalFont());
        this._status.setBorder(null);
        bottom.setBorder(new EmptyBorder(DMDialog._BottomInsets));
        bottom.add((Component)this._status, "South");
        JButton[] buttons = DialogUtil.buildButtons(bLabels, (ActionListener)this);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 6, 3));
        for (int i = 0; i < buttons.length; ++i) {
            buttonPanel.add(buttons[i]);
        }
        bottom.add((Component)buttonPanel, "North");
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)DialogUtil.buildPanel(this._labels, this._values), bottom);
        this._privLevel.setSelected(false);
        this._authLevel.setSelected(true);
        this._privLevel.addActionListener(this);
        this._authLevel.addActionListener(this);
        this._values[5].setEnabled(false);
        this._values[6].setEnabled(false);
        this._values[7].setEnabled(false);
        this._labels[5].setEnabled(false);
        this._labels[6].setEnabled(false);
        this._labels[7].setEnabled(false);
        this._isAuthEnabled = true;
        this._isPrivEnabled = false;
    }

    void passwordConfirmed() throws Exception {
        String auth_pwd = ((JTextComponent)this._values[2]).getText();
        String priv_pwd = ((JTextComponent)this._values[6]).getText();
        String auth_cfm_pwd = ((JTextComponent)this._values[3]).getText();
        String priv_cfm_pwd = ((JTextComponent)this._values[7]).getText();
        String confirm_fail_msg = "Passwords do not match";
        String length_fail_msg = "Password needs to be at least 8 characters long";
        if (this._values[6].isEnabled()) {
            if (priv_pwd.length() < 8) {
                throw new Exception(length_fail_msg);
            }
            if (!priv_pwd.equals(priv_cfm_pwd)) {
                throw new Exception(confirm_fail_msg);
            }
        } else if (this._values[2].isEnabled()) {
            if (auth_pwd.length() < 8) {
                throw new Exception(length_fail_msg);
            }
            if (!auth_pwd.equals(auth_cfm_pwd)) {
                throw new Exception(confirm_fail_msg);
            }
        }
        if (!this._isAuthEnabled && ((JTextComponent)this._values[1]).getText().equals("")) {
            throw new Exception("Old Authentication Password needed to validate old Privacy Password");
        }
        if (!InsertUser.validateUSMUserPassword(this._peer, this._userName, this._isSHA ? 1 : 0, ((JTextComponent)this._values[1]).getText().equals("") ? null : ((JTextComponent)this._values[1]).getText(), this._isAES ? 1 : 0, ((JTextComponent)this._values[5]).getText().equals("") ? null : ((JTextComponent)this._values[5]).getText())) {
            throw new Exception("Invalid old password");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._privLevel || e.getSource() == this._authLevel) {
            int confirmPos;
            int newPos;
            int oldPos;
            boolean isEnabled;
            if (e.getSource() == this._authLevel) {
                isEnabled = ((JCheckBox)e.getSource()).isSelected();
                this._isAuthEnabled = isEnabled;
                oldPos = 1;
                newPos = 2;
                confirmPos = 3;
            } else {
                isEnabled = ((JCheckBox)e.getSource()).isSelected();
                this._isPrivEnabled = isEnabled;
                oldPos = 5;
                newPos = 6;
                confirmPos = 7;
            }
            if (e.getSource() != this._authLevel || isEnabled) {
                this._values[oldPos].setEnabled(isEnabled);
            }
            this._values[newPos].setEnabled(isEnabled);
            this._values[confirmPos].setEnabled(isEnabled);
            if (e.getSource() != this._authLevel || isEnabled) {
                this._labels[oldPos].setEnabled(isEnabled);
            }
            this._labels[newPos].setEnabled(isEnabled);
            this._labels[confirmPos].setEnabled(isEnabled);
            return;
        }
        switch (((AbstractButton)e.getSource()).getText().charAt(0)) {
            case 'A': {
                int[] index = EditUserTable.getUserIndex(this._peer.getEngineId(), this._userName);
                byte[] engineId = this._peer.getEngineId();
                String sessionAuthPwd = ((JTextComponent)this._values[1]).getText();
                String newAuthPassword = ((JTextComponent)this._values[2]).getText();
                String sessionPrivPwd = ((JTextComponent)this._values[5]).getText();
                String newPrivPassword = ((JTextComponent)this._values[6]).getText();
                try {
                    this.passwordConfirmed();
                    try {
                        int flag;
                        int n = this._isAuthEnabled ? (this._isPrivEnabled ? 3 : 1) : (flag = this._isPrivEnabled ? 2 : 4);
                        if (flag == 4) {
                            return;
                        }
                        InsertUser.changeUSMUserPassword(this._peer, index, engineId, flag, this._isSHA ? 1 : 0, sessionAuthPwd, newAuthPassword, sessionPrivPwd, newPrivPassword, false);
                        this._status.setText("ok");
                        if (this._userName.equals(this._peer.getUserName())) {
                            this._peer.setCredentials(this._peer.getSession(), this._peer.getUserName(), newAuthPassword, this._peer.getAuthProtocol(), newPrivPassword.equals("") ? null : newPrivPassword, this._peer.getPrivProtocol());
                        }
                        InsertUser.createCLISnmpUser(this, this._peer, this._userName, this._peer.getAuthProtocol(), newAuthPassword, this._peer.getPrivProtocol(), newPrivPassword, this._status);
                    }
                    catch (Exception ex) {
                        if (ex.getMessage().indexOf("commitFailed") != -1) {
                            Util.errorMessage((Component)this._parent, "Clone Privacy Password non-existing");
                            break;
                        }
                        Util.errorMessage((Component)this._parent, "Failed to change passwords. (" + ex.getMessage() + ")");
                    }
                }
                catch (Exception ex) {
                    Util.errorMessage((Component)this._parent, ex.getMessage());
                }
                break;
            }
            case 'C': {
                super.setVisible(false);
                return;
            }
        }
    }
}

