/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.sme;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.DmTableModel;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import javax.swing.ListSelectionModel;

public class EditSMEIfTable
extends EditTable {
    public static int[] _IfIndex = new int[]{0x11FFFFFF};
    static final int ALIAS = 2;
    static final int ADMINSPEED = 3;
    static final int SPEED = 4;
    static final int ADMIN = 5;
    static final int OPER = 6;
    static final int CAUSE = 7;
    static final int LASTCHANGE = 8;
    int[] _ifColumns = new int[]{2, 3, 4, 5, 6, 7, 8};
    protected int _smeTimeout = 60000;
    static final String VER_STR_5_2_6 = "5.2(6)";

    public EditSMEIfTable(String[] vars) {
        super(vars);
    }

    @Override
    protected int[] getIndex() {
        return _IfIndex;
    }

    @Override
    protected boolean isEnd(int[] req, SnmpVarBind vb) {
        if (vb.getError() == 21) {
            return true;
        }
        int[] oid = vb.getOid().getValue();
        int[] newFirstOid = new int[req.length - 1];
        System.arraycopy(req, 0, newFirstOid, 0, newFirstOid.length);
        return !SnmpOID.startsWith(newFirstOid, vb.getOid().getValue()) || IfIndexUtil.getType(oid[oid.length - 1]) != 18;
    }

    @Override
    protected DmTableModel buildTableModel() {
        DmTableModel model = new DmTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                if (col == 4) {
                    return false;
                }
                return super.isCellEditable(row, col);
            }
        };
        return model;
    }

    @Override
    protected void buildTable() {
        super.buildTable();
        ListSelectionModel tableListener = this._table.getSelectionModel();
        tableListener.setSelectionMode(0);
    }

    @Override
    protected SnmpPDU getDeletePDU(int[] selected) {
        SnmpPDU pdu = super.getDeletePDU(selected);
        if (Discover.isSysVersionGreaterThanEqual(VER_STR_5_2_6)) {
            pdu.setTimeout(this._smeTimeout);
        }
        return pdu;
    }
}

