/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.dialogs.syslog;

import com.cisco.dcbu.dm.DMDialog;
import com.cisco.dcbu.dm.DialogListener;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.EditForm;
import com.cisco.dcbu.dm.EditTable;
import com.cisco.dcbu.dm.InsertForm;
import com.cisco.dcbu.install.Service;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import java.awt.Component;
import java.net.InetAddress;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CheckSysLogService
implements SnmpCallbackIf {
    JFrame _parent;
    SnmpPeer _peer;
    InetAddress _ipAddr;
    static final int AAAD = 1240;
    static final int INFO = 7;
    private static final int DNS_TYPE = 16;

    public CheckSysLogService(JFrame parent, SnmpPeer peer, InetAddress ipAddr) {
        this._parent = parent;
        this._peer = peer;
        this._ipAddr = ipAddr;
        if (!FiconPortByIfIndexCache.getInstance(peer).getIsFiconEnabled() && !Service.isRunning("SAN Server")) {
            return;
        }
        if (Discover.getSysVersionInterim().compareTo("1.3") >= 0) {
            this.changeAAADSeverity();
        }
        this.checkSysLogRegisterOnSwitch();
    }

    private void changeAAADSeverity() {
        try {
            VarBindList vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cseSyslogMessageSeverity").getOid(), 1240), new SnmpInt(7)));
            SnmpPDU pdu = new SnmpPDU(-93, vbl);
            pdu.setIgnoreSetCount(true);
            this._peer.set(pdu);
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this._parent, ex.getMessage());
        }
    }

    private void checkSysLogRegisterOnSwitch() {
        try {
            VarBindList vbl = new VarBindList(1);
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cseSyslogServerAddressType").getOid())));
            vbl.add(new SnmpVarBind(new SnmpOID(MibNode.get("cseSyslogServerAddress").getOid())));
            new SnmpFetch().getBulk(this._peer, vbl, 3, this);
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this._parent, ex.getMessage());
        }
    }

    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        if (this._parent == null) {
            return;
        }
        if (timedOut) {
            DefaultLogger._DefLogger.debug((Object)"Syslog Server timedout");
            return;
        }
        if (pdu.getError() != 0) {
            DefaultLogger._DefLogger.debug((Object)("Syslog Server: " + SnmpException.toError(pdu.getError())));
            return;
        }
        String dnsName = this._ipAddr.getHostName();
        VarBindList vbl = pdu.getVariables();
        boolean found = false;
        for (int i = 0; i < vbl.size() && !found; i += 2) {
            found = vbl.intValue(i) == 16 ? dnsName.equals(vbl.stringValue(i + 1)) : SnmpString.equals(this._ipAddr.getAddress(), vbl.byteValue(i + 1));
        }
        if (!found) {
            SwingUtilities.invokeLater(new PromptForSysLogLocal(this._parent, this._ipAddr.getHostAddress()));
        }
    }

    class UpdateForm
    implements Runnable {
        EditTable _table;
        EditForm _form;

        public UpdateForm(EditTable table, EditForm form) {
            this._table = table;
            this._form = form;
        }

        @Override
        public void run() {
            if (this._table.getTableModel().getRowCount() > 0) {
                int nextValue = this._table.getTableModel().getIndex(this._table.getTableModel().getRowCount() - 1)[0] + 1;
                if (nextValue > 3) {
                    nextValue = 3;
                }
                FieldPanel idPanel = (FieldPanel)this._form.getComponents()[0];
                idPanel.setText(Integer.toString(nextValue));
            }
        }
    }

    class PromptForSysLogLocal
    implements Runnable {
        JFrame _parent;
        String _ipAddress;

        public PromptForSysLogLocal(JFrame parent, String ipAddress) {
            this._parent = parent;
            this._ipAddress = ipAddress;
        }

        @Override
        public void run() {
            if (JOptionPane.showConfirmDialog(this._parent, "Do you want this switch to send SysLog messages to local server (" + this._ipAddress + ") ?", this._parent.getTitle(), 0) != 0) {
                return;
            }
            DMDialog d = DialogListener.getInstance().dialogAction("Syslog");
            EditTable panel = (EditTable)d.getPanel(0);
            AbstractButton[] buttons = panel.getBuiltButtons();
            buttons[0].doClick();
            InsertForm form = panel.getInsertDialog().getForm();
            SwingUtilities.invokeLater(new UpdateForm(panel, form));
        }
    }
}

