/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.AbstractPort;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class AbstractEthPort
extends AbstractPort {
    protected static JPopupMenu _Menu;
    protected String _toolTipText;
    public boolean _fcipStatusChanged = false;
    public String _fcipStatusToolTipText = "";
    public boolean _hide = false;
    public int[][] _fcipLinks = new int[0][];
    public boolean[] _fcipHide = new boolean[]{false, false, false, false, false, false};
    protected boolean _isIscsi = false;
    public int[][] _breakoutPorts;
    public int _iscsiOper = -1;
    public SnmpVar _connectorPresent;

    @Override
    public abstract SnmpVarBind[] getStatusVar();

    public abstract void redrawStatus(PhysicalView var1);

    public void redrawFcipLed(PhysicalView view) {
        Graphics g = view.getOffscreenImage().getGraphics();
        Color bg = new Color(66, 66, 66);
        g.setColor(bg);
        this.drawFcipLed(g, this._fcipLinks);
        g.dispose();
    }

    public void drawFcipLed(Graphics g, int[][] fcipLinks) {
        this._fcipLinks = fcipLinks;
        Rectangle r = this.getRect();
        for (int i = 0; i < fcipLinks.length; ++i) {
            Color fcipColor = Color.black;
            if (!this._fcipHide[i] && fcipLinks[i][0] != -1) {
                fcipColor = fcipLinks[i][1] == 1 ? Color.green : new Color(160, 132, 32);
            }
            int xOffset = fcipLinks.length < 6 ? 17 : 20;
            int yOffset = fcipLinks.length < 6 ? i * 5 : (i - 1) * 4;
            this.drawFcipLine(g, r, xOffset, yOffset, fcipColor);
        }
    }

    private void drawFcipLine(Graphics g, Rectangle r, int xOffset, int yOffset, Color color) {
        g.setColor(color);
        g.fillRect(r.x + xOffset, r.y + yOffset, 5, 1);
        g.drawRect(r.x + xOffset, r.y + yOffset, 5, 1);
    }

    public void clearBreakoutPortStatus(PhysicalView view) {
        this._breakoutPorts = null;
    }

    public void updateImage4BreakoutPortStatus(PhysicalView view) {
        if (this._breakoutPorts == null) {
            view.updateImage(this._image, this._rect.x, this._rect.y, Color.white);
            return;
        }
        boolean isAllUp = true;
        for (int i = 0; i < this._breakoutPorts.length; ++i) {
            if (this._breakoutPorts[i] == null || this._breakoutPorts[i][0] == 0 || this._breakoutPorts[i][1] == 2) continue;
            isAllUp = false;
            break;
        }
        Color portColor = isAllUp ? _Colors[0] : _Colors[3];
        view.updateImage(this._image, this._rect.x, this._rect.y, portColor);
    }

    public void updateBreakoutPortStatus(PhysicalView view, int bpIfIndex, int breakoutPort, int operCause, int breakoutFactor) {
        if (this._breakoutPorts == null) {
            this._breakoutPorts = new int[breakoutFactor][2];
        }
        this._breakoutPorts[breakoutPort][0] = bpIfIndex;
        this._breakoutPorts[breakoutPort][1] = operCause;
    }

    public void clearBreakoutPortLed(PhysicalView view, int breakoutFactor) {
        Graphics g = view.getOffscreenImage().getGraphics();
        Color bg = new Color(184, 186, 188);
        g.setColor(bg);
        Rectangle r = this.getRect();
        for (int i = 0; i < breakoutFactor; ++i) {
            int xOffset = 10;
            int yOffset = i * 5 + 1;
            this.drawBreakoutPortLine(g, r, xOffset, yOffset, bg);
        }
        this._breakoutPorts = null;
        g.dispose();
    }

    public void drawBreakoutPortLed(Graphics g, int breaoutFactor) {
        Rectangle r = this.getRect();
        this._breakoutPorts = new int[breaoutFactor][2];
        for (int i = 0; i < breaoutFactor; ++i) {
            Color blankColor = Color.black;
            int xOffset = 10;
            int yOffset = i * 5 + 1;
            this.drawBreakoutPortLine(g, r, xOffset, yOffset, blankColor);
        }
    }

    public void drawBreakoutPortLed(Graphics g, int bpIfIndex, int breaoutPort, int operCause) {
        Rectangle r = this.getRect();
        Color portColor = _Colors[1];
        this._breakoutPorts[breaoutPort][0] = bpIfIndex;
        this._breakoutPorts[breaoutPort][1] = operCause;
        switch (operCause) {
            case 2: {
                portColor = _Colors[0];
                break;
            }
            case 12: {
                portColor = _Colors[1];
                break;
            }
            case 155: {
                portColor = Color.black;
                break;
            }
            case 7: {
                portColor = _Colors[2];
            }
        }
        int xOffset = 10;
        int yOffset = breaoutPort * 5 + 1;
        this.drawBreakoutPortLine(g, r, xOffset, yOffset, portColor);
    }

    public void drawBreakoutPortLine(Graphics g, Rectangle r, int xOffset, int yOffset, Color color) {
        g.setColor(color);
        g.fillRect(r.x + xOffset, r.y + yOffset, 5, 2);
        g.drawRect(r.x + xOffset, r.y + yOffset, 5, 2);
    }

    @Override
    public void linkTrap(boolean up, VarBindList vbl, PhysicalView view) {
        this._toolTipText = null;
        this.setStatus(up ? 1 : 2, view);
        view.repaint();
    }

    @Override
    public abstract int[] getStatusIndex(int[] var1);

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
        this._toolTipText = null;
    }

    @Override
    public String getBitmap() {
        return "fcport.gif";
    }

    @Override
    public String getErrorBitmap() {
        return "fcporterror.gif";
    }

    @Override
    public abstract String getEditDialog();

    @Override
    public abstract String getGraphDialog();

    @Override
    public abstract JPopupMenu getMenu();

    protected void addMenu(JMenu menu, String[][] menuItems) {
        for (int i = 0; i < menuItems.length; ++i) {
            JMenuItem mi = new JMenuItem(menuItems[i][0]);
            mi.addActionListener(this);
            mi.setActionCommand(menuItems[i][1]);
            menu.add(mi);
        }
    }

    public static void resetMenuComponent() {
        _Menu = null;
    }

    @Override
    public String getToolTipText() {
        if (this._toolTipText == null || this._fcipStatusChanged) {
            StringBuffer sb = new StringBuffer(32);
            sb.append("<html>");
            sb.append(this.toString());
            if (this._description != null && !this._description.equals("")) {
                sb.append("<br>Description: ");
                sb.append(this._description);
            }
            sb.append("<br>Status: ");
            if (this._status == 1) {
                sb.append("up");
                if (this._isIscsi) {
                    sb.append(", iSCSI");
                }
            } else if (this._status == 2) {
                sb.append("down");
            } else {
                sb.append("failed/notPresent");
            }
            if (!this._fcipStatusToolTipText.equals("")) {
                sb.append(this._fcipStatusToolTipText);
            }
            sb.append("<html>");
            this._toolTipText = sb.toString();
            this._fcipStatusChanged = false;
        }
        return this._toolTipText;
    }

    @Override
    public String toString() {
        return Discover.getRoot().ifIndexToName(this.getIndex()[0]);
    }
}

