/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.andiamo.elements.Card;
import com.cisco.dcbu.dmdb.andiamo.elements.EthernetPort;
import com.cisco.dcbu.dmdb.andiamo.elements.FCCard;
import com.cisco.dcbu.dmdb.andiamo.elements.IPSEthPort;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPopupMenu;

public class Card_68
extends FCCard {
    private static final int[][] STATUS_VAR = new int[][]{MibNode.get("entPhysicalSoftwareRev").getOid()};
    private static final Class[] CHILDREN = new Class[]{Port.class, EthernetPort.class, IPSEthPort.class};
    static final int[][] CARD_STATUS_LED_POS = new int[][]{{14, 28}};
    private static final int HI_Y = 132;
    private static final int LO_Y = 154;
    private static final int[][] FC_PORT_POS = new int[][]{{13, 132}, {13, 154}, {30, 132}, {30, 154}, {47, 132}, {47, 154}, {64, 132}, {64, 154}, {81, 132}, {81, 154}, {98, 132}, {98, 154}, {115, 132}, {115, 154}, {132, 132}, {132, 154}, {154, 132}, {154, 154}, {171, 132}, {171, 154}, {188, 132}, {188, 154}, {205, 132}, {205, 154}, {222, 132}, {222, 154}, {239, 132}, {239, 154}, {256, 132}, {256, 154}, {273, 132}, {273, 154}, {295, 132}, {295, 154}, {312, 132}, {312, 154}, {329, 132}, {329, 154}, {348, 132}, {348, 154}};
    private static final int[][] ETH_PORT_POS = new int[][]{{373, 132}, {373, 154}, {390, 132}, {390, 154}, {407, 132}, {407, 154}, {424, 132}, {424, 154}};
    private static final int[][] IPS_ETH_PORT_POS = new int[][]{{32, 67}, {67, 67}};
    private String _version;
    int _numCardVars;

    @Override
    public int[][] getChildPos(Class child) {
        if (child == Port.class) {
            return FC_PORT_POS;
        }
        if (child == EthernetPort.class) {
            return ETH_PORT_POS;
        }
        if (child == IPSEthPort.class) {
            return IPS_ETH_PORT_POS;
        }
        return CARD_STATUS_LED_POS;
    }

    @Override
    public Class[] getChildren() {
        return CHILDREN;
    }

    @Override
    public JPopupMenu getMenu() {
        if (this._Menu == null) {
            this._Menu = super.getMenu();
            String[][] menuItems = new String[][]{{"Show Port Resources...", "ShowPortResourcesAction"}};
            this.addMenuItems(this._Menu, menuItems, this, this._Menu.getComponentCount());
        }
        return this._Menu;
    }

    @Override
    public SnmpVarBind[] getStatusVar() {
        if (Card._isSupportPortStatusPerModuleFeature) {
            SnmpVarBind[] supVar = this.buildStatusVar(STATUS_VAR);
            SnmpVarBind[] cardVars = super.getStatusVar();
            SnmpVarBind[] vb = new SnmpVarBind[supVar.length + cardVars.length];
            System.arraycopy(cardVars, 0, vb, 0, cardVars.length);
            System.arraycopy(supVar, 0, vb, cardVars.length, supVar.length);
            this._numCardVars = cardVars.length;
            return vb;
        }
        return this.buildStatusVar(STATUS_VAR);
    }

    @Override
    public int[] getStatusVarIndex(int[] index) {
        int[] cardIndex = new int[]{index[0]};
        return cardIndex;
    }

    @Override
    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        String version;
        if (Card._isSupportPortStatusPerModuleFeature) {
            super.setStatus(varBindList, offset, view);
        }
        if (Discover.setSysVersionFrmSup(version = varBindList.get(offset += this._numCardVars).getVar().toString())) {
            return;
        }
        if (this._version != null && version.equals(this._version)) {
            return;
        }
        Graphics g = view.getOffscreenImage().getGraphics();
        g.setFont(Port._ModeFont);
        Rectangle r = this.getRect();
        if (this._version != null) {
            g.setColor(new Color(66, 66, 66));
            g.drawString(this._version, r.x + 50, r.y + 15);
        }
        g.setColor(Color.black);
        g.drawString(version, r.x + 50, r.y + 15);
        g.dispose();
        this._version = version;
    }

    public void checkOversubscriptionAction(PhysicalElement[] selected) {
        this.checkOversubscriptionAction(selected, 1, 48, 4);
    }

    @Override
    public String getToolTipText() {
        if (this._toolTipText == null) {
            this._toolTipText = FRUConstants.getCardTypeName(68) + ". Status: " + this.getStatus();
        }
        return this._toolTipText;
    }

    @Override
    public String getBitmap() {
        return "Alishan-sup.gif";
    }
}

