/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.andiamo.elements.Card;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis;
import com.cisco.dcbu.dmdb.andiamo.elements.Fan;
import com.cisco.dcbu.dmdb.andiamo.elements.PowerSupply_XBOW;
import com.cisco.dcbu.dmdb.andiamo.elements.XBar_Card;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.event.ActionListener;

public class Chassis_6_XBOW
extends Chassis
implements ActionListener {
    private static final int OFFSET_X = 30;
    final Class[] _Children = new Class[]{Fan.class, PowerSupply_XBOW.class, Card.class, XBar_Card.class};
    static final int[][] _CardPos = new int[][]{{33, 7}, {33, 55}, {33, 103}, {265, 103}, {33, 151}, {33, 201}};
    static final int[][] _PSPos = new int[][]{{11, 257}, {130, 257}, {249, 257}, {369, 257}};
    static final int[][] _XBarPos = new int[][]{{3, 135}, {3, 152}, {3, 169}, {3, 186}, {3, 203}, {3, 220}};
    final int[][] _FanPos = new int[][]{{11, 65}};
    static final int _XBar_offset = 21 + _CardPos.length + 1;
    static final int NUM_XBAR = 6;
    Class[] _XBarCardClass;
    Class[] _FanClass;

    @Override
    public Class[] getChildren() {
        return this._Children;
    }

    @Override
    public Class[] getChildSubclass(Class child) throws Exception {
        if (child == XBar_Card.class) {
            return this.discoverXBars();
        }
        return super.getChildSubclass(child);
    }

    @Override
    public int[][] getChildPos(Class child) {
        if (child == Card.class) {
            return _CardPos;
        }
        if (child == Fan.class) {
            return this._FanPos;
        }
        if (child == XBar_Card.class) {
            return _XBarPos;
        }
        return _PSPos;
    }

    @Override
    public int[] getChildIndex(Class child, int index) {
        if (child == XBar_Card.class) {
            return new int[]{_XBar_offset + index};
        }
        if (child == Fan.class) {
            return new int[]{this._FanOffset + index};
        }
        return super.getChildIndex(child, index);
    }

    @Override
    public int getNumberOfPowerSupplies() {
        return _PSPos.length;
    }

    @Override
    protected Class getPowerSupplyClass() {
        return PowerSupply_XBOW.class;
    }

    @Override
    public int getNumberOfSlot() {
        return _CardPos.length;
    }

    @Override
    protected Class[] discoverCards() throws Exception {
        return this.discoverCards(_CardPos.length + 6);
    }

    @Override
    protected SnmpVarBind[] buildHotSwapStatusVar() {
        return this.buildHotSwapStatusVar(_CardPos.length + 6, this.getNumberOfPowerSupplies());
    }

    @Override
    protected void hotSwap(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        this.hotSwap(varBindList, offset, view, _CardPos.length + 6, this.getNumberOfPowerSupplies());
    }

    protected Class[] discoverXBars() throws Exception {
        this._XBarCardClass = new Class[6];
        String className = this.getCardClassPrefix() + "_";
        SnmpPDU pdu = new SnmpPDU(-91, new VarBindList());
        pdu.setMaxRptr(this._XBarCardClass.length);
        int[] vendorType = MibNode.get("entPhysicalVendorType").getOid();
        int xbar_offset = 21 + this.getNumberOfSlot();
        pdu.addNull(new SnmpOID(vendorType, xbar_offset));
        try {
            SnmpPDU resp = Discover.getPeer().send(pdu);
            for (int i = 0; i < resp.getVariables().size(); ++i) {
                int[] xbarOID;
                int[] vendorId;
                SnmpVarBind vb = resp.getVariables().get(i);
                if (!vb.getOid().startsWith(vendorType) || vb.getVar().getType() != 6 || !SnmpOID.equals(vendorId = ((SnmpOID)vb.getVar()).getValue(), xbarOID = new int[]{1, 3, 6, 1, 4, 1, 9, 12, 3, 1, 9, 97, 3})) continue;
                int moduleTypeId = FRUConstants.getModuleType(vendorId);
                int[] oid = vb.getOid().getValue();
                int index = oid[oid.length - 1];
                int slot = index - xbar_offset - 1;
                try {
                    this._XBarCardClass[slot] = Class.forName(className + moduleTypeId);
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    DefaultLogger._DefLogger.debug((Object)("XBar Class not found :" + className + vendorId[vendorId.length - 1]));
                }
            }
        }
        catch (SnmpException ex) {
            throw new Exception("discoverXBars: " + ex);
        }
        return this._XBarCardClass;
    }

    @Override
    public String getBitmap() {
        return "C7006.gif";
    }
}

