/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_1;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_40000001;
import com.cisco.dcbu.dmdb.andiamo.elements.Card_40000033;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis_10;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis_1_Alishan;
import com.cisco.dcbu.dmdb.andiamo.elements.Chassis_1_Minishan;
import com.cisco.dcbu.dmdb.andiamo.elements.Port;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JPopupMenu;

public class Pcmcia
extends PhysicalElement
implements ActionListener {
    static final int[][] _StatusVarOld = new int[][]{MibNode.get("ciscoFlashDeviceSize").getOid()};
    static final int[][] _StatusVar = new int[][]{MibNode.get("ciscoFlashPartitionSize").getOid(), MibNode.get("ciscoFlashDeviceName").getOid(), MibNode.get("ciscoFlashPartitionName").getOid(), MibNode.get("ciscoFlashPartitionSize").getOid()};
    static final int[][] _StatusVar4G = new int[][]{MibNode.get("ciscoFlashPartitionSizeExtended").getOid(), MibNode.get("ciscoFlashDeviceName").getOid(), MibNode.get("ciscoFlashPartitionName").getOid(), MibNode.get("ciscoFlashPartitionSizeExtended").getOid()};
    protected JPopupMenu _Menu;
    boolean _isOldVersion = Discover.getSysVersionInterim().equals("1.0") || Discover.getSysVersionInterim().equals("1.1");
    boolean _is4GFlashSupport = Discover.isSysVersionGreaterThanEqual("4.1(3)");
    static final int FLASH_DEVICE_NUMBER = 4;
    String _toolTipText;
    String _title;

    @Override
    public String getBitmap() {
        PhysicalElement cardParent = this.getParent();
        PhysicalElement chassisParent = cardParent.getParent();
        return this.getParent() instanceof Card_40000001 ? (this.getParent() instanceof Card_40000033 ? (DmId.isChassisGrayBackGound(Discover.getSysObjectID()) ? "led_XBOW.gif" : "led.gif") : (chassisParent instanceof Chassis_10 ? "pcmcia_n7k.gif" : "pcmcia.gif")) : (this.getParent() instanceof Chassis_1_Alishan || this.getParent() instanceof Chassis_1_Minishan ? "pcmcia_v.gif" : "pcmcia.gif");
    }

    @Override
    public String getEditDialog() {
        return "Pcmcia";
    }

    @Override
    public String getGraphDialog() {
        return null;
    }

    @Override
    public JPopupMenu getMenu() {
        if (this._Menu == null) {
            this._Menu = this.buildMenu(this);
        }
        return this._Menu;
    }

    @Override
    public SnmpVarBind[] getStatusVar() {
        return this.buildStatusVar(this._isOldVersion ? _StatusVarOld : (this._is4GFlashSupport ? _StatusVar4G : _StatusVar));
    }

    @Override
    public SnmpVarBind[] buildStatusVar(int[][] oids) {
        if (this._isOldVersion) {
            return super.buildStatusVar(oids);
        }
        SnmpVarBind[] vb = new SnmpVarBind[oids.length * 4];
        int i = 0;
        int j = 0;
        while (i < 4) {
            vb[j] = new SnmpVarBind(new SnmpOID(oids[0], new int[]{this.getStatusVarIndex(this._index)[0] + i, 1}));
            vb[j + 1] = new SnmpVarBind(new SnmpOID(oids[1], new int[]{this.getStatusVarIndex(this._index)[0] + i}));
            vb[j + 2] = new SnmpVarBind(new SnmpOID(oids[2], new int[]{this.getStatusVarIndex(this._index)[0] + i, 1}));
            vb[j + 3] = new SnmpVarBind(new SnmpOID(oids[3], new int[]{this.getStatusVarIndex(this._index)[0] + i, 2}));
            ++i;
            j += oids.length;
        }
        return vb;
    }

    @Override
    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        boolean flashDr = this._isOldVersion;
        long size = 0L;
        if (!this._isOldVersion) {
            int i = 0;
            int j = 0;
            while (i < 4) {
                String deviceName = varBindList.stringValue(offset + j + 1);
                if (deviceName.startsWith("slot0") || deviceName.startsWith("usb")) {
                    flashDr = true;
                    long partitionSize = this._is4GFlashSupport ? varBindList.longValue(offset + j) : (long)varBindList.intValue(offset + j);
                    String partition1Name = varBindList.stringValue(offset + j + 2);
                    long partition2Size = this._is4GFlashSupport ? varBindList.longValue(offset + j + 3) : (long)varBindList.intValue(offset + j + 3);
                    boolean activePartition = partition1Name.startsWith("sup-local");
                    size = this.getParent() instanceof Card_1 && ((Card_1)this.getParent())._activeSup == -1 ? (activePartition ? partition2Size : partitionSize) : (activePartition ? partitionSize : 0L);
                    break;
                }
                ++i;
                j += _StatusVar.length;
            }
        } else {
            size = varBindList.intValue(offset);
        }
        view.updateImage(this._image, this._rect.x, this._rect.y);
        StringBuffer sb = new StringBuffer();
        StringBuffer sb1 = new StringBuffer();
        if (flashDr && !this._isOldVersion) {
            int firstDevice = -1;
            int i = 0;
            int j = 0;
            while (i < 4) {
                String deviceName = varBindList.stringValue(offset + j + 1);
                if (deviceName.startsWith("slot0") || deviceName.startsWith("usb")) {
                    long partitionSize = this._is4GFlashSupport ? varBindList.longValue(offset + j) : (long)varBindList.intValue(offset + j);
                    String partition1Name = varBindList.stringValue(offset + j + 2);
                    long partition2Size = this._is4GFlashSupport ? varBindList.longValue(offset + j + 3) : (long)varBindList.intValue(offset + j + 3);
                    boolean activePartition = partition1Name.startsWith("sup-local");
                    if (this.getParent() instanceof Card_1 && ((Card_1)this.getParent())._activeSup == -1) {
                        partitionSize = activePartition ? partition2Size : partitionSize;
                    } else {
                        long l = partitionSize = activePartition ? partitionSize : 0L;
                    }
                    if (firstDevice == -1 && partitionSize != 0L) {
                        firstDevice = i;
                    }
                    if (partitionSize != 0L) {
                        if (i == firstDevice) {
                            sb.append("<html>");
                        } else {
                            sb.append("<br>");
                            sb1.append(", ");
                        }
                        sb.append(deviceName);
                        sb.append(" - ");
                        sb.append(this.getSizeString(partitionSize));
                        sb1.append(deviceName);
                    }
                    if (i == firstDevice) {
                        size = partitionSize;
                    } else if (size == 0L) {
                        size = partitionSize;
                    }
                }
                ++i;
                j += _StatusVar.length;
            }
        }
        this._toolTipText = sb.toString().length() == 0 ? "n/a" : sb.toString();
        String string = this._title = sb1.toString().length() == 0 ? "flash" : sb1.toString();
        if (this.getParent() instanceof Chassis_1_Alishan) {
            return;
        }
        if (this.getParent() instanceof Chassis_1_Minishan) {
            return;
        }
        PhysicalElement cardParent = this.getParent();
        PhysicalElement chassisParent = cardParent.getParent();
        String number = this.getSizeString(size);
        Graphics g = DeviceManager.getInstance().getView().getOffscreenImage().getGraphics();
        if (this.getParent() instanceof Card_40000001 && chassisParent instanceof Chassis_10) {
            if (!(this.getParent() instanceof Card_40000033)) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.white);
                g2d.setFont(Port._ModeFont);
                Rectangle r = this.getRect();
                AffineTransform at = new AffineTransform();
                at.setToTranslation(r.x + (10 - number.length()), r.y + 25);
                g2d.transform(at);
                at.setToRotation(1.5707963267948966);
                g2d.transform(at);
                g2d.drawString(number, 0.0f, 0.0f);
                g2d.transform(at);
                g2d.dispose();
            } else if (this._toolTipText != null && this._toolTipText.length() > 0) {
                view.updateImage(this._image, this._rect.x, this._rect.y);
                view.updateImage(this._image, this._rect.x, this._rect.y, Color.black);
            }
        } else if (!(this.getParent() instanceof Card_40000033)) {
            g.setColor(Color.white);
            g.setFont(Port._ModeFont);
            Rectangle r = this.getRect();
            g.drawString(number, r.x + (32 - number.length()), r.y + 11);
            g.dispose();
        }
    }

    private String getSizeString(long size) {
        String number;
        String string = number = size == 0L ? "n/a" : size / 1000000L + " M";
        if (size > 0L && size < 1000000L) {
            number = Long.toString(size);
        }
        return number;
    }

    @Override
    public int[] getStatusIndex(int[] index) {
        int offset = Discover.getSysVersionInterim().equals("1.0") || Discover.getSysVersionInterim().equals("1.1") || Discover.getSysVersionInterim().equals("1.2") ? 1 : (Discover.getSysVersionInterim().equals("1.3") ? 3 : (!Discover.isSysVersionGreaterThanEqual("3.3(1)") ? 3 : 2));
        int[] idx = new int[]{index[1] + offset};
        return idx;
    }

    @Override
    public String getToolTipText() {
        return this._toolTipText;
    }

    public String toString() {
        return this._title;
    }
}

