/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.AbstractPort;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.DmSystem;
import com.cisco.dcbu.dmdb.andiamo.elements.AbstractEthPort;
import com.cisco.dcbu.dmdb.andiamo.elements.EthernetPort;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import java.awt.Color;
import javax.swing.JPopupMenu;

public class SatUplinkPort
extends AbstractEthPort {
    protected int _connectedSwitchPortIfIndex;

    @Override
    public String getToolTipText() {
        if (this._toolTipText == null) {
            this._toolTipText = DmId.isNuovaFamily(Discover.getSysObjectID()) ? this.getHTMLToolTipText() : this.toString() + (this._connectedSwitchPortIfIndex != 0 ? ". Connected to " + Discover.getRoot().ifIndexToName(this._connectedSwitchPortIfIndex) : "");
        }
        return this._toolTipText;
    }

    @Override
    public String getHTMLToolTipText() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("<html>").append("<b>").append(this.getNameForTooltip());
        sb.append(this._connectedSwitchPortIfIndex != 0 ? "<br>Connected to " + Discover.getRoot().ifIndexToName(this._connectedSwitchPortIfIndex) : "");
        sb.append("</b>").append("</html>");
        return sb.toString();
    }

    @Override
    public JPopupMenu getMenu() {
        return null;
    }

    public void update(PhysicalView view, int ethPortIfIndex, AbstractPort e) {
        this._connectedSwitchPortIfIndex = ethPortIfIndex;
        int status = 2;
        if (e != null && ethPortIfIndex == e.getIndex()[0]) {
            status = e.getStatus();
        } else if (e != null && ((EthernetPort)e)._breakoutPorts != null) {
            int[][] bports = ((EthernetPort)e)._breakoutPorts;
            for (int count = 0; count < bports.length; ++count) {
                int bportIfIndex;
                if (bports[count] == null || bports[count][0] == 0 || ethPortIfIndex != (bportIfIndex = bports[count][0])) continue;
                status = bports[count][1] == 2 ? 1 : 2;
            }
        }
        this.setStatus(status, view);
        this._toolTipText = null;
    }

    @Override
    public void redrawStatus(PhysicalView view) {
        Color c = this._hide ? DmSystem._bg : AbstractPort._Colors[this._connectedSwitchPortIfIndex != 0 ? 0 : 1];
        view.updateImage(this._image, this._rect.x, this._rect.y, c);
    }

    @Override
    public int[] getStatusIndex(int[] index) {
        int[] ifIndex = new int[]{index[1]};
        return ifIndex;
    }

    @Override
    public SnmpVarBind[] getStatusVar() {
        return null;
    }

    @Override
    public String getEditDialog() {
        return null;
    }

    @Override
    public String getGraphDialog() {
        return null;
    }

    @Override
    public String getBitmap() {
        return "satuplinkport.gif";
    }

    @Override
    public String toString() {
        return "10GE Uplink Port " + this._index[0];
    }
}

