/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.dmdb.andiamo.elements;

import com.cisco.dcbu.dm.AbstractPort;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dm.RediscoverException;
import com.cisco.dcbu.dmdb.DmId;
import com.cisco.dcbu.dmdb.andiamo.elements.PowerSupply;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;

public class XBarStatusLED
extends PhysicalElement {
    static final int[][] STATUS_VAR = new int[][]{MibNode.get("cefcFRUPowerOperStatus").getOid()};
    static final int UP = 2;
    static final int UP_BADFAN = 9;

    @Override
    public String getBitmap() {
        return DmId.isChassisGrayBackGound(Discover.getSysObjectID()) ? "led_XBOW.gif" : "led.gif";
    }

    @Override
    public SnmpVarBind[] getStatusVar() {
        return this.buildStatusVar(STATUS_VAR);
    }

    @Override
    public void setStatus(VarBindList varBindList, int offset, PhysicalView view) throws RediscoverException {
        SnmpVar v = varBindList.get(offset).getVar();
        if (v.getType() == 2) {
            int oper = ((SnmpInt)v).getValue();
            int color = 2;
            if (oper == 2 || oper == 9) {
                color = 0;
            } else if (oper == 3) {
                color = 4;
            }
            view.updateImage(this._image, this._rect.x, this._rect.y, AbstractPort._Colors[color]);
            if (oper == 9) {
                try {
                    view.updateImage(Discover.getInstance().getImage("led.gif"), this._rect.x + this._image.getWidth(view) / 2 + 2, this._rect.y, AbstractPort._Colors[2]);
                }
                catch (Exception ex) {
                    DefaultLogger._DefLogger.debug((Object)ex);
                }
            }
            if (this.getParent() instanceof PowerSupply) {
                ((PowerSupply)this.getParent())._status = oper;
                ((PowerSupply)this.getParent())._toolTipText = null;
            }
        } else {
            throw new RediscoverException(" XBar removed.");
        }
    }

    @Override
    public int[] getStatusIndex(int[] index) {
        int[] cardIndex = new int[]{index[0]};
        return cardIndex;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }
}

