/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.cisco.dcbu.install.Installer;
import com.cisco.dcbu.install.MoveDMFMTask;
import com.cisco.dcbu.install.Service;
import com.cisco.dcbu.install.Util;
import com.cisco.dcbu.install.model.Install;
import com.cisco.dcbu.install.model.SysInfo;
import com.cisco.dcbu.install.view.FinishPanel;
import com.cisco.dcbu.install.view.LicensePanel;
import com.cisco.dcbu.install.view.LocationPanel;
import com.cisco.dcbu.install.view.WelcomePanel;
import com.cisco.dcbu.install.view.WizardPanel;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.util.ClientCache;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class DMInstaller
extends Installer {
    public static final String NAME = "Cisco Device Manager";
    static final int PROGRESSWITHHELP = 1509;
    static final int PROGRESSCOUNT = 46;
    private boolean upgrade;
    private boolean reinstall;
    private boolean createUninstall = true;
    private LocationPanel lPanel;
    private FinishPanel fPanel;
    private boolean useOldConf = false;
    private boolean migrateDMFM = false;

    public DMInstaller(HashMap args) {
        super(args, "Cisco Device Manager Installer");
        this.textMode = this.existsArg("-text");
        if (!this.existsArg("-text")) {
            this.lPanel = new LocationPanel();
            this.lPanel.setFMSelectorVisible(false);
            this.fPanel = new FinishPanel(this.iModel.getUserDir(), SysInfo.ONWINDOWS);
            this.fPanel.setLaunchVisible(false);
        }
        Util.logger = logger;
    }

    public void collectInstallInfo() {
        String nmsRoot = this.confProps.getProperty("mds.nmsRoot");
        String oldDir = this.findNMSRoot(nmsRoot);
        String iDir = null;
        SwitchVersion oldVersion = this.getVersion(null);
        if (this.existsArg("-selfstart")) {
            iDir = this.getArg("-dir");
            if (this.existsArg("-MDS9000")) {
                this.iModel = new DMInstall();
                ((DMInstall)this.iModel).setFMDir(iDir);
            } else {
                this.iModel = new Install();
                this.iModel.setInstallDir(iDir);
            }
        } else if (oldDir != null) {
            String dmVersion = this.confProps.getProperty("mds.dm.version");
            if (dmVersion != null && Util.exists(oldDir + SysInfo.FS + "bin" + SysInfo.FS + "DeviceManager" + SysInfo.ESUFFIX)) {
                String fmVersion = this.confProps.getProperty("mds.version");
                oldVersion = new SwitchVersion(dmVersion);
                if (!oldVersion.lessThan(this.VER412)) {
                    if (this.confProps.getProperty("mds.ciscoRoot") != null) {
                        oldDir = this.confProps.getProperty("mds.ciscoRoot");
                    }
                    this.iModel.setInstallDir(oldDir);
                    if (!this.existsArg("-text")) {
                        this.lPanel.setLocation(oldDir);
                        this.lPanel.setSelectorEnabled(false);
                    }
                } else if (fmVersion != null && this.checkInstallDir(oldDir)) {
                    SwitchVersion fmV = new SwitchVersion(fmVersion);
                    if (fmV.lessThan(this.VER412)) {
                        this.iModel = new DMInstall();
                        this.useOldConf = true;
                        ((DMInstall)this.iModel).setFMDir(oldDir);
                        if (!this.existsArg("-text")) {
                            this.lPanel.setLocation(oldDir);
                            this.lPanel.setSelectorEnabled(false);
                        }
                    } else {
                        if (this.confProps.getProperty("mds.ciscoRoot") != null) {
                            oldDir = this.confProps.getProperty("mds.ciscoRoot");
                        }
                        this.iModel.setInstallDir(oldDir);
                        if (!this.existsArg("-text")) {
                            this.lPanel.setLocation(oldDir);
                            this.lPanel.setSelectorEnabled(false);
                        }
                    }
                    this.createUninstall = false;
                } else {
                    String dcnmDir = this.getDCNMDir();
                    if (dcnmDir == null) {
                        this.migrateDMFM = true;
                        this.iModel.setInstallDir(this.getDefaultInstallDir());
                        this.lPanel.setSelectorEnabled(true);
                    } else {
                        this.migrateDMFM = true;
                        this.iModel.setInstallDir(dcnmDir);
                        this.lPanel.setLocation(dcnmDir);
                        this.lPanel.setSelectorEnabled(false);
                    }
                }
            } else {
                String fmVersion = this.confProps.getProperty("mds.version");
                if (fmVersion != null && this.checkInstallDir(oldDir)) {
                    String ciscoRoot = this.confProps.getProperty("mds.ciscoRoot");
                    if (!new SwitchVersion(fmVersion).lessThan(this.VER412) && Util.exists(ciscoRoot)) {
                        this.iModel.setInstallDir(ciscoRoot);
                        if (!this.existsArg("-text")) {
                            this.lPanel.setLocation(ciscoRoot);
                            this.lPanel.setSelectorEnabled(false);
                        }
                    } else {
                        this.iModel = new DMInstall();
                        this.useOldConf = true;
                        ((DMInstall)this.iModel).setFMDir(oldDir);
                        if (!this.existsArg("-text")) {
                            this.lPanel.setLocation(oldDir);
                            this.lPanel.setSelectorEnabled(false);
                        }
                    }
                    this.createUninstall = false;
                } else {
                    String dcnmDir = this.getDCNMDir();
                    if (dcnmDir == null) {
                        this.iModel.setInstallDir(this.getDefaultInstallDir());
                        this.lPanel.setSelectorEnabled(true);
                    } else {
                        this.iModel.setInstallDir(dcnmDir);
                        if (!this.existsArg("-text")) {
                            this.lPanel.setLocation(dcnmDir);
                            this.lPanel.setSelectorEnabled(false);
                        }
                    }
                }
            }
        } else {
            String fmVersion = this.confProps.getProperty("mds.version");
            if (fmVersion != null && this.checkInstallDir(oldDir)) {
                this.iModel = new DMInstall();
                this.useOldConf = true;
                ((DMInstall)this.iModel).setFMDir(oldDir);
                if (!this.existsArg("-text")) {
                    this.lPanel.setLocation(oldDir);
                    this.lPanel.setSelectorEnabled(false);
                }
                this.createUninstall = false;
            } else {
                String dcnmDir = this.getDCNMDir();
                if (dcnmDir == null) {
                    this.iModel.setInstallDir(this.getDefaultInstallDir());
                    this.lPanel.setSelectorEnabled(true);
                } else {
                    this.iModel.setInstallDir(dcnmDir);
                    this.lPanel.setLocation(dcnmDir);
                    this.lPanel.setSelectorEnabled(false);
                }
            }
        }
        this.iModel.setOldVersion(oldVersion);
        this.iModel.setOldInstallDir(oldDir);
        this.iModel.setVersion(this.getVersion());
    }

    @Override
    public void preInstall() {
        if (SysInfo.UNKNOWN_OS || !SysInfo.OKJDK) {
            String msg = "JRE " + SysInfo.JDK + " is not supported. Please install Sun JRE 1.5.x/1.6.x before running this installer.";
            if (!this.existsArg("-text")) {
                this.parent.pack();
                this.parent.setVisible(true);
                this.parent.validate();
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(null, msg, "Unsupported Platform", 0);
            }
            logger.error((Object)msg);
            logger.error((Object)("Platform not supported: " + SysInfo.JDK));
            System.exit(1);
        }
        this.collectInstallInfo();
        this.iModel.setCodebase(this.getArg("-home"));
        SwitchVersion oldVer = this.iModel.getOldVersion();
        SwitchVersion ver = this.iModel.getVersion();
        String oldIDir = this.iModel.getOldInstallDir();
        this.iModel.setNoCompress(this.existsArg("-nocompress"));
        if (!oldVer.isUnknown()) {
            if (oldVer != null && oldVer.compareTo(new SwitchVersion("3.2(0)")) < 0 && Service.isInstalled("SAN Server") && !this.existsArg("-selfstart")) {
                String message = "This version of Device Manager is not compatible with the current DCNM-SAN Server.\nPlease upgrade your server to version " + ver.toString() + " before installing.";
                logger.warn((Object)message);
                if (!this.existsArg("-text")) {
                    this.msgHelper.showMessage("<html><body>" + message.replace("\n", "<br>") + "</body></html>");
                }
                System.exit(1);
            }
            boolean runApp = false;
            if (ver.compareTo(oldVer) > 0) {
                if (this.existsArg("-text")) {
                    logger.info((Object)("Upgrading to Cisco Device Manager " + ver.toString()));
                } else if (!this.existsArg("-selfstart") && !this.msgHelper.doUpgrade(NAME)) {
                    runApp = true;
                }
                this.upgrade = true;
            } else if (!this.existsArg("-selfstart")) {
                runApp = true;
            }
            if (runApp) {
                try {
                    String host = this.getArg("-host");
                    host = null;
                    String script = "DeviceManager" + SysInfo.ESUFFIX;
                    String binDir = this.confProps.getProperty("mds.nmsRoot") + SysInfo.FS + "bin";
                    if (!Util.exists(binDir + SysInfo.FS + script) && !Util.exists((binDir = this.iModel.getOldInstallDir() + SysInfo.FS + "dcm" + SysInfo.FS + "fm" + SysInfo.FS + "bin") + SysInfo.FS + script)) {
                        binDir = this.iModel.getOldInstallDir() + SysInfo.FS + "bin";
                    }
                    if (!Util.exists(binDir + FS + script)) {
                        throw new IOException(script + " not found.");
                    }
                    this.runApp(script, new String[]{host}, binDir);
                    System.exit(0);
                }
                catch (IOException ex) {
                    logger.warn((Object)ex.getMessage());
                }
            }
        }
        if (!this.existsArg("-selfstart")) {
            this.checkEnvironment();
        }
        this.iModel.setDeleteOldExec(oldVer.lessThan(this.VER412));
        if (!this.existsArg("-text")) {
            this.wizard.addCard(new WelcomePanel());
            this.wizard.addCard(new LicensePanel());
            this.wizard.addCard(this.lPanel);
            this.wizard.addCard(this.progressPanel);
            this.wizard.addCard(this.fPanel);
            this.wizard.getNextButton().addActionListener(this);
            this.wizard.getBackButton().addActionListener(this);
            this.wizard.getCancelButton().addActionListener(this);
            this.wizard.getBackButton().setEnabled(false);
            this.wizard.getNavigator().revalidate();
            this.wizard.first();
            this.parent.pack();
            this.parent.setVisible(true);
            this.pause();
        }
        if (!this.existsArg("-selfstart") && this.iModel.getVersion().compareTo(this.iModel.getOldVersion()) > 0) {
            progressMon.setMaximum(1509);
        } else if (!this.existsArg("-selfstart")) {
            progressMon.setMaximum(46);
        }
    }

    public void setAllUsers(boolean b) {
        if (!this.existsArg("-text")) {
            this.fPanel.setCreateShortcutForAllUsers(b);
        } else if (b) {
            this.args.put("-allusers", "");
        }
    }

    public void setCreateUninstall(boolean b) {
        this.createUninstall = b;
    }

    @Override
    public void install() {
        try {
            this.iModel.setInstallDir(this.existsArg("-text") ? this.getArg("-dir") : this.lPanel.getInstallFolder());
            this.mkdirs(this.iModel.getFMDir());
            this.mkdirs(this.iModel.getLibDir());
            this.mkdirs(this.iModel.getDMLibDir());
            this.mkdirs(this.iModel.getBinDir());
            this.mkdirs(this.iModel.getConfDir());
            this.mkdirs(this.iModel.getLogDir());
            this.mkdirs(this.iModel.getHelpDir());
            this.iModel.setLogger(logger);
            if (this.migrateDMFM) {
                MoveDMFMTask task = new MoveDMFMTask(this.iModel.getOldInstallDir(), this.iModel.getFMDir());
                try {
                    task.execute();
                }
                catch (Exception ex) {
                    logger.error((Object)"Unable to migrate existing FM/DM to new directory.");
                }
            }
            Util.delete(this.iModel.getDMLocal("crimson"));
            logger.warn((Object)"Downloading Files");
            for (int i = 0; i < Install.DMFiles.length; ++i) {
                logger.info((Object)("Fetching " + Install.DMFiles[i]));
                try {
                    Util.download(this.iModel.getRemote(Install.DMFiles[i]), this.iModel.getDMLocal(Install.DMFiles[i]));
                    continue;
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to download " + Install.DMFiles[i] + ": " + ex.getCause()));
                }
            }
            try {
                if (this.createUninstall) {
                    Util.download(this.iModel.getRemote("installer"), this.iModel.getLibDir() + SysInfo.FS + "installer.jar");
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Download failed: " + ex.getMessage());
            }
            logger.warn((Object)"Finished Downloading Files");
            logger.warn((Object)"Extracting Files");
            try {
                logger.info((Object)"Extracting DM native");
                String iDir = this.iModel.getFMDir();
                String[] tNames = new String[]{"MDSNMSROOT", "MDSJVMARGS", "MDSJAVACMD", "MDSJAVA", "MDSNMSTEMPDIR", "MDSNMSUSERHOME"};
                String vmArgs = SysInfo.ONWINDOWS ? "-Xms6m -Dswing.defaultlaf=com.sun.java.swing.plaf.windows.WindowsLookAndFeel -Dmds.nmsRoot=\"" + iDir + "\"" : "-Xms6m -Dmds.nmsRoot=" + iDir;
                String[] tValues = new String[]{iDir, vmArgs, SysInfo.JCMDEXEC, SysInfo.JEXEC, SysInfo.TMP, SysInfo.ONWINDOWS ? "\"" + ClientCache.getDir() + "\"" : ClientCache.getDir()};
                try {
                    Util.extract(this.iModel.getDMLibDir() + FS + "dmnative.jar", this.iModel.getFMDir(), true, tNames, tValues, null, null, false);
                }
                catch (IOException ioe) {
                    logger.error((Object)ioe.getMessage());
                }
                if (!SysInfo.ONWINDOWS) {
                    Util.createExec(this.iModel.getBinDir());
                }
                String uFile = "Uninstall" + SysInfo.ESUFFIX;
                if (this.createUninstall) {
                    Util.copy(this.iModel.getBinDir() + SysInfo.FS + uFile, this.iModel.getFMDir() + SysInfo.FS + uFile);
                    Util.createExec(this.iModel.getFMDir(), uFile);
                }
                Util.delete(this.iModel.getBinDir() + SysInfo.FS + uFile);
                if (!this.existsArg("-selfstart") && this.iModel.getVersion().compareTo(this.iModel.getOldVersion()) > 0) {
                    logger.info((Object)"Setting up help");
                    Util.download(this.iModel.getRemote("fmhelp"), this.iModel.getLocal("fmhelp"));
                    Util.extract(this.iModel.getLocal("fmhelp"), this.iModel.getHelpDir());
                } else {
                    logger.info((Object)"Skipping help");
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to extract files: " + ex.getCause());
            }
            this.iModel.touchOld();
            if (!this.existsArg("-text")) {
                this.wizard.getNextButton().setText("Finish");
                this.wizard.getNextButton().setEnabled(true);
                this.wizard.getCancelButton().setEnabled(false);
                this.wizard.getBackButton().setEnabled(false);
                this.wizard.getNextButton().setEnabled(true);
                this.wizard.getNextButton().setText("Finish");
                this.wizard.getNextButton().setIcon(null);
                if (SysInfo.ONWINDOWS) {
                    this.fPanel.setLaunchDMVisible(true);
                    this.fPanel.setLaunchDM(true);
                }
                if (this.iModel.isWinDefaultInstallDirFail() || this.isWinDefaultInstallDirFail()) {
                    this.fPanel.setShortcutVisible(false);
                    this.fPanel.setCreateShortcutForAllUsers(false);
                    this.fPanel.setseeRunAppInstructionInfoVisible(true, this.iModel.getBinDir());
                }
                this.wizard.doNext();
                this.pause();
            }
        }
        catch (Exception ex) {
            String msg = "Install encountered a problem. " + (ex.getCause() != null ? ex.getCause() + "." : "");
            if (ex.getMessage() != null) {
                msg = msg + " " + ex.getMessage();
            }
            ex.printStackTrace(System.err);
            msg = msg + "\nAn installation log can be found at " + this.iModel.getUserDir() + FS + "install.log";
            logger.fatal((Object)msg);
            if (!this.existsArg("-text")) {
                this.msgHelper.showFailure(ex.getMessage());
            }
            System.exit(-1);
        }
    }

    @Override
    public void postInstall() {
        File oldIHandle;
        boolean allUser = this.existsArg("-text") ? this.existsArg("-allusers") : this.fPanel.createShortcutForAllUsers();
        HashMap<String, String> info = new HashMap<String, String>();
        String iDir = this.iModel.getFMDir();
        if (SysInfo.ONWINDOWS) {
            iDir = Util.preserveBackslash(iDir);
        }
        info.put("mds.jvm", SysInfo.ONWINDOWS ? Util.preserveBackslash(SysInfo.JHOME) : SysInfo.JHOME);
        info.put("mds.dm.version", this.iModel.getVersion().toString());
        info.put("mds.nmsRoot", iDir);
        info.put("mds.dm.winAllUsers", Boolean.toString(allUser));
        if (!this.useOldConf) {
            String ciscoDir = this.iModel.getInstallDir();
            if (ciscoDir != null && SysInfo.ONWINDOWS) {
                ciscoDir = Util.preserveBackslash(ciscoDir);
            }
            info.put("mds.ciscoRoot", ciscoDir);
            String dcmDir = this.iModel.getDCMDir();
            if (dcmDir != null && SysInfo.ONWINDOWS) {
                dcmDir = Util.preserveBackslash(dcmDir);
            }
            info.put("mds.dcmRoot", dcmDir);
        }
        this.createConf(info.keySet().toArray(new String[0]), info.values().toArray(new String[0]));
        if (this.existsArg("-nostart")) {
            logger.warn((Object)"found -nostart, DMInstaller skipping shortcut setup");
            System.out.println("DMInstaller skipping shortcut setup");
            return;
        }
        if (SysInfo.ONWINDOWS) {
            if (!this.isWinDefaultInstallDirFail()) {
                logger.info((Object)"DMInstaller winsetup...");
                if (this.createUninstall) {
                    this.cleanDMShortcuts();
                }
                try {
                    this.iModel.deleteOldExec();
                    this.winSetup(this.iModel.getFMDir(), this.iModel.getUserDir(), allUser);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                logger.info((Object)"Failed to find default install dir, DMInstaller skipping winsetup for shortcut setup");
            }
            if (!this.existsArg("-text") && this.fPanel.showInstallLog() && !this.existsArg("-selfstart")) {
                try {
                    Runtime.getRuntime().exec("cmd /c start notepad " + this.iModel.getUserDir() + FS + "install.log");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            try {
                this.iModel.deleteOldExec();
                this.unixSetup(this.iModel.getFMDir(), this.iModel.getUserDir());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            String host = this.getArg("-host");
            host = null;
            if (!this.existsArg("-selfstart") && this.fPanel.launchDM()) {
                this.runApp("DeviceManager" + SysInfo.ESUFFIX, new String[]{host}, this.iModel.getBinDir());
            }
        }
        catch (Exception ex) {
            logger.info((Object)("Unable to launch DM: " + ex.getCause()));
        }
        if (this.migrateDMFM && (oldIHandle = new File(this.iModel.getOldInstallDir())).compareTo(new File(this.iModel.getFMDir())) != 0 && oldIHandle.compareTo(new File(this.iModel.getInstallDir())) != 0) {
            Util.delete(this.iModel.getOldInstallDir());
        }
        logger.info((Object)"Cisco Device Manager installation completed.");
        if (!this.existsArg("-selfstart")) {
            System.exit(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name;
        WizardPanel cur;
        String cmd = e.getActionCommand();
        if ("Go".equals(cmd)) {
            cmd = this.wizard.getNextButton().getActionCommand();
        }
        char c = cmd.charAt(0);
        switch (c) {
            case 'N': {
                cur = this.wizard.getCurrent();
                name = cur.getName();
                if (LicensePanel.NAME.equals(name)) {
                    LicensePanel lic = (LicensePanel)cur;
                    if (!lic.isAccepted()) {
                        lic.showDialog();
                        return;
                    }
                    this.wizard.getNextButton().setText("Install");
                    this.wizard.getNextButton().setIcon(null);
                    this.wizard.getNextButton().revalidate();
                }
                this.wizard.doNext();
                break;
            }
            case 'I': {
                cur = this.wizard.getCurrent();
                name = cur.getName();
                if ("Install Options".equals(name) && !this.createInstallLocation((LocationPanel)cur)) {
                    return;
                }
                this.wizard.doNext();
            }
            case 'F': {
                this.resume();
                break;
            }
            case 'B': {
                this.wizard.doBack();
                if (this.wizard.getCurrent().getName().equals("Install Options")) break;
                this.wizard.resetNavigator();
                break;
            }
            case 'C': {
                if (this.msgHelper.doCancel()) {
                    System.exit(0);
                    break;
                }
                return;
            }
            default: {
                this.msgHelper.showError("Unexpected error.");
                System.exit(-1);
            }
        }
        cur = this.wizard.getCurrent();
        name = cur.getName();
        if (name.equals("Welcome")) {
            this.wizard.getBackButton().setEnabled(false);
        } else if ("Installing".equals(name)) {
            this.wizard.getBackButton().setEnabled(false);
            this.wizard.getNextButton().setEnabled(false);
        } else {
            this.wizard.getBackButton().setEnabled(true);
            return;
        }
    }

    public void setFinishPanel(FinishPanel fp) {
        this.fPanel = fp;
    }

    public void winSetup(String iDir, String uDir, boolean allUser) {
        boolean useCiscoMDS = this.iModel instanceof DMInstall;
        try {
            if (!useCiscoMDS) {
                String[] links;
                Util.deleteForce(Service.getAllStartMenu() + SysInfo.FS + "Cisco MDS9000" + SysInfo.FS + "Uninstall.lnk");
                Util.deleteForce(Service.getStartMenu() + SysInfo.FS + "Cisco MDS9000" + SysInfo.FS + "Uninstall.lnk");
                for (String l : links = new String[]{NAME}) {
                    Util.deleteForce(Service.getAllStartMenu() + FS + "Cisco MDS9000" + FS + l + ".lnk");
                    Util.deleteForce(Service.getStartMenu() + FS + "Cisco MDS9000" + FS + l + ".lnk");
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
        }
        String libDir = iDir + FS + "lib";
        String binDir = iDir + FS + "bin";
        String confDir = iDir + FS + "conf";
        String startMenu = allUser ? Service.getAllStartMenu() : Service.getStartMenu();
        startMenu = startMenu + FS + (useCiscoMDS ? "Cisco MDS9000" : "Cisco DCNM");
        String icon = libDir + FS + "mds9000.ico";
        String desktop = allUser ? Service.getAllDesktop() : Service.getDesktop();
        Util.mkdir(startMenu);
        System.err.println("Creating shortcuts");
        String[] links = new String[]{desktop + FS + NAME + ".lnk", binDir + FS + "DeviceManager.bat", NAME, startMenu + FS + NAME + ".lnk", binDir + FS + "DeviceManager.bat", NAME, startMenu + FS + "Uninstall.lnk", iDir + FS + "Uninstall.bat", "Uninstall"};
        Util.delete(links[0]);
        Util.delete(links[3]);
        Util.delete(links[6]);
        for (int i = 0; i < links.length; ++i) {
            Service.createLink(links[i++], links[i++], links[i], iDir, icon);
        }
        if (!this.createUninstall) {
            return;
        }
        System.err.println("Windows Setup End");
    }

    public void unixSetup(String iDir, String uDir) {
        if (!this.createUninstall) {
            return;
        }
        System.err.println("Unix Setup Start");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.err.println("Unix setup end");
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("-home", "jar:file:/E:/au_fmclient/nms/build/html/m9000-fm-DEVEL.jar!/");
        map.put("-host", "192.12.23.1");
        DMInstaller installer = new DMInstaller(map);
        installer.preInstall();
        installer.install();
        installer.postInstall();
        System.exit(0);
    }

    class DMInstall
    extends Install {
        String nmsRoot;

        DMInstall() {
        }

        @Override
        public String getFMDir() {
            return this.nmsRoot;
        }

        public void setFMDir(String nms) {
            this.nmsRoot = nms;
        }
    }
}

