/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class PropertiesUtil {
    static Logger logger = Logger.getLogger(PropertiesUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProps(String path) {
        Properties props = new Properties();
        if (new File(path).exists()) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(path);
                props.load(fin);
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace(System.err);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateProperties(String inFile, String outFile, String[] keys, String[] values, boolean add) throws IOException {
        if (!new File(inFile).exists()) {
            return false;
        }
        if (keys == null || values == null) {
            return false;
        }
        if (keys.length == 0 || values.length == 0 || keys.length != values.length) {
            return false;
        }
        Properties properties = new Properties();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(inFile);
            properties.load(fin);
        }
        catch (Exception ex) {
            logger.error((Object)("Unable to load file: " + ex.getMessage()));
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Throwable t) {}
            }
        }
        BufferedWriter os = new BufferedWriter(new FileWriter(outFile));
        BufferedReader is = new BufferedReader(new FileReader(inFile));
        try {
            String line;
            while ((line = is.readLine()) != null) {
                boolean found = false;
                if (line.startsWith("#")) {
                    os.write(line + "\n");
                    continue;
                }
                for (int i = 0; i < keys.length; ++i) {
                    char afterChar;
                    int position;
                    if (!line.contains(keys[i]) || (position = line.indexOf(keys[i])) > 0 && line.charAt(position - 1) != ' ' || (afterChar = line.charAt(position + keys[i].length())) != ' ' && afterChar != '=') continue;
                    found = true;
                    if (line.indexOf("#") == -1) {
                        if (!add) continue;
                        line = keys[i] + " = " + (values[i] == null ? "" : values[i]) + "\n";
                        os.write(line);
                        break;
                    }
                    String comment = line.substring(line.indexOf("#"));
                    if (!(line = line.substring(0, line.indexOf("#"))).contains(keys[i])) {
                        os.write(line + comment + "\n");
                        break;
                    }
                    if (!add) continue;
                    if (values[i] != null && values[i].contains("#") && comment.startsWith(values[i])) {
                        comment = comment.substring(values[i].length());
                    }
                    line = keys[i] + " = " + (values[i] == null ? "" : values[i]) + comment + "\n";
                    os.write(line);
                }
                if (found) continue;
                os.write(line + "\n");
            }
            if (add) {
                for (int i = 0; i < keys.length; ++i) {
                    if (properties.containsKey(keys[i])) continue;
                    os.write(keys[i] + " = " + (values[i] == null ? "" : values[i]) + "\n");
                }
            }
        }
        finally {
            os.close();
            is.close();
        }
        return true;
    }

    public static void copy(InputStream inStream, String outFile, String[] names, String[] values) throws IOException {
        if (names == null) {
            File file = new File(outFile);
            file.getParentFile().mkdirs();
            byte[] buffer = new byte[1000];
            int bytes = 0;
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outFile));
            while ((bytes = inStream.read(buffer)) != -1) {
                bos.write(buffer, 0, bytes);
                bos.flush();
            }
            bos.close();
        } else {
            String l;
            BufferedWriter os = new BufferedWriter(new FileWriter(outFile));
            BufferedReader r = new BufferedReader(new InputStreamReader(inStream, "US-ASCII"));
            while ((l = r.readLine()) != null) {
                for (int i = 0; i < names.length; ++i) {
                    if (values[i] == null || l.indexOf(names[i]) == -1) continue;
                    int preIndex = l.indexOf(names[i]);
                    int postIndex = preIndex + names[i].length();
                    l = l.substring(0, preIndex) + values[i] + l.substring(postIndex);
                }
                os.write(l);
                os.newLine();
            }
            os.close();
        }
    }
}

