/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.cisco.dcbu.install.Service;
import com.cisco.dcbu.install.Shortcut;
import com.cisco.dcbu.install.StreamReader;
import com.cisco.dcbu.install.model.SysInfo;
import com.cisco.dcbu.lib.util.ClientCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Scanner;
import java.util.Vector;

public class Uninstaller {
    private static final String JBOSS = "jboss-4.2.2.GA";
    Scanner in = new Scanner(System.in);
    Properties props = new Properties();
    String iDir = null;
    String fmDir = null;
    String dcmDir = null;
    String dbDir = null;
    String msi = SysInfo.HOME + SysInfo.FS + ".cisco_mds9000" + SysInfo.FS + "postgres-win" + SysInfo.FS + "postgresql-8.2-int.msi";
    boolean allUsers = false;
    boolean isFMSA = false;
    String nmsDir = null;
    String conf = ClientCache.getCommonDir() + "install.conf";
    private boolean promptUser = true;
    boolean hasJServer = false;
    private boolean removeAll = false;
    private boolean removeDB = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uninstaller() {
        String cwd = System.getProperty("user.dir");
        if (SysInfo.ONWINDOWS) {
            // empty if block
        }
        this.nmsDir = SysInfo.HOME;
        this.nmsDir = this.nmsDir + (this.nmsDir.equals(SysInfo.FS) ? ".cisco_mds9000" : SysInfo.FS + ".cisco_mds9000");
        if (!this.exists(this.conf)) {
            this.conf = ClientCache.getDir() + SysInfo.FS + "install.conf";
        }
        if (this.exists(this.conf)) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(this.conf);
                this.props.load(fin);
            }
            catch (FileNotFoundException e) {
                System.err.println(e.getMessage());
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException e) {
                        System.err.println(e.getMessage());
                    }
                }
            }
            this.fmDir = this.props.getProperty("mds.nmsRoot");
            if (this.fmDir == null) {
                throw new RuntimeException("Unable to find NMS root. Un-installation cannot continue.");
            }
            this.dcmDir = this.props.getProperty("mds.dcmRoot");
            if (this.dcmDir == null) {
                throw new RuntimeException("Unable to find DCM root. Un-installation cannot continue.");
            }
            this.iDir = this.props.getProperty("mds.ciscoRoot");
            if (this.iDir == null) {
                throw new RuntimeException("Unable to find installation root. Un-installation cannot continue.");
            }
        } else {
            throw new RuntimeException("Unable to locate " + this.conf + ".  Un-installation cannot continue.");
        }
        this.dbDir = this.props.getProperty("mds.db.dir");
        this.allUsers = Boolean.parseBoolean((String)this.props.get("mds.winAllUsers"));
        this.isFMSA = Boolean.parseBoolean((String)this.props.get("mds.standalone"));
        this.hasJServer = Boolean.parseBoolean(this.props.getProperty("mds.smis.installed", "false"));
    }

    public void copy(String fromFile, String toFile) {
        String[] cmds = SysInfo.ONWINDOWS ? new String[]{"cmd", "/c", "copy", "/Y", fromFile, toFile} : new String[]{"cp", fromFile, toFile};
        if (this.exists(fromFile)) {
            if (this.exists(toFile)) {
                this.delete(toFile);
            }
            File srcFile = new File(fromFile);
            try {
                Runtime.getRuntime().exec(cmds, null, new File(srcFile.getParent())).waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void removeDM() {
    }

    public void removeFM() {
    }

    public void removeJServer() {
        if (!this.hasJServer) {
            return;
        }
        if (SysInfo.ONWINDOWS || SysInfo.ONLINUX) {
            if (Service.isInstalled("CiscoSMIS")) {
                if (Service.isRunning("CiscoSMIS")) {
                    System.out.println("Stopping services...");
                    Service.stop("CiscoSMIS");
                    try {
                        Thread.sleep(45000L);
                    }
                    catch (Exception wake) {
                        // empty catch block
                    }
                }
                try {
                    Service.delete("CiscoSMIS");
                }
                catch (Exception ex) {
                    System.err.println(ex.getMessage());
                }
            }
            System.out.println("Removing SMI-S J server profile");
            if (this.exists(this.dcmDir + SysInfo.FS + "smis")) {
                this.delete(this.dcmDir + SysInfo.FS + "smis");
            }
        }
    }

    public void removeFMS() {
        System.out.println("Removing fm server profile");
        if (this.exists(this.dcmDir + SysInfo.FS + JBOSS + SysInfo.FS + "server" + SysInfo.FS + "fm")) {
            this.delete(this.dcmDir + SysInfo.FS + JBOSS + SysInfo.FS + "server" + SysInfo.FS + "fm");
        }
    }

    private boolean delete(String file) {
        File f = new File(file);
        if (f.exists()) {
            boolean deleted;
            System.out.println("Deleting " + file);
            if (f.isDirectory()) {
                File[] files;
                for (File fi : files = f.listFiles()) {
                    if (fi.isDirectory()) {
                        if (this.delete(fi.getAbsolutePath())) continue;
                        fi.deleteOnExit();
                        System.err.println("Unable to delete " + fi.getAbsolutePath());
                        continue;
                    }
                    if (fi.delete()) continue;
                    fi.deleteOnExit();
                    System.err.println("Unable to delete " + fi.getAbsolutePath());
                }
            }
            if (!(deleted = f.delete())) {
                f.deleteOnExit();
            }
            return deleted;
        }
        return true;
    }

    public void removeJBoss() {
    }

    public void removeDB() {
        String cmd = null;
        System.out.println("Removing PostgreSQL");
        if (SysInfo.ONWINDOWS) {
            cmd = "msiexec /x \"" + this.msi + "\" /qn";
        } else if (this.dbDir != null && new File(this.dbDir).exists()) {
            String bin = this.dbDir + SysInfo.FS + "bin" + SysInfo.FS + "DB";
            cmd = bin + " stop";
        }
        try {
            if (cmd != null) {
                Process proc = Runtime.getRuntime().exec(cmd);
                StreamReader oReader = new StreamReader(proc.getInputStream());
                StreamReader eReader = new StreamReader(proc.getErrorStream());
                oReader.start();
                eReader.start();
                int rc = proc.waitFor();
                if (rc != 0) {
                    System.err.println("Unable to remove DB.");
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        if (!SysInfo.ONWINDOWS) {
            if (!this.delete(this.dbDir)) {
                System.err.println("Unable to delete " + this.dbDir);
            }
            String pgsqlTmp = SysInfo.TMP + SysInfo.FS + ".s.PGSQL.5432";
            String pgsqlTmpLock = pgsqlTmp + ".lock";
            this.delete(pgsqlTmp);
            this.delete(pgsqlTmpLock);
        }
    }

    public void removeUserHome() {
    }

    public void removeCiscoHome() {
    }

    public void execute() {
        String[] dirs;
        this.askUser();
        System.out.println("Uninstalling...");
        if (this.removeDB) {
            this.removeDB();
        }
        if (Service.isInstalled("SAN Server")) {
            if (Service.isRunning("SAN Server")) {
                System.out.println("Stopping services...");
                Service.stop("SAN Server");
                try {
                    Thread.sleep(45000L);
                }
                catch (Exception wake) {
                    // empty catch block
                }
            }
            try {
                Service.delete("SAN Server");
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
        this.removeJServer();
        for (String dir : dirs = new String[]{"bin", "lib", "dir", "help", "download"}) {
            this.delete(this.fmDir + SysInfo.FS + dir);
        }
        this.delete(this.fmDir + SysInfo.FS + "README.txt");
        if (this.removeAll) {
            String[] oDirs;
            for (String dir : oDirs = new String[]{"reports", "logs", "db", "backup", "conf", "pm"}) {
                this.delete(this.fmDir + SysInfo.FS + dir);
            }
            this.delete(SysInfo.HOME + SysInfo.FS + ".cisco_mds9000");
        }
        this.removeFMS();
        String jbossDir = this.dcmDir + SysInfo.FS + JBOSS;
        String svrDir = jbossDir + SysInfo.FS + "server";
        if (!this.exists(svrDir + SysInfo.FS + "dcnm") && !this.exists(svrDir + SysInfo.FS + "open-dcnm")) {
            System.out.println("Deleting JBoss");
            this.delete(jbossDir);
        }
        this.delete(this.nmsDir + SysInfo.FS + "install.conf");
        this.delete(this.nmsDir + SysInfo.FS + "tmp");
        this.delete(this.nmsDir + SysInfo.FS + "tftp");
        this.delete(ClientCache.getCommonDir());
        if (this.removeAll) {
            this.delete(this.nmsDir);
        }
        if (SysInfo.ONWINDOWS) {
            System.out.println("Removing shortcuts...");
            String libDir = this.fmDir + SysInfo.FS + "lib";
            String binDir = this.fmDir + SysInfo.FS + "bin";
            Vector<Shortcut> shortcuts = new Vector<Shortcut>();
            shortcuts.add(new Shortcut(Service.getAllDesktop(), this.fmDir, libDir, binDir, Service.getAllStartMenu() + SysInfo.FS + "Cisco MDS9000"));
            shortcuts.add(new Shortcut(Service.getDesktop(), this.fmDir, libDir, binDir, Service.getStartMenu() + SysInfo.FS + "Cisco MDS9000"));
            shortcuts.add(new Shortcut(Service.getAllDesktop(), this.fmDir, libDir, binDir, Service.getAllStartMenu() + SysInfo.FS + "Cisco Fabric Manager"));
            shortcuts.add(new Shortcut(Service.getDesktop(), this.fmDir, libDir, binDir, Service.getStartMenu() + SysInfo.FS + "Cisco Fabric Manager"));
            System.out.println("Deleting links");
            try {
                for (Shortcut sc : shortcuts) {
                    sc.deleteFMSALinks();
                    sc.deleteFMSLinks();
                    sc.deleteDMLinks();
                    sc.deleteFMLinks();
                    sc.deleteServerPropLinks();
                }
            }
            catch (UnsatisfiedLinkError ex) {
                System.out.println("links not found: " + ex.getMessage());
            }
        }
        this.delete(this.fmDir + SysInfo.FS + "install.conf");
        this.delete(this.conf);
        this.removeStartup(SysInfo.FMSERVER_STARTUP);
        this.removeStartup(SysInfo.CISCOSMIS_STARTUP);
        if (this.promptUser) {
            System.out.println("Uninstallation complete. Hit Enter/Return to exit.");
            this.in.nextLine();
        }
    }

    private void askUser() {
        boolean ask;
        if (!this.promptUser) {
            this.removeAll = true;
            this.removeDB = true;
            return;
        }
        while (this.promptUser) {
            System.out.println("You are about to uninstall Cisco Management Software.");
            if (Service.isInstalled("SAN Server")) {
                System.out.println("If this is a server federation node, please  remove all fabrics managed by this server or move managed fabrics to another server in the federation before continuing.\n");
            }
            System.out.print("Are you sure you want to Uninstall? Press 'Y' to uninstall, 'A' to remove all files (including client preferences) or 'N' to exit.  [Y/A/N] ");
            String answer = this.in.nextLine();
            if (answer.trim().equalsIgnoreCase("n")) {
                System.exit(-1);
                continue;
            }
            if (answer.trim().equalsIgnoreCase("a")) {
                this.removeAll = true;
                break;
            }
            if (!answer.trim().equalsIgnoreCase("y")) continue;
            break;
        }
        if (ask = false) {
            // empty if block
        }
    }

    private void removeStartup(String name) {
        String file;
        if (SysInfo.ONWINDOWS) {
            return;
        }
        for (String link : SysInfo.STARTDIR) {
            file = link + SysInfo.FS + "S85" + name;
            this.delete(file);
            file = link + SysInfo.FS + "S86" + name;
            this.delete(file);
            file = link + SysInfo.FS + "S84" + name;
            this.delete(file);
        }
        for (String link : SysInfo.STOPDIR) {
            file = link + SysInfo.FS + "K03" + name;
            this.delete(file);
        }
        String initDir = SysInfo.FS + "etc" + SysInfo.FS + "init.d";
        if (SysInfo.ONLINUX && this.exists(SysInfo.FS + "etc" + SysInfo.FS + "rc.d" + SysInfo.FS + "init.d")) {
            initDir = SysInfo.FS + "etc" + SysInfo.FS + "rc.d" + SysInfo.FS + "init.d";
        }
        if (this.exists(initDir + SysInfo.FS + name)) {
            this.delete(initDir + SysInfo.FS + name);
        }
    }

    private boolean exists(String file) {
        return new File(file).exists();
    }

    public void setPromptUser(boolean b) {
        this.promptUser = b;
    }

    public void setRemoveDB(boolean b) {
        this.removeDB = true;
    }

    public void setRemoveAll(boolean b) {
        this.removeAll = true;
    }

    public static void main(String[] args) {
        try {
            new Uninstaller().execute();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            System.exit(-1);
        }
        System.exit(0);
    }
}

