/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.cisco.dcbu.install.ProgressTracker;
import com.cisco.dcbu.install.PropertiesUtil;
import com.cisco.dcbu.install.StreamReader;
import com.cisco.dcbu.install.model.SysInfo;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.util.NetUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class Util {
    static final long EMPTY_CRC = new CRC32().getValue();
    static Logger logger = Logger.getLogger(Util.class);

    static boolean bool(String b) {
        return Boolean.valueOf(b);
    }

    public static boolean exists(String file) {
        if (file == null) {
            return false;
        }
        return new File(file).exists();
    }

    static boolean canWrite(String file) {
        return new File(file).canWrite();
    }

    static boolean canRead(String file) {
        return new File(file).canRead();
    }

    public static boolean mkdir(String dir) {
        return new File(dir).mkdirs();
    }

    public static boolean isFile(String name) {
        return new File(name).isFile();
    }

    public static boolean isDirectory(String name) {
        return new File(name).isDirectory();
    }

    public static boolean touch(String file) throws IOException {
        return new File(file).createNewFile();
    }

    public static void createExec(String dir) throws Exception {
        String[] ls = new File(dir).list();
        for (int i = 0; i < ls.length; ++i) {
            Util.createExec(dir, ls[i]);
        }
    }

    public static void createExec(String dir, String file) throws Exception {
        if (!SysInfo.ONWINDOWS) {
            String[] cmds = new String[]{"chmod", "+x", dir + SysInfo.FS + file};
            Runtime.getRuntime().exec(cmds).waitFor();
        }
    }

    public static boolean delete(String file) {
        File f = new File(file);
        if (f.exists()) {
            if (f.isDirectory()) {
                File[] files;
                for (File fi : files = f.listFiles()) {
                    if (fi.isDirectory()) {
                        Util.delete(fi.getAbsolutePath());
                        continue;
                    }
                    fi.delete();
                }
            }
            return f.delete();
        }
        return true;
    }

    public static void deleteForce(String file) {
        File f = new File(file);
        if (!f.exists()) {
            return;
        }
        if (!f.delete()) {
            f.deleteOnExit();
        }
    }

    public static void deleteFiles(String dir, FilenameFilter filter) {
        if (Util.exists(dir)) {
            File[] fs = new File(dir).listFiles(filter);
            for (int i = 0; i < fs.length; ++i) {
                fs[i].delete();
            }
        }
    }

    public static void deleteFiles(String dir, String[] names) throws Exception {
        String[] cmds = SysInfo.ONWINDOWS ? new String[]{"cmd", "/c", "rmdir", "/s", "/q", ""} : new String[]{"rm", "-rf", ""};
        for (int i = 0; i < names.length; ++i) {
            String path;
            if (names[i] == null || !Util.exists(path = dir + SysInfo.FS + names[i])) continue;
            File file = new File(path);
            if (file.isDirectory()) {
                cmds[cmds.length - 1] = SysInfo.ONWINDOWS ? "\"" + path + "\"" : path;
                Runtime.getRuntime().exec(cmds, null, new File(dir)).waitFor();
                continue;
            }
            file.delete();
        }
    }

    public static void copyFiles(String fromDir, String toDir) throws Exception {
        String[] cmds = SysInfo.ONWINDOWS ? new String[]{"cmd", "/c", "xcopy", "/q", "/e", "/i", "", ""} : new String[]{"cp", "-r", "", ""};
        if (Util.exists(fromDir)) {
            File srcFile;
            if (Util.exists(toDir)) {
                Util.delete(toDir);
            }
            if ((srcFile = new File(fromDir)).isDirectory()) {
                cmds[cmds.length - 2] = SysInfo.ONWINDOWS ? "\"" + fromDir + "\"" : fromDir;
                cmds[cmds.length - 1] = SysInfo.ONWINDOWS ? "\"" + toDir + "\"" : toDir;
                Runtime.getRuntime().exec(cmds, null, new File(fromDir)).waitFor();
            }
        }
    }

    public static void copyFiles(String fromDir, String toDir, String[] names) throws Exception {
        String[] cmds = SysInfo.ONWINDOWS ? new String[]{"cmd", "/c", "xcopy", "/q", "/e", "/i", "", ""} : new String[]{"cp", "-r", "", ""};
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            String fromPath = fromDir + SysInfo.FS + names[i];
            String toPath = toDir + SysInfo.FS + names[i];
            if (!Util.exists(fromPath)) continue;
            if (Util.exists(toPath)) {
                Util.delete(toPath);
            }
            File srcFile = new File(fromPath);
            cmds[cmds.length - 2] = SysInfo.ONWINDOWS ? "\"" + fromPath + "\"" : fromPath;
            cmds[cmds.length - 1] = SysInfo.ONWINDOWS ? "\"" + (srcFile.isDirectory() ? toPath : toDir) + "\"" : toDir;
            Runtime.getRuntime().exec(cmds, null, new File(fromDir)).waitFor();
        }
    }

    public static void copy(String inFile, String outFile) throws IOException {
        FileInputStream fis = new FileInputStream(inFile);
        Util.copy(fis, outFile);
        fis.close();
    }

    public static void copy(InputStream inStream, String outFile) throws IOException {
        Util.copy(inStream, outFile, null, null);
    }

    public static void copy(InputStream inStream, String outFile, String[] names, String[] values) throws IOException {
        PropertiesUtil.copy(inStream, outFile, names, values);
    }

    static void copy(String inFile, String outFile, String[] names, String[] values) throws IOException {
        FileInputStream inStream = new FileInputStream(inFile);
        if (names == null) {
            byte[] buffer = new byte[1000];
            int bytes = 0;
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outFile));
            while ((bytes = inStream.read(buffer)) != -1) {
                bos.write(buffer, 0, bytes);
                bos.flush();
            }
            bos.close();
        } else {
            String l;
            BufferedWriter os = new BufferedWriter(new FileWriter(outFile));
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)inStream, "US-ASCII"));
            while ((l = r.readLine()) != null) {
                if (l.length() >= 1 && l.charAt(0) != '#') {
                    if (l.indexOf("=") == -1) {
                        l = " ";
                    } else {
                        for (int i = 0; i < names.length; ++i) {
                            if (values[i] == null || l.indexOf(names[i]) == -1) continue;
                            values[i] = values[i].replace("\\", "\\\\");
                            int preIndex = l.indexOf(names[i]);
                            int postIndex = l.indexOf("=", preIndex);
                            String parsedName = l.substring(preIndex, postIndex);
                            while (parsedName.lastIndexOf(" ") != -1) {
                                parsedName = parsedName.substring(0, parsedName.lastIndexOf(" "));
                            }
                            if (!parsedName.equals(names[i])) continue;
                            l = names[i] + " = " + values[i];
                            break;
                        }
                    }
                }
                os.write(l);
                os.newLine();
            }
            os.close();
        }
        inStream.close();
    }

    public static boolean updateProperties(String inFile, String outFile, String[] keys, String[] values, boolean add) throws IOException {
        return PropertiesUtil.updateProperties(inFile, outFile, keys, values, add);
    }

    public static String getJarVersion(String file) {
        String version = null;
        if (Util.exists(file)) {
            try {
                JarFile jf = new JarFile(file);
                Attributes ar = jf.getManifest().getMainAttributes();
                if (ar != null) {
                    version = ar.getValue(Attributes.Name.MANIFEST_VERSION);
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return version;
    }

    public static void download(String remote, String local) throws IOException {
        Util.download(remote, local, null);
    }

    static void download(String remote, String local, ProgressTracker tr) throws IOException {
        URL url = new URL(remote);
        URLConnection conn = url.openConnection();
        conn.setDefaultUseCaches(false);
        conn.setUseCaches(false);
        conn.setRequestProperty("pragma", "no-cache");
        if (tr != null) {
            tr.startDownload(remote);
        }
        Util.download(conn, local, remote.endsWith(".tbz2"), tr);
    }

    static void download(URLConnection conn, String local, boolean isTarBz2, ProgressTracker tr) throws IOException {
        InputStream in = conn.getInputStream();
        int SIZE = 100;
        byte[] buff = new byte[100];
        int offset = 0;
        if (isTarBz2) {
            TarEntry entry;
            char[] magic = new char[]{'B', 'Z'};
            for (int i = 0; i < magic.length; ++i) {
                if (in.read() == magic[i]) continue;
                throw new IOException("Invalid bz2 file");
            }
            CBZip2InputStream zin = new CBZip2InputStream(in);
            TarInputStream tin = new TarInputStream(zin);
            ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(local));
            zout.setMethod(8);
            String extraSep = "//";
            while ((entry = tin.getNextEntry()) != null) {
                int gotbytes;
                String name = entry.getName();
                boolean isDir = entry.isDirectory();
                if (name.endsWith(extraSep)) {
                    name = name.substring(0, name.length() - 1);
                }
                if (isDir) {
                    ZipEntry dirEntry = new ZipEntry(name);
                    dirEntry.setSize(0L);
                    dirEntry.setMethod(0);
                    dirEntry.setCrc(EMPTY_CRC);
                    zout.putNextEntry(dirEntry);
                    continue;
                }
                ZipEntry fileEntry = new ZipEntry(name);
                zout.putNextEntry(fileEntry);
                while ((gotbytes = tin.read(buff, 0, 100)) > 0) {
                    zout.write(buff, 0, gotbytes);
                    zout.flush();
                    offset += gotbytes;
                }
            }
            tin.close();
            zout.close();
        } else {
            BufferedInputStream bin = new BufferedInputStream(in);
            File f = new File(local);
            BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(f));
            try {
                int gotbytes;
                while ((gotbytes = bin.read(buff, 0, 100)) > 0) {
                    bout.write(buff, 0, gotbytes);
                    bout.flush();
                    offset += gotbytes;
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            finally {
                bin.close();
                bout.close();
            }
        }
    }

    private static char toHex(int nibble) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        return hexDigit[nibble & 0xF];
    }

    public static String saveConvert(String theString) {
        String specialSaveChars = "=: \t\r\n\f#!";
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(Util.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(Util.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(Util.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(Util.toHex(aChar & 0xF));
                        continue block8;
                    }
                    if ("=: \t\r\n\f#!".indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static void extract(String jarFile, String outDir) throws IOException {
        Util.extract(jarFile, outDir, null);
    }

    public static void extract(String jarFile, String outDir, boolean xtractMeta) throws IOException {
        Util.extract(jarFile, outDir, false, null, null, null, null, xtractMeta);
    }

    static void extract(String jarFile, String outDir, ProgressTracker tr) throws IOException {
        Util.extract(jarFile, outDir, false, null, null, null, tr, false);
    }

    public static void extract(String jarFile, String outDir, boolean replace, String[] names, String[] values, String[] dontOverWrite, ProgressTracker tr, boolean xtractMETA) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(new FileInputStream(jarFile));
        while ((entry = zis.getNextEntry()) != null) {
            String name = entry.getName();
            String fullName = outDir + SysInfo.FS + name;
            if (entry.isDirectory()) {
                if (name.startsWith("META-INF") && !xtractMETA) continue;
                if (Util.exists(fullName) && Util.isFile(fullName)) {
                    Util.delete(fullName);
                }
                Util.mkdir(fullName);
                continue;
            }
            if (Util.exists(fullName) && !Util.isFile(fullName)) {
                Util.delete(fullName);
            }
            if (tr != null) {
                tr.extractFile(name);
            }
            logger.info((Object)name);
            if (name.startsWith("META-INF") && !xtractMETA || SysInfo.ONWINDOWS && name.endsWith(".sh") || !SysInfo.ONWINDOWS && Util.isWindows(name) || !SysInfo.ONLINUX && name.endsWith(".linux") || !SysInfo.ONSOLARIS && name.endsWith(".solaris") || !SysInfo.ONMAC && name.endsWith(".macosx")) continue;
            if (SysInfo.ONLINUX && name.endsWith(".linux") || SysInfo.ONSOLARIS && name.endsWith(".solaris") || SysInfo.ONMAC && name.endsWith(".macosx")) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            String outFile = outDir + SysInfo.FS + name;
            boolean overWrite = true;
            if (dontOverWrite != null) {
                for (int i = 0; i < dontOverWrite.length; ++i) {
                    if (!dontOverWrite[i].equals(name)) continue;
                    overWrite = false;
                    break;
                }
            }
            if (Util.exists(outFile) && !overWrite) continue;
            if (replace && Util.isAscii(name)) {
                Util.copy(zis, outFile, names, values);
                continue;
            }
            Util.copy(zis, outFile);
        }
        zis.close();
    }

    static boolean isAscii(String name) {
        String[] extns = new String[]{".sh", ".conf", ".bat", ".properties", ".properties.ini"};
        return Util.isType(name, extns);
    }

    static boolean isWindows(String name) {
        String[] extns = new String[]{".dll", ".exe", ".bat"};
        return Util.isType(name, extns);
    }

    static boolean isType(String name, String[] extns) {
        for (int i = 0; i < extns.length; ++i) {
            if (!name.endsWith(extns[i])) continue;
            return true;
        }
        return false;
    }

    public static String[] getLocalAddresses(boolean includeLoop) {
        String[] addrs = NetUtil.getLocalIpv4Addresses();
        if (!includeLoop) {
            return addrs;
        }
        String[] loops = NetUtil.getLoopIpv4Addresses();
        int length = 0;
        if (addrs != null) {
            if (loops == null) {
                return addrs;
            }
            length = addrs.length + loops.length;
            String[] ar = new String[length];
            System.arraycopy(addrs, 0, ar, 0, addrs.length);
            System.arraycopy(loops, 0, ar, addrs.length, loops.length);
            addrs = ar;
        } else if (loops != null) {
            addrs = loops;
        }
        return addrs;
    }

    static int freePort(boolean tcp, int[] prefPorts) {
        for (int i = 0; i < prefPorts.length; ++i) {
            if (Util.freePort(tcp, prefPorts[i]) == -1) continue;
            return prefPorts[i];
        }
        return Util.freePort(tcp, 0);
    }

    static int freePort(boolean tcp, int port) {
        int retPort = -1;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            InetSocketAddress sockAddr = new InetSocketAddress(addr, port);
            if (tcp) {
                Socket sock = new Socket();
                sock.bind(sockAddr);
                retPort = sock.getLocalPort();
                sock.close();
            } else {
                DatagramSocket dsock = new DatagramSocket(sockAddr);
                retPort = dsock.getLocalPort();
                dsock.close();
            }
        }
        catch (Exception ex) {
            retPort = -1;
        }
        return retPort;
    }

    public static Properties loadProps(String path) {
        Properties props = PropertiesUtil.loadProps(path);
        return props;
    }

    static String verifyPassword(String pass1, String pass2) {
        if ("".equals(pass1.trim())) {
            return null;
        }
        if (pass1.trim().equals(pass2.trim())) {
            return pass1.trim();
        }
        return null;
    }

    public static void chmod(String file, String permission) throws Exception {
        if (SysInfo.ONWINDOWS) {
            return;
        }
        if (!Util.exists(file)) {
            System.err.println("chmod error: " + file + " not found.");
            return;
        }
        String[] cmds = new String[]{"chmod", permission, file};
        Runtime.getRuntime().exec(cmds).waitFor();
    }

    public static void chown(String user, String path) throws Exception {
        if (SysInfo.ONWINDOWS) {
            return;
        }
        if (!Util.exists(path)) {
            System.err.println("chmown error: " + path + " does not exist.");
            return;
        }
        String[] cmds = new String[]{"chown", "-R", user, path};
        Runtime.getRuntime().exec(cmds).waitFor();
    }

    public static boolean isRoot() {
        if (!SysInfo.ONSOLARIS && !SysInfo.ONLINUX) {
            return false;
        }
        String user = System.getProperty("user.name", "unknown");
        if ("unknown".equals(user)) {
            return false;
        }
        return user.contains("root");
    }

    public static boolean validateUser(String str) {
        if (str == null) {
            return false;
        }
        if (str.trim().length() == 0) {
            return false;
        }
        if (str.trim().length() > 32) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '@') continue;
            return false;
        }
        return true;
    }

    public static boolean validatePassword(String str) {
        if (str == null) {
            return false;
        }
        if (str.trim().length() == 0) {
            return false;
        }
        if (str.trim().length() > 64) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isSpaceChar(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean exec(String[] cmds) throws Exception {
        Process proc = Runtime.getRuntime().exec(cmds);
        new StreamReader(proc.getInputStream()).start();
        new StreamReader(proc.getErrorStream()).start();
        int rc = proc.waitFor();
        return rc == 0;
    }

    public static boolean exec(String cmd) throws Exception {
        Process proc = Runtime.getRuntime().exec(cmd);
        new StreamReader(proc.getInputStream()).start();
        new StreamReader(proc.getErrorStream()).start();
        int rc = proc.waitFor();
        return rc == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tcpConnect(String server, int port) {
        Socket soc = null;
        try {
            soc = new Socket(server, port);
            boolean bl = soc.isConnected();
            return bl;
        }
        catch (Exception ex) {
            System.err.println("Unable to connect to port " + port);
        }
        finally {
            if (soc != null) {
                try {
                    soc.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static boolean link(String file, String link) throws Exception {
        if (SysInfo.ONWINDOWS) {
            return false;
        }
        String ln = "";
        if (Util.exists("/usr/bin/ln")) {
            ln = "/usr/bin/ln";
        } else if (Util.exists("/bin/ln")) {
            ln = "/bin/ln";
        } else if (Util.exists("/usr/local/bin/ln")) {
            ln = "/usr/local/bin/ln";
        } else {
            throw new Exception("Unable to find ln");
        }
        String cmd = ln + " -s " + file + " " + link;
        return Util.exec(cmd);
    }

    public static String hideString(String str) {
        return str.replaceAll("[\\x21-\\x7E]", "*");
    }

    public static String getExtension(File f) {
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            return s.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public static String preserveBackslash(String str) {
        return str.replace("\\", "\\\\");
    }

    public static boolean isSamePath(String path1, String path2) {
        return new File(path1).equals(new File(path2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSnmpCheck(String seed, String seed2, int authProtocol, int privProtocol, String username, String password) throws IOException, SnmpException, UnknownHostException {
        SnmpSession session = null;
        SnmpPeer peer = null;
        if (seed == null) {
            seed = "";
        }
        try {
            session = SnmpSession.getInstance();
            session.open();
            peer = new SnmpPeer(InetAddress.getByName(seed), session, username, password, authProtocol, password, privProtocol);
            if (seed2 != null && !"".equals(seed2.trim())) {
                peer = new SnmpPeer(InetAddress.getByName(seed2), session, username, password, authProtocol, password, privProtocol);
            }
        }
        finally {
            if (peer != null) {
                peer.close();
            }
        }
    }
}

