/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install;

import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.CustomFieldDef;
import com.vmware.vim25.CustomFieldStringValue;
import com.vmware.vim25.CustomFieldValue;
import com.vmware.vim25.mo.CustomFieldsManager;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.net.URL;
import java.util.HashMap;
import org.apache.commons.lang.StringEscapeUtils;

public class VCProxy {
    private static boolean checkPingable = true;
    private String _server;
    private String _username;
    private int _port;
    private String _password;
    private String _sessionId;
    private ServiceInstance _serviceInstance = null;
    private int _custFieldKey = -1;
    private String version;
    private HashMap<String, VirtualMachine> vmMap = new HashMap();
    public static final String SESSION_ID = "sessionId";
    public static final String SERVICE_URL = "serviceUrl";
    public static final String SOAP_SESSION_KEY = "vmware_soap_session";
    public static final int DEFAULT_PORT = 443;

    public VCProxy(String server, String port, String username, String password) {
        this(server, Integer.valueOf(port), username, password);
    }

    public VCProxy(String server, int port, String username, String password) {
        this._server = server;
        this._port = port;
        this._username = username;
        this._password = password;
    }

    public VCProxy(String server, String sessionId) {
        this(server, 443, sessionId);
    }

    public VCProxy(String server, int port, String sessionId) {
        this._server = server;
        this._port = port;
        this._sessionId = sessionId;
    }

    public void setSessionId(String sessionId) {
        this._sessionId = sessionId;
    }

    public String getSessionId() {
        return this._sessionId;
    }

    protected String getSessionStr() {
        return "vmware_soap_session=\"" + this._sessionId + "\"";
    }

    protected String getVCURL() {
        return "https://" + this._server + ":" + this._port + "/sdk";
    }

    public String getVersion() {
        return this.version;
    }

    public synchronized ServiceInstance getServiceInstance() throws Exception {
        if (this._serviceInstance == null) {
            try {
                this._serviceInstance = this._sessionId != null ? new ServiceInstance(new URL(this.getVCURL()), this.getSessionStr(), true) : new ServiceInstance(new URL(this.getVCURL()), this._username, this._password, true);
                this.version = VCProxy.checkVCenterType(this._serviceInstance);
                this.initAnmCustomerFieldKey();
            }
            catch (Exception e) {
                if (e.getMessage() == null) {
                    throw new Exception("Error in connecting to " + this._server);
                }
                if (e.getMessage().indexOf("Connection timed out") != -1 || e.getMessage().indexOf("Connection refused") != -1) {
                    throw new Exception("Cannot access vCenter, please make sure that the IP address or DNS name and the access port are correct");
                }
                throw new Exception("Error in connecting to " + this._server + ": " + e.getMessage(), e);
            }
        }
        return this._serviceInstance;
    }

    public static String checkVCenterType(ServiceInstance service) throws Exception {
        AboutInfo about = service.getAboutInfo();
        if (about == null || !"VirtualCenter".equalsIgnoreCase(about.getApiType())) {
            throw new Exception("The target device type is unsupported: " + about.getName());
        }
        System.out.println("The vCenter info: " + about.getApiType() + ", version=" + about.getApiVersion() + ", fullname=" + about.getFullName() + ", osType=" + about.getOsType() + ", vendor=" + about.getVendor());
        return about.getApiVersion();
    }

    private void initAnmCustomerFieldKey() throws Exception {
        try {
            CustomFieldsManager customFieldMgr = this.getServiceInstance().getCustomFieldsManager();
            CustomFieldDef[] fields = customFieldMgr.getField();
            if (fields != null && fields.length > 0) {
                for (CustomFieldDef field : fields) {
                    if (!"ANM_MAPPING_FIELD".equals(field.getName())) continue;
                    this._custFieldKey = field.getKey();
                    break;
                }
            }
            if (this._custFieldKey == -1) {
                CustomFieldDef field = customFieldMgr.addCustomFieldDef("ANM_MAPPING_FIELD", "ManagedEntity", null, null);
                this._custFieldKey = field.getKey();
            }
        }
        catch (Exception ex) {
            throw new Exception("Error in initialize ANM custom field key in VCenter: " + ex.getMessage(), ex);
        }
    }

    public void addVm(String vmId, VirtualMachine vm) {
        this.vmMap.put(vmId, vm);
    }

    public void setCustomField(VirtualMachine vm, String value) throws Exception {
        if (this._custFieldKey == -1) {
            throw new Exception("ANM Custom Field is not initialized in VCenter.");
        }
        this._serviceInstance.getCustomFieldsManager().setField((ManagedEntity)vm, this._custFieldKey, StringEscapeUtils.escapeHtml((String)value));
    }

    public void setCustomField(String vmId, String value) throws Exception {
        if (this._custFieldKey == -1) {
            throw new Exception("ANM Custom Field is not initialized in VCenter.");
        }
        if (this.vmMap.get(vmId) == null) {
            throw new RuntimeException("setCustomField: can't find VM object, vmId=" + vmId + ", value=" + value);
        }
        this.setCustomField(this.vmMap.get(vmId), value);
    }

    public void resetCustomField(VirtualMachine vm) throws Exception {
        this.setCustomField(vm, "");
    }

    public String getCustomField(VirtualMachine vm) throws Exception {
        if (this._custFieldKey == -1) {
            throw new Exception("ANM Custom Field is not initialized in VCenter.");
        }
        CustomFieldValue[] cusFields = vm.getValues();
        if (cusFields == null || cusFields.length == 0) {
            return null;
        }
        for (CustomFieldValue field : cusFields) {
            if (field.getKey() != this._custFieldKey || field.getClass() != CustomFieldStringValue.class) continue;
            String str = StringEscapeUtils.unescapeHtml((String)((CustomFieldStringValue)field).getValue());
            return str;
        }
        return null;
    }

    public String getProductInfo() throws Exception {
        AboutInfo aboutInfo = this.getServiceInstance().getAboutInfo();
        if (aboutInfo == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("FullName:" + aboutInfo.getFullName() + ", ");
        buffer.append("Vendor:" + aboutInfo.getVendor() + ", ");
        buffer.append("Version:" + aboutInfo.getVersion() + ", ");
        buffer.append("Build:" + aboutInfo.getBuild() + ", ");
        buffer.append("ApiType:" + aboutInfo.getApiType() + ", ");
        buffer.append("ApiVersion:" + aboutInfo.getApiVersion());
        return buffer.toString();
    }

    public String getProductVersion() throws Exception {
        AboutInfo aboutInfo = this.getServiceInstance().getAboutInfo();
        if (aboutInfo == null) {
            return null;
        }
        return aboutInfo.getVersion();
    }

    public synchronized void disconnect() throws Exception {
        this.getServiceInstance().getServerConnection().logout();
        this._serviceInstance = null;
    }

    public static void main(String[] args) {
        VCProxy proxy = new VCProxy("172.22.29.87", new Integer(443), "Administrator", "nbv_12345");
        try {
            System.out.println(proxy.getProductInfo());
            ServiceInstance si = proxy.getServiceInstance();
            int anmFieldKey = proxy.getCustFieldKey();
            if (anmFieldKey == -1) {
                System.out.println("Can't find ANM custom field key.");
                return;
            }
            String moId = "vm-316";
            proxy.setCustomField(moId, "<Rule>Name-Mapping</Rule><RSERVER>sf123/rserver1:111</RSERVER>");
            proxy.setCustomField(moId, "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getCustFieldKey() {
        return this._custFieldKey;
    }

    public void setCustFieldKey(int fieldKey) {
        this._custFieldKey = fieldKey;
    }

    public String getServer() {
        return this._server;
    }

    public static void logConsole(String msg) {
    }

    public String get_server() {
        return this._server;
    }

    public String get_username() {
        return this._username;
    }

    public int get_port() {
        return this._port;
    }

    public String get_password() {
        return this._password;
    }
}

