/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install.view;

import com.cisco.dcbu.install.view.CheckTreeNode;
import com.cisco.dcbu.install.view.NICCard;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;

class CheckTree
extends JTree {
    private CheckTreeNode[] nodes = null;
    private CheckTreeNode root = null;

    public CheckTree(CheckTreeNode root) {
        super(root);
        if (root == null) {
            root = new CheckTreeNode("");
        } else {
            this.root = root;
        }
    }

    public void saveState() {
        if (this.root == null) {
            return;
        }
        this.root.saveSelection();
        Enumeration<TreeNode> eRoot = this.root.children();
        while (eRoot.hasMoreElements()) {
            CheckTreeNode node = (CheckTreeNode)eRoot.nextElement();
            node.saveSelection();
            Enumeration<TreeNode> eChild = node.children();
            while (eChild.hasMoreElements()) {
                CheckTreeNode child = (CheckTreeNode)eChild.nextElement();
                child.saveSelection();
            }
        }
    }

    public void rollBack() {
        if (this.root == null) {
            return;
        }
        this.root.undoSelected();
        Enumeration<TreeNode> eRoot = this.root.children();
        while (eRoot.hasMoreElements()) {
            CheckTreeNode node = (CheckTreeNode)eRoot.nextElement();
            node.undoSelected();
            Enumeration<TreeNode> eChild = node.children();
            while (eChild.hasMoreElements()) {
                CheckTreeNode child = (CheckTreeNode)eChild.nextElement();
                child.undoSelected();
            }
        }
    }

    public boolean hasSelectedNode() {
        Enumeration<TreeNode> eRoot = this.root.children();
        while (eRoot.hasMoreElements()) {
            CheckTreeNode node = (CheckTreeNode)eRoot.nextElement();
            if (!node.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void processInput() {
    }

    public String getSelectedItems() {
        String selectedItems = new String("");
        try {
            if (this.root == null) {
                System.err.println("root is null");
                return null;
            }
            Enumeration<TreeNode> eRoot = this.root.children();
            while (eRoot.hasMoreElements()) {
                CheckTreeNode node = (CheckTreeNode)eRoot.nextElement();
                if (!node.isSelected()) continue;
                if (node.isActive()) {
                    if ("".equals(selectedItems)) {
                        selectedItems = selectedItems + NICCard.parseIntfName(node.toString());
                        continue;
                    }
                    selectedItems = selectedItems + ", " + NICCard.parseIntfName(node.toString());
                    continue;
                }
                Enumeration<TreeNode> eChild = node.children();
                while (eChild.hasMoreElements()) {
                    CheckTreeNode child = (CheckTreeNode)eChild.nextElement();
                    if (!child.isSelected()) continue;
                    if ("".equals(selectedItems)) {
                        selectedItems = selectedItems + child.toString();
                        continue;
                    }
                    selectedItems = selectedItems + ", " + child.toString();
                }
            }
        }
        catch (NullPointerException npe) {
            System.err.println(npe.toString());
        }
        catch (StringIndexOutOfBoundsException ooe) {
            System.err.println(ooe.toString());
        }
        return selectedItems;
    }
}

