/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install.view;

import com.cisco.dcbu.install.view.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class FinishPanel
extends WizardPanel {
    public static final String NAME = "Install Complete";
    public static final String CREATE_MENU = "Create menu items for all users";
    private JCheckBox installLog;
    private JCheckBox shortcut;
    private JTextArea seeRunAppInstructionInfo;
    private JLabel seeInstallLog;
    private boolean onWindows;
    private JCheckBox launchFM = new JCheckBox("Launch Fabric Manager");
    private JCheckBox launchDM = new JCheckBox("Launch Device Manager");
    private JEditorPane getFMLabel = new JEditorPane();

    public FinishPanel(String uDir, boolean onWindows) {
        super(FinishPanel.createBanner(NAME, "Installation was completed successfully"), 0, false);
        this.banner.setVisible(false);
        this.installLog = new JCheckBox("Open install log");
        this.shortcut = new JCheckBox("Create shortcuts and menu items for all users");
        this.shortcut.setSelected(false);
        this.seeRunAppInstructionInfo = new JTextArea("");
        this.seeInstallLog = new JLabel("<html><body>Please view " + uDir + "/install.log for further details.</body><html>");
        this.onWindows = onWindows;
        this.launchFM.setSelected(true);
        this.launchDM.setSelected(false);
        this.getFMLabel.setContentType("text/html");
        this.getFMLabel.setEditable(false);
        this.getFMLabel.setFont(this.seeInstallLog.getFont());
        this.getFMLabel.addHyperlinkListener(this);
        this.getFMLabel.setFont((Font)UIManager.getDefaults().get("Table.font"));
        Color bg = UIManager.getColor("Label.foreground");
        if (bg != null && !bg.equals(Color.WHITE)) {
            this.installLog.setBackground(Color.WHITE);
            this.shortcut.setBackground(Color.WHITE);
            this.seeInstallLog.setBackground(Color.WHITE);
            this.launchFM.setBackground(Color.WHITE);
            this.launchDM.setBackground(Color.WHITE);
            this.getFMLabel.setBackground(Color.WHITE);
        }
        this.setContent();
    }

    public boolean showInstallLog() {
        return this.installLog.isSelected();
    }

    public boolean launchFM() {
        return this.launchFM.isSelected();
    }

    public boolean launchDM() {
        return this.launchDM.isSelected();
    }

    public boolean createShortcutForAllUsers() {
        return this.shortcut.isSelected();
    }

    public void setLaunchVisible(boolean b) {
        this.launchFM.setVisible(b);
        this.launchDM.setVisible(b);
        this.revalidate();
    }

    public void setLaunchFMVisible(boolean b) {
        this.launchFM.setVisible(b);
        this.revalidate();
    }

    public void setLaunchDM(boolean b) {
        this.launchDM.setSelected(b);
    }

    public void setLaunchDMVisible(boolean b) {
        this.launchDM.setVisible(b);
        this.revalidate();
    }

    public void setShortCutText(String text) {
        this.shortcut.setText(text);
    }

    public void setCreateShortcutForAllUsers(boolean b) {
        this.shortcut.setSelected(b);
        this.revalidate();
    }

    public void setShortcutVisible(boolean b) {
        this.shortcut.setVisible(b);
        this.revalidate();
    }

    public void setseeRunAppInstructionInfoVisible(boolean b, String binDir) {
        if (b) {
            String appName = "DeviceManager" + (this.onWindows ? ".bat" : ".sh");
            this.seeRunAppInstructionInfo.setText("Please run \"" + binDir + File.separator + appName + "\" to launch Device Manager.");
        }
        this.seeRunAppInstructionInfo.setVisible(b);
        this.revalidate();
    }

    public void setContent() {
        JComponent[] labels = new JLabel[]{new JLabel(""), new JLabel(""), new JLabel(""), new JLabel(""), new JLabel("")};
        JComponent[] comps = new JComponent[]{this.seeInstallLog, this.installLog, this.shortcut, this.launchFM, this.launchDM};
        try {
            JPanel content = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.weighty = 0.0;
            gbc.weightx = 0.0;
            content.add(new JLabel(new ImageIcon(FinishPanel.loadImage("FMWelcome193x346.png"))));
            ++gbc.gridx;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.anchor = 13;
            JPanel right = new JPanel(new BorderLayout());
            JLabel completeLbl = new JLabel("<html>Installation completed successfully.</html>");
            Font font = UIManager.getDefaults().getFont("Table.font");
            completeLbl.setFont(new Font(font.getFontName(), 1, font.getSize()));
            JPanel form = FinishPanel.createForm(labels, comps);
            completeLbl.setBorder(BorderFactory.createEmptyBorder(47, 33, 0, 15));
            form.setBorder(BorderFactory.createEmptyBorder(0, 33, 15, 15));
            right.add((Component)completeLbl, "North");
            right.add((Component)form, "Center");
            Color bg = UIManager.getColor("Label.foreground");
            if (bg != null && !bg.equals(Color.WHITE)) {
                form.setBackground(Color.WHITE);
                right.setBackground(Color.WHITE);
            }
            this.getFMLabel.setBorder(BorderFactory.createEmptyBorder(0, 33, 20, 15));
            right.add((Component)this.getFMLabel, "South");
            content.add((Component)right, gbc);
            JPanel south = new JPanel(new BorderLayout());
            this.seeRunAppInstructionInfo.setEditable(false);
            this.seeRunAppInstructionInfo.setLineWrap(true);
            this.seeRunAppInstructionInfo.setWrapStyleWord(true);
            this.seeRunAppInstructionInfo.setOpaque(false);
            this.seeRunAppInstructionInfo.setFont(new Font(font.getFontName(), 1, font.getSize()));
            this.seeRunAppInstructionInfo.setBorder(BorderFactory.createEmptyBorder(47, 33, 0, 15));
            south.add((Component)this.seeRunAppInstructionInfo, "North");
            south.setBackground(Color.WHITE);
            this.center.add((Component)content, "Center");
            this.center.add((Component)south, "South");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.installLog.setVisible(this.onWindows);
        this.shortcut.setVisible(this.onWindows);
        this.seeRunAppInstructionInfo.setVisible(false);
        this.seeInstallLog.setVisible(!this.onWindows);
        this.revalidate();
    }

    public void setGetFMLabel(String where) {
        this.getFMLabel.setText(where);
        this.revalidate();
    }

    public static void main(String[] args) throws Exception {
        JFrame test = new JFrame();
        test.getContentPane().add(new FinishPanel("123 Maple Lane.", true));
        test.pack();
        test.setVisible(true);
    }
}

