/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install.view;

import com.cisco.dcbu.install.view.WizardPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class SHProgressPanel
extends WizardPanel {
    public static final String NAME = "Collecting";
    private JProgressBar pbar = new JProgressBar(0, 100);
    private JLabel timeRemainLbl = new JLabel("Time remaining: ");
    private JLabel timeRemainVal = new JLabel("0:00");

    public SHProgressPanel() {
        super(SHProgressPanel.createBanner(NAME, "FM is gathering information about your fabric(s).  When the time elapses, you will be prompted to email analysis file and uninstall.  Press 'Cancel' to stop gathering immediately.", true), 0, true);
        this.pbar.setIndeterminate(false);
        this.setContent();
    }

    public void setContent() {
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        JPanel timePanel = new JPanel();
        timePanel.setLayout(new FlowLayout(3));
        timePanel.add(this.timeRemainLbl);
        timePanel.add(this.timeRemainVal);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        content.add((Component)timePanel, gbc);
        ++gbc.gridy;
        content.add((Component)this.pbar, gbc);
        this.setContent(content);
    }

    public void updateProgress(int percent) {
        this.pbar.setValue(percent);
    }

    public void updateTime(long milliseconds) {
        this.timeRemainVal.setText(SHProgressPanel.formatTime(milliseconds));
    }

    public static String formatTime(long millis) {
        String hour = "-";
        String min = "-";
        String sec = "-";
        if (millis > 0L) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(millis));
            hour = Long.toString(millis / 3600000L % 99L);
            min = String.valueOf(cal.get(12));
            sec = String.valueOf(cal.get(13));
            hour = SHProgressPanel.prependZero(hour);
            min = SHProgressPanel.prependZero(min);
            sec = SHProgressPanel.prependZero(sec);
        }
        String ret = hour + ":" + min + ":" + sec;
        return ret;
    }

    private static String prependZero(String s) {
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }
}

