/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install.view;

import com.cisco.dcbu.install.view.WizardPanel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class UserPanel
extends WizardPanel {
    public static final String NAME = "User Options";
    public static final String ENTER_CREDENTIAL_BRIEF = "In order to upgrade/reinstall FM on this host, please authenticate with a local FM user who has privilege as network-admin.  Click Next to continue.";
    public static final String CREATE_USER_BRIEF = "Please choose your local username and password wisely. Your password should be difficult for others to figure out but easy for you to remember.  Local login is used when AAA and MDS authentication modes are disabled.";
    private JTextField user = new JTextField("admin", 20);
    private JLabel confirmPasswdLbl = new JLabel("Confirm Password:");
    private JPasswordField passwd = new JPasswordField("", 20);
    private JPasswordField confirmPasswd = new JPasswordField("", 20);

    public UserPanel(boolean verify) {
        super(UserPanel.createBanner(NAME, "Create a local user"), 0, true);
        this.buildContent(verify);
    }

    public UserPanel() {
        this(false);
    }

    public void setPassword(String password) {
        this.passwd.setText(password);
        this.confirmPasswd.setText(password);
    }

    public String getConfirmPassword() {
        return new String(this.confirmPasswd.getPassword());
    }

    public void setUser(String username) {
        this.user.setText(username);
    }

    public String getUser() {
        return this.user.getText();
    }

    public String getPassword() {
        return new String(this.passwd.getPassword());
    }

    private void buildContent(boolean verify) {
        JLabel fmUser = new JLabel("Local FM User:");
        JLabel fmPasswd = new JLabel("Local FM Password:");
        JLabel mode = new JLabel("Mode:");
        JComponent[] labels = new JLabel[]{fmUser, fmPasswd, this.confirmPasswdLbl};
        JComponent[] comps = new JComponent[]{this.user, this.passwd, this.confirmPasswd};
        try {
            this.setContent(UserPanel.createForm(labels, comps));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setShowCreateUser(!verify);
    }

    public void setShowCreateUser(boolean b) {
        this.confirmPasswdLbl.setVisible(b);
        this.confirmPasswd.setVisible(b);
        this.setBrief(b ? CREATE_USER_BRIEF : ENTER_CREDENTIAL_BRIEF);
    }
}

