/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.install.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

class WizardBanner
extends JPanel {
    protected JLabel title;
    protected JTextArea describe;
    ImageIcon image;
    boolean enableHeaderDesc;

    public WizardBanner(String title, String describe, ImageIcon icon, boolean enableHeaderDesc) {
        this.title = new JLabel(title);
        this.describe = new JTextArea(describe);
        this.image = icon;
        this.enableHeaderDesc = enableHeaderDesc;
        this.buildContent();
    }

    public WizardBanner(String title, String describe, ImageIcon icon) {
        this(title, describe, icon, false);
    }

    public WizardBanner(String title, ImageIcon i) {
        this.title = new JLabel(title);
        this.image = i;
        JLabel imageLbl = new JLabel(this.image);
        imageLbl.setBorder(BorderFactory.createEmptyBorder());
        this.add(imageLbl);
    }

    public String getTitle() {
        return this.title.getText();
    }

    private void buildContent() {
        JPanel left = new JPanel();
        left.setLayout(new GridBagLayout());
        Color bg = UIManager.getColor("Panel.background");
        if (bg == null || !bg.equals(Color.BLACK)) {
            left.setBackground(Color.WHITE);
            this.setBackground(Color.WHITE);
        }
        Font font = UIManager.getDefaults().getFont("Table.font");
        this.title.setFont(new Font(font.getFontName(), 1, font.getSize()));
        this.describe.setEditable(false);
        this.describe.setLineWrap(true);
        this.describe.setWrapStyleWord(true);
        this.describe.setOpaque(false);
        this.describe.setFont((Font)UIManager.getDefaults().get("Table.font"));
        JLabel icon = new JLabel(this.image);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 2;
        gbc.anchor = 17;
        left.add((Component)this.title, gbc);
        gbc.gridy = 1;
        gbc.insets = new Insets(0, 30, 0, 0);
        if (this.enableHeaderDesc) {
            left.add((Component)this.describe, gbc);
        }
        this.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)left, gbc);
        gbc.gridx = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 0;
        gbc.anchor = 13;
        this.add((Component)icon, gbc);
    }
}

