/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.ep;

import com.cisco.dcbu.jaxws.handler.SecurityHandler;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.model.FMUserBase;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.security.RoleType;
import com.cisco.dcbu.sm.server.bean.SessionHelper;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.facade.FMSessionManager;
import com.cisco.dcbu.sm.server.security.DCNMUserImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.UMUtil;
import com.cisco.dcbu.sm.server.security.UserManager;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class IdentityManager {
    static final int TIMER_PERIOD = 3600000;
    public static final String TOKEN_SEPERATOR = ";";
    static final String insertTOKENSQL = "insert into WS_TOKEN(TOKEN, EXPIRE) values(?, ?)";
    static final String queryTOKENSQL = "select EXPIRE from WS_TOKEN where TOKEN=?";
    static final String deleteTOKENSQL = "delete from WS_TOKEN where TOKEN=?";
    static final String deleteExpiredTOKENSQL = "delete from WS_TOKEN where EXPIRE<?";
    private static Logger logger = LogManager.getLogger((String)"fms.ws");
    private static IdentityManager instance;
    private HashMap<String, Long> tokenCache = new HashMap();
    private Timer timer = new Timer();

    public static synchronized IdentityManager getInstance() {
        if (instance == null) {
            instance = new IdentityManager();
        }
        return instance;
    }

    private IdentityManager() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                IdentityManager.this.clean();
            }
        }, 3600000L, 3600000L);
    }

    private synchronized void clean() {
        logger.debug((Object)(IdentityManager.class + "cleaning up " + new Date()));
        Set<String> tokens = this.tokenCache.keySet();
        ArrayList<String> removeList = new ArrayList<String>();
        for (String token : tokens) {
            Long expire = this.tokenCache.get(token);
            if (expire >= System.currentTimeMillis()) continue;
            logger.debug((Object)(token + " expired " + new Date(expire)));
            removeList.add(token);
        }
        for (String rm : removeList) {
            this.tokenCache.remove(rm);
            this.removeTokenFromDB(rm);
        }
        this.removeExpiredTokenFromDB();
    }

    public FMUserBase extractToken(String token) {
        if (token == null || !this.validateToken(token)) {
            logger.warn((Object)("Failed token is: " + token));
            return null;
        }
        String userName = null;
        FMUserBase fmUserBase = null;
        FMUser fmUser = null;
        try {
            userName = StringEncrypter.DESedeDecrypt(token).split(TOKEN_SEPERATOR)[0];
            logger.info((Object)("extractToken userName: " + userName));
            fmUser = UserManager.getInstance().findUser(userName);
            logger.info((Object)("extractToken fmUser: " + fmUser));
            if (fmUser != null) {
                fmUserBase = new FMUserBase(userName, fmUser.getHashedPwd(), fmUser.getRoles());
            }
            if (fmUserBase == null) {
                fmUserBase = DCNMUserImpl.getFMUserBase(userName);
            }
        }
        catch (Exception ex) {
            logger.warn((Object)"Verify WS token: ", (Throwable)ex);
        }
        return fmUserBase;
    }

    public synchronized String createToken(String username, String password, long expiration) {
        String token;
        Long expire = System.currentTimeMillis() + expiration;
        Random rand = new Random();
        String encryptMe = username + TOKEN_SEPERATOR + expire + TOKEN_SEPERATOR + rand.nextInt(1000);
        try {
            token = StringEncrypter.DESedeEncrypt(encryptMe);
        }
        catch (Exception ex) {
            logger.debug((Object)"Unable to encrypt string");
            throw new RuntimeException("Unable to start encryption engine. Please try again later.");
        }
        logger.debug((Object)("Adding token " + token + " expring " + new Date(expire)));
        this.tokenCache.put(token, expire);
        this.addTokenToDB(token, expire);
        return token;
    }

    public synchronized String createToken() {
        String userName = this.getCurrentUsername();
        long expire = 1800000L;
        return this.createToken(userName, null, expire);
    }

    public synchronized String createServerToServerToken(long expiration) {
        String token;
        Long expire = System.currentTimeMillis() + expiration;
        String username = this.generateRandomString();
        String passwd = this.generateRandomString();
        Random rand = new Random();
        String encryptMe = username + TOKEN_SEPERATOR + expire + TOKEN_SEPERATOR + rand.nextInt(1000);
        try {
            token = StringEncrypter.DESedeEncrypt(encryptMe);
        }
        catch (Exception ex) {
            logger.debug((Object)"Unable to encrypt string");
            throw new RuntimeException("Unable to start encryption engine. Please try again later.");
        }
        logger.debug((Object)("Adding token " + token + " expring " + new Date(expire)));
        try {
            UserManager.createUserInDB(username, StringEncrypter.DESedeEncrypt(passwd), RoleType.ROLE_ADMIN.value());
        }
        catch (Exception e) {
            logger.debug((Object)"Unable to encrypt string");
            throw new RuntimeException("Unable to start encryption user information. Please try again later.");
        }
        this.tokenCache.put(token, expire);
        this.addTokenToDB(token, expire);
        return token;
    }

    public boolean validateToken(String token) {
        String tok = (token = token.replaceAll(" ", "+")).trim();
        Long expiration = this.tokenCache.get(tok);
        if (expiration == null) {
            logger.debug((Object)("Token not found in cache. Lookup in the database,token: " + tok));
            expiration = this.getTokenFromDB(tok);
            if (expiration == null) {
                logger.warn((Object)("Token validation failed,token: " + tok + " not valid!"));
                return false;
            }
        }
        if (System.currentTimeMillis() > expiration) {
            logger.warn((Object)("Token validation failed,token: " + tok + " expires!"));
            return false;
        }
        return true;
    }

    private void addTokenToDB(String token, Long expire) {
        Connection con = null;
        PreparedStatement stat = null;
        if (token == null) {
            return;
        }
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(insertTOKENSQL);
            stat.setString(1, token);
            stat.setLong(2, expire);
            stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.warn((Object)("Unable to store session token " + token + " Exception: " + ex.getMessage()));
                throw new RuntimeException("Unable to store session token. Please try again later.");
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    private void removeTokenFromDB(String token) {
        Connection con = null;
        PreparedStatement stat = null;
        if (token == null) {
            return;
        }
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(deleteTOKENSQL);
            stat.setString(1, token);
            stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.warn((Object)("Unable to remove session token " + token + " Exception: " + ex.getMessage()));
                throw new RuntimeException("Unable to remove session token. Please try again later.");
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    public void removeServerToServerToken(String token) {
        String userName = null;
        this.tokenCache.remove(token);
        this.removeTokenFromDB(token);
        try {
            userName = StringEncrypter.DESedeDecrypt(token).split(TOKEN_SEPERATOR)[0];
            UserManager.getInstance().deleteUser(userName, null);
        }
        catch (Exception ex) {
            logger.warn((Object)"Delete token : ", (Throwable)ex);
        }
    }

    private void removeExpiredTokenFromDB() {
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(deleteExpiredTOKENSQL);
            stat.setLong(1, System.currentTimeMillis());
            stat.executeUpdate();
        }
        catch (SQLException ex) {
            try {
                logger.warn((Object)("Unable to remove expired session tokens. Exception: " + ex.getMessage()));
                throw new RuntimeException("Unable to remove exipired session token. Please try again later.");
            }
            catch (Throwable throwable) {
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    private Long getTokenFromDB(String token) {
        Long l;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        Long expire = null;
        if (token == null) {
            return expire;
        }
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(queryTOKENSQL);
            stat.setString(1, token);
            rs = stat.executeQuery();
            while (rs.next()) {
                expire = rs.getLong(1);
            }
            l = expire;
        }
        catch (SQLException ex) {
            try {
                logger.warn((Object)("Unable to get session token " + token + " Exception: " + ex.getMessage()));
                throw new RuntimeException("Unable to get session token. Please try again later.");
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return l;
    }

    private String generateRandomString() {
        SecureRandom rand = new SecureRandom();
        String letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ0123456789";
        String str = "";
        for (int i = 0; i < 8; ++i) {
            int index = (int)(rand.nextDouble() * (double)letters.length());
            str = str + letters.substring(index, index + 1);
        }
        return str;
    }

    public String getCurrentUsername() {
        try {
            String token = SecurityHandler.getToken();
            if (token != null) {
                FMUserBase user = this.extractToken(token);
                if (user != null) {
                    return user.getUsername();
                }
                logger.warn((Object)"Unable to get logged in web client user name");
                return "";
            }
            SessionRif session = SessionHelper.getInstance().getSession();
            return session.getUser().getUserName();
        }
        catch (Exception ex) {
            logger.warn((Object)"Unable to get logged in user name");
            return "";
        }
    }

    public String getClientIp() {
        String cIp = null;
        String sessionId = SecurityHandler.getSessioId();
        try {
            if (sessionId != null) {
                int sid = Integer.parseInt(sessionId);
                SessionRif session = FMSessionManager.getInstance().findSession(sid);
                if (session != null) {
                    cIp = session.getClient();
                }
            }
        }
        catch (Exception ex) {
            logger.info((Object)("getClientIp--> sessionId:  " + sessionId));
            logger.warn((Object)("Failed to get client ip:" + cIp));
            return null;
        }
        return cIp;
    }

    public InetAddress getClientAddress() {
        String ip = this.getClientIp();
        try {
            if (ip == null) {
                SessionRif session = SessionHelper.getInstance().getSession();
                ip = session.getClient();
                logger.info((Object)("IdentityManager.getClientAddress() ip: " + ip));
                return UMUtil.getInetAddress(ip);
            }
            return InetAddress.getByName(ip);
        }
        catch (Exception ex) {
            logger.warn((Object)("Failed not get client Gui or Web client ip. " + ex.getMessage()));
            return null;
        }
    }
}

