/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.ep;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.ep.InvalidCredentialException;
import com.cisco.dcbu.jaxws.ep.SanNotFoundException;
import com.cisco.dcbu.jaxws.ep.WSFaultException;
import com.cisco.dcbu.jaxws.wo.CredentialDO;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.model.FMUserBase;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.security.SecurityManager;
import com.cisco.dcbu.sm.server.security.UserManager;
import java.net.URLEncoder;
import java.util.List;
import javax.ejb.Stateless;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.WebContext;

@WebService(name="Logon", serviceName="LogonService", endpointInterface="com.cisco.dcbu.jaxws.ep.LogonSEI")
@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@WebContext(contextRoot="/LogonWSService", urlPattern="/LogonWS")
@Stateless
public class LogonWS {
    static Logger logger = LogManager.getLogger((String)"fms.ws");

    @WebMethod
    public String requestToken(String username, String password, long expiration) throws InvalidCredentialException, WSFaultException, SanNotFoundException {
        try {
            logger.info((Object)("Request a new token with expiration time: " + expiration));
            if (username == null || password == null) {
                throw new InvalidCredentialException("Username and/or password cannot be null.");
            }
            username = username.trim();
            password = password.trim();
            try {
                password = StringEncrypter.DESedeEncrypt(password);
            }
            catch (Exception ex) {
                logger.error((Object)"Cannot get password", (Throwable)ex);
            }
            FMUser fmuser = SecurityManager.getInstance().authenticateUser(username, password);
            if (fmuser == null) {
                throw new InvalidCredentialException("Invalid username:" + fmuser);
            }
            String token = IdentityManager.getInstance().createToken(username, password, expiration);
            logger.debug((Object)("Token request successful: " + token));
            if (token == null) {
                throw new SanNotFoundException("Cannot find token for the user:" + fmuser);
            }
            return token;
        }
        catch (InvalidCredentialException e) {
            logger.warn((Object)"LogonWS caught WS exception", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in requestToken():", (Throwable)e);
            throw e;
        }
        catch (Throwable e1) {
            logger.warn((Object)"LogonWS caught runtime exception", e1);
            throw new WSFaultException("LogonWS caught runtime exception", e1);
        }
    }

    @WebMethod
    public String requestLogonRole(String username, String password) throws InvalidCredentialException, WSFaultException, SanNotFoundException {
        try {
            if (username == null || password == null) {
                throw new InvalidCredentialException("Username and/or password cannot be null.");
            }
            username = username.trim();
            password = password.trim();
            try {
                password = StringEncrypter.DESedeEncrypt(password);
            }
            catch (Exception ex) {
                logger.error((Object)"Cannot get password", (Throwable)ex);
            }
            FMUser fmuser = SecurityManager.getInstance().authenticateUser(username, password);
            if (fmuser == null) {
                throw new InvalidCredentialException("Invalid username:" + fmuser);
            }
            List<String> roleList = fmuser.getRoles();
            if (roleList.size() == 0 || roleList == null) {
                throw new SanNotFoundException("Cannot get logon role for  user:" + fmuser);
            }
            return roleList.toString();
        }
        catch (InvalidCredentialException e) {
            logger.warn((Object)"LogonWS caught WS exception", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in requestLogonRole():", (Throwable)e);
            throw e;
        }
        catch (Throwable e1) {
            logger.warn((Object)"LogonWS caught runtime exception", e1);
            throw new WSFaultException("LogonWS caught runtime exception", e1);
        }
    }

    @WebMethod
    public String requestLogonToken(String username, String password) throws InvalidCredentialException, WSFaultException, SanNotFoundException {
        try {
            if (username == null || password == null) {
                throw new InvalidCredentialException("Username and/or password cannot be null.");
            }
            username = username.trim();
            password = password.trim();
            try {
                password = StringEncrypter.DESedeEncrypt(password);
            }
            catch (Exception ex) {
                logger.error((Object)"Cannot get password", (Throwable)ex);
            }
            FMUser fmuser = SecurityManager.getInstance().authenticateUser(username, password);
            if (fmuser == null) {
                throw new InvalidCredentialException("Invalid username:" + fmuser);
            }
            UserManager.getInstance().addUser(fmuser);
            String auth_mode = System.getProperty("authentication.mode");
            username = auth_mode.equalsIgnoreCase("local") ? username : username + "@" + auth_mode;
            String token = URLEncoder.encode(SecurityManager.getSSOToken(username), "UTF-8");
            if (token == null) {
                throw new SanNotFoundException("Cannot find token for the user:" + fmuser);
            }
            return token;
        }
        catch (InvalidCredentialException e) {
            logger.warn((Object)"LogonWS caught WS exception", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in requestLogonToken():", (Throwable)e);
            throw e;
        }
        catch (Throwable e1) {
            logger.warn((Object)"LogonWS caught runtime exception", e1);
            throw new WSFaultException("LogonWS caught runtime exception", e1);
        }
    }

    @WebMethod
    public CredentialDO getCredentialByToken(String wsToken) throws InvalidCredentialException, WSFaultException {
        try {
            if (wsToken == null) {
                throw new InvalidCredentialException("Username and/or password cannot be null.");
            }
            FMUserBase fmuser = IdentityManager.getInstance().extractToken(wsToken);
            if (fmuser == null) {
                throw new InvalidCredentialException("Invalid web service token.");
            }
            String userName = fmuser.getUsername();
            String password = StringEncrypter.DESedeDecrypt(fmuser.getEncryptedPassword());
            String authMode = SecurityManager.getInstance().getAuthMode();
            boolean isAAA = !authMode.equalsIgnoreCase("local");
            return new CredentialDO(userName, password, isAAA);
        }
        catch (InvalidCredentialException e) {
            logger.warn((Object)"LogonWS caught WS exception", (Throwable)e);
            throw e;
        }
        catch (Throwable e1) {
            logger.warn((Object)"LogonWS caught runtime exception", e1);
            throw new WSFaultException("LogonWS caught runtime exception", e1);
        }
    }

    @WebMethod
    public boolean validateToken(String token) {
        return IdentityManager.getInstance().validateToken(token);
    }

    @WebMethod
    public String getDcnmVersion() throws WSFaultException {
        try {
            return "6.3(1)";
        }
        catch (Throwable e) {
            logger.warn((Object)"LogonWS caught exception in getDcnmVersion():", e);
            throw new WSFaultException("Cannot get DCNM version info.", e);
        }
    }
}

