/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.ep;

import com.cisco.dcbu.jaxws.ep.FaultInfo;
import com.cisco.dcbu.lib.snmp.SnmpException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.ws.WebFault;

@XmlAccessorType(value=XmlAccessType.FIELD)
@WebFault(name="SnmpException", faultBean="com.cisco.dcbu.jaxws.wo.fault.SnmpExceptionBean")
public class WSSnmpException
extends Exception
implements FaultInfo {
    public static final int ErrCode = 400;
    public static final String ErrMsg = "SNMP query has error/failed";
    private boolean timeout;
    private boolean unmanageable;
    protected int code = 400;
    protected String detail;
    protected String reason;

    public WSSnmpException() {
        super(ErrMsg);
    }

    public WSSnmpException(SnmpException snmpE) {
        this(snmpE.getMessage());
        this.timeout = snmpE.isTimeOut();
        this.unmanageable = snmpE.isUnmanageableError();
    }

    public WSSnmpException(String detail) {
        super(ErrMsg);
        this.detail = detail;
    }

    public WSSnmpException(String detail, Throwable cause) {
        super(ErrMsg, cause);
        this.detail = detail;
        if (cause != null) {
            this.reason = cause.getClass().getName() + ":" + cause.getMessage();
        }
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public void setCode(int code) {
        this.code = code;
    }

    @Override
    public String getDetail() {
        return this.detail;
    }

    @Override
    public void setDetail(String detail) {
        this.detail = detail;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public void setTimeout(boolean isTimeOut) {
        this.timeout = isTimeOut;
    }

    public boolean isUnmanageable() {
        return this.unmanageable;
    }

    public void setUnmanageable(boolean isUnmanageable) {
        this.unmanageable = isUnmanageable;
    }
}

