/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.handler;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.handler.SSOHandler;
import com.cisco.dcbu.jaxws.san.helper.cluster.ServerResolver;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.log4j.Logger;
import org.jboss.ws.api.handler.GenericSOAPHandler;
import org.jboss.ws.core.binding.BindingException;

public class RequestHandler
extends GenericSOAPHandler {
    private static final Logger logger = Logger.getLogger(RequestHandler.class);
    private static ThreadLocal<SOAPMessage> soapMsg = new ThreadLocal();
    @Resource
    protected WebServiceContext context;

    public boolean handleInbound(MessageContext msgContext) {
        if (!this.isClustering()) {
            return true;
        }
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        RequestHandler.setSoapMsg(soapMessage);
        URI uri = (URI)msgContext.get((Object)"javax.xml.ws.wsdl.description");
        QName wsdlservice = (QName)msgContext.get((Object)"javax.xml.ws.wsdl.service");
        QName wsdlport = (QName)msgContext.get((Object)"javax.xml.ws.wsdl.port");
        QName wsdloper = (QName)msgContext.get((Object)"javax.xml.ws.wsdl.operation");
        try {
            boolean continueNext;
            Vector<String> server = null;
            server = ServerResolver.getServer(wsdlservice, wsdloper);
            boolean bl = continueNext = server == null || server.size() < 1;
            if (continueNext) {
                return true;
            }
            int serverId = FMServerImpl.getInstance().getCurrentServerId();
            InetAddress self = ClusterMapping.getInstance().qIPFromSId(serverId);
            String svr = server.get(0);
            if (self.getHostAddress().equals(svr)) {
                return true;
            }
            HttpServletRequest req = (HttpServletRequest)msgContext.get((Object)"javax.xml.ws.servlet.request");
            String protocol = req.getScheme();
            int port = req.getServerPort();
            URL wsdlURL = new URL(protocol + "://" + svr + ":" + port + uri.getPath() + "?wsdl");
            SOAPMessage newReq = this.wrapMessage(soapMessage);
            this.dispatch(msgContext, "http://schemas.xmlsoap.org/wsdl/soap/http", wsdlservice, wsdlport, wsdlURL, newReq);
        }
        catch (BindingException e) {
            e.printStackTrace();
            throw new WebServiceException("Unable to dispatch request: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WebServiceException("Unable to dispatch request: " + e.getMessage());
        }
        return false;
    }

    public static SOAPMessage getSoapMsg() {
        return soapMsg.get();
    }

    public static void setSoapMsg(SOAPMessage soapMessage) {
        soapMsg.set(soapMessage);
    }

    private SOAPMessage wrapMessage(SOAPMessage soapMessage) throws Exception {
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage newReq = factory.createMessage();
        newReq.getSOAPPart().setContent(soapMessage.getSOAPPart().getContent());
        SSOHandler sh = new SSOHandler();
        String wsToken = IdentityManager.getInstance().createToken();
        SOAPElement wsTokenElement = sh.createWsTokenElement(wsToken);
        if (newReq.getSOAPHeader() == null) {
            newReq.getSOAPPart().getEnvelope().addHeader();
        }
        newReq.getSOAPHeader().addChildElement(wsTokenElement);
        return newReq;
    }

    private void dispatch(MessageContext msgContext, String bindingId, QName serviceName, QName portName, URL wsdlURL, SOAPMessage newReq) throws SOAPException, IOException {
        Service service = Service.create((QName)serviceName);
        service.addPort(portName, bindingId, wsdlURL.toExternalForm());
        Dispatch dispatch = service.createDispatch(portName, SOAPMessage.class, Service.Mode.MESSAGE);
        SOAPMessage res = (SOAPMessage)dispatch.invoke((Object)newReq);
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage newRes = factory.createMessage();
        newRes.getSOAPPart().setContent(res.getSOAPPart().getContent());
        SOAPMessageContext msg = (SOAPMessageContext)msgContext;
        msg.setMessage(newRes);
    }

    public boolean isClustering() {
        try {
            List<String> ips = ClusterMapping.getInstance().qALlIPStrings();
            if (ips != null && ips.size() > 1) {
                return true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error checking federation mode: " + ex.getMessage()));
        }
        return false;
    }
}

