/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.handler;

import com.cisco.dcbu.sm.server.security.SecurityManager;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.ws.api.handler.GenericSOAPHandler;

public class SSOHandler
extends GenericSOAPHandler {
    protected boolean handleInbound(MessageContext msgContext) {
        return true;
    }

    protected boolean handleOutbound(MessageContext msgContext) {
        SOAPMessage soapMsg = ((SOAPMessageContext)msgContext).getMessage();
        try {
            SOAPEnvelope envelope = soapMsg.getSOAPPart().getEnvelope();
            SOAPHeader header = envelope.getHeader();
            if (header == null) {
                envelope.addHeader();
            }
            String sso = this.requestSso();
            SOAPElement el = this.createSSOElement(sso);
            header.addChildElement(el);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected SOAPElement createSSOElement(String sso) {
        SOAPElement ssoElement = null;
        try {
            if (sso == null) {
                return null;
            }
            SOAPFactory factory = SOAPFactory.newInstance();
            Name TOKEN_NAME = factory.createName("ssoToken", "m", "http://ep.jaxws.dcbu.cisco.com");
            ssoElement = factory.createElement(TOKEN_NAME);
            ssoElement.addTextNode(sso);
            return ssoElement;
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (WebServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected SOAPElement createWsTokenElement(String wsToken) {
        SOAPElement wsElement = null;
        try {
            if (wsToken == null) {
                return null;
            }
            SOAPFactory factory = SOAPFactory.newInstance();
            Name TOKEN_NAME = factory.createName("Token", "m", "http://ep.jaxws.dcbu.cisco.com");
            wsElement = factory.createElement(TOKEN_NAME);
            wsElement.addTextNode(wsToken);
            return wsElement;
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        catch (WebServiceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String requestSso() throws Exception {
        SecurityManager sm = SecurityManager.getInstance();
        return SecurityManager.getSSOToken("fmws");
    }
}

