/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.lan.ep.util;

import com.cisco.dcbu.install.PortConfigurator;
import com.cisco.dcbu.jaxws.lan.ep.util.LanReferenceIf;
import com.cisco.dcbu.jaxws.lan.ep.util.WSReference;
import com.cisco.dcbu.lib.util.ClientCache;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import org.xml.sax.SAXException;

public class LanReferenceFactory {
    private static LanReferenceIf _Instance = null;
    private static String _server;
    private static int _httpPort;
    private static boolean _useSSL;

    public static LanReferenceIf getInstance() throws SAXException, IOException {
        if (_Instance == null) {
            _server = System.getProperty("lan.server.bindaddrs");
            PortConfigurator conf = new PortConfigurator(ClientCache.getDcmDir(), "dcnm");
            conf.getWebPortsFromTomcat();
            _httpPort = conf.getWebPort();
            _useSSL = conf.isHTTPS();
            _Instance = WSReference.getInstance(_server, _httpPort, _useSSL);
        }
        return _Instance;
    }

    public static int getLanHttpPort() {
        String lanConfigurationFile = ClientCache.getDcmDir() + "\\jboss-as-7.2.0.Final\\standalone\\configuration\\dcnmlan-standalone.xml";
        int port = 8080;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(lanConfigurationFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("<socket-binding name=\"http\"") == -1) continue;
                String portStr = line.substring(line.lastIndexOf("=") + 2, line.lastIndexOf("\""));
                port = Integer.parseInt(portStr);
                break;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return port;
    }

    public static boolean isHttps() {
        return false;
    }

    public static LanReferenceIf getInstance(String server, int httpPort, boolean useSSL) throws RemoteException {
        if (_Instance == null || _server != null && (!_server.equals(server) || _httpPort != httpPort || _useSSL != useSSL)) {
            _Instance = WSReference.getInstance(server, httpPort, useSSL);
            _server = server;
            _httpPort = httpPort;
            _useSSL = useSSL;
        }
        return _Instance;
    }

    public static LanReferenceIf getNewInstance(String server, int serverPort, int httpPort, boolean useSSL) throws RemoteException {
        _Instance = WSReference.getInstance(server, httpPort, useSSL);
        return _Instance;
    }
}

