/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.lan.ep.util;

import com.cisco.dcbu.jaxws.lan.ep.util.LanReferenceIf;
import com.cisco.dcbu.lan.webservice.client.generated.datacentergrp.LANDataCenterGrpWS;
import com.cisco.dcbu.lan.webservice.client.generated.datacentergrp.LANDataCenterGrpWSBindingStub;
import com.cisco.dcbu.lan.webservice.client.generated.datacentergrp.LANDataCenterGrpWebServiceLocator;
import com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.DeepDiscoveryWSLocator;
import com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.DeepDiscvWS;
import com.cisco.dcbu.lan.webservice.client.generated.deepdiscv.DeepDiscvWSBindingStub;
import com.cisco.dcbu.lan.webservice.client.generated.license.LicenseWS;
import com.cisco.dcbu.lan.webservice.client.generated.license.LicenseWSBindingStub;
import com.cisco.dcbu.lan.webservice.client.generated.license.LicenseWebServiceLocator;
import com.cisco.dcbu.lan.webservice.client.generated.user.UserWS;
import com.cisco.dcbu.lan.webservice.client.generated.user.UserWSBindingStub;
import com.cisco.dcbu.lan.webservice.client.generated.user.UserWebServiceLocator;
import com.cisco.dcbu.lan.webservice.client.generated.vpc.VpcWS;
import com.cisco.dcbu.lan.webservice.client.generated.vpc.VpcWSBindingStub;
import com.cisco.dcbu.lan.webservice.client.generated.vpc.VpcWebServiceLocator;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.server.web.cfgtemplates.util.ConfigTemplateLanWS;
import com.cisco.dcbu.sm.server.web.cfgtemplates.util.ConfigTemplateLanWSBindingStub;
import com.cisco.dcbu.sm.server.web.cfgtemplates.util.ConfigTemplateLanWSServiceLocator;
import java.rmi.RemoteException;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;

class WSReference
implements LanReferenceIf {
    private static WSReference _Instance = null;
    String _server;
    int _httpPort;
    boolean _useSSL;
    static Logger _logger = Logger.getLogger((String)"com.wbemsolutions.wbem.jserver");

    static WSReference getInstance(String server, int httpPort, boolean useSSL) throws RemoteException {
        if (_Instance == null || !WSReference._Instance._server.equals(server) || WSReference._Instance._httpPort != httpPort || WSReference._Instance._useSSL != useSSL) {
            _Instance = new WSReference(server, httpPort, useSSL);
        }
        return _Instance;
    }

    static WSReference getNewInstance(String server, int httpPort, boolean useSSL) throws RemoteException {
        _Instance = new WSReference(server, httpPort, useSSL);
        return _Instance;
    }

    private WSReference(String server, int httpPort, boolean useSSL) throws RemoteException {
        this._server = server;
        this._httpPort = httpPort;
        this._useSSL = useSSL;
    }

    private String getURL() {
        String ret = this._useSSL ? "https" : "http";
        ret = ret + "://" + this._server + ":" + this._httpPort + "/dcnm-ws-server";
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("ws URL:" + ret));
        }
        return ret;
    }

    private SOAPHeaderElement setSoapHeader(String token) {
        SOAPHeaderElement hdrElement = new SOAPHeaderElement("http://ep.cisco.dcbu.cisco.com", "token");
        hdrElement.setPrefix("m");
        hdrElement.setMustUnderstand(false);
        hdrElement.setValue(token);
        return hdrElement;
    }

    @Override
    public VpcWS getVpcWS(String token) throws Exception {
        String lanServiceAddr = this.getURL() + "/VpcWebService?wsdl";
        System.out.println(lanServiceAddr);
        try {
            VpcWebServiceLocator vpcWebServiceLocator = new VpcWebServiceLocator();
            vpcWebServiceLocator.setVpcWSPortEndpointAddress(lanServiceAddr);
            VpcWS vpcWS = vpcWebServiceLocator.getVpcWSPort();
            if (null == vpcWS) {
                _logger.warn((Object)"San service not available");
                throw new Exception("vPC LAN service not available");
            }
            SOAPHeaderElement hdrElement = this.setSoapHeader(token);
            VpcWSBindingStub sService = (VpcWSBindingStub)vpcWS;
            sService.setHeader(hdrElement);
            sService.setHeader(this.getUserIdHeaderElement(token));
            return vpcWS;
        }
        catch (Exception e) {
            _logger.info((Object)("lanServiceAddr: " + lanServiceAddr));
            _logger.warn((Object)("Unable to get LAN VPC webservices, token: " + token + " "), (Throwable)e);
            throw new Exception("Unable to get LAN VPC webservices, token: " + token + " " + e.getMessage());
        }
    }

    @Override
    public DeepDiscvWS getDeepDiscvWS(String token) throws Exception {
        if (_logger.isTraceEnabled()) {
            _logger.info((Object)("Inside getDeepDiscvWS(), token is :" + token));
        }
        String lanServiceAddr = this.getURL() + "/" + "DeepDiscvWS?wsdl";
        if (_logger.isTraceEnabled()) {
            _logger.info((Object)("lanServiceAddr: " + lanServiceAddr));
        }
        try {
            DeepDiscoveryWSLocator deepDiscvWebServiceLocator = new DeepDiscoveryWSLocator();
            deepDiscvWebServiceLocator.setDeepDiscvWSPortEndpointAddress(lanServiceAddr);
            DeepDiscvWS deepDiscvWS = deepDiscvWebServiceLocator.getDeepDiscvWSPort();
            if (deepDiscvWS == null) {
                _logger.warn((Object)"DeepDiscovery service not available");
                throw new Exception("DeepDiscovery service not available");
            }
            SOAPHeaderElement hdrElement = this.setSoapHeader(token);
            DeepDiscvWSBindingStub sService = (DeepDiscvWSBindingStub)deepDiscvWS;
            sService.setHeader(hdrElement);
            sService.setHeader(this.getUserIdHeaderElement(token));
            return deepDiscvWS;
        }
        catch (Exception e) {
            _logger.info((Object)("lanServiceAddr: " + lanServiceAddr));
            _logger.warn((Object)("Unable to get LAN discovery webservices, token: " + token + " "), (Throwable)e);
            throw new Exception("Unable to get LAN discovery webservices, token: " + token + " " + e.getMessage());
        }
    }

    @Override
    public LicenseWS getLicenseWS(String token) throws Exception {
        String lanServiceAddr = this.getURL() + "/" + "LicenseWSService?wsdl";
        System.out.println(lanServiceAddr);
        try {
            LicenseWebServiceLocator licenseWebServiceLocator = new LicenseWebServiceLocator();
            licenseWebServiceLocator.setLicenseWSPortEndpointAddress(lanServiceAddr);
            LicenseWS licenseWS = licenseWebServiceLocator.getLicenseWSPort();
            if (licenseWS == null) {
                _logger.warn((Object)"License service not available");
                throw new Exception("License service not available");
            }
            SOAPHeaderElement hdrElement = this.setSoapHeader(token);
            LicenseWSBindingStub sService = (LicenseWSBindingStub)licenseWS;
            sService.setHeader(hdrElement);
            sService.setHeader(this.getUserIdHeaderElement(token));
            return licenseWS;
        }
        catch (Exception e) {
            _logger.info((Object)("lanServiceAddr: " + lanServiceAddr));
            _logger.warn((Object)("Unable to get LAN License webservices, token: " + token + " "), (Throwable)e);
            throw new Exception("Unable to get LAN License webservices, token: " + token + " " + e.getMessage());
        }
    }

    @Override
    public ConfigTemplateLanWS getConfigTemplateLanWS(String token) throws Exception {
        String templateServiceAddr = this.getURL() + "/" + "ConfigTemplateLanWS?wsdl";
        ConfigTemplateLanWSServiceLocator templateLanServiceLocator = new ConfigTemplateLanWSServiceLocator();
        templateLanServiceLocator.setConfigTemplateLanWSPortEndpointAddress(templateServiceAddr);
        ConfigTemplateLanWS templateLanWS = templateLanServiceLocator.getConfigTemplateLanWSPort();
        if (templateLanWS == null) {
            _logger.info((Object)"LAN custom template  service not available");
            throw new Exception("LAN custom template  service not available");
        }
        SOAPHeaderElement hdrElement = this.setSoapHeader(token);
        ConfigTemplateLanWSBindingStub sService = (ConfigTemplateLanWSBindingStub)templateLanWS;
        sService.setHeader(hdrElement);
        sService.setHeader(this.getUserIdHeaderElement(token));
        return sService;
    }

    @Override
    public UserWS getUserWS(String token) throws Exception {
        String lanServiceAddr = this.getURL() + "/" + "UserWSService?wsdl";
        System.out.println(lanServiceAddr);
        try {
            UserWebServiceLocator userWebServiceLocator = new UserWebServiceLocator();
            userWebServiceLocator.setUserWSPortEndpointAddress(lanServiceAddr);
            UserWS userWS = userWebServiceLocator.getUserWSPort();
            if (userWS == null) {
                _logger.info((Object)"User service not available");
                throw new Exception("User service not available");
            }
            SOAPHeaderElement hdrElement = this.setSoapHeader(token);
            UserWSBindingStub sService = (UserWSBindingStub)userWS;
            sService.setHeader(hdrElement);
            sService.setHeader(this.getUserIdHeaderElement(token));
            return userWS;
        }
        catch (Exception e) {
            _logger.info((Object)("lanServiceAddr: " + lanServiceAddr));
            _logger.warn((Object)("Unable to get LAN User webservices, token: " + token + " "), (Throwable)e);
            throw new Exception("Unable to get LAN User webservices, token: " + token + " " + e.getMessage());
        }
    }

    @Override
    public LANDataCenterGrpWS getDataCenterGrpWS(String token) throws Exception {
        _logger.info((Object)("Inside getDataCenterGrpWS(), token is :" + token));
        String lanServiceAddr = this.getURL() + "/" + "LANDataCenterGrpWebService?wsdl";
        _logger.info((Object)("lanServiceAddr: " + lanServiceAddr));
        try {
            LANDataCenterGrpWebServiceLocator dataCenterWebServiceLocator = new LANDataCenterGrpWebServiceLocator();
            dataCenterWebServiceLocator.setLANDataCenterGrpWSPortEndpointAddress(lanServiceAddr);
            LANDataCenterGrpWS dataCenterGrpWS = dataCenterWebServiceLocator.getLANDataCenterGrpWSPort();
            if (dataCenterGrpWS == null) {
                _logger.warn((Object)"DataCenterGrp service not available");
                throw new Exception("DataCenterGrp service not available");
            }
            SOAPHeaderElement hdrElement = this.setSoapHeader(token);
            LANDataCenterGrpWSBindingStub sService = (LANDataCenterGrpWSBindingStub)dataCenterGrpWS;
            sService.setHeader(hdrElement);
            sService.setHeader(this.getUserIdHeaderElement(token));
            return dataCenterGrpWS;
        }
        catch (Exception e) {
            _logger.warn((Object)("Unable to get LAN DataCenterGrp webservices, token: " + token + " "), (Throwable)e);
            throw new Exception("Unable to get LAN DataCenterGrp webservices, token: " + token + " " + e.getMessage());
        }
    }

    private SOAPHeaderElement getUserIdHeaderElement(String token) throws Exception {
        SOAPHeaderElement hdrElement = new SOAPHeaderElement("http://ep.cisco.dcbu.cisco.com", "userId");
        hdrElement.setPrefix("m");
        hdrElement.setMustUnderstand(false);
        String userName = StringEncrypter.DESedeDecrypt(token).split(";")[0];
        _logger.info((Object)("getUserIdHeaderElement -> userName: " + userName));
        if (userName != null) {
            hdrElement.setValue(userName);
        }
        return hdrElement;
    }
}

