/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.ep.InvalidArgumentException;
import com.cisco.dcbu.jaxws.ep.SanNotFoundException;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.san.ep.DashBoardSEI;
import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.jaxws.san.wo.DashBoardStateDO;
import com.cisco.dcbu.jaxws.san.wo.DashboardFabricDO;
import com.cisco.dcbu.jaxws.san.wo.DashboardSettingsDO;
import com.cisco.dcbu.jaxws.san.wo.DashboardTopologyDO;
import com.cisco.dcbu.jaxws.san.wo.DashboardTopologyVlanListDO;
import com.cisco.dcbu.jaxws.san.wo.DashboardTopologyVsanListDO;
import com.cisco.dcbu.jaxws.san.wo.FederationDO;
import com.cisco.dcbu.jaxws.san.wo.HealthSummaryDO;
import com.cisco.dcbu.jaxws.san.wo.InventorySummaryDO;
import com.cisco.dcbu.jaxws.san.wo.OperationStatusDO;
import com.cisco.dcbu.jaxws.san.wo.PerformanceSummaryDO;
import com.cisco.dcbu.jaxws.san.wo.ReportDO;
import com.cisco.dcbu.jaxws.san.wo.SMISNavItemDO;
import com.cisco.dcbu.jaxws.san.wo.StatDO;
import com.cisco.dcbu.jaxws.san.wo.StatisticsDataDO;
import com.cisco.dcbu.jaxws.san.wo.StorageSummaryDO;
import com.cisco.dcbu.jaxws.san.wo.StorageSystemSummaryDO;
import com.cisco.dcbu.jaxws.san.wo.TopXSummaryDO;
import com.cisco.dcbu.jaxws.wo.CapacityDO;
import com.cisco.dcbu.jaxws.wo.CredentialDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.jaxws.wo.TotalRxTxComparator;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.model.GlobalViManager;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.dashboard.CapacityMgrHandler;
import com.cisco.dcbu.sm.server.web.dashboard.DashboardHandler;
import com.cisco.dcbu.sm.server.web.dashboard.FederationHandler;
import com.cisco.dcbu.sm.server.web.dashboard.HealthSummaryHandler;
import com.cisco.dcbu.sm.server.web.dashboard.InventorySummaryHandler;
import com.cisco.dcbu.sm.server.web.dashboard.PerformanceSummaryHandler;
import com.cisco.dcbu.sm.server.web.dashboard.TopHandler;
import com.cisco.dcbu.sm.server.web.dashboard.TopologyHandler;
import com.cisco.dcbu.sm.server.web.inventory.EndDeviceStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.GigEStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.HostEnclHandler;
import com.cisco.dcbu.sm.server.web.inventory.IslStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.OidStatHandler;
import com.cisco.dcbu.sm.server.web.report.ReportHandler;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.storage.db.SMISHandler;
import com.cisco.dcbu.vi.model.VirtualCenterBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.EndpointConfig;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/DashBoardWSService", urlPattern="/DashBoardWS")
@EndpointConfig(configName="Standard WSSecurity Endpoint")
@WebService(name="DashBoard", serviceName="DashBoardService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.DashBoardSEI")
@Stateless
public class DashBoardWS
implements DashBoardSEI {
    static Logger logger = LogManager.getLogger((String)"fms.ws");

    @Override
    @WebMethod(operationName="getDashboardLayout")
    @WebResult(name="result", partName="result")
    public DashBoardStateDO getDashboardLayout(String user, String view) {
        logger.debug((Object)"DashboardWS.getDashboardLayout");
        DashBoardStateDO db = DashboardHandler.getInstance().getDashboard(user, view);
        try {
            DashBoardStateDO save = new DashBoardStateDO();
            save.setUser(user);
            save.setView("LastView");
            save.setData(view);
            DashboardHandler.getInstance().setDashboard(user, save);
        }
        catch (Exception e) {
            // empty catch block
        }
        return db;
    }

    @Override
    @WebMethod(operationName="getDashboardFabrics")
    @WebResult(name="result", partName="result")
    public DashboardFabricDO[] getDashboardFabrics() {
        logger.debug((Object)"DashboardWS.getDashboardFabrics");
        ArrayList<DashboardFabricDO> ret = new ArrayList<DashboardFabricDO>();
        List<FabricPK> fabricPKs = GlobalFabricManager.getInstance().getAllDisplayFabricPKs();
        if (fabricPKs != null) {
            for (FabricPK fpk : fabricPKs) {
                DashboardFabricDO df = new DashboardFabricDO();
                df.setFid(fpk.get_fid());
                df.setName(fpk.getName());
                df.setDbid(fpk.id);
                ret.add(df);
            }
        }
        DashboardFabricDO[] retList = new DashboardFabricDO[ret.size()];
        retList = ret.toArray(retList);
        return retList;
    }

    @Override
    @WebMethod(operationName="setDashboardLayout")
    @WebResult(name="result", partName="result")
    public OperationStatusDO setDashboardLayout(DashBoardStateDO dashboard) {
        logger.debug((Object)"DashboardWS.setDashboardLayout");
        OperationStatusDO status = DashboardHandler.getInstance().setDashboard(dashboard.getUser(), dashboard);
        return status;
    }

    @Override
    @WebMethod(operationName="getHealthSummary")
    @WebResult(name="result", partName="result")
    public HealthSummaryDO getHealthSummary(DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getHealthSummary");
        HealthSummaryDO hsdo = HealthSummaryHandler.getInstance().getHealthSummary(dbFilter);
        return hsdo;
    }

    @Override
    @WebMethod(operationName="getInventorySummary")
    @WebResult(name="result", partName="result")
    public InventorySummaryDO getInventorySummary(DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getInventorySummary");
        InventorySummaryDO isdo = InventorySummaryHandler.getInstance().getInventorySummary(dbFilter);
        return isdo;
    }

    @Override
    @WebMethod(operationName="getPerformanceSummary")
    @WebResult(name="result", partName="result")
    public PerformanceSummaryDO getPerformanceSummary(CredentialDO cred, DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getPerformanceSummary");
        return PerformanceSummaryHandler.getInstance().getPerformanceSummary(cred, dbFilter);
    }

    @Override
    @WebMethod(operationName="getCapacity")
    @WebResult(name="result", partName="result")
    public CapacityDO getCapacity(DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getCapacity");
        return CapacityMgrHandler.getInstance().getCapacity(dbFilter);
    }

    @Override
    @WebMethod(operationName="getGroupNavigation")
    @WebResult(name="result", partName="result")
    public String getGroupNavigation() throws SanServiceException {
        try {
            return NavigationUtil.getInstance().getGroupsNav();
        }
        catch (Throwable e) {
            logger.warn((Object)"DashBoardWS caught exception in getGroupNavigation():", e);
            throw new SanServiceException("Cannot get group navigation info", e);
        }
    }

    @Override
    @WebMethod(operationName="getRptViewDataList")
    @WebResult(name="result", partName="result")
    public ReportDO[] getReportsLast24hrs(CredentialDO cred) {
        logger.debug((Object)"DashboardWS.getRptViewDataList");
        try {
            ArrayList<ReportDO> rptViewDataList = ReportHandler.getInstance().getRptViewDataList(cred);
            ArrayList<ReportDO> filteredList = new ArrayList<ReportDO>();
            for (int i = 0; i < rptViewDataList.size(); ++i) {
                Date now;
                Date dayAgo;
                ReportDO rpt = rptViewDataList.get(i);
                Date lastMod = SnmpTimeticks.getDateFormat().parse(rpt.getLastModified());
                if (!lastMod.after(dayAgo = new Date((now = new Date()).getTime() - 86400000L))) continue;
                filteredList.add(rpt);
            }
            ReportDO[] retEP = new ReportDO[filteredList.size()];
            for (int i = 0; i < filteredList.size(); ++i) {
                retEP[i] = (ReportDO)filteredList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"DashboardWS caught exception in getRptViewDataList():", e);
            return new ReportDO[0];
        }
    }

    @Override
    @WebMethod(operationName="getTopHosts")
    @WebResult(name="result", partName="result")
    public TopXSummaryDO getTopHosts(DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getTopHosts");
        if (dbFilter.getFabricDbId() < 0L) {
            dbFilter.setFabricDbId(-1L);
        }
        ArrayList<StatisticsDataDO> statList = EndDeviceStatHandler.getInstance().getEndDeviceStatList(dbFilter, "Host Ports", "24 Hours", 0, dbFilter.getLimit(), true);
        for (StatisticsDataDO stat : statList) {
            if (stat.getRxTxStr().length() == 0) {
                stat.setRxTxStr("0B");
                continue;
            }
            stat.setRxTxStr(stat.getRxTxStr());
        }
        StatisticsDataDO[] retList = new StatisticsDataDO[statList.size()];
        retList = statList.toArray(retList);
        TopXSummaryDO ret = new TopXSummaryDO();
        ret.setDataSource(dbFilter.getGroupFilterXml());
        ret.setDataProvider(retList);
        return ret;
    }

    @Override
    @WebMethod(operationName="getTopTargets")
    @WebResult(name="result", partName="result")
    public TopXSummaryDO getTopTargets(DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getTopTargets");
        if (dbFilter.getFabricDbId() < 0L) {
            dbFilter.setFabricDbId(-1L);
        }
        ArrayList<StatisticsDataDO> statList = EndDeviceStatHandler.getInstance().getEndDeviceStatList(dbFilter, "Storage Ports", "24 Hours", 0, dbFilter.getLimit(), true);
        for (StatisticsDataDO stat : statList) {
            if (stat.getRxTxStr().length() == 0) {
                stat.setRxTxStr("0B");
                continue;
            }
            stat.setRxTxStr(stat.getRxTxStr());
        }
        StatisticsDataDO[] retList = new StatisticsDataDO[statList.size()];
        retList = statList.toArray(retList);
        TopXSummaryDO ret = new TopXSummaryDO();
        ret.setDataSource(dbFilter.getGroupFilterXml());
        ret.setDataProvider(retList);
        return ret;
    }

    @Override
    @WebMethod(operationName="getTopSan")
    @WebResult(name="result", partName="result")
    public TopXSummaryDO getTopSan(DbFilterDO dbFilter) {
        TopXSummaryDO ret = new TopXSummaryDO();
        ret.setDataSource(dbFilter.getGroupFilterXml());
        TopXSummaryDO host = this.getTopHosts(dbFilter);
        TopXSummaryDO target = this.getTopTargets(dbFilter);
        ret.setDataProvider(host.getDataProvider());
        ret.setDataProvider2(target.getDataProvider());
        return ret;
    }

    @Override
    @WebMethod(operationName="getTopSwitches")
    @WebResult(name="result", partName="result")
    public TopXSummaryDO getTopSwitches(DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getTopSwitches");
        ArrayList<StatisticsDataDO> topSwitches = TopHandler.getInstance().getTopSwitches(dbFilter);
        StatisticsDataDO[] retList = new StatisticsDataDO[topSwitches.size()];
        retList = topSwitches.toArray(retList);
        TopXSummaryDO ret = new TopXSummaryDO();
        ret.setDataSource(dbFilter.getGroupFilterXml());
        ret.setDataProvider(retList);
        return ret;
    }

    @Override
    @WebMethod(operationName="getTopInterfaces")
    @WebResult(name="result", partName="result")
    public TopXSummaryDO getTopInterfaces(DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getTopInterfaces");
        ArrayList<StatisticsDataDO> topInterfaces = GigEStatHandler.getInstance().getTopLanEthernetStatList(dbFilter, "24 Hours", 0, dbFilter.getLimit(), true);
        StatisticsDataDO[] retList = new StatisticsDataDO[topInterfaces.size()];
        retList = topInterfaces.toArray(retList);
        TopXSummaryDO ret = new TopXSummaryDO();
        ret.setDataSource(dbFilter.getGroupFilterXml());
        ret.setDataProvider(retList);
        return ret;
    }

    @Override
    @WebMethod(operationName="getTopISLs")
    @WebResult(name="result", partName="result")
    public TopXSummaryDO getTopISLs(DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getTopISLs");
        TopXSummaryDO ret = new TopXSummaryDO();
        ret.setDataSource(dbFilter.getGroupFilterXml());
        String networkType = dbFilter.getNetworkType();
        if (networkType != null && networkType.equals("Data Center")) {
            ArrayList<StatisticsDataDO> sanISLs = null;
            ArrayList<StatisticsDataDO> lanISLs = null;
            dbFilter.setNetworkType("SAN");
            try {
                sanISLs = IslStatHandler.getInstance().getIslStatList(dbFilter, "24 Hours", 0, dbFilter.getLimit(), true);
            }
            catch (Throwable e) {
                logger.warn((Object)"DashboardWS.getTopISLs exception", e);
            }
            dbFilter.setNetworkType("LAN");
            try {
                lanISLs = IslStatHandler.getInstance().getIslStatList(dbFilter, "24 Hours", 0, dbFilter.getLimit(), true);
            }
            catch (Throwable e) {
                logger.warn((Object)"DashboardWS.getTopISLs exception", e);
            }
            ArrayList<StatisticsDataDO> topISLs = new ArrayList<StatisticsDataDO>();
            topISLs.addAll(sanISLs);
            topISLs.addAll(lanISLs);
            Collections.sort(topISLs, new TotalRxTxComparator());
            int retLen = dbFilter.getLimit();
            if (retLen > topISLs.size()) {
                retLen = topISLs.size();
            }
            StatisticsDataDO[] retList = new StatisticsDataDO[retLen];
            for (int i = 0; i < retLen; ++i) {
                retList[i] = (StatisticsDataDO)topISLs.get(i);
            }
            ret.setDataProvider(retList);
        } else {
            try {
                ArrayList<StatisticsDataDO> topISLs = IslStatHandler.getInstance().getIslStatList(dbFilter, "24 Hours", 0, dbFilter.getLimit(), true);
                StatisticsDataDO[] retList = new StatisticsDataDO[topISLs.size()];
                retList = topISLs.toArray(retList);
                ret.setDataProvider(retList);
            }
            catch (Throwable e) {
                logger.warn((Object)"DashboardWS.getTopISLs exception", e);
            }
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="getTopCPUs")
    @WebResult(name="result", partName="result")
    public TopXSummaryDO getTopCPUs(DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getTopCPUs");
        TopXSummaryDO ret = new TopXSummaryDO();
        int why = OidStatHandler.getInstance().getOidStatDataLength(dbFilter, "24 Hours", OidStatHandler.TYPE_CPU);
        String networkType = dbFilter.getNetworkType();
        if (networkType != null && networkType.equals("Data Center")) {
            ArrayList<StatisticsDataDO> sanCPUs = null;
            ArrayList<StatisticsDataDO> lanCPUs = null;
            dbFilter.setNetworkType("SAN");
            try {
                sanCPUs = OidStatHandler.getInstance().getOidStatList(dbFilter, "24 Hours", 0, dbFilter.getLimit(), OidStatHandler.TYPE_CPU);
            }
            catch (Throwable e) {
                logger.warn((Object)"DashboardWS.getTopISLs exception", e);
            }
            dbFilter.setNetworkType("LAN");
            try {
                lanCPUs = OidStatHandler.getInstance().getOidStatList(dbFilter, "24 Hours", 0, dbFilter.getLimit(), OidStatHandler.TYPE_CPU);
            }
            catch (Throwable e) {
                logger.warn((Object)"DashboardWS.getTopISLs exception", e);
            }
            ArrayList<StatisticsDataDO> topCPUs = new ArrayList<StatisticsDataDO>();
            topCPUs.addAll(sanCPUs);
            topCPUs.addAll(lanCPUs);
            for (StatisticsDataDO s : topCPUs) {
                double rxtx = 0.0;
                try {
                    rxtx = Double.parseDouble(s.getAvgRxStr());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                s.setRxTx(rxtx);
            }
            Collections.sort(topCPUs, new TotalRxTxComparator());
            int retLen = dbFilter.getLimit();
            if (retLen > topCPUs.size()) {
                retLen = topCPUs.size();
            }
            StatisticsDataDO[] retList = new StatisticsDataDO[retLen];
            for (int i = 0; i < retLen; ++i) {
                retList[i] = (StatisticsDataDO)topCPUs.get(i);
            }
            ret.setDataProvider(retList);
        } else {
            try {
                ArrayList<StatisticsDataDO> topCPUs = OidStatHandler.getInstance().getOidStatList(dbFilter, "24 Hours", 0, dbFilter.getLimit(), OidStatHandler.TYPE_CPU);
                StatisticsDataDO[] retList = new StatisticsDataDO[topCPUs.size()];
                retList = topCPUs.toArray(retList);
                ret.setDataSource(dbFilter.getGroupFilterXml());
                ret.setDataProvider(retList);
            }
            catch (Throwable e) {
                logger.warn((Object)"DashboardWS.getTopISLs exception", e);
            }
        }
        return ret;
    }

    @Override
    @WebMethod(operationName="getTopology")
    @WebResult(name="result", partName="result")
    public DashboardTopologyDO getTopology(DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getDashboardTopology");
        return TopologyHandler.getInstance().getDashboardTopology(dbFilter);
    }

    @Override
    @WebMethod(operationName="getTopologyVsanList")
    @WebResult(name="result", partName="result")
    public DashboardTopologyVsanListDO getTopologyVsanList(DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getDashboardTopologyVsanList");
        return TopologyHandler.getInstance().getTopologyVsanList(dbFilter);
    }

    @Override
    @WebMethod(operationName="getTopologyVlanList")
    @WebResult(name="result", partName="result")
    public DashboardTopologyVlanListDO getTopologyVlanList(DbFilterDO dbFilter) {
        logger.debug((Object)"DashboardWS.getDashboardTopologyVlanList");
        return TopologyHandler.getInstance().getTopologyVlanList(dbFilter);
    }

    @Override
    @WebMethod(operationName="getTopologyNodes")
    @WebResult(name="result", partName="result")
    public String getTopologyNodes(String owner, String topologyName) throws SanNotFoundException {
        logger.debug((Object)"DashboardWS.getTopologyNodes");
        return TopologyHandler.getInstance().getTopologyNodes(owner, topologyName);
    }

    @Override
    @WebMethod(operationName="setTopologyNodes")
    @WebResult(name="result", partName="result")
    public OperationStatusDO setTopologyNodes(String owner, String topologyName, String nodes) {
        logger.debug((Object)"DashboardWS.setTopologyNodes");
        return TopologyHandler.getInstance().setTopologyNodes(owner, topologyName, nodes);
    }

    @Override
    @WebMethod(operationName="getFederation")
    @WebResult(name="result", partName="result")
    public FederationDO[] getFederation() {
        logger.debug((Object)"DashboardWS.getFederation");
        ArrayList<FederationDO> fedList = FederationHandler.getInstance().getFederationList();
        FederationDO[] retList = new FederationDO[fedList.size()];
        retList = fedList.toArray(retList);
        return retList;
    }

    @Override
    @WebMethod(operationName="setServerLocation")
    @WebResult(name="result", partName="result")
    public CallResultDO setServerLocation(int serverId, String location) {
        logger.debug((Object)"DashboardWS.setServerLocation");
        try {
            if (location != null) {
                location = location.trim();
            }
            FederationHandler.getInstance().updateLocation(serverId, location);
        }
        catch (SanServiceException e) {
            logger.warn((Object)"DbAdminWS caught exception in setServerLocation():", (Throwable)e);
            return new CallResultDO(1, "Cannot update server location " + e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="getEnclChartData")
    @WebResult(name="result", partName="result")
    public CallResultDO getEnclChartData(long encId, int pmType, int chartType) throws SanServiceException, InvalidArgumentException {
        try {
            return HostEnclHandler.getInstance().getEnclChartData(encId, pmType, chartType);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getEnclChartData():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getEnclChartData():", e);
            throw new SanServiceException("SanWS caught exception in getEnclChartData():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getPMChartData")
    @WebResult(name="result", partName="result")
    public CallResultDO getPMChartData(String rrdFile, int pmType, int fid, int interval) throws SanServiceException {
        double[][] stats = null;
        CallResultDO rstDo = new CallResultDO();
        try {
            PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new LanPK(fid));
            stats = pmRif.getPmChartData(rrdFile, pmType, interval);
            if (stats == null || stats.length == 0) {
                throw new SanServiceException("No chart data found");
            }
            StatDO[] statArr = new StatDO[stats.length];
            for (int i = 0; i < stats.length; ++i) {
                statArr[i] = new StatDO(stats[i][0], stats[i][1], stats[i][2]);
            }
            rstDo.setResultStats(statArr);
        }
        catch (Exception e) {
            logger.warn((Object)"SanWS caught exception in getPMChartData():", (Throwable)e);
            rstDo.setResultMessage(e.getMessage());
            rstDo.setResultStatus(-1);
        }
        return rstDo;
    }

    @Override
    @WebMethod(operationName="getDataSourcesCount")
    @WebResult(name="result", partName="result")
    public int getDataSourcesCount() {
        logger.debug((Object)"getDataSourcesCount");
        int lanCount = 0;
        int sanCount = 0;
        int vmCount = 0;
        try {
            List<LanPK> lanList = GlobalDCManager.getInstance().getAllLanPKs();
            if (lanList != null) {
                lanCount = lanList.size();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            List<FabricPK> fabrics = GlobalFabricManager.getInstance().getAllFabricPKs();
            if (fabrics != null) {
                sanCount = fabrics.size();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            VirtualCenterBase[] vms = GlobalViManager.getInstance().getAllVCenters();
            if (vms != null) {
                vmCount = vms.length;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return lanCount + sanCount + vmCount;
    }

    @Override
    @WebMethod(operationName="getDashboardSettings")
    @WebResult(name="result", partName="result")
    public DashboardSettingsDO getDashboardSettings() {
        String s;
        DashboardSettingsDO ret = new DashboardSettingsDO();
        long timeout = 0L;
        try {
            s = System.getProperty("web.dashboard.refreshInterval");
            s = s.trim();
            timeout = Long.valueOf(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        ret.setRefreshTimeout(timeout);
        try {
            s = System.getProperty("web.isBeta");
            s = s.trim();
            if (s != null && s.equalsIgnoreCase("true")) {
                ret.setBeta(true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String currentUser = IdentityManager.getInstance().getCurrentUsername();
            DashBoardStateDO state = DashboardHandler.getInstance().getDashboard(currentUser, "LastView");
            ret.setLastView(state.getData());
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod(operationName="getStorageSummary")
    @WebResult(name="result", partName="result")
    public StorageSummaryDO getStorageSummary(DbFilterDO dbFilter) {
        Object alist = null;
        Connection con = null;
        ArrayList<StorageSystemSummaryDO> sumList = new ArrayList<StorageSystemSummaryDO>();
        try {
            SMISNavItemDO[] list;
            con = ConnectionManager.getConnection();
            for (SMISNavItemDO item : list = SMISHandler.getInstance().getStorageSystemList(con)) {
                StorageSystemSummaryDO sys = SMISHandler.getInstance().getStorageSystemSummary(con, item.getDbid());
                sumList.add(sys);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        StorageSummaryDO systemSummary = new StorageSummaryDO();
        systemSummary.setSystemList(sumList.toArray(new StorageSystemSummaryDO[0]));
        return systemSummary;
    }
}

