/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.jaxws.discv.wo.LanDomainDO;
import com.cisco.dcbu.jaxws.discv.wo.LanObjectDO;
import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.san.ep.DataCenterGrpSEI;
import com.cisco.dcbu.jaxws.san.ep.DbAdminWS;
import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.lan.webservice.client.LanWSDelegator;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.security.SecurityManager;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/DataCenterGrpWSService", urlPattern="/DataCenterGrpWS")
@WebService(name="DataCenterGrpWS", serviceName="DataCenterGrpService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.DataCenterGrpSEI")
@Stateless
public class DataCenterGrpWS
implements DataCenterGrpSEI {
    static Logger logger = LogManager.getLogger((String)"fms.ws");
    static final String _GetDevDbIdByLanSwClassIdSQL = "select ethsw.id, nav.group_id, ethsw.lanswitch_classid from ETHSWITCH ethsw, NAV_GROUP_MEMBER nav where (nav.mem_dbid=ethsw.id) AND ethsw.lanswitch_classid in (";
    static final String _GetDevByDevDbIdSQL = "select nav.mem_dbid, nav.type, ethsw.id, ethsw.ip_address, ethsw.SYS_NAME, ethsw.serial_number from ETHSWITCH ethsw, NAV_GROUP_MEMBER nav where (ethsw.id=nav.mem_dbid) AND (nav.group_id=?)";
    static final String _GetGroupNameByIdSQL = "select name from NAV_GROUPS where id =?";
    static final String _GetGroupCtByNameSQL = "select count(*) from nav_groups ng where ng.name = ?";
    static final String _GetIDForNameSQL = "select  id from nav_groups where name=?";
    static final String _GetMembersForGroupSQL = "select mem_dbid, type, mem_name from nav_group_member where group_id=?";
    static final String _GetAllLanGroupSQL = "select id, name from nav_groups where type =1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod
    public LanDomainDO[] getAllLANDomains() throws SanServiceException {
        logger.info((Object)"DataCenterGrpWS getAllLANDomains....");
        ArrayList<LanDomainDO> groups = new ArrayList<LanDomainDO>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(_GetAllLanGroupSQL);
            rs = stat.executeQuery();
            ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
            DBEntryDO dto = new DBEntryDO();
            dto.setColumn(new String[]{"groupDbId", "groupName"});
            while (rs.next()) {
                long groupDbId = rs.getLong(1);
                String groupName = rs.getString(2);
                logger.info((Object)("DataCenterGrpWS getAllLANDomains, found group " + groupDbId + "/" + groupName));
                DBRowDO row = new DBRowDO();
                row.setEntry(new String[]{Long.toString(groupDbId), groupName});
                rList.add(row);
            }
            for (DBRowDO gp : rList) {
                logger.info((Object)("DataCenterGrpWS getAllLANDomains, query member for group " + gp.getEntry()[0] + "/" + gp.getEntry()[1]));
                LanObjectDO[] devices = this.getMembers(con, Long.valueOf(gp.getEntry()[0]));
                LanDomainDO lanDoaminGrp = new LanDomainDO(Long.valueOf(gp.getEntry()[0]), gp.getEntry()[1], devices);
                logger.info((Object)("DataCenterGrpWS getAllLANDomains, " + gp.getEntry()[0] + "/" + gp.getEntry()[1] + " found all members, add this group to list"));
                groups.add(lanDoaminGrp);
            }
        }
        catch (Exception ex) {
            try {
                logger.warn((Object)"DataCenterGrpWS getAllLANDomains ex=", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        logger.info((Object)"DataCenterGrpWS getAllLANDomains, DONE");
        return groups.toArray(new LanDomainDO[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LanObjectDO[] getMembers(Connection con, long groupDbId) throws Exception {
        ArrayList<LanObjectDO> devList;
        block9: {
            logger.info((Object)"DataCenterGrpWS getMembers....");
            PreparedStatement stat = null;
            ResultSet rs = null;
            devList = new ArrayList<LanObjectDO>();
            try {
                stat = con.prepareStatement(_GetDevByDevDbIdSQL);
                stat.setLong(1, groupDbId);
                logger.info((Object)("DataCenterGrpWS getMembers, query member for group " + groupDbId));
                rs = stat.executeQuery();
                while (rs.next()) {
                    Long memDbId = rs.getLong(1);
                    int type = rs.getInt(2);
                    String memName = rs.getString(3);
                    if (type != 4) {
                        logger.info((Object)("DataCenterGrpWS getMembers, " + groupDbId + " have NON EthSw memeber:" + memDbId + "/" + memName + "/" + type));
                        continue;
                    }
                    byte[] mgmtAddrB = rs.getBytes(4);
                    String mgmtAddr = mgmtAddrB.toString();
                    try {
                        mgmtAddr = InetAddress.getByAddress(mgmtAddrB).getHostAddress();
                    }
                    catch (UnknownHostException ue) {
                        logger.warn((Object)"DataCenterGrpWS getMembers failed to resolve ethSwIP from DB ", (Throwable)ue);
                    }
                    String sysName = rs.getString(5);
                    byte[] serialNum = rs.getBytes(6);
                    LanObjectDO dev = new LanObjectDO(mgmtAddr, sysName.toString(), serialNum.toString(), "", 0);
                    logger.info((Object)("DataCenterGrpWS getMembers, " + groupDbId + " found member: dbId/name/type=" + memDbId + "/" + memName + "/" + type + ", mgmtAddr/sysName/SerialNum=" + mgmtAddr + '/' + sysName + '/' + serialNum));
                    devList.add(dev);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                logger.warn((Object)"DataCenterGrpWS getMembers ex=", (Throwable)ex);
                break block9;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        logger.info((Object)"DataCenterGrpWS getMembers, DONE");
        return devList.toArray(new LanObjectDO[0]);
    }

    @Override
    @WebMethod
    public LanDomainDO getLANDomainMembers(LanDomainDO lanDomain) throws SanServiceException {
        logger.info((Object)"DataCenterGrpWS getLANDomainMembers....");
        long groupDbId = lanDomain.getgroupDbid();
        String groupName = lanDomain.getgroupName();
        String nameCkErr = this.checkGroupName(groupDbId, groupName);
        if (nameCkErr != null) {
            logger.info((Object)("DataCenterGrpWS getLANDomainMembers group name not matched in DB: " + nameCkErr));
            throw new SanServiceException("getLANDomainMembers group name not matched in DB: " + nameCkErr);
        }
        logger.info((Object)("DataCenterGrpWS getLANDomainMembers groupId:" + groupDbId));
        int status = NavigationUtil.getInstance().isLANDomain(groupDbId);
        if (status < 0) {
            String statusString = status == -1 ? "group does not exist" : (status == -2 ? "error" : "group type not qualified");
            logger.info((Object)("DataCenterGrpWS getLANDomainMembers, " + groupDbId + " isLANDomain false, status=" + status + ":" + statusString));
            throw new SanServiceException("Group " + groupDbId + " not a LAN Domain.(" + statusString + ")\n");
        }
        logger.info((Object)("DataCenterGrpWS getLANDomainMembers, " + groupDbId + " isLANDomain true"));
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            LanObjectDO[] devices = this.getMembers(con, groupDbId);
            lanDomain.setgMembers(devices);
            logger.info((Object)"DataCenterGrpWS getLANDomainMembers, DONE");
        }
        catch (Exception ex) {
            logger.warn((Object)("DataCenterGrpWS getLANDomainMembers ex=" + ex.getMessage()));
            throw new SanServiceException("getLANDomainMembers Failed: " + ex.getMessage());
        }
        finally {
            DbUtil.close(con);
        }
        return lanDomain;
    }

    @Override
    @WebMethod
    public CallResultDO createTopHierachyLANDomain(String groupName, Long[] neIds) throws SanServiceException {
        logger.info((Object)"DataCenterGrpWS createTopHierachyLANDomain....");
        logger.info((Object)("DataCenterGrpWS createTopHierachyLANDomain....  groupName=" + groupName));
        for (Long neId : neIds) {
            logger.info((Object)("DataCenterGrpWS createTopHierachyLANDomain....  neId=" + neId));
        }
        long parentGroupDbid = -1L;
        int status = this.isGroupNameUnique(groupName);
        if (status < 0) {
            String errMsg = status == -1 ? "Group exists" : "SQL error";
            logger.warn((Object)("DataCenterGrpWS createTopHierachyLANDomain, " + groupName + ":" + errMsg));
            return new CallResultDO(-1, "Failed to create group " + groupName + ": " + errMsg);
        }
        if (neIds == null || neIds.length == 0) {
            logger.warn((Object)"DataCenterGrpWS createTopHierachyLANDomain, Cannot create LAN Domain without EthSwitch/Device!");
            return new CallResultDO(-1, "Cannot create LAN Domain without EthSwitch/Device.");
        }
        List<String> dbIdList = this.findGroupMembersAttr(neIds);
        if (dbIdList.size() == 0) {
            logger.warn((Object)"DataCenterGrpWS createTopHierachyLANDomain, Cannot create LAN Domain without EthSwitch/Device, no mapping devices in DB.!");
            return new CallResultDO(-1, "CreateLANDomain Failed: Cannot create LAN Domain without EthSwitch/Device, no mapping devices in DB.");
        }
        long newGroupDbid = -1L;
        try {
            newGroupDbid = NavigationUtil.getInstance().addGroup(parentGroupDbid, groupName);
        }
        catch (Throwable e) {
            logger.warn((Object)"DataCenterGrpWS createTopHierachyLANDomain caught exception in createTopHierachyLANDomain():", e);
            return new CallResultDO(-1, "CreateLANDomain Failed: create group failed, " + e.getMessage());
        }
        CallResultDO result = DbAdminWS.moveLANGroupMemberGen(dbIdList.toArray(new String[0]), newGroupDbid);
        if (result.getResultStatus() != 0) {
            logger.warn((Object)("DataCenterGrpWS createTopHierachyLANDomain move members failed: " + result.getResultStatus()));
            return new CallResultDO(-1, "CreateLANDomain Failed: move members failed, " + result.getResultMessage());
        }
        try {
            String dcnmUser = IdentityManager.getInstance().getCurrentUsername();
            logger.info((Object)("DataCenterGrpWS createTopHierachyLANDomain(), notifyDataCenterGroupCreation()... dcnmUser/newGroupdbId=" + dcnmUser + '/' + newGroupDbid));
            LanWSDelegator.getInstance().notifyDataCenterGroupCreation(dcnmUser, new long[]{newGroupDbid});
        }
        catch (Exception ex) {
            logger.warn((Object)("DataCenterGrpWS createTopHierachyLANDomain, notifyDataCenterGroupCreation failed: " + ex));
        }
        logger.info((Object)"DataCenterGrpWS createTopHierachyLANDomain, DONE");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int isGroupNameUnique(String groupName) {
        block12: {
            DataCenterGrpWS.logger.info((Object)("DataCenterGrpWS isGroupNameUnique... groupName=" + groupName));
            status = 0;
            con = null;
            stat = null;
            rs = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement("select count(*) from nav_groups ng where ng.name = ?");
                stat.setString(1, groupName);
                rs = stat.executeQuery();
                if (rs.next()) {
                    ct = rs.getInt(1);
                    v0 = status = ct == 0 ? 0 : -1;
                }
                if (rs == null) break block12;
            }
            catch (Exception ex) {
                block13: {
                    try {
                        DataCenterGrpWS.logger.warn((Object)("DataCenterGrpWS isGroupNameUnique ex=" + ex.getMessage()));
                        status = -2;
                        if (rs == null) break block13;
                    }
                    catch (Throwable var7_8) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stat != null) {
                            DbUtil.close(stat);
                        }
                        if (con != null) {
                            DbUtil.close(con);
                        }
                        throw var7_8;
                    }
                    DbUtil.close(rs);
                }
                if (stat != null) {
                    DbUtil.close(stat);
                }
                if (con != null) {
                    DbUtil.close(con);
                } else {
                    ** GOTO lbl42
                }
            }
            DbUtil.close(rs);
        }
        if (stat != null) {
            DbUtil.close(stat);
        }
        if (con != null) {
            DbUtil.close(con);
        }
        DataCenterGrpWS.logger.info((Object)("DataCenterGrpWS isGroupNameUnique DONE. status=" + status));
        return status;
    }

    private List<String> findGroupMembersAttr(Long[] neIds) throws SanServiceException {
        logger.info((Object)"DataCenterGrpWS findGroupMembersAttr...");
        for (Long lanObj : neIds) {
            logger.info((Object)("DataCenterGrpWS findGroupMembersAttr, lanswitch_classid ==> " + lanObj));
        }
        ArrayList ipLanObjList = new ArrayList();
        Connection con = null;
        PreparedStatement stat = null;
        String query_statement = _GetDevDbIdByLanSwClassIdSQL;
        ResultSet rs = null;
        ArrayList<String> dbIdList = new ArrayList<String>();
        HashMap<Long, String> resultList = new HashMap<Long, String>();
        try {
            con = ConnectionManager.getConnection();
            for (Long lanObj : neIds) {
                if (query_statement.length() > _GetDevDbIdByLanSwClassIdSQL.length()) {
                    query_statement = query_statement + ",";
                }
                query_statement = query_statement + lanObj;
                logger.info((Object)("DataCenterGrpWS findGroupMembersAttr DB query, lanswitch_classid= " + lanObj));
            }
            if (query_statement.length() > _GetDevDbIdByLanSwClassIdSQL.length()) {
                query_statement = query_statement + ")";
                stat = con.prepareStatement(query_statement);
                logger.info((Object)("DataCenterGrpWS findGroupMembersAttr statement=" + query_statement));
                rs = stat.executeQuery();
                while (rs.next()) {
                    Long memDbId = rs.getLong(1);
                    Long groupId = rs.getLong(2);
                    Long neId = rs.getLong(3);
                    resultList.put(new Long(neId), "");
                    String memAttr = memDbId.toString() + ':' + groupId.toString();
                    dbIdList.add(memAttr);
                    logger.info((Object)("DataCenterGrpWS findGroupMembersAttr DB result -> neId/DbId " + neId + "/" + memDbId));
                }
            }
        }
        catch (SQLException ex) {
            logger.warn((Object)("DataCenterGrpWS findGroupMembersAttr ex=" + ex.getMessage()));
            throw new SanServiceException("CreateLANDomain Failed: " + ex.getMessage());
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        StringBuffer sb = new StringBuffer();
        for (Long lanObj : neIds) {
            if (resultList.get(new Long(lanObj)) != null) continue;
            sb.append(lanObj);
            sb.append(" ");
        }
        if (sb.length() > 0) {
            throw new SanServiceException("cannot find neId " + sb.toString() + "in DB");
        }
        return dbIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkGroupName(long groupDbId, String groupName) {
        logger.info((Object)"DataCenterGrpWS checkGroupName....");
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        String resultString = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(_GetGroupNameByIdSQL);
            stat.setLong(1, groupDbId);
            rs = stat.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                resultString = name.equals(groupName) ? null : "group name not matched for " + groupDbId + ":" + groupName + "/" + name;
            }
        }
        catch (SQLException ex) {
            try {
                logger.warn((Object)("DataCenterGrpWS checkGroupName, ex=" + ex.getMessage()));
                resultString = "group name not matched, SQL error:" + ex.getMessage();
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        logger.warn((Object)"DataCenterGrpWS checkGroupNames DONE");
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WebMethod
    public CallResultDO deleteLANDomains(LanDomainDO[] lanDomains) throws SanServiceException {
        logger.info((Object)"DataCenterGrpWS deleteTopHierachyLANDomains....");
        ArrayList<Long> deleteGrpList = new ArrayList<Long>();
        StringBuffer errMsg = new StringBuffer();
        Connection con = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            for (LanDomainDO lanDomain : lanDomains) {
                String groupName;
                long groupDbId = lanDomain.getgroupDbid();
                String nameCkErr = this.checkGroupName(groupDbId, groupName = lanDomain.getgroupName());
                if (nameCkErr != null) {
                    logger.info((Object)("DataCenterGrpWS deleteTopHierachyLANDomains group name not matched in DB: " + nameCkErr));
                    CallResultDO callResultDO = new CallResultDO(-1, "deleteTopHierachyLANDomains group name not matched in DB: " + nameCkErr);
                    return callResultDO;
                }
                logger.info((Object)("DataCenterGrpWS deleteTopHierachyLANDomains groupId:" + groupDbId));
                int status = NavigationUtil.getInstance().isLANDomain(groupDbId);
                if (status < 0) {
                    String statusString = status == -1 ? "group does not exist" : (status == -2 ? "error" : "group type not qualified");
                    logger.info((Object)("DataCenterGrpWS deleteTopHierachyLANDomains, " + groupDbId + " isLANDomain false, status=" + status + ":" + statusString + ", skipped"));
                    errMsg.append("Group " + groupDbId + " not a LAN Domain.(" + statusString + ")\n");
                    continue;
                }
                logger.info((Object)("DataCenterGrpWS deleteTopHierachyLANDomains, " + groupDbId + " isLANDomain true"));
                ArrayList<String> dbIdList = new ArrayList<String>();
                if (stat != null) {
                    stat.clearBatch();
                    stat.clearParameters();
                    stat.close();
                }
                stat = con.prepareStatement(_GetMembersForGroupSQL);
                stat.setLong(1, groupDbId);
                rs = stat.executeQuery();
                status = 0;
                while (rs.next()) {
                    Long memDbId = rs.getLong(1);
                    int type = rs.getInt(2);
                    String memName = rs.getString(3);
                    if (type != 4) {
                        logger.info((Object)("DataCenterGrpWS deleteTopHierachyLANDomains, " + groupDbId + " have member " + memName + " not ethSwitch/Device"));
                        errMsg.append("Group " + groupDbId + " have member " + memName + " not ethSwitch/Device.\n");
                        status = -1;
                        continue;
                    }
                    logger.info((Object)("DataCenterGrpWS deleteTopHierachyLANDomains, " + groupDbId + " found member " + memDbId + "/" + memName));
                    String memAttr = memDbId.toString() + ':' + groupDbId;
                    dbIdList.add(memAttr);
                }
                if (status < 0) {
                    logger.warn((Object)("DataCenterGrpWS deleteTopHierachyLANDomains, Group " + groupDbId + " not all members ethSwitch/Device, skipped"));
                    continue;
                }
                CallResultDO result = DbAdminWS.moveLANGroupMemberGen(dbIdList.toArray(new String[0]), 2L);
                if (result.getResultStatus() != 0) {
                    logger.warn((Object)("DataCenterGrpWS deleteTopHierachyLANDomains, Group " + groupDbId + " move members failed," + result.getResultMessage() + ", skipped"));
                    errMsg.append("Group " + groupDbId + ": failed to move members to DEFAULT_LAN (" + result.getResultMessage() + ")\n");
                    continue;
                }
                logger.info((Object)("DataCenterGrpWS deleteTopHierachyLANDomains, " + groupDbId + " moved all members to DEFAULT_LAN"));
                status = NavigationUtil.getInstance().removeEmptyGroup(groupDbId);
                if (status < 0) {
                    String statusString = status == -1 ? "group not empty" : "SQL error";
                    logger.info((Object)("DataCenterGrpWS deleteTopHierachyLANDomains, " + groupDbId + " removeEmptyGroup failed, status=" + status + ":" + statusString + ", skipped"));
                    errMsg.append("Group " + groupDbId + ": failed to remove group(" + statusString + ")\n");
                    continue;
                }
                deleteGrpList.add(groupDbId);
                logger.info((Object)("DataCenterGrpWS deleteTopHierachyLANDomains, " + groupDbId + ", group removed"));
            }
        }
        catch (SQLException ex) {
            logger.warn((Object)("DataCenterGrpWS deleteTopHierachyLANDomains ex=" + ex.getMessage()));
            CallResultDO len$ = new CallResultDO(-1, "deleteTopHierachyLANDomains Failed: " + ex.getMessage());
            return len$;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        if (deleteGrpList.size() > 0) {
            logger.info((Object)"DataCenterGrpWS deleteTopHierachyLANDomains() found LAN Domains, notifyDataCenterGroupDeletion()...");
            try {
                Long[] delList = deleteGrpList.toArray(new Long[0]);
                long[] objs = new long[delList.length];
                int i = 0;
                for (Long grp : delList) {
                    objs[i++] = grp;
                    logger.info((Object)("DataCenterGrpWS deleteTopHierachyLANDomains() found LAN Domains, notifyDataCenterGroupDeletion()... LAN Domain id=" + grp));
                }
                String dcnmUser = IdentityManager.getInstance().getCurrentUsername();
                logger.info((Object)("DataCenterGrpWS deleteTopHierachyLANDomains() found LAN Domains, notifyDataCenterGroupDeletion()... dcnmUser=" + dcnmUser));
                LanWSDelegator.getInstance().notifyDataCenterGroupDeletion(dcnmUser, objs);
            }
            catch (Exception ex) {
                logger.warn((Object)("DataCenterGrpWS deleteTopHierachyLANDomains(), notifyDataCenterGroupDeletion() ex=" + ex));
            }
        }
        if (errMsg.length() > 0) {
            return new CallResultDO(-1, "deleteTopHierachyLANDomains Failed: " + errMsg.toString());
        }
        logger.info((Object)"DataCenterGrpWS deleteTopHierachyLANDomains, DONE.");
        return new CallResultDO();
    }

    @Override
    @WebMethod
    public CallResultDO addDevicesToLANDomain(Long dataCenterGroupId, Long[] neIds) throws SanServiceException {
        logger.info((Object)("DataCenterGrpWS addDevicesToLANDomain....  groupDbId=" + dataCenterGroupId));
        for (Long neId : neIds) {
            logger.info((Object)("DataCenterGrpWS addDevicesToLANDomain....  neId=" + neId));
        }
        int status = NavigationUtil.getInstance().isLANDomain(dataCenterGroupId);
        if (status < 0) {
            String statusString = status == -1 ? "group does not exist" : (status == -2 ? "error" : "group type not qualified");
            logger.info((Object)("DataCenterGrpWS addDevicesToLANDomain, " + dataCenterGroupId + " isLANDomain false, status=" + status + ":" + statusString));
            return new CallResultDO(-1, "Group is not LAN Domain.");
        }
        logger.info((Object)("DataCenterGrpWS addDevicesToLANDomain, " + dataCenterGroupId + " isLANDomain true"));
        List<String> dbIdList = this.findGroupMembersAttr(neIds);
        CallResultDO result = DbAdminWS.moveLANGroupMemberGen(dbIdList.toArray(new String[0]), dataCenterGroupId);
        if (result.getResultStatus() != 0) {
            logger.warn((Object)("DataCenterGrpWS addDevicesToLANDomain move members failed: " + result.getResultStatus()));
            return new CallResultDO(-1, "DataCenterGrpWS addDevicesToLANDomain Failed: move members failed, " + result.getResultMessage());
        }
        try {
            long[] objs = new long[neIds.length];
            int i = 0;
            for (Long member : neIds) {
                objs[i++] = member;
                logger.info((Object)("DataCenterGrpWS addDevicesToLANDomain, notifyMemberAddedToGroup()... aneId=" + member));
            }
            String dcnmUser = IdentityManager.getInstance().getCurrentUsername();
            logger.info((Object)("DataCenterGrpWS addDevicesToLANDomain, notifyMemberAddedToGroup()... dcnmUser=" + dcnmUser));
            LanWSDelegator.getInstance().notifyMemberAddedToGroup(dcnmUser, dataCenterGroupId, objs);
        }
        catch (Exception ex) {
            logger.warn((Object)("DataCenterGrpWS addDevicesToLANDomain, notifyMemberAddedToGroup ex=" + ex));
        }
        logger.info((Object)"DataCenterGrpWS addDevicesToLANDomain, DONE");
        return result;
    }

    @Override
    @WebMethod
    public CallResultDO removeDevicesFromLANDomain(Long dataCenterGroupId, Long[] neIds) throws SanServiceException {
        logger.info((Object)("DataCenterGrpWS removeDevicesFromLANDomain....  groupDbId=" + dataCenterGroupId));
        List<String> dbIdList = this.findGroupMembersAttr(neIds);
        CallResultDO result = DbAdminWS.moveLANGroupMemberGen(dbIdList.toArray(new String[0]), 2L);
        if (result.getResultStatus() != 0) {
            logger.warn((Object)("DataCenterGrpWS removeDevicesFromLANDomain move members failed: " + result.getResultStatus()));
            return new CallResultDO(-1, "removeDevicesFromLANDomain Failed: move members failed, " + result.getResultMessage());
        }
        try {
            String dcnmUser = IdentityManager.getInstance().getCurrentUsername();
            logger.info((Object)("DataCenterGrpWS removeDevicesFromLANDomain() notifyMemberRemovedFromGroup()... dcnmUser=" + dcnmUser));
            long[] objs = new long[neIds.length];
            int i = 0;
            for (Long member : neIds) {
                objs[i++] = member;
            }
            logger.info((Object)("DataCenterGrpWS removeDevicesFromLANDomain() notifyMemberRemovedFromGroup() for group " + dataCenterGroupId));
            LanWSDelegator.getInstance().notifyMemberRemovedFromGroup(dcnmUser, dataCenterGroupId, objs);
            if (DbAdminWS.getGroupType(dataCenterGroupId) != 1) {
                logger.info((Object)("DataCenterGrpWS removeDevicesFromLANDomain(), not LAN_DOMAIN anymore... group=" + dataCenterGroupId));
                LanWSDelegator.getInstance().notifyDataCenterGroupDeletion(dcnmUser, new long[]{dataCenterGroupId});
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("DataCenterGrpWS removeDevicesFromLANDomain(), notifyMemberRemovedFromGroup() ex=" + ex));
        }
        logger.info((Object)"DataCenterGrpWS removeDevicesFromLANDomain, DONE");
        return result;
    }

    public static void main(String[] strArgs) {
        String mode = SecurityManager.getInstance().getAuthMode();
        System.out.println(mode);
        if (mode != null && !mode.equalsIgnoreCase("local")) {
            try {
                throw new Exception("The security mode is not local");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

