/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.ep.InvalidArgumentException;
import com.cisco.dcbu.jaxws.ep.InvalidCredentialException;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.handler.SecurityHandler;
import com.cisco.dcbu.jaxws.lan.ep.util.LanReferenceFactory;
import com.cisco.dcbu.jaxws.san.ep.DbAdminSEI;
import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.jaxws.san.wo.CollectionDO;
import com.cisco.dcbu.jaxws.san.wo.FabricKeyDO;
import com.cisco.dcbu.jaxws.san.wo.KeyValueDO;
import com.cisco.dcbu.jaxws.san.wo.LicenseCallResultDO;
import com.cisco.dcbu.jaxws.san.wo.LicenseInfoFlexDO;
import com.cisco.dcbu.jaxws.san.wo.PerformanceDBDO;
import com.cisco.dcbu.jaxws.san.wo.PerformanceOidDO;
import com.cisco.dcbu.jaxws.san.wo.PerformancePolicyDO;
import com.cisco.dcbu.jaxws.san.wo.PerformanceThresholdDO;
import com.cisco.dcbu.jaxws.san.wo.SftpCredentialDO;
import com.cisco.dcbu.jaxws.san.wo.SnmpCredentialDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchAssignedLicenseInfoDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchNameDO;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lan.webservice.client.LanWSDelegator;
import com.cisco.dcbu.lib.util.PropertyWrapper;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.lib.util.jboss_4_2.JBoss_4_2Encrypter;
import com.cisco.dcbu.sm.common.dto.LicenseFileUsage;
import com.cisco.dcbu.sm.common.dto.LicenseInfoFlex;
import com.cisco.dcbu.sm.common.dto.SwitchAssignedLicenseInfo;
import com.cisco.dcbu.sm.common.model.SnmpCommunityBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.rif.EMRif;
import com.cisco.dcbu.sm.common.rif.EjbRegistryIf;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.IscRif;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.config.BackUpConfiguration;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.licmgr.LicenseValidatorFlexnet;
import com.cisco.dcbu.sm.server.security.FMUserFailedAttempts;
import com.cisco.dcbu.sm.server.security.SecurityManager;
import com.cisco.dcbu.sm.server.security.ServerPropertyUtil;
import com.cisco.dcbu.sm.server.security.UserManager;
import com.cisco.dcbu.sm.server.test.AuthTest;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.WebReferenceManager;
import com.cisco.dcbu.sm.server.web.admin.AdminServiceHandler;
import com.cisco.dcbu.sm.server.web.admin.LogViewerHandler;
import com.cisco.dcbu.sm.server.web.admin.PerformanceHandler;
import com.cisco.dcbu.sm.server.web.health.EventSummaryHandler;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.WebUtil;
import com.cisco.dcbu.sm.server.web.wrapper.CollectionFabrics;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/DbAdminWSService", urlPattern="/DbAdminWS")
@WebService(name="DbAdminWS", serviceName="DbAdminService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.DbAdminSEI")
@Stateless
public class DbAdminWS
implements DbAdminSEI {
    static Logger logger = LogManager.getLogger((String)"fms.ws");
    static final String _GetLanSwClassIdByEthIdSQL = "select ethsw.id, ethsw.lanswitch_classid from ETHSWITCH ethsw where ethsw.id in (";
    static final String _GetGroupIdByMemDbId = "select nav.group_id, ethsw.lanswitch_classid from NAV_GROUP_MEMBER nav, ETHSWITCH ethsw where nav.mem_dbid = ? AND ethsw.id = ?";

    @Override
    @WebMethod(operationName="getServiceList")
    @WebResult(name="result", partName="result")
    public DBEntryDO getServiceList(DbFilterDO dbFilter) throws SanServiceException {
        try {
            DBEntryDO serviceList = AdminServiceHandler.getInstance().getServiceList(dbFilter);
            return serviceList;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getServiceList():", e);
            throw new SanServiceException("Cannot get all admin services", e);
        }
    }

    @Override
    @WebMethod(operationName="startAdminService")
    @WebResult(name="result", partName="result")
    public String startAdminService(DbFilterDO dbFilter, String serverIp, String service) throws SanServiceException {
        if (serverIp == null || serverIp.equals("")) {
            throw new SanServiceException("Please provide server IP");
        }
        if (serverIp == null || serverIp.equals("") || service == null || service.equals("")) {
            throw new SanServiceException("Please provide service name");
        }
        try {
            AdminServiceHandler.getInstance().startAdminService(dbFilter, serverIp, service);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in startAdminService():", e);
            throw new SanServiceException("Cannot get all admin services", e);
        }
        return service;
    }

    @Override
    @WebMethod(operationName="getLicensedLanSwitchesGroupsInfo")
    @WebResult(name="result", partName="result")
    public String getLicensedLanSwitchesGroupsInfo() throws SanServiceException {
        try {
            return NavigationUtil.getInstance().getLicensedLanSwitchesGroupsInfo();
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getLicensedLanSwitchesGroupsInfo():", e);
            throw new SanServiceException("Cannot get licensed lan group navigation info", e);
        }
    }

    @Override
    @WebMethod(operationName="getAllLanGroups")
    @WebResult(name="result", partName="result")
    public DBEntryDO getAllLanGroups() throws SanServiceException {
        try {
            return NavigationUtil.getInstance().getAllLanGroups();
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getGroupNavigation():", e);
            throw new SanServiceException("Cannot get group navigation info", e);
        }
    }

    @Override
    @WebMethod(operationName="getGroupNavigation")
    @WebResult(name="result", partName="result")
    public String getGroupNavigation() throws SanServiceException {
        logger.info((Object)"DbAdminWS getGroupNavigation....");
        try {
            String navGroupXml = NavigationUtil.getInstance().getGroupsInfo();
            logger.info((Object)("DbAdminWS getGroupNavigation, navGroupXml=" + navGroupXml));
            logger.info((Object)"DbAdminWS getGroupNavigation DONE");
            return navGroupXml;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getGroupNavigation():", e);
            throw new SanServiceException("Cannot get group navigation info", e);
        }
    }

    @Override
    @WebMethod(operationName="getLanGroupNavigation")
    @WebResult(name="result", partName="result")
    public String getLanGroupNavigation() throws SanServiceException {
        logger.info((Object)"DbAdminWS getLanGroupNavigation....");
        try {
            String navLanGroupXml = NavigationUtil.getInstance().getLanGroupsInfo();
            logger.info((Object)("DbAdminWS getLanGroupNavigation, navLanGroupXml=" + navLanGroupXml));
            logger.info((Object)"DbAdminWS getLanGroupNavigation DONE");
            return navLanGroupXml;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getLanGroupNavigation():", e);
            throw new SanServiceException("Cannot get lan group navigation info", e);
        }
    }

    @Override
    @WebMethod(operationName="getSanGroupNavigation")
    @WebResult(name="result", partName="result")
    public String getSanGroupNavigation() throws SanServiceException {
        logger.info((Object)"DbAdminWS getSanGroupNavigation....");
        try {
            String navSanGroupXml = NavigationUtil.getInstance().getSanGroupsInfo();
            logger.info((Object)("DbAdminWS getSanGroupNavigation, navSanGroupXml=" + navSanGroupXml));
            logger.info((Object)"DbAdminWS getSanGroupNavigation DONE");
            return navSanGroupXml;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getSanGroupNavigation():", e);
            throw new SanServiceException("Cannot get san group navigation info", e);
        }
    }

    @Override
    @WebMethod(operationName="modifyGroupName")
    @WebResult(name="result", partName="result")
    public CallResultDO modifyGroupName(long groupId, String newGroupName) throws SanServiceException {
        logger.warn((Object)("DbAdminWS modifyGroupName()...,  groupId/name=" + groupId + "/" + newGroupName));
        int status = 0;
        String errMsg = "";
        try {
            status = NavigationUtil.getInstance().modifyGroupName(groupId, newGroupName);
            if (status == -1) {
                errMsg = "Group does not exists!";
            } else if (status == -2) {
                errMsg = "Failed to update to DB!";
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in modifyGroupName():", e);
            errMsg = e.getMessage();
            throw new SanServiceException("Cannot modify group name", e);
        }
        try {
            if (DbAdminWS.getGroupType(groupId) == 1) {
                try {
                    String dcnmUser = IdentityManager.getInstance().getCurrentUsername();
                    logger.info((Object)("DbAdminWS modifyGroupName(), notifyDataCenterGroupDeletion()... dcnmUser=" + dcnmUser));
                    LanWSDelegator.getInstance().notifyGroupNameChanged(dcnmUser, groupId);
                }
                catch (Exception ex) {
                    logger.warn((Object)("DbAdminWS modifyGroupName(), notifyGroupNameChanged() ex=" + ex));
                }
            }
        }
        catch (Exception ex1) {
            logger.warn((Object)("DbAdminWS modifyGroupName() check groups if type LAN_DOMAIN, ex=" + ex1));
        }
        return new CallResultDO(status, errMsg);
    }

    @Override
    @WebMethod(operationName="updateGroupNavigation")
    @WebResult(name="result", partName="result")
    public CallResultDO updateGroupNavigation(String updatedGroupNav) throws SanServiceException {
        int status = 0;
        String errorMessage = "";
        try {
            status = NavigationUtil.getInstance().updateGroupInfo(updatedGroupNav);
            if (status == -1) {
                errorMessage = "Failed to update, wrong xml format.";
            }
            if (status == -2) {
                errorMessage = "Failed to update, persistence failed.";
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getGroupNavigation():", e);
            return new CallResultDO(-3, e.getMessage());
        }
        return new CallResultDO(status, errorMessage);
    }

    @Override
    @WebMethod(operationName="addGroupNavigation")
    @WebResult(name="result", partName="result")
    public CallResultDO addGroupNavigation(String newGroupNav) throws SanServiceException {
        int status = 0;
        String errorMessage = "";
        try {
            status = NavigationUtil.getInstance().updateGroupInfo(newGroupNav);
            if (status == -1) {
                errorMessage = "Failed to update, wrong xml format.";
            }
            if (status == -2) {
                errorMessage = "Failed to update, persistence failed.";
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in addGroupNavigation():", e);
            return new CallResultDO(-3, e.getMessage());
        }
        return new CallResultDO(status, errorMessage);
    }

    @Override
    @WebMethod(operationName="removeGroupNavigation")
    @WebResult(name="result", partName="result")
    public CallResultDO removeGroupNavigation(String[] memDbidStrArr, String defGroupXml, String defLanGroupXml) throws SanServiceException {
        logger.warn((Object)"DbAdminWS removeGroupNavigation()...");
        ArrayList<Long> lanDomainList = new ArrayList<Long>();
        ArrayList<Long> lanSwList = new ArrayList<Long>();
        HashMap<Long, List<Long>> parentGrpList = null;
        for (String memDbIdStr : memDbidStrArr) {
            long memDbId = Long.parseLong(memDbIdStr.split(":")[0]);
            int type = Integer.parseInt(memDbIdStr.split(":")[1]);
            if (type == 1) {
                lanDomainList.add(memDbId);
                logger.info((Object)("DbAdminWS removeGroupNavigation() found GROUP_MEMBER_TYPE_LAN to remove: " + memDbId));
                continue;
            }
            if (type != 4) continue;
            lanSwList.add(memDbId);
            logger.info((Object)("DbAdminWS removeGroupNavigation() found GROUP_MEMBER_TYPE_LAN_SWITCH: " + memDbId));
        }
        if (lanSwList.size() > 0) {
            try {
                logger.info((Object)"DbAdminWS removeGroupNavigation() findGroupIdByMemDbId()....");
                parentGrpList = this.findGroupIdByMemDbId(lanSwList.toArray(new Long[0]));
            }
            catch (Exception ex) {
                logger.info((Object)("DbAdminWS removeGroupNavigation() failed to find parents for members, ex " + ex));
            }
        }
        int status = 0;
        String errorMessage = "";
        try {
            status = NavigationUtil.getInstance().removeGroupAndMem(memDbidStrArr, defGroupXml, defLanGroupXml);
            if (status < 0) {
                errorMessage = "Failed to remove group.";
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in removeGroupNavigation():", e);
            return new CallResultDO(-1, e.getMessage());
        }
        logger.info((Object)"DbAdminWS removeGroupNavigation() found LAN Domains, going to check if notify LAN server");
        String dcnmUser = IdentityManager.getInstance().getCurrentUsername();
        ArrayList<Long> delGrpList = new ArrayList<Long>();
        if (lanSwList.size() > 0 && parentGrpList != null && parentGrpList.size() > 0) {
            logger.info((Object)"DbAdminWS removeGroupNavigation() found LAN sws, notifyMemberRemovedFromGroup()...");
            try {
                logger.info((Object)("DbAdminWS removeGroupNavigation() found LAN sws, notifyMemberRemovedFromGroup()... dcnmUser=" + dcnmUser));
                for (Long groupId : parentGrpList.keySet()) {
                    List<Long> members = parentGrpList.get(groupId);
                    if (members.size() == 0) continue;
                    Long parentDbId = parentGrpList.keySet().iterator().next();
                    Long[] memberList = members.toArray(new Long[0]);
                    long[] objs = new long[memberList.length];
                    int i = 0;
                    for (Long lanSw : memberList) {
                        objs[i++] = lanSw;
                        logger.info((Object)("DbAdminWS removeGroupNavigation() found LAN sws, prepare notifyMemberRemovedFromGroup(), group/aneId" + parentDbId + "/" + lanSw));
                    }
                    logger.info((Object)("DbAdminWS removeGroupNavigation() found LAN sws, notifyMemberRemovedFromGroup() for group " + parentDbId));
                    LanWSDelegator.getInstance().notifyMemberRemovedFromGroup(dcnmUser, parentDbId, objs);
                }
            }
            catch (Exception ex) {
                logger.warn((Object)("DbAdminWS removeGroupNavigation(), notifyMemberRemovedFromGroup() ex=" + ex));
            }
            try {
                logger.info((Object)("DbAdminWS removeGroupNavigation() check groups if type not LAN_DOMAIN anymore... dcnmUser=" + dcnmUser));
                for (Long parentDbId : parentGrpList.keySet()) {
                    if (DbAdminWS.getGroupType(parentDbId) == 1) continue;
                    logger.info((Object)("DbAdminWS removeGroupNavigation(), not LAN_DOMAIN anymore... group=" + parentDbId));
                    delGrpList.add(parentDbId);
                }
            }
            catch (Exception ex) {
                logger.warn((Object)("DbAdminWS removeGroupNavigation() check groups if type not LAN_DOMAIN anymore..., ex=" + ex));
            }
        }
        if (lanDomainList.size() > 0 || delGrpList.size() > 0) {
            logger.info((Object)"DbAdminWS removeGroupNavigation() found LAN Domains to remove from DCNM-LAN, notifyDataCenterGroupDeletion()...");
            try {
                Long[] lanDomains = lanDomainList.toArray(new Long[0]);
                Long[] delGrps = delGrpList.toArray(new Long[0]);
                long[] objs = new long[lanDomains.length + delGrps.length];
                int i = 0;
                for (Long lanDomain : lanDomains) {
                    objs[i++] = lanDomain;
                    logger.info((Object)("DbAdminWS removeGroupNavigation(), need to remove group(removed from webclient)=" + lanDomain));
                }
                for (Long lanDomain : delGrps) {
                    objs[i++] = lanDomain;
                    logger.info((Object)("DbAdminWS removeGroupNavigation(), need to remove group(not LAN Domain anymore)=" + lanDomain));
                }
                logger.info((Object)("DbAdminWS removeGroupNavigation() found LAN Domains removed, notifyDataCenterGroupDeletion()... dcnmUser=" + dcnmUser));
                LanWSDelegator.getInstance().notifyDataCenterGroupDeletion(dcnmUser, objs);
            }
            catch (Exception ex) {
                logger.warn((Object)("DbAdminWS removeGroupNavigation(), notifyDataCenterGroupDeletion() ex=" + ex));
            }
        }
        logger.warn((Object)"DbAdminWS removeGroupNavigation() DONE");
        return new CallResultDO(status, errorMessage);
    }

    private HashMap<Long, List<Long>> findGroupIdByMemDbId(Long[] memDbIds) throws Exception {
        logger.info((Object)"DbAdminWS findGroupIdByMemDbId...");
        HashMap<Long, List<Long>> groupMap = new HashMap<Long, List<Long>>();
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            Long[] arr$ = memDbIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                long memDbId = arr$[i$];
                stat = con.prepareStatement(_GetGroupIdByMemDbId);
                stat.setLong(1, memDbId);
                stat.setLong(2, memDbId);
                rs = stat.executeQuery();
                while (rs.next()) {
                    Long parentGrpId = rs.getLong(1);
                    Long neId = rs.getLong(2);
                    List<Long> memberList = groupMap.get(parentGrpId);
                    if (neId == -1L) {
                        logger.warn((Object)("DbAdminWS findGroupidByMemDbId find neId -1 for member/parent=" + memDbId + "/" + rs.getLong(1)));
                        continue;
                    }
                    if (memberList == null) {
                        ArrayList<Long> members = new ArrayList<Long>(0);
                        members.add(neId);
                        logger.info((Object)("DbAdminWS findGroupidByMemDbId group=" + rs.getLong(1)));
                        groupMap.put(parentGrpId, members);
                    } else {
                        memberList.add(neId);
                    }
                    logger.info((Object)("DbAdminWS findGroupidByMemDbId find member/neId/parent=" + memDbId + "/" + rs.getLong(2) + "/" + rs.getLong(1)));
                }
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("DbAdminWS findGroupidByMemDbId ex=" + ex));
            throw ex;
        }
        finally {
            if (rs != null) {
                DbUtil.close(rs);
            }
            if (stat != null) {
                DbUtil.close(stat);
            }
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return groupMap;
    }

    private Long[] findLanSwClassId(String[] dbidStrArr) throws Exception {
        long[] memDbids = new long[dbidStrArr.length];
        int i = 0;
        for (String memDbIdStr : dbidStrArr) {
            long memDbId = Long.parseLong(memDbIdStr.split(":")[0]);
            long origGrpId = Long.parseLong(memDbIdStr.split(":")[1]);
            memDbids[i++] = memDbId;
        }
        Connection con = null;
        PreparedStatement stat = null;
        String query_statement = _GetLanSwClassIdByEthIdSQL;
        ResultSet rs = null;
        ArrayList<Long> neIds = new ArrayList<Long>();
        try {
            con = ConnectionManager.getConnection();
            long[] arr$ = memDbids;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Long lanObj = arr$[i$];
                if (query_statement.length() > _GetLanSwClassIdByEthIdSQL.length()) {
                    query_statement = query_statement + ",";
                }
                query_statement = query_statement + lanObj;
                logger.info((Object)("DbAdminWS findLanSwClassId DB query, eth.id " + lanObj));
            }
            if (query_statement.length() > _GetLanSwClassIdByEthIdSQL.length()) {
                query_statement = query_statement + ")";
                stat = con.prepareStatement(query_statement);
                logger.info((Object)("DbAdminWS findLanSwClassId statement=" + query_statement));
                rs = stat.executeQuery();
                while (rs.next()) {
                    long memDbid = rs.getLong(1);
                    long neId = rs.getLong(2);
                    if (neId == -1L) {
                        logger.warn((Object)("DbAdminWS findLanSwClassId: ethSwitch " + memDbid + " neId -1"));
                        continue;
                    }
                    neIds.add(neId);
                    logger.info((Object)("DbAdminWS findLanSwClassId DB result -> neId/ethDbId=" + neId + "/" + memDbid));
                }
            }
        }
        catch (SQLException ex) {
            logger.warn((Object)("DbAdminWS findLanSwClassId SQLex=" + ex.getMessage()));
            throw new Exception("DbAdminWS findLanSwClassId Failed: " + ex.getMessage());
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return neIds.toArray(new Long[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static int getGroupType(long groupId) throws Exception {
        block12: {
            DbAdminWS.logger.info((Object)("DbAdminWS getGroupType... for group " + groupId));
            con = null;
            stmt = null;
            rs = null;
            type = -1;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement("select type from NAV_GROUPS nav where nav.id = ?");
                stmt.setLong(1, groupId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    type = rs.getInt(1);
                }
                if (rs == null) break block12;
            }
            catch (Exception ex) {
                block13: {
                    try {
                        DbAdminWS.logger.info((Object)("DbAdminWS getGroupType... ex=" + ex));
                        if (rs == null) break block13;
                    }
                    catch (Throwable var7_6) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con != null) {
                            DbUtil.close(con);
                        }
                        throw var7_6;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con != null) {
                    DbUtil.close(con);
                } else {
                    ** GOTO lbl40
                }
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con != null) {
            DbUtil.close(con);
        }
        DbAdminWS.logger.info((Object)("DbAdminWS getGroupType... group/type=" + groupId + '/' + type));
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean isGroupEmpty(long newGroupId) throws Exception {
        block12: {
            DbAdminWS.logger.info((Object)"DbAdminWS isGroupEmpty...");
            con = null;
            stmt = null;
            rs = null;
            isEmpty = true;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement("select count(*) from nav_group_member where group_id = ?");
                stmt.setLong(1, newGroupId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    cnt = rs.getInt(1);
                    v0 = isEmpty = cnt == 0;
                }
                if (rs == null) break block12;
            }
            catch (Exception ex) {
                block13: {
                    try {
                        DbAdminWS.logger.info((Object)("DbAdminWS isGroupEmpty... ex=" + ex));
                        if (rs == null) break block13;
                    }
                    catch (Throwable var8_8) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con != null) {
                            DbUtil.close(con);
                        }
                        throw var8_8;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con != null) {
                    DbUtil.close(con);
                } else {
                    ** GOTO lbl41
                }
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con != null) {
            DbUtil.close(con);
        }
        DbAdminWS.logger.info((Object)("DbAdminWS isGroupEmpty... isEmpty=" + isEmpty));
        return isEmpty;
    }

    @Override
    @WebMethod(operationName="moveLANGroupMember")
    @WebResult(name="result", partName="result")
    public CallResultDO moveLANGroupMember(String[] dbidStrArr, long newParentDbId) throws SanServiceException {
        logger.info((Object)"DbAdminWS moveLANGroupMember...");
        boolean isGroupEmpty = true;
        try {
            isGroupEmpty = this.isGroupEmpty(newParentDbId);
        }
        catch (Exception ex) {
            // empty catch block
        }
        CallResultDO result = DbAdminWS.moveLANGroupMemberGen(dbidStrArr, newParentDbId);
        logger.info((Object)"DbAdminWS moveLANGroupMember DONE with moveLANGroupMembers, going to find aneId to notify LAN server");
        String dcnmUser = IdentityManager.getInstance().getCurrentUsername();
        if (isGroupEmpty) {
            try {
                logger.info((Object)("DbAdminWS moveLANGroupMember(), first becomes LAN Domain, notifyDataCenterGroupCreation()... dcnmUser=" + dcnmUser));
                LanWSDelegator.getInstance().notifyDataCenterGroupCreation(dcnmUser, new long[]{newParentDbId});
            }
            catch (Exception ex) {
                logger.warn((Object)("DbAdminWS moveLANGroupMember, notifyDataCenterGroupCreation failed: " + ex));
            }
        } else {
            try {
                Long[] aneIds = this.findLanSwClassId(dbidStrArr);
                logger.info((Object)("DbAdminWS moveLANGroupMember DONE with moveLANGroupMembers, aneIds length=" + aneIds.length));
                if (aneIds.length > 0) {
                    logger.info((Object)"DbAdminWS moveLANGroupMember DONE with moveLANGroupMembers, going to notify LAN server");
                    long[] objs = new long[aneIds.length];
                    int i = 0;
                    for (Long aneId : aneIds) {
                        objs[i++] = aneId;
                    }
                    logger.info((Object)("DbAdminWS moveLANGroupMember, notifyMemberAddedToGroup()... dcnmUser=" + dcnmUser));
                    LanWSDelegator.getInstance().notifyMemberAddedToGroup(dcnmUser, newParentDbId, objs);
                }
            }
            catch (Exception ex) {
                logger.warn((Object)("DbAdmin WSmoveLANGroupMember, notifyMemberAddedToGroup ex=" + ex));
            }
        }
        logger.info((Object)"DbAdminWS moveLANGroupMember DONE");
        return result;
    }

    public static CallResultDO moveLANGroupMemberGen(String[] dbidStrArr, long newParentDbId) throws SanServiceException {
        int status = 0;
        try {
            long[] memDbids = new long[dbidStrArr.length];
            ArrayList<Long> origGroupList = new ArrayList<Long>();
            int i = 0;
            for (String memDbIdStr : dbidStrArr) {
                long memDbId = Long.parseLong(memDbIdStr.split(":")[0]);
                long origGrpId = Long.parseLong(memDbIdStr.split(":")[1]);
                memDbids[i++] = memDbId;
                if (origGrpId == -1L || origGrpId == 2L || origGrpId == 1L || origGroupList.indexOf(origGrpId) != -1) continue;
                origGroupList.add(origGrpId);
            }
            status = NavigationUtil.getInstance().isLANDomain(newParentDbId);
            if (status == -1) {
                logger.warn((Object)("DbAdminWS group does not exist in moveLANGroupMember():" + newParentDbId + " status=" + status));
                return new CallResultDO(-1, "Failed to assign LAN member, group not available");
            }
            if (status < 0) {
                logger.warn((Object)("DbAdminWS moveLANGroupMember(), group is not LAN domain:" + newParentDbId + " status=" + status));
                return new CallResultDO(-1, "Failed to assign LAN member, group is not LAN domain");
            }
            status = NavigationUtil.getInstance().modifyGroupType(newParentDbId, 1);
            if (status == -1) {
                logger.warn((Object)("DbAdminWS group does not exist in moveLANGroupMember():" + newParentDbId + " status=" + status));
                return new CallResultDO(-1, "Failed to assign LAN member, group not available");
            }
            if (status < 0) {
                logger.warn((Object)("DbAdminWS moveLANGroupMember(), Failed to assign LAN member:" + newParentDbId + " status=" + status));
                return new CallResultDO(-1, "Failed to assign LAN member");
            }
            status = NavigationUtil.getInstance().moveGroupMember(memDbids, newParentDbId);
            if (status < 0) {
                logger.warn((Object)("DbAdminWS moveLANGroupMember(), Failed to move group member:" + newParentDbId + " status=" + status));
                return new CallResultDO(-1, "Failed to assign LAN member");
            }
            for (Long origGrpId : origGroupList) {
                NavigationUtil.getInstance().resetGroupType(origGrpId);
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in moveLANGroupMember():", e);
            return new CallResultDO(-1, e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="moveGroupMember")
    @WebResult(name="result", partName="result")
    public CallResultDO moveGroupMember(long[] memDbids, long newParentDbId) throws SanServiceException {
        logger.info((Object)("DbAdminWS moveGroupMember, newParentDbId=" + newParentDbId));
        for (long memDbid : memDbids) {
            logger.info((Object)("DbAdminWS moveGroupMember, memDbid=" + memDbid));
        }
        int status = 0;
        String errorMessage = "";
        try {
            status = NavigationUtil.getInstance().moveGroupMember(memDbids, newParentDbId);
            logger.info((Object)("DbAdminWS moveGroupMember, NavigationUtil.moveGroupMember status=" + status));
            if (status < 0) {
                errorMessage = "Failed to move group member.";
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in moveGroupMember():", e);
            return new CallResultDO(-1, e.getMessage());
        }
        logger.info((Object)"DbAdminWS moveGroupMember DONE");
        return new CallResultDO(status, errorMessage);
    }

    @Override
    @WebMethod(operationName="addNavGroup")
    @WebResult(name="result", partName="result")
    public long addNavGroup(long parentGroupId, String groupName) throws SanServiceException {
        logger.info((Object)("DbAdminWS addNavGroup..., groupName=" + groupName));
        long newGroupDbid = -1L;
        try {
            newGroupDbid = NavigationUtil.getInstance().addGroup(parentGroupId, groupName);
            logger.info((Object)"DbAdminWS addNavGroup DONE addGroup, going to notify LAN server");
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in addNavGroup():", e);
        }
        logger.info((Object)"DbAdminWS addNavGroup DONE");
        return newGroupDbid;
    }

    @Override
    @WebMethod(operationName="stopAdminService")
    @WebResult(name="result", partName="result")
    public String stopAdminService(DbFilterDO dbFilter, String serverIp, String service) throws SanServiceException {
        if (serverIp == null || serverIp.equals("")) {
            throw new SanServiceException("Please provide server IP");
        }
        if (serverIp == null || serverIp.equals("") || service == null || service.equals("")) {
            throw new SanServiceException("Please provide service name");
        }
        try {
            AdminServiceHandler.getInstance().stopAdminService(dbFilter, serverIp, service);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in stopAdminService():", e);
            throw new SanServiceException("Cannot get all admin services", e);
        }
        return service;
    }

    @Override
    @WebMethod(operationName="getLogTOC")
    @WebResult(name="result", partName="result")
    public String getLogTOC(DbFilterDO dbFilter, String name, String device, String file, String type) throws SanServiceException {
        try {
            return LogViewerHandler.getInstance().getTOC(name);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getLogTOC():", e);
            throw new SanServiceException("Cannot get log TOC", e);
        }
    }

    @Override
    @WebMethod(operationName="getCollections")
    @WebResult(name="result", partName="result")
    public CollectionDO[] getCollections() throws SanServiceException {
        try {
            CollectionDO[] cols = PerformanceHandler.getInstance().getCollections();
            if (cols == null) {
                return new CollectionDO[0];
            }
            return cols;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getCollectionsDoc():", e);
            throw new SanServiceException("Cannot get collections", e);
        }
    }

    @Override
    @WebMethod(operationName="getCollectionPolicies")
    @WebResult(name="result", partName="result")
    public PerformancePolicyDO getCollectionPolicies() throws SanServiceException {
        try {
            return PerformanceHandler.getInstance().getCollectionPolicies();
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getCollectionPolicies():", e);
            throw new SanServiceException("Cannot get collection policies", e);
        }
    }

    @Override
    @WebMethod(operationName="setThresholdPolicies")
    @WebResult(name="pmNeedRestart", partName="pmNeedRestart")
    public boolean setThresholdPolicies(@WebParam(name="autoCollect", partName="autoCollect") boolean autoCollect, @WebParam(name="interpolateMissingStats", partName="interpolateMissingStats") boolean interpolate) throws SanServiceException {
        try {
            boolean pmRequiredRestart = PerformanceHandler.getInstance().setThresholdPolicies(autoCollect, interpolate);
            return pmRequiredRestart;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in setThresholdPolicies():", e);
            throw new SanServiceException("Cannot set threshold policies", e);
        }
    }

    @Override
    @WebMethod(operationName="setAllPMPolicies")
    @WebResult(name="pmNeedRestart", partName="pmNeedRestart")
    public boolean setAllPMPolicies(@WebParam(name="pmPolicy", partName="pmPolicy") PerformancePolicyDO pmPolicy) throws SanServiceException {
        try {
            boolean pmRequiredRestart = PerformanceHandler.getInstance().setAllPMPolicies(pmPolicy);
            return pmRequiredRestart;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in setThresholdPolicies():", e);
            throw new SanServiceException("Cannot set threshold policies", e);
        }
    }

    @Override
    @WebMethod(operationName="updatePMCollection")
    @WebResult(name="pmNeedRestart", partName="pmNeedRestart")
    public boolean updatePMCollection(@WebParam(name="sanSwitchList", partName="sanSwitchList") CollectionDO[] sanSWList, @WebParam(name="collectLanSwitchIdList", partName="collectLanSwitchIdList") String collectLanSWIdList, @WebParam(name="unCollectLanSwitchIdList", partName="unCollectLanSwitchIdList") String unCollectLanSWIdList) throws SanServiceException {
        try {
            boolean pmRequiredRestart = PerformanceHandler.getInstance().updatePMCollection(sanSWList, collectLanSWIdList, unCollectLanSWIdList);
            return pmRequiredRestart;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in updatePMLanCollection():", e);
            throw new SanServiceException("Cannot update PM Collection", e);
        }
    }

    @Override
    @WebMethod(operationName="getMonitoredEthSw")
    @WebResult(name="lanCdpKeys", partName="lanCdpKeys")
    public KeyValueDO[] getMonitoredEthSw(String[] tasks) throws SanServiceException {
        logger.info((Object)"getMonitoredEthSw ....");
        try {
            if (tasks == null || tasks.length == 0) {
                return new KeyValueDO[0];
            }
            ArrayList<KeyValueDO> monitorEthSwList = new ArrayList<KeyValueDO>();
            for (String taskIdString : tasks) {
                logger.info((Object)("getMonitoredEthSw,  check taskId = " + taskIdString));
                long cdpSeedDbId = Long.parseLong(taskIdString);
                List<KeyValueDO> monitoredEthSws = PerformanceHandler.getInstance().getMonitoredEthSw(cdpSeedDbId);
                monitorEthSwList.addAll(monitoredEthSws);
            }
            if (monitorEthSwList.size() == 0) {
                return new KeyValueDO[0];
            }
            KeyValueDO[] ret = new KeyValueDO[monitorEthSwList.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (KeyValueDO)monitorEthSwList.get(i);
            }
            return ret;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getMonitoredEthSw():", e);
            throw new SanServiceException("Cannot get collectible ethSwitch", e);
        }
    }

    @Override
    @WebMethod(operationName="getNotMonitoredFabrics")
    @WebResult(name="fabricKeys", partName="fabricKeys")
    public FabricKeyDO[] getNotMonitoredFabrics() throws SanServiceException {
        try {
            List<CollectionFabrics> fabs = PerformanceHandler.getInstance().getCollectibleFabrics();
            if (fabs == null) {
                return new FabricKeyDO[0];
            }
            FabricKeyDO[] ret = new FabricKeyDO[fabs.size()];
            for (int i = 0; i < ret.length; ++i) {
                FabricKeyDO dto;
                CollectionFabrics fab = fabs.get(i);
                ret[i] = dto = new FabricKeyDO(fab.getFid(), fab.getName());
            }
            return ret;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getCollectibleFabrics():", e);
            throw new SanServiceException("Cannot get collectible fabrics", e);
        }
    }

    @Override
    @WebMethod(operationName="getMonitoredFabrics")
    @WebResult(name="fabricKeys", partName="fabricKeys")
    public FabricKeyDO[] getMonitoredFabrics() throws SanServiceException {
        try {
            List<CollectionFabrics> fabs = PerformanceHandler.getInstance().getCollectedFabrics();
            if (fabs == null) {
                return new FabricKeyDO[0];
            }
            FabricKeyDO[] ret = new FabricKeyDO[fabs.size()];
            for (int i = 0; i < ret.length; ++i) {
                FabricKeyDO dto;
                CollectionFabrics fab = fabs.get(i);
                ret[i] = dto = new FabricKeyDO(fab.getFid(), fab.getName());
            }
            return ret;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getCollectedFabrics():", e);
            throw new SanServiceException("Cannot get collected fabrics", e);
        }
    }

    @Override
    @WebMethod(operationName="removeCollections")
    @WebResult(name="pmNeedRestart", partName="pmNeedRestart")
    public boolean removeCollections(@WebParam(name="fabricKeys", partName="fabricKeys") FabricKeyDO[] keys) throws SanServiceException {
        try {
            return PerformanceHandler.getInstance().removeCollections(keys);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in removeCollections():", e);
            throw new SanServiceException("Cannot set remove collections", e);
        }
    }

    @Override
    @WebMethod(operationName="addCollection")
    @WebResult(name="pmNeedRestart", partName="pmNeedRestart")
    public boolean addCollection(@WebParam(name="policy", partName="policy") CollectionDO item) throws SanServiceException {
        try {
            return PerformanceHandler.getInstance().addCollection(item);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in addCollection():", e);
            throw new SanServiceException("Cannot add collection policy", e);
        }
    }

    @Override
    @WebMethod(operationName="checkoutEvalLicense")
    @WebResult(name="result", partName="result")
    public void checkoutEvalLicense(@WebParam(name="fabricKey", partName="fabricKey") FabricKeyDO fpk, @WebParam(name="snmpV3User", partName="snmpV3User") SnmpCredentialDO cred) throws InvalidCredentialException, SanServiceException {
        if (!cred.isV3()) {
            throw new InvalidCredentialException("Credential must be SNMPv3 credential.");
        }
        try {
            PerformanceHandler.getInstance().checkoutEvalLicSwitches(fpk.toDomain(), cred.toUserOpt());
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in checkoutEvalLicense():", e);
            throw new SanServiceException("Cannot check out eval license", e);
        }
    }

    @Override
    @WebMethod(operationName="getEvalLicenseNotCheckedoutSwitches")
    @WebResult(name="result", partName="result")
    public SwitchDO[] getEvalLicenseNotCheckedoutSwitches(@WebParam(name="fabricKey", partName="fabricKey") FabricKeyDO fpk) throws SanServiceException {
        try {
            List<SwitchBase> switches = PerformanceHandler.getInstance().getAllFMEvalNotCheckedoutSwitches(fpk.toDomain());
            SwitchDO[] ret = new SwitchDO[switches.size()];
            for (int i = 0; i < ret.length; ++i) {
                SwitchDO dto;
                ret[i] = dto = new SwitchDO(switches.get(i));
            }
            return ret;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getEvalLicenseNotCheckedoutSwitches():", e);
            throw new SanServiceException("Cannot get eval-license-not-checked out switches", e);
        }
    }

    @Override
    @WebMethod(operationName="getLicenseFileUsage")
    @WebResult(name="result", partName="result")
    public LicenseInfoFlexDO[] getLicenseFileUsage() throws SanServiceException {
        try {
            FMServerImpl fmServerRif = FMServerImpl.getInstance();
            List<LicenseInfoFlex> licenseFiles = fmServerRif.getFileLicenseInfo();
            Map<String, LicenseFileUsage> licUsageMap = fmServerRif.getFileLicenseUsageInfo();
            LicenseInfoFlexDO[] ret = new LicenseInfoFlexDO[licenseFiles.size()];
            for (int i = 0; i < ret.length; ++i) {
                LicenseInfoFlexDO dto = new LicenseInfoFlexDO(licenseFiles.get(i));
                LicenseFileUsage usage = licUsageMap.get(dto.getSignature());
                dto.setSanUsageCount(-1);
                dto.setLanUsageCount(-1);
                List<Integer> licProductTypes = usage.getProductTypes();
                if (usage != null) {
                    if (licProductTypes.contains(1)) {
                        dto.setSanUsageCount(usage.getUsedSanCount());
                    }
                    if (licProductTypes.contains(2)) {
                        dto.setLanUsageCount(usage.getUsedLanCount());
                    }
                }
                ret[i] = dto;
            }
            return ret;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getLicenseFileUsage():", e);
            throw new SanServiceException("Cannot get file license info.", e);
        }
    }

    @Override
    @WebMethod(operationName="printLicenseFileUsage")
    @WebResult(name="result", partName="result")
    public String printLicenseFileUsage(String title, String[] columnHeader, LicenseInfoFlexDO[] licInfo) throws SanServiceException {
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, Arrays.asList(licInfo));
    }

    @Override
    @WebMethod(operationName="exportLicenseFileUsage")
    @WebResult(name="result", partName="result")
    public String exportLicenseFileUsage(String title, String[] columnHeader, LicenseInfoFlexDO[] licInfo) throws SanServiceException {
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, Arrays.asList(licInfo));
    }

    @Override
    @WebMethod(operationName="getLicenseUsageSummary")
    @WebResult(name="result", partName="result")
    public DBEntryDO getLicenseUsageSummary() throws SanServiceException {
        try {
            FMServerImpl fmServerRif = FMServerImpl.getInstance();
            List<LicenseInfoFlex> licenseFiles = fmServerRif.getFileLicenseInfo();
            Map<String, LicenseFileUsage> licUsageMap = fmServerRif.getFileLicenseUsageInfo();
            int unLicensedSanCount = 0;
            int sanSwitchCount = 0;
            int sanSwitchLicenseNeeded = 0;
            int unLicensedLanCount = 0;
            int lanSwitchCount = 0;
            int lanSwitchLicenseNeeded = 0;
            List<SwitchAssignedLicenseInfo> licenseAssigment = fmServerRif.getLicenseInfoSwitchAssignment();
            for (SwitchAssignedLicenseInfo next : licenseAssigment) {
                if (next.getProductType() == 1) {
                    ++sanSwitchCount;
                    if (next.isLicensed() || !next.isLicenseable()) continue;
                    ++unLicensedSanCount;
                    continue;
                }
                if (next.getProductType() != 2) continue;
                ++lanSwitchCount;
                if (next.isLicensed() || !next.isLicenseable()) continue;
                ++unLicensedLanCount;
            }
            DBEntryDO summaryList = new DBEntryDO();
            summaryList.setColumn(new String[]{"licenseType", "licenseCount", "usedCount", "freeCount", "unLicensedCount", "totalSwitchCount", "neededLicenseCount"});
            DBRowDO[] rlist = new DBRowDO[2];
            int lanUsage = 0;
            int sanUsage = 0;
            int lanDeviceCount = 0;
            int sanDeviceCount = 0;
            HashMap<String, Integer> permanantSanPerPid = new HashMap<String, Integer>();
            HashMap<String, Integer> permanantLanPerPid = new HashMap<String, Integer>();
            for (int i = 0; i < licenseFiles.size(); ++i) {
                LicenseInfoFlex next = licenseFiles.get(i);
                LicenseFileUsage usage = licUsageMap.get(next.getSignature());
                if (usage == null) continue;
                List<Integer> licProductTypes = usage.getProductTypes();
                sanUsage += usage.getUsedSanCount();
                lanUsage += usage.getUsedLanCount();
                if (!next.isEval()) {
                    String pid = next.getPidDeviceStr();
                    if (licProductTypes.contains(1)) {
                        Integer sanPermCountPerPid = (Integer)permanantSanPerPid.get(pid);
                        if (sanPermCountPerPid == null) {
                            sanPermCountPerPid = 0;
                        }
                        sanPermCountPerPid = sanPermCountPerPid + next.getDeviceCount();
                        permanantSanPerPid.put(pid, sanPermCountPerPid);
                    }
                    if (licProductTypes.contains(2)) {
                        Integer lanPermCountPerPid = (Integer)permanantLanPerPid.get(pid);
                        if (lanPermCountPerPid == null) {
                            lanPermCountPerPid = 0;
                        }
                        lanPermCountPerPid = lanPermCountPerPid + next.getDeviceCount();
                        permanantLanPerPid.put(pid, lanPermCountPerPid);
                    }
                }
                if (licProductTypes.contains(1)) {
                    sanDeviceCount += next.getDeviceCount();
                }
                if (!licProductTypes.contains(2)) continue;
                lanDeviceCount += next.getDeviceCount();
            }
            ArrayList<String> chassisKeysAlreadyCounted = new ArrayList<String>();
            for (SwitchAssignedLicenseInfo nextsw : licenseAssigment) {
                Integer count;
                boolean match;
                Integer freeCount;
                String matchingPid;
                Set pids;
                if (!nextsw.isLicenseable()) continue;
                if (nextsw.getProductType() == 1) {
                    if (nextsw.isLicensed() && !nextsw.isLicenseFileType()) continue;
                    pids = permanantSanPerPid.keySet();
                    matchingPid = null;
                    for (String nextPid : pids) {
                        freeCount = (Integer)permanantSanPerPid.get(nextPid);
                        if (freeCount <= 0 || !(match = LicenseValidatorFlexnet.isLicenseForPid(nextPid, nextsw.getSwitchType(), nextsw.getProductType()))) continue;
                        matchingPid = nextPid;
                        break;
                    }
                    if (matchingPid != null) {
                        count = (Integer)permanantSanPerPid.get(matchingPid);
                        count = count - 1;
                        permanantSanPerPid.put(matchingPid, count);
                        continue;
                    }
                    ++sanSwitchLicenseNeeded;
                    continue;
                }
                if (chassisKeysAlreadyCounted.contains(nextsw.getSwitchKey())) continue;
                chassisKeysAlreadyCounted.add(nextsw.getSwitchKey());
                pids = permanantLanPerPid.keySet();
                matchingPid = null;
                for (String nextPid : pids) {
                    freeCount = (Integer)permanantLanPerPid.get(nextPid);
                    if (freeCount <= 0 || !(match = LicenseValidatorFlexnet.isLicenseForPid(nextPid, nextsw.getSwitchType(), nextsw.getProductType()))) continue;
                    matchingPid = nextPid;
                    break;
                }
                if (matchingPid != null) {
                    count = (Integer)permanantLanPerPid.get(matchingPid);
                    count = count - 1;
                    permanantLanPerPid.put(matchingPid, count);
                    continue;
                }
                ++lanSwitchLicenseNeeded;
            }
            DBRowDO sanRow = new DBRowDO();
            sanRow.setEntry(new String[]{"SAN", Integer.toString(sanDeviceCount), Integer.toString(sanUsage), Integer.toString(sanDeviceCount - sanUsage), Integer.toString(unLicensedSanCount), Integer.toString(sanSwitchCount), Integer.toString(sanSwitchLicenseNeeded)});
            rlist[0] = sanRow;
            DBRowDO lanRow = new DBRowDO();
            lanRow.setEntry(new String[]{"LAN", Integer.toString(lanDeviceCount), Integer.toString(lanUsage), Integer.toString(lanDeviceCount - lanUsage), Integer.toString(unLicensedLanCount), Integer.toString(lanSwitchCount), Integer.toString(lanSwitchLicenseNeeded)});
            rlist[1] = lanRow;
            summaryList.setRow(rlist);
            return summaryList;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getLicenseUsageSummary():", e);
            throw new SanServiceException("Cannot get license Usage Summary info.", e);
        }
    }

    @Override
    @WebMethod(operationName="getLicenseHostId")
    @WebResult(name="result", partName="result")
    public String getLicenseHostId() throws SanServiceException {
        try {
            return FMServerImpl.getInstance().getLicenseHostID();
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getLicenseHostId():", e);
            throw new SanServiceException("Cannot get license host Id info.", e);
        }
    }

    @Override
    @WebMethod(operationName="printLicenseAssigmentInfo")
    @WebResult(name="result", partName="result")
    public String printLicenseAssigmentInfo(String title, String[] columnHeader, SwitchAssignedLicenseInfoDO[] assignInfo) throws SanServiceException {
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, Arrays.asList(assignInfo));
    }

    @Override
    @WebMethod(operationName="exportLicenseAssigmentInfo")
    @WebResult(name="result", partName="result")
    public String exportLicenseAssigmentInfo(String title, String[] columnHeader, SwitchAssignedLicenseInfoDO[] assignInfo) throws SanServiceException {
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, Arrays.asList(assignInfo));
    }

    @Override
    @WebMethod(operationName="getLicenseAssigmentInfo")
    @WebResult(name="result", partName="result")
    public SwitchAssignedLicenseInfoDO[] getLicenseAssigmentInfo() throws SanServiceException {
        try {
            FMServerImpl fmServerRif = FMServerImpl.getInstance();
            List<SwitchAssignedLicenseInfo> swLicenses = fmServerRif.getLicenseInfoSwitchAssignment();
            SwitchAssignedLicenseInfoDO[] ret = new SwitchAssignedLicenseInfoDO[swLicenses.size()];
            for (int i = 0; i < ret.length; ++i) {
                SwitchAssignedLicenseInfoDO dto;
                ret[i] = dto = new SwitchAssignedLicenseInfoDO(swLicenses.get(i));
            }
            return ret;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getLicenseFileUsage():", e);
            throw new SanServiceException("Cannot get file license info.", e);
        }
    }

    @Override
    @WebMethod(operationName="assignAvailableLicenseToSwitch")
    @WebResult(name="result", partName="result")
    public SwitchAssignedLicenseInfoDO assignAvailableLicenseToSwitch(long swDbId, int fabOrLanFid, int licenseType) throws SanServiceException {
        try {
            FMServerImpl fmServerRif = FMServerImpl.getInstance();
            SwitchAssignedLicenseInfo assignment = fmServerRif.assignAvailableLicenseToSwitch(swDbId, fabOrLanFid, licenseType);
            return new SwitchAssignedLicenseInfoDO(assignment);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in assignAvailableLicenseToSwitch():", e);
            return new SwitchAssignedLicenseInfoDO(e.getCause());
        }
    }

    @Override
    @WebMethod(operationName="unassignLicenseFromSwitch")
    @WebResult(name="result", partName="result")
    public SwitchAssignedLicenseInfoDO unassignLicenseFromSwitch(long swDbId, int fabOrLanFid, int licenseType) throws SanServiceException {
        try {
            FMServerImpl fmServerRif = FMServerImpl.getInstance();
            SwitchAssignedLicenseInfo assignment = fmServerRif.unassignLicenseFromSwitch(swDbId, fabOrLanFid, licenseType);
            return new SwitchAssignedLicenseInfoDO(assignment);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in unassignLicenseFromSwitch():", e);
            return new SwitchAssignedLicenseInfoDO(e.getCause());
        }
    }

    @Override
    @WebMethod(operationName="saveLicenseFileToServer")
    @WebResult(name="result", partName="result")
    public LicenseCallResultDO saveLicenseFileToServer(String fileContent, String fileName) {
        try {
            FMServerImpl fmServerRif = FMServerImpl.getInstance();
            fmServerRif.saveLicenseFileToServer(fileContent, fileName);
            List<String> filesThatFailedToLoad = fmServerRif.reloadLicenseFiles();
            if (filesThatFailedToLoad.size() > 0) {
                StringBuffer filesList = new StringBuffer();
                filesList.append("The following files didn't load as they were considered invalid.<br/>");
                filesList.append("Possible reasons include: HOSTID didn't match, license expired, file not for this product or the license file was modified.<br/><br/>");
                for (String nextFile : filesThatFailedToLoad) {
                    filesList.append(nextFile).append("<br/>");
                }
                int swCount = FileLicensingHelper.getInstance().getSwitchCount();
                return new LicenseCallResultDO(-1, filesList.toString(), swCount > 0);
            }
            int swCount = FileLicensingHelper.getInstance().getSwitchCount();
            return new LicenseCallResultDO(swCount > 0);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in saveLicenseFileToServer():", e);
            return new LicenseCallResultDO(-1, e.getCause().getMessage(), false);
        }
    }

    @Override
    @WebMethod(operationName="getDefaultLANCredentials")
    @WebResult(name="result", partName="result")
    public CallResultDO getDefaultLANCredentials() {
        try {
            String username = LanReferenceFactory.getInstance().getUserWS(SecurityHandler.getToken()).getDefaultNetworkElementUserCredentials();
            return new CallResultDO(0, username);
        }
        catch (Throwable e) {
            logger.error((Object)"Unable to get Default LAN Credentials ", e);
            return new CallResultDO(-1, "Unable to get default LAN credentials. Please make sure that the LAN server is running: " + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="setDefaultLANCredentials")
    @WebResult(name="result", partName="result")
    public CallResultDO setDefaultLANCredentials(String username, String password, String enablePassword) {
        try {
            LanReferenceFactory.getInstance().getUserWS(SecurityHandler.getToken()).modifyDefaultNetworkElementUserCredentials(username, password, username, enablePassword);
        }
        catch (Exception e) {
            logger.error((Object)"Unable to set Default LAN Credentials ", (Throwable)e);
            return new CallResultDO(-1, "Unable to set default LAN credentials: " + e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="restartPM")
    @WebResult(name="result", partName="result")
    public void retartPM() throws SanServiceException {
        try {
            ArrayList<PMRif> pms = FMServerImpl.getInstance().getClusterProcessor().getPMRifs();
            for (PMRif pm : pms) {
                pm.restart();
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in restartPM():", e);
            throw new SanServiceException("Cannot restart PM", e);
        }
    }

    @Override
    @WebMethod(operationName="getDatabasePolicy")
    @WebResult(name="result", partName="result")
    public PerformanceDBDO getDatabasePolicy() throws SanServiceException {
        try {
            return PerformanceHandler.getInstance().getPerformanceDatabase();
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getDatabasePolicy():", e);
            throw new SanServiceException("Cannot get Performance DB", e);
        }
    }

    @Override
    @WebMethod(operationName="getDatabaseStatus")
    @WebResult(name="result", partName="result")
    public String[] getDatabaseStatus(@WebParam(name="dbPolicy", partName="dbPolicy") PerformanceDBDO bean) throws SanServiceException {
        try {
            List<String> status = PerformanceHandler.getInstance().getDatabaseStatusList(bean);
            if (status == null) {
                return new String[0];
            }
            return status.toArray(new String[0]);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getDatabaseStatus():", e);
            throw new SanServiceException("Cannot get Performance DB Status", e);
        }
    }

    @Override
    @WebMethod(operationName="setDatabasePolicy")
    @WebResult(name="result", partName="result")
    public void setDatabasePolicy(@WebParam(name="dbPolicy", partName="dbPolicy") PerformanceDBDO bean) throws SanServiceException {
        try {
            PerformanceHandler.getInstance().applyDatabasePolicy(bean);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in setDatabasePolicy():", e);
            throw new SanServiceException("Cannot set Performance DB", e);
        }
    }

    @Override
    @WebMethod(operationName="getThresholds")
    @WebResult(name="result", partName="result")
    public PerformanceThresholdDO getThresholds() throws SanServiceException {
        try {
            return PerformanceHandler.getInstance().getThresholdsFromDB();
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getThresholds():", e);
            throw new SanServiceException("Cannot get thresholds from DB", e);
        }
    }

    @Override
    @WebMethod(operationName="setThresholds")
    @WebResult(name="result", partName="result")
    public boolean setThresholds(@WebParam(name="dbPolicy", partName="dbPolicy") PerformanceThresholdDO bean) throws SanServiceException {
        try {
            return PerformanceHandler.getInstance().applyThresholds(bean);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in setThresholds():", e);
            throw new SanServiceException("Cannot set thresholds to DB", e);
        }
    }

    @Override
    @WebMethod(operationName="getOids")
    @WebResult(name="result", partName="result")
    public PerformanceOidDO[] getOids() throws SanServiceException {
        try {
            List<PerformanceOidDO> dto = PerformanceHandler.getInstance().getOidsFromDB();
            if (dto == null) {
                return new PerformanceOidDO[0];
            }
            return dto.toArray(new PerformanceOidDO[0]);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getOids():", e);
            throw new SanServiceException("Cannot get OIDs from DB", e);
        }
    }

    @Override
    @WebMethod(operationName="addOid")
    @WebResult(name="result", partName="result")
    public CallResultDO addOid(PerformanceOidDO oid) throws SanServiceException {
        try {
            boolean ret = PerformanceHandler.getInstance().addOid(oid);
            if (!ret) {
                return new CallResultDO(-1, "Failed to add OID");
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in addOid():", e);
            return new CallResultDO(-1, e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="addOids")
    @WebResult(name="result", partName="result")
    public CallResultDO addOids(PerformanceOidDO[] oid) throws SanServiceException {
        try {
            boolean ret = PerformanceHandler.getInstance().addOids(oid);
            if (!ret) {
                return new CallResultDO(-1, "Failed to add OID");
            }
        }
        catch (Exception e) {
            logger.warn((Object)"DbAdminWS caught exception in addOids():", (Throwable)e);
            return new CallResultDO(-1, e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="removeOids")
    @WebResult(name="result", partName="result")
    public boolean removeOids(PerformanceOidDO[] oids) throws SanServiceException {
        try {
            return PerformanceHandler.getInstance().removeOid(oids);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in removeOids():", e);
            throw new SanServiceException("Cannot remove OID(s)", e);
        }
    }

    @Override
    @WebMethod(operationName="getGroupLicensedSwitchList")
    @WebResult(name="result", partName="result")
    public SwitchNameDO[] getGroupLicensedSwitchList(int type) throws SanServiceException {
        try {
            List<SwitchNameDO> sws = PerformanceHandler.getInstance().getGroupLicensedSwitchList(type);
            if (sws == null) {
                return new SwitchNameDO[0];
            }
            return sws.toArray(new SwitchNameDO[0]);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getGroupLicensedSwitchList():", e);
            throw new SanServiceException("Cannot get Group Licensed Switch List", e);
        }
    }

    @Override
    @WebMethod(operationName="getOidFabrics")
    @WebResult(name="result", partName="result")
    public FabricKeyDO[] getOidFabrics() throws SanServiceException {
        try {
            List<CollectionFabrics> list = PerformanceHandler.getInstance().getFabricListForOid();
            ArrayList<FabricKeyDO> ret = new ArrayList<FabricKeyDO>();
            for (CollectionFabrics fab : list) {
                FabricKeyDO bean = new FabricKeyDO(fab.getFid(), fab.getName());
                ret.add(bean);
            }
            return ret.toArray(new FabricKeyDO[0]);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getOidFabrics():", e);
            throw new SanServiceException("Cannot get oid fabrics", e);
        }
    }

    @Override
    @WebMethod(operationName="getSwitchNamesInFabric")
    @WebResult(name="result", partName="result")
    public SwitchNameDO[] getSwitchNamesInFabric(FabricKeyDO key) throws SanServiceException {
        try {
            List<SwitchNameDO> sws = PerformanceHandler.getInstance().getSwitchNames(key);
            if (sws == null) {
                return new SwitchNameDO[0];
            }
            return sws.toArray(new SwitchNameDO[0]);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getSwitchNamesInFabric():", e);
            throw new SanServiceException("Cannot get switch names", e);
        }
    }

    @Override
    @WebMethod(operationName="getEventStatusList")
    @WebResult(name="result", partName="result")
    public DBEntryDO getEventStatusList() throws SanServiceException {
        return AdminServiceHandler.getInstance().getEventStatusList();
    }

    @Override
    @WebMethod(operationName="getEventSourceList")
    @WebResult(name="result", partName="result")
    public DBEntryDO getEventSourceList() throws SanServiceException {
        return AdminServiceHandler.getInstance().getEventSourceList();
    }

    @Override
    @WebMethod(operationName="getForwarder")
    @WebResult(name="result", partName="result")
    public DBEntryDO getForwarder() throws SanServiceException {
        return AdminServiceHandler.getInstance().getForwarders();
    }

    @Override
    @WebMethod(operationName="removeForwarder")
    @WebResult(name="result", partName="result")
    public CallResultDO removeForwarder(String id, FabricKeyDO fpk) throws SanServiceException {
        FabricPK pk = new FabricPK(fpk.getFid());
        try {
            EMRif em = ClusterProcessor.getInstance().getEMByPK(pk);
            em.removeEventForward(Long.parseLong(id));
        }
        catch (Exception e) {
            logger.warn((Object)"DbAdminWS caught exception in removeForwarder():", (Throwable)e);
            throw new SanServiceException("Cannot removeForwarder", e);
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="getClientList")
    @WebResult(name="result", partName="result")
    public DBEntryDO getClientList(DbFilterDO dbFilter) throws SanServiceException {
        try {
            DBEntryDO clientList = AdminServiceHandler.getInstance().getClientList(dbFilter);
            return clientList;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getClientList():", e);
            throw new SanServiceException("Cannot get all fm clients", e);
        }
    }

    @Override
    @WebMethod(operationName="disconnectClient")
    @WebResult(name="result", partName="result")
    public CallResultDO disconnectClient(String toRemove) throws SanServiceException {
        try {
            FMServerImpl.getInstance().getClusterProcessor().removeSessionById(Integer.parseInt(toRemove));
            return new CallResultDO();
        }
        catch (Exception ex) {
            logger.error((Object)"failed to kill fm client session: ", (Throwable)ex);
            throw new SanServiceException("failed to kill fm client session: ", ex);
        }
    }

    @Override
    @WebMethod(operationName="getCommunityList")
    @WebResult(name="result", partName="result")
    public DBEntryDO getCommunityList(DbFilterDO dbFilter) throws SanServiceException {
        try {
            DBEntryDO communityList = AdminServiceHandler.getInstance().getCommunityList(dbFilter);
            return communityList;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getCommunityList():", e);
            throw new SanServiceException("Cannot get all fm community", e);
        }
    }

    @Override
    @WebMethod(operationName="addCommunity")
    @WebResult(name="result", partName="result")
    public CallResultDO addCommunity(String ipAddress, String community) throws SanServiceException {
        try {
            IscRif isc = FMServerImpl.getInstance().getIsc(StringEncrypter.encryptString("DESede", new Date().toString()));
            if (isc != null) {
                isc.createSnmpCommunity(new SnmpCommunityBase(ipAddress, community, community));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"DbAdminWS caught exception in addCommunity():", (Throwable)e);
            return new CallResultDO(1, "Cannot add Community: " + e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="removeCommunity")
    @WebResult(name="result", partName="result")
    public CallResultDO removeCommunity(String id, String ipAddress, String read, String write) throws SanServiceException {
        try {
            IscRif isc = FMServerImpl.getInstance().getIsc(StringEncrypter.encryptString("DESede", new Date().toString()));
            if (isc != null) {
                isc.deleteSnmpCommunity(new SnmpCommunityBase(Long.parseLong(id), ipAddress, read, write));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"DbAdminWS caught exception in removeCommunity():", (Throwable)e);
            return new CallResultDO(1, "Cannot remove Community: " + e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="getLocalUserList")
    @WebResult(name="result", partName="result")
    public DBEntryDO getLocalUserList(DbFilterDO dbFilter) throws SanServiceException {
        try {
            DBEntryDO userList = AdminServiceHandler.getInstance().getLocalUserList(dbFilter);
            return userList;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getLocalUserList():", e);
            throw new SanServiceException("Cannot get all local users", e);
        }
    }

    @Override
    @WebMethod(operationName="getRoles")
    @WebResult(name="result", partName="result")
    public DBEntryDO getRoleNames(DbFilterDO dbFilter) throws SanServiceException {
        try {
            DBEntryDO roleList = new DBEntryDO();
            roleList.setColumn(new String[]{"role"});
            ArrayList<DBRowDO> rlist = new ArrayList<DBRowDO>();
            try {
                ArrayList<String> roles = UserManager.getAllRoles();
                if (roles != null) {
                    for (int i = 0; i < roles.size(); ++i) {
                        DBRowDO row = new DBRowDO();
                        row.setEntry(new String[]{roles.get(i)});
                        rlist.add(row);
                    }
                }
            }
            catch (Exception ex) {
                return new DBEntryDO(1, "Cannot get roles: " + ex);
            }
            roleList.setRow(rlist.toArray(new DBRowDO[0]));
            return roleList;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getRoles():", e);
            throw new SanServiceException("Cannot get all roles", e);
        }
    }

    @Override
    @WebMethod(operationName="addUser")
    @WebResult(name="result", partName="result")
    public CallResultDO addUser(String userName, String password, String roleName) throws SanServiceException {
        try {
            String mode = SecurityManager.getInstance().getAuthMode();
            if (mode != null && !mode.equalsIgnoreCase("local")) {
                throw new Exception("The security mode is not local");
            }
            UserManager.getInstance();
            int ret = UserManager.createUserInDB(userName, StringEncrypter.DESedeEncrypt(password), roleName, IdentityManager.getInstance().getCurrentUsername());
            if (ret == 0) {
                return new CallResultDO(1, "User already exists.");
            }
            if (ret == -1) {
                return new CallResultDO(1, "Failed to add user: other errors");
            }
        }
        catch (Exception e) {
            logger.warn((Object)"DbAdminWS caught exception in addUser():", (Throwable)e);
            return new CallResultDO(1, "Cannot add user: " + e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="changeCurrentUsersPassword")
    @WebResult(name="result", partName="result")
    public CallResultDO changeCurrentUsersPassword(String plainTextPassword) {
        String currentUser = "";
        try {
            currentUser = IdentityManager.getInstance().getCurrentUsername();
            String password = StringEncrypter.DESedeEncrypt(plainTextPassword);
            boolean updatePwdOk = UserManager.getInstance().updateUser(currentUser, password);
            if (updatePwdOk) {
                return new CallResultDO();
            }
            logger.warn((Object)("DbAdminWS updateUser(), failed to update password for user " + currentUser));
            return new CallResultDO(1, "Failed to update password for user " + currentUser);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to update password for user " + currentUser), (Throwable)e);
            return new CallResultDO(-1, "Failed to update password for user " + currentUser + ": " + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="modifyUser")
    @WebResult(name="result", partName="result")
    public CallResultDO modifyUser(String userName, String password, String roleName) throws SanServiceException {
        try {
            password = StringEncrypter.DESedeEncrypt(password);
        }
        catch (Exception e) {
            throw new SanServiceException(e.getMessage());
        }
        boolean updatePwdOk = UserManager.getInstance().updateUser(userName, password);
        UserManager.getInstance();
        boolean updateRoleOk = UserManager.updateRoleForUser(roleName, userName);
        if (updatePwdOk && updateRoleOk) {
            return new CallResultDO();
        }
        if (!updatePwdOk) {
            logger.warn((Object)("DbAdminWS updateUser(), failed to update password for user " + userName));
            return new CallResultDO(1, "Failed to update password for user " + userName);
        }
        logger.warn((Object)("DbAdminWS updateUser(), failed to update role/user " + userName + "/" + roleName));
        return new CallResultDO(1, "Failed to update role/user " + userName + "/" + roleName);
    }

    @Override
    @WebMethod(operationName="removeUser")
    @WebResult(name="result", partName="result")
    public CallResultDO removeUser(String userName) throws SanServiceException {
        boolean result = false;
        try {
            result = UserManager.getInstance().deleteUser(userName, IdentityManager.getInstance().getCurrentUsername());
        }
        catch (Exception e) {
            logger.warn((Object)"DbAdminWS caught exception in removeUser():", (Throwable)e);
            return new CallResultDO(1, "Cannot remove user: " + e.getMessage());
        }
        if (result) {
            return new CallResultDO();
        }
        return new CallResultDO(1, "Failed to remove user.  Verify user is not logged in and try again.");
    }

    @Override
    @WebMethod(operationName="resetFailedAttempt4User")
    @WebResult(name="result", partName="result")
    public CallResultDO resetFailedAttempt4User(String userName) throws SanServiceException {
        try {
            FMUserFailedAttempts.getInstance().purgeFailedAttempt(userName);
        }
        catch (Exception e) {
            logger.warn((Object)"DbAdminWS caught exception in resetFailedAttempt4User():", (Throwable)e);
            return new CallResultDO(1, "Cannot reset failed attempt for user: " + e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="getRoles")
    @WebResult(name="result", partName="result")
    public DBEntryDO getRoles(DbFilterDO dbFilter) throws SanServiceException {
        try {
            DBEntryDO roleList = AdminServiceHandler.getInstance().getRoles(dbFilter);
            return roleList;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getRoles():", e);
            throw new SanServiceException("Cannot get all roles", e);
        }
    }

    @Override
    @WebMethod(operationName="addRole")
    @WebResult(name="result", partName="result")
    public CallResultDO addRole(String roleName, String[] fabrics) throws SanServiceException {
        try {
            UserManager.getInstance();
            boolean isNewRole = UserManager.addRole(roleName);
            if (!isNewRole) {
                return new CallResultDO(1, "Role already exists.");
            }
            ArrayList<Long> fabricList = null;
            if (fabrics != null && (fabricList = new ArrayList<Long>(fabrics.length)) != null) {
                for (int i = 0; i < fabrics.length; ++i) {
                    fabricList.add(new Long(Long.parseLong(fabrics[i])));
                }
            }
            UserManager.getInstance();
            UserManager.addFabricsToRole(roleName, fabricList);
        }
        catch (Exception e) {
            logger.warn((Object)"DbAdminWS caught exception in addRole():", (Throwable)e);
            return new CallResultDO(1, "Cannot add Role: " + e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="removeRole")
    @WebResult(name="result", partName="result")
    public CallResultDO removeRole(String roleName) throws SanServiceException {
        try {
            UserManager.getInstance();
            UserManager.deleteRole(roleName);
        }
        catch (Exception e) {
            logger.warn((Object)"DbAdminWS caught exception in removeRole():", (Throwable)e);
            return new CallResultDO(1, "Cannot remove role: " + e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="getServerPropertiesByKey")
    @WebResult(name="result", partName="result")
    public DBEntryDO getServerPropertiesByKey(String[] keys) throws SanServiceException {
        try {
            DBEntryDO serverProperties = AdminServiceHandler.getInstance().getServerProperties(keys);
            return serverProperties;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getServerProperties():", e);
            throw new SanServiceException("Cannot get server properties", e);
        }
    }

    @Override
    @WebMethod(operationName="getServerProperties")
    @WebResult(name="result", partName="result")
    public DBEntryDO getServerProperties(DbFilterDO dbFilter) throws SanServiceException {
        try {
            DBEntryDO serverProperties = AdminServiceHandler.getInstance().getServerProperties(dbFilter, false);
            return serverProperties;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getServerProperties():", e);
            throw new SanServiceException("Cannot get server properties", e);
        }
    }

    @Override
    @WebMethod(operationName="getAAAProperties")
    @WebResult(name="result", partName="result")
    public DBEntryDO getAAAProperties(DbFilterDO dbFilter) throws SanServiceException {
        try {
            DBEntryDO aaaProperties = AdminServiceHandler.getInstance().getServerProperties(dbFilter, true);
            return aaaProperties;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getAAAProperties():", e);
            throw new SanServiceException("Cannot get AAA properties", e);
        }
    }

    private List<Long> parseList(String excludedSwList) {
        if (excludedSwList == null || excludedSwList.equals("")) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        StringTokenizer st = new StringTokenizer(excludedSwList, ",", false);
        while (st.hasMoreTokens()) {
            String sw = st.nextToken().trim();
            list.add(new Long(Long.parseLong(sw)));
        }
        return list;
    }

    @Override
    @WebMethod(operationName="updateServerProperties")
    @WebResult(name="result", partName="result")
    public CallResultDO updateServerProperties(String[] keys, String[] values) throws SanServiceException {
        String resultStr = "";
        try {
            logger.info((Object)"DbAdminWS updateServerProperties, updateServerProperties...");
            resultStr = WebUtil.updateServerProperties(keys, values);
        }
        catch (Exception ex) {
            logger.info((Object)("DbAdminWS updateServerProperties ex " + ex.getMessage()));
            throw new SanServiceException(ex.getMessage());
        }
        logger.info((Object)("DbAdminWS updateServerProperties DONE, resultStr=" + resultStr));
        if (resultStr != null && resultStr.length() > 0) {
            return new CallResultDO(1, resultStr);
        }
        return new CallResultDO();
    }

    private FMServerRif getFMServer(String server) {
        FMServerRif fmRif = null;
        String defaultRmiPort = System.getProperty("server.port", "4447");
        if (server == null || server.equals("")) {
            server = "localhost";
        }
        int rmiPort = Integer.parseInt(defaultRmiPort);
        try {
            EjbRegistryIf rif = WebReferenceManager.getInstance().getLocalRef();
            String localServer = rif.getFMServer().whereami();
            if (rif != null) {
                fmRif = server.equals("localhost") || localServer.equals(server) ? rif.getFMServer() : (FMServerRif)rif.getRemoteService(server, "FMServerBean");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fmRif;
    }

    @Override
    @WebMethod(operationName="getFileTransferConfig")
    @WebResult(name="result", partName="result")
    public SftpCredentialDO getFileTransferConfig() throws SanServiceException {
        SftpCredentialDO ft = new SftpCredentialDO();
        String[] data = null;
        try {
            data = BackUpConfiguration.getBackupServerData();
            ft.setUsername(data[1] == null ? "" : data[1]);
            ft.setPassword(data[2] == null ? "" : data[2]);
            ft.setIsWindowsOS(data[4]);
            ft.setHomeDir(data[3] == null || data[3].toString().trim().length() == 0 ? (ft.getIsWindowsOS().equals("true") ? "" : "/") : data[3]);
            ft.setServerType(data[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ft;
    }

    @Override
    @WebMethod(operationName="setFileTransferConfig")
    @WebResult(name="result", partName="result")
    public void setFileTransferConfig(SftpCredentialDO ft) throws SanServiceException {
        if (ft == null) {
            throw new InvalidArgumentException("Argument cannot be null");
        }
        String encryptedP = null;
        String homeDir = null;
        String usrName = null;
        ArrayList<PropertyWrapper> propsList = ServerPropertyUtil.readServerProperties();
        String serverType = ft.getServerType();
        if (Integer.parseInt(serverType) == 3) {
            if (ft.getUsername() == null || ft.getUsername().trim().equals("")) {
                throw new InvalidArgumentException("Username cannot be empty or null");
            }
            if (ft.getPassword() == null || ft.getPassword().trim().equals("")) {
                throw new InvalidArgumentException("Password cannot be empty or null");
            }
            if (ft.getHomeDir() == null || ft.getHomeDir().trim().equals("")) {
                throw new InvalidArgumentException("Server cannot be empty or null");
            }
            try {
                encryptedP = "#" + JBoss_4_2Encrypter.encrypt(ft.getPassword());
            }
            catch (Exception e) {
                logger.error((Object)("Unable to encrypt password: " + e.getMessage()));
                throw new SanServiceException("Unable to encrypt password: " + e.getMessage());
            }
            homeDir = ft.getHomeDir();
            usrName = ft.getUsername();
            this.updateProperties(SftpCredentialDO.SERVER_HOMEDIR_PROP, homeDir, propsList);
            this.updateProperties(SftpCredentialDO.SERVER_USERNAME_PROP, usrName, propsList);
            this.updateProperties(SftpCredentialDO.SERVER_PASSWORD_PROP, encryptedP, propsList);
            this.updateProperties(SftpCredentialDO.HOMEDIR_PROP, null, propsList);
            this.updateProperties(SftpCredentialDO.USERNAME_PROP, null, propsList);
            this.updateProperties(SftpCredentialDO.PASSWORD_PROP, null, propsList);
        }
        this.updateProperties(SftpCredentialDO.PROTOCOL_PROP, serverType, propsList);
        ServerPropertyUtil.storeServerProperties(propsList, true);
        this.updateOtherServers();
        if (Integer.parseInt(serverType) == 3) {
            System.setProperty(SftpCredentialDO.HOMEDIR_PROP, homeDir);
            System.setProperty(SftpCredentialDO.USERNAME_PROP, usrName);
            System.setProperty(SftpCredentialDO.PASSWORD_PROP, encryptedP);
        }
        System.setProperty(SftpCredentialDO.PROTOCOL_PROP, serverType);
    }

    private void updateOtherServers() {
        List<FMServerRif> servers = ClusterProcessor.getInstance().getFMServers();
        for (FMServerRif fms : servers) {
            try {
                logger.warn((Object)("notifying update to server " + fms.getCurrentServerIP()));
                fms.prefUpdated();
            }
            catch (Exception ex) {
                logger.error((Object)("Unable to notify properties change: " + ex.getMessage()));
            }
        }
    }

    private void updateProperties(String key, String value, ArrayList<PropertyWrapper> propsList) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        PropertyWrapper prop = null;
        prop = ServerPropertyUtil.getProperty(key, propsList);
        if (prop == null) {
            prop = new PropertyWrapper(key, value);
            propsList.add(prop);
        } else {
            prop.setValue(value);
            ServerPropertyUtil.setProperty(key, prop, propsList);
        }
    }

    @Override
    @WebMethod(operationName="testAAAServer")
    @WebResult(name="result", partName="result")
    public CallResultDO testAAAServer(String aaaMode, String aaaServer, String aaaSecret, String authMode, String radiusAuthPort, String radiusActPort, String tacacsPort, String ldapPortToTest, String ldapSslEnableToTest, String ldapBaseDNToTest, String ldapFilterToTest, String ldapRoleAttributeToTest, String ldapRoleAdminGrpToTest, String fmGrpToTest, String user, String password) throws SanServiceException {
        StringBuffer result = new StringBuffer();
        try {
            try {
                InetAddress.getByName(aaaServer);
            }
            catch (Exception ex) {
                return new CallResultDO(1, "Invalid server address");
            }
            AuthTest aaaTest = new AuthTest();
            if (aaaMode.equals("radius")) {
                aaaTest.setRadiusInfo(aaaServer, aaaSecret, Integer.parseInt(radiusAuthPort), Integer.parseInt(radiusActPort), authMode);
                aaaTest.setUserInfo(user, password);
                aaaTest.doRadiusAuthentication(true);
            } else if (aaaMode.equals("tacacs")) {
                aaaTest.setTacacsInfo(aaaServer, aaaSecret, Integer.parseInt(tacacsPort), authMode);
                aaaTest.setUserInfo(user, password);
                aaaTest.doTacacsAthentication(true);
            } else if (aaaMode.equals("ldap")) {
                boolean isEnable = ldapSslEnableToTest.equals("true");
                aaaTest.setLdapInfo(aaaServer, Integer.parseInt(ldapPortToTest), isEnable, ldapBaseDNToTest, ldapFilterToTest, ldapRoleAttributeToTest, ldapRoleAdminGrpToTest, fmGrpToTest);
                aaaTest.setUserInfo(user, password);
                aaaTest.doLdapAthentication();
            } else {
                return new CallResultDO(1, "Only Radius, Tacacs+ and LDAP supported.");
            }
            String avPair = aaaTest.getAVPair();
            result.append(avPair);
        }
        catch (Exception ex) {
            return new CallResultDO(1, ex.getMessage());
        }
        return new CallResultDO(0, result.toString());
    }

    @Override
    @WebMethod(operationName="printAdminDBEntryDOPage")
    @WebResult(name="result", partName="result")
    public String printAdminDBEntryDOPage(String title, String[] columnHeader, DBEntryDO[] gridInfo) throws SanServiceException {
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, Arrays.asList(gridInfo));
    }

    @Override
    @WebMethod(operationName="exportAdminDBEntryDO")
    @WebResult(name="result", partName="result")
    public String exportAdminDBEntryDO(String title, String[] columnHeader, DBEntryDO[] gridInfo) throws SanServiceException {
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, Arrays.asList(gridInfo));
    }

    @Override
    @WebMethod(operationName="getEventSuppressors")
    @WebResult(name="result", partName="result")
    public DBEntryDO getEventSuppressors() throws SanServiceException {
        try {
            DBEntryDO suppressors = EventSummaryHandler.getInstance().getEventSuppressors();
            return suppressors;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbAdminWS caught exception in getEventSuppressors():", e);
            throw new SanServiceException("Cannot get all event suppressors", e);
        }
    }

    @Override
    @WebMethod(operationName="addEventSuppressor")
    @WebResult(name="result", partName="result")
    public CallResultDO addEventSuppressor(String switchName, String facility, String type, String desc) throws SanServiceException {
        try {
            boolean ret = EventSummaryHandler.getInstance().addEventSuppressor(switchName, facility, type, desc);
            if (!ret) {
                return new CallResultDO(1, "Cannot add suppressor.");
            }
        }
        catch (Exception e) {
            logger.warn((Object)"DbAdminWS caught exception in addEventSuppressor():", (Throwable)e);
            return new CallResultDO(1, "Cannot add suppressor: " + e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="modifyEventSuppressor")
    @WebResult(name="result", partName="result")
    public CallResultDO modifyEventSuppressor(String[] indices, String switchIp, String facility, String type, String desc) throws SanServiceException {
        boolean ret = EventSummaryHandler.getInstance().modifyEventSuppressor(indices, switchIp, facility, type, desc);
        if (ret) {
            return new CallResultDO();
        }
        logger.warn((Object)"DbAdminWS modifyEventSuppressor(), failed to update suppressor");
        return new CallResultDO(1, "Failed to update suppressor");
    }

    @Override
    @WebMethod(operationName="deleteEventSuppressors")
    @WebResult(name="result", partName="result")
    public CallResultDO deleteEventSuppressors(String[] indices) throws SanServiceException {
        boolean ret = EventSummaryHandler.getInstance().deleteEventSuppressors(indices);
        if (ret) {
            return new CallResultDO();
        }
        return new CallResultDO(1, "Failed to remove event suppressor(s).");
    }

    public static void main(String[] strArgs) {
        String mode = SecurityManager.getInstance().getAuthMode();
        System.out.println(mode);
        if (mode != null && !mode.equalsIgnoreCase("local")) {
            try {
                throw new Exception("The security mode is not local");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

