/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.jaxws.ep.SanNotFoundException;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.san.ep.DbHealthSEI;
import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.jaxws.san.wo.HostRedundancyErrorDO;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.jaxws.wo.NameValueDO;
import com.cisco.dcbu.lib.util.PropertyWrapper;
import com.cisco.dcbu.sm.common.model.NavBase;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.hostredundancy.HostRedundancyCheck;
import com.cisco.dcbu.sm.server.hostredundancy.HostRedundancyError;
import com.cisco.dcbu.sm.server.hostredundancy.HostRedundancyIgnoredHost;
import com.cisco.dcbu.sm.server.hostredundancy.HostRedundancySummary;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.security.ServerPropertyUtil;
import com.cisco.dcbu.sm.server.web.health.AccountingHandler;
import com.cisco.dcbu.sm.server.web.health.EventHandler;
import com.cisco.dcbu.sm.server.web.health.EventSummaryHandler;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperReportBuilder;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.WebUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.persistence.Transient;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/DbHealthWSService", urlPattern="/DbHealthWS")
@WebService(name="DbHealthWS", serviceName="DbHealthService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.DbHealthSEI")
@Stateless
public class DbHealthWS
implements DbHealthSEI {
    @Transient
    static Logger logger = LogManager.getLogger((String)"fms.ws");

    @Override
    @WebMethod(operationName="getFabricSwitchNavECHInXml")
    @WebResult(name="result", partName="result")
    public String getNavigationECHInXml() throws SanServiceException {
        try {
            return WebUtil.getFabricSwitchNavECHInXml();
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in getFabricSwitchNavECHInXml():", e);
            throw new SanServiceException("Cannot getFabricSwitchNavECHInXml:", e);
        }
    }

    @Override
    @WebMethod(operationName="getNavigationInXml")
    @WebResult(name="result", partName="result")
    public String getNavigationInXml() throws SanServiceException {
        try {
            return WebUtil.getFabricSwitchNavInXml();
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in getFabricSwitchNavInXml():", e);
            throw new SanServiceException("Cannot getFabricSwitchNavInXml:", e);
        }
    }

    @Override
    @WebMethod(operationName="getFabricEventList")
    @WebResult(name="result", partName="result")
    public DBEntryDO getFabricEventList(DbFilterDO dbFilter, String severity, String interval, String type, int startIdx, int recordSize) throws SanServiceException, SanNotFoundException {
        try {
            DbHealthWS.parseFilters(dbFilter);
            DBEntryDO list = EventSummaryHandler.getInstance().getList(dbFilter, severity, interval, type, startIdx, recordSize);
            if (list == null) {
                throw new SanNotFoundException("Could not fetch Fabric Event List");
            }
            return list;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"DbHealthWS caught exception in getFabricEventList():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in getFabricEventList():", e);
            throw new SanServiceException("Cannot get all license in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="getFabricEventDataLength")
    @WebResult(name="result", partName="result")
    public int getFabricEventDataLength(DbFilterDO dbFilter, String severity, String interval, String type) throws SanServiceException {
        try {
            DbHealthWS.parseFilters(dbFilter);
            return EventSummaryHandler.getInstance().getDataLength(dbFilter, severity, interval, type);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in getFabricEventDataLength():", e);
            throw new SanServiceException("Cannot get all fabric event data length in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="checkNewEvents")
    @WebResult(name="result", partName="result")
    public int checkNewEvents(DbFilterDO dbFilter) throws SanServiceException {
        try {
            return EventSummaryHandler.getInstance().checkNewEvents(dbFilter);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in checkNewEvents():", e);
            throw new SanServiceException("Failed to check for new events", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void parseFilters(DbFilterDO dbFilter) {
        block10: {
            block11: {
                long navId;
                int navType;
                block12: {
                    dbFilter.setGroupId(-1L);
                    NavBase select = NavigationUtil.getInstance().getNavSelection(dbFilter.getGroupFilterXml());
                    if (select == null) break block11;
                    navType = select.getNavType();
                    navId = select.getMemDbId();
                    if (navType != 2) break block12;
                    dbFilter.setGroupId(navId);
                    break block10;
                }
                if (navType == 0) {
                    dbFilter.setFabricDbId(navId);
                    break block10;
                } else if (navType == 1) {
                    dbFilter.setDcType(1);
                    dbFilter.setGroupId(navId);
                    break block10;
                } else if (navType != 4) {
                    // empty if block
                }
                break block10;
            }
            if (dbFilter.getNetworkType() != null) {
                if (dbFilter.getNetworkType().equals("SAN")) {
                    dbFilter.setDcType(0);
                } else if (dbFilter.getNetworkType().equals("LAN")) {
                    dbFilter.setDcType(1);
                }
            }
        }
        if (dbFilter.getNetworkType() != null && dbFilter.getNetworkType().equals("LAN")) {
            dbFilter.setDcType(1);
        }
    }

    @Override
    @WebMethod(operationName="getEventSummary")
    @WebResult(name="result", partName="result")
    public NameValueDO[] getEventSummary(DbFilterDO dbFilter, String severity, String interval, String type) throws SanServiceException {
        try {
            return EventSummaryHandler.getInstance().getEventSummary(dbFilter, severity, interval, type);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in getEventSummary():", e);
            throw new SanServiceException("Cannot get EventSummary in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="getSyslogEventList")
    @WebResult(name="result", partName="result")
    public DBEntryDO getSyslogEventList(DbFilterDO dbFilter, int startIdx, int recordSize) throws SanServiceException, SanNotFoundException {
        try {
            DBEntryDO list = EventHandler.getInstance().getList(dbFilter, startIdx, recordSize);
            if (list == null) {
                throw new SanNotFoundException("Couldn't get SyslogEventList");
            }
            return list;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"DbHealthWS caught exception in getSyslogEventList():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in getSyslogEventList():", e);
            throw new SanServiceException("Cannot get all license in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="getSyslogEventDataLength")
    @WebResult(name="result", partName="result")
    public int getSyslogEventDataLength(DbFilterDO dbFilter) throws SanServiceException {
        try {
            return EventHandler.getInstance().getDataLength(dbFilter);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in getSyslogEventDataLength():", e);
            throw new SanServiceException("Cannot get all fabric event data length in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="getSwitchSyslogEventList")
    @WebResult(name="result", partName="result")
    public DBEntryDO getSwitchSyslogEventList(DbFilterDO dbFilter, String name, String device, String file, String type) throws SanServiceException, SanNotFoundException {
        try {
            DBEntryDO list = EventHandler.getInstance().getSwitchList(dbFilter, name, device, file, type);
            if (list == null) {
                throw new SanNotFoundException("Could not get switch syslog");
            }
            return list;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"DbHealthWS caught exception in getSyslogEventList():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in getSyslogEventList():", e);
            throw new SanServiceException("Cannot get all license in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="getSwitchSyslogEventDataLength")
    @WebResult(name="result", partName="result")
    public int getSwitchSyslogEventDataLength(DbFilterDO dbFilter, String name, String device, String file, String type) throws SanServiceException {
        try {
            return EventHandler.getInstance().getSwitchListDataLength(dbFilter, name, device, file, type);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in getSyslogEventDataLength():", e);
            throw new SanServiceException("Cannot get all fabric event data length in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="getAccountingList")
    @WebResult(name="result", partName="result")
    public DBEntryDO getAccountingList(DbFilterDO dbFilter, String severity, String interval, String type, int startIdx, int recordSize) throws SanServiceException, SanNotFoundException {
        try {
            DbHealthWS.parseFilters(dbFilter);
            DBEntryDO list = AccountingHandler.getInstance().getList(dbFilter, severity, interval, type, startIdx, recordSize);
            if (list == null) {
                throw new SanNotFoundException("Couldn't get AccountingList");
            }
            return list;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"DbHealthWS caught exception in getSyslogEventList():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in getAccountingList():", e);
            throw new SanServiceException("Cannot get all license in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="getAccountingDataLength")
    @WebResult(name="result", partName="result")
    public int getAccountingDataLength(DbFilterDO dbFilter, String severity, String interval, String type) throws SanServiceException {
        try {
            DbHealthWS.parseFilters(dbFilter);
            return AccountingHandler.getInstance().getDataLength(dbFilter, severity, interval, type);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in getAccountingDataLength():", e);
            throw new SanServiceException("Cannot get all fabric event data length in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="addEventSuppressor")
    @WebResult(name="result", partName="result")
    public CallResultDO addEventSuppressor(String switchName, String facility, String type, String desc) throws SanServiceException {
        try {
            boolean ret = EventSummaryHandler.getInstance().addEventSuppressor(switchName, facility, type, desc);
            if (!ret) {
                return new CallResultDO(1, "Cannot add suppressor.");
            }
        }
        catch (Exception e) {
            logger.warn((Object)"DbHealthWS caught exception in addEventSuppressor():", (Throwable)e);
            return new CallResultDO(1, "Cannot add suppressor: " + e.getMessage());
        }
        return new CallResultDO();
    }

    @Override
    @WebMethod(operationName="setAckFabricEvent")
    @WebResult(name="result", partName="result")
    public void setAckFabricEvent(String[] indices) throws SanServiceException {
        try {
            EventSummaryHandler.getInstance().setAckFabricEvent(indices);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in setAckFabricEvent():", e);
            throw new SanServiceException("Cannot set event acknowledge in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="clearAckFabricEvent")
    @WebResult(name="result", partName="result")
    public void clearAckFabricEvent(String[] indices) throws SanServiceException {
        try {
            EventSummaryHandler.getInstance().clearAckFabricEvent(indices);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in clearAckFabricEvent():", e);
            throw new SanServiceException("Cannot clear event acknowledge in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="deleteFabricEvent")
    @WebResult(name="result", partName="result")
    public void deleteFabricEvent(String[] indices) throws SanServiceException {
        try {
            EventSummaryHandler.getInstance().deleteFabricEvent(indices);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in deleteFabricEvent():", e);
            throw new SanServiceException("Cannot delete events", e);
        }
    }

    @Override
    @WebMethod(operationName="deleteAllEvent")
    @WebResult(name="result", partName="result")
    public void deleteAllEvent(DbFilterDO dbFilter, String sevFilter, String intervalFilter, String typeFilter) throws SanServiceException {
        try {
            DbHealthWS.parseFilters(dbFilter);
            EventSummaryHandler.getInstance().deleteAllEvent(dbFilter, sevFilter, intervalFilter, typeFilter);
        }
        catch (Exception e) {
            logger.warn((Object)"DbHealthWS caught exception in deleteAllEvent():", (Throwable)e);
            throw new SanServiceException("Cannot delete events", e);
        }
    }

    @Override
    @WebMethod(operationName="deleteAccountingEvent")
    @WebResult(name="result", partName="result")
    public void deleteAccountingEvent(String[] indices) throws SanServiceException {
        try {
            AccountingHandler.getInstance().deleteAccountingEvent(indices);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in deleteAccountingEvent():", e);
            throw new SanServiceException("Cannot delete events", e);
        }
    }

    @Override
    @WebMethod(operationName="deleteAccountingAllEvent")
    @WebResult(name="result", partName="result")
    public void deleteAccountingAllEvent(DbFilterDO dbFilter, String sevFilter, String intervalFilter, String typeFilter) throws SanServiceException {
        try {
            DbHealthWS.parseFilters(dbFilter);
            AccountingHandler.getInstance().deleteAccountingAllEvent(dbFilter, sevFilter, intervalFilter, typeFilter);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in deleteAccountingAllEvent():", e);
            throw new SanServiceException("Cannot delete events", e);
        }
    }

    @Override
    public String printEventTable(DbFilterDO dbFilter, String severity, String interval, String type, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            DbHealthWS.parseFilters(dbFilter);
            return EventSummaryHandler.getInstance().printEventTable(dbFilter, severity, interval, type, startIdx, recordSize, columnHeader);
        }
        catch (Exception e) {
            logger.warn((Object)"DbHealtWS caught exception in printEventTable():", (Throwable)e);
            throw new SanServiceException("Cannot print events", e);
        }
    }

    @Override
    public String exportEventTable(DbFilterDO dbFilter, String severity, String interval, String type, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            DbHealthWS.parseFilters(dbFilter);
            return EventSummaryHandler.getInstance().exportEventTable(dbFilter, severity, interval, type, startIdx, recordSize, columnHeader);
        }
        catch (Exception e) {
            logger.warn((Object)"DbHealthWS caught exception in exportEventTable():", (Throwable)e);
            throw new SanServiceException("Cannot export events", e);
        }
    }

    @Override
    public String printAccountingTable(DbFilterDO dbFilter, String severity, String interval, String type, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            DbHealthWS.parseFilters(dbFilter);
            return AccountingHandler.getInstance().printAccountingTable(dbFilter, severity, interval, type, startIdx, recordSize, columnHeader);
        }
        catch (Exception e) {
            logger.warn((Object)"DbHealtWS caught exception in printEventTable():", (Throwable)e);
            throw new SanServiceException("Cannot print events", e);
        }
    }

    @Override
    public String exportAccountingTable(DbFilterDO dbFilter, String severity, String interval, String type, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            DbHealthWS.parseFilters(dbFilter);
            return AccountingHandler.getInstance().exportAccountingTable(dbFilter, severity, interval, type, startIdx, recordSize, columnHeader);
        }
        catch (Exception e) {
            logger.warn((Object)"DbHealthWS caught exception in exportEventTable():", (Throwable)e);
            throw new SanServiceException("Cannot export events", e);
        }
    }

    @Override
    @WebMethod(operationName="triggerReRunOfHostRedundancyCheck")
    @WebResult(name="result", partName="result")
    public void triggerReRunOfHostRedundancyCheck() throws SanServiceException {
        try {
            FMServerImpl fmServerRif = FMServerImpl.getInstance();
            fmServerRif.triggerReRunOfHostRedundancyCheck(true);
        }
        catch (Exception e) {
            logger.warn((Object)"DbHealthWS caught exception in triggerReRunOfHostRedundancyCheck():", (Throwable)e);
            throw new SanServiceException("Cannot run host redundancy check", e);
        }
    }

    @Override
    @WebMethod(operationName="clearAllHostRedundancyCheckErrors")
    @WebResult(name="result", partName="result")
    public void clearAllHostRedundancyCheckErrors() throws SanServiceException {
        try {
            HostRedundancyCheck.getInstance().clearAllHostRedundancyErrors();
        }
        catch (Exception e) {
            logger.warn((Object)"DbHealthWS caught exception in clearAllHostRedundancyCheckErrors():", (Throwable)e);
            throw new SanServiceException("Cannot run clear errors", e);
        }
    }

    @Override
    @WebMethod(operationName="hostRedundancyAddIgnoreHost")
    @WebResult(name="result", partName="result")
    public Long[] hostRedundancyAddIgnoreHost(Long[] enclosureIds) throws SanServiceException {
        return HostRedundancyCheck.getInstance().addIgnoreHost(enclosureIds);
    }

    @Override
    @WebMethod(operationName="hostRedundancyRemoveIgnoreHost")
    @WebResult(name="result", partName="result")
    public Long[] hostRedundancyRemoveIgnoreHost(Long[] enclosureIds) throws SanServiceException {
        return HostRedundancyCheck.getInstance().removeFromIgnoreHost(enclosureIds);
    }

    @Override
    @WebMethod(operationName="getHostRedundancyPathErrors")
    @WebResult(name="result", partName="result")
    public HostRedundancyErrorDO[] getHostRedundancyPathErrors() throws SanServiceException {
        HostRedundancyErrorDO[] result;
        try {
            List<HostRedundancyError> errorErrors = HostRedundancyCheck.getInstance().getAllErrors();
            result = new HostRedundancyErrorDO[errorErrors.size()];
            int index = 0;
            for (HostRedundancyError nextError : errorErrors) {
                result[index++] = new HostRedundancyErrorDO(nextError);
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"DbHealthWS caught exception in getHostRedundancyPathErrors():", e);
            throw new SanServiceException("Cannot get Host Redundancy Path Errors.", e);
        }
        return result;
    }

    @Override
    @WebMethod(operationName="getHostRedundancyPathSummary")
    @WebResult(name="result", partName="result")
    public DBEntryDO getHostRedundancyPathSummary() throws SanServiceException {
        DBEntryDO result;
        try {
            HostRedundancySummary errored;
            HostRedundancySummary skipped;
            HashMap<String, HostRedundancySummary> currentSummaryDBEntries = HostRedundancyCheck.getInstance().getAllSummaryEntries();
            result = new DBEntryDO();
            result.setColumn(new String[]{"title", "summaryType", "count", "filterType", "filterErrorIds", "lastUpdateTime", "Index"});
            DBRowDO[] rlist = new DBRowDO[HostRedundancyCheck.titles.length + 3];
            int index = 0;
            HostRedundancySummary good = currentSummaryDBEntries.get("Good");
            if (good == null) {
                good = new HostRedundancySummary("Good", 1, 0, 0, null);
            }
            if ((skipped = currentSummaryDBEntries.get("Skipped")) == null) {
                skipped = new HostRedundancySummary("Skipped", 1, 0, 0, null);
            }
            if ((errored = currentSummaryDBEntries.get("Errored")) == null) {
                errored = new HostRedundancySummary("Errored", 1, 0, 0, null);
            }
            DBRowDO nextRow = new DBRowDO();
            nextRow.setEntry(new String[]{good.getTitle(), Integer.toString(good.getSummaryType()), Integer.toString(good.getCount()), Integer.toString(good.getFilter_type()), "", good.getLastUpdateTimeStr(), Integer.toString(index)});
            rlist[index++] = nextRow;
            nextRow = new DBRowDO();
            nextRow.setEntry(new String[]{skipped.getTitle(), Integer.toString(skipped.getSummaryType()), Integer.toString(skipped.getCount()), Integer.toString(skipped.getFilter_type()), "", skipped.getLastUpdateTimeStr(), Integer.toString(index)});
            rlist[index++] = nextRow;
            nextRow = new DBRowDO();
            nextRow.setEntry(new String[]{errored.getTitle(), Integer.toString(errored.getSummaryType()), Integer.toString(errored.getCount()), Integer.toString(errored.getFilter_type()), "", errored.getLastUpdateTimeStr(), Integer.toString(index)});
            rlist[index++] = nextRow;
            for (int i = 0; i < HostRedundancyCheck.titleToErrorMap.length; ++i) {
                String nextTitle = (String)HostRedundancyCheck.titleToErrorMap[i][0];
                int[] errorIds = (int[])HostRedundancyCheck.titleToErrorMap[i][1];
                HostRedundancySummary next = currentSummaryDBEntries.get(nextTitle);
                nextRow = new DBRowDO();
                if (next == null) {
                    next = new HostRedundancySummary(nextTitle, 0, 0, 1, null);
                }
                nextRow.setEntry(new String[]{next.getTitle(), Integer.toString(next.getSummaryType()), Integer.toString(next.getCount()), Integer.toString(next.getFilter_type()), HostRedundancySummary.getFilterErrorIdsList(errorIds), next.getLastUpdateTimeStr(), Integer.toString(index)});
                rlist[index++] = nextRow;
            }
            result.setRow(rlist);
        }
        catch (Exception e) {
            result = new DBEntryDO(-1, e.toString());
        }
        return result;
    }

    @Override
    @WebMethod(operationName="getHostRedundancyIgnoredHosts")
    @WebResult(name="result", partName="result")
    public DBEntryDO getHostRedundancyIgnoredHosts() throws SanServiceException {
        DBEntryDO result;
        try {
            List<HostRedundancyIgnoredHost> ignoredHosts = HostRedundancyCheck.getInstance().getIgnoredList();
            result = new DBEntryDO();
            result.setColumn(new String[]{"hostEnclosureName", "hostEnclosureId", "type", "reason"});
            DBRowDO[] rlist = new DBRowDO[ignoredHosts.size()];
            int index = 0;
            for (HostRedundancyIgnoredHost next : ignoredHosts) {
                String nextEnclosureName = next.getHostEnclosureName();
                Long enclosureId = next.getHostEnclosureId();
                int type = next.getType();
                String reason = next.getReason();
                DBRowDO nextRow = new DBRowDO();
                nextRow.setEntry(new String[]{nextEnclosureName, Long.toString(enclosureId), Integer.toString(type), reason});
                rlist[index++] = nextRow;
            }
            result.setRow(rlist);
        }
        catch (Exception e) {
            result = new DBEntryDO(-1, e.toString());
        }
        return result;
    }

    @Override
    @WebMethod(operationName="getHostRedundancyConfiguration")
    @WebResult(name="result", partName="result")
    public DBEntryDO getHostRedundancyConfiguration() throws SanServiceException {
        DBEntryDO dto = new DBEntryDO();
        dto.setColumn(new String[]{"key", "value", "comment"});
        ArrayList<DBRowDO> properties = new ArrayList<DBRowDO>();
        ArrayList<PropertyWrapper> nu = ServerPropertyUtil.readServerProperties();
        for (PropertyWrapper property : nu) {
            String key;
            if (property == null || !HostRedundancyCheck.propertyList.contains(key = property.getKey())) continue;
            DBRowDO row = new DBRowDO();
            row.setEntry(new String[]{property.getKey(), property.getValue(), property.getComment().toString()});
            properties.add(row);
        }
        dto.setRow(properties.toArray(new DBRowDO[0]));
        return dto;
    }

    @Override
    @WebMethod(operationName="printHostRedundancyData")
    @WebResult(name="result", partName="result")
    public String printHostRedundancyData(String title, String[] columnHeader, HostRedundancyErrorDO[] gridInfo, String[] summaryHeader) throws SanServiceException {
        DBEntryDO summaryData = this.getHostRedundancyPathSummary();
        JasperPrintGenerator jasper = JasperPrintGenerator.getInstance();
        ArrayList<JasperReportBuilder> list = new ArrayList<JasperReportBuilder>();
        JasperReportBuilder subReport = jasper.generateSubReport("Error Types and Summary Counts", summaryHeader, null, summaryData);
        list.add(subReport);
        subReport = jasper.generateSubReport(title, columnHeader, null, Arrays.asList(gridInfo));
        list.add(subReport);
        return jasper.generateMultiTableReport("San Path Errors", list);
    }

    @Override
    @WebMethod(operationName="exportHostRedundancyData")
    @WebResult(name="result", partName="result")
    public String exportHostRedundancyData(String title, String[] columnHeader, HostRedundancyErrorDO[] gridInfo, String[] summaryHeader) throws SanServiceException {
        DBEntryDO summaryData = this.getHostRedundancyPathSummary();
        JasperPrintGenerator jasper = JasperPrintGenerator.getInstance();
        ArrayList<JasperReportBuilder> list = new ArrayList<JasperReportBuilder>();
        JasperReportBuilder subReport = jasper.generateSubReport("Error Types and Summary Counts", summaryHeader, null, summaryData);
        list.add(subReport);
        subReport = jasper.generateSubReport(title, columnHeader, null, Arrays.asList(gridInfo));
        list.add(subReport);
        return jasper.generateExcelMutiTableReport("San Path Errors", list);
    }

    @Override
    @WebMethod(operationName="isHostRedundancyCheckLicensed")
    @WebResult(name="result", partName="result")
    public boolean isHostRedundancyCheckLicensed() throws SanServiceException {
        try {
            return FileLicensingHelper.getInstance().areAllFabricsLicensed();
        }
        catch (Exception e) {
            throw new SanServiceException("Unable to check license state of fabrics", e);
        }
    }
}

