/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.jaxws.ep.InvalidArgumentException;
import com.cisco.dcbu.jaxws.ep.SanNotFoundException;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.san.ep.DbInventorySEI;
import com.cisco.dcbu.jaxws.san.wo.BladeDO;
import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.jaxws.san.wo.EnclosureDO;
import com.cisco.dcbu.jaxws.san.wo.EndPortDO;
import com.cisco.dcbu.jaxws.san.wo.IslDO;
import com.cisco.dcbu.jaxws.san.wo.NpvLinkDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchDO;
import com.cisco.dcbu.jaxws.san.wo.TopoDO;
import com.cisco.dcbu.jaxws.san.wo.TopoPathDO;
import com.cisco.dcbu.jaxws.san.wo.TopoTrafficDO;
import com.cisco.dcbu.jaxws.san.wo.VmDO;
import com.cisco.dcbu.jaxws.san.wo.VsanDO;
import com.cisco.dcbu.jaxws.san.wo.ZoneDO;
import com.cisco.dcbu.jaxws.wo.CapacityDO;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.jaxws.wo.NameValueDO;
import com.cisco.dcbu.lib.util.ReportUtil;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.web.dashboard.CapacityMgrHandler;
import com.cisco.dcbu.sm.server.web.inventory.EndDeviceHandler;
import com.cisco.dcbu.sm.server.web.inventory.HostEnclHandler;
import com.cisco.dcbu.sm.server.web.inventory.IslHandler;
import com.cisco.dcbu.sm.server.web.inventory.LicenseHandler;
import com.cisco.dcbu.sm.server.web.inventory.ModuleHandler;
import com.cisco.dcbu.sm.server.web.inventory.NpvLinkHandler;
import com.cisco.dcbu.sm.server.web.inventory.SwitchHandler;
import com.cisco.dcbu.sm.server.web.inventory.VsanHandler;
import com.cisco.dcbu.sm.server.web.inventory.ZoneHandler;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.topology.HostEnclTopology;
import com.cisco.dcbu.sm.server.web.util.AppGroupUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/DbInventoryWSService", urlPattern="/DbInventoryWS")
@WebService(name="DbInventoryWS", serviceName="DbInventoryService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.DbInventorySEI")
@Stateless
public class DbInventoryWS
implements DbInventorySEI {
    static Logger logger = LogManager.getLogger((String)"fms.ws");

    @Override
    @WebMethod(operationName="getNavigationInXml")
    @WebResult(name="result", partName="result")
    public String getNavigationInXml() throws SanServiceException {
        try {
            return ReportUtil.getInstance().getNavigationInXml();
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getNavigation():", e);
            throw new SanServiceException("Cannot getNavigation:", e);
        }
    }

    @Override
    @WebMethod(operationName="getVsanNavigationInXml")
    @WebResult(name="result", partName="result")
    public String getVsanNavigationInXml(boolean showVsans) throws SanServiceException {
        try {
            return ReportUtil.getInstance().getVsanNavigationInXml(showVsans);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getNavigation():", e);
            throw new SanServiceException("Cannot getNavigation:", e);
        }
    }

    @Override
    @WebMethod(operationName="getRptViewNavigation")
    @WebResult(name="result", partName="result")
    public String getRptViewNavigation() throws SanServiceException {
        try {
            return ReportUtil.getInstance().getRptViewNavigation();
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getRptViewNavigation():", e);
            throw new SanServiceException("Cannot getRptViewNavigation:", e);
        }
    }

    @Override
    @WebMethod(operationName="createAppGroup")
    @WebResult(name="result", partName="result")
    public CallResultDO createAppGroup(String gName) throws SanServiceException {
        try {
            return AppGroupUtil.getInstance().addNewGroup(gName);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in createAppGroup():", e);
            throw new SanServiceException("Cannot createAppGroup:", e);
        }
    }

    @Override
    @WebMethod(operationName="deleteAppGroup")
    @WebResult(name="result", partName="result")
    public CallResultDO deleteAppGroup(int gId) throws SanServiceException {
        try {
            return AppGroupUtil.getInstance().deleteGroup(gId);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in deleteAppGroup():", e);
            throw new SanServiceException("Cannot deleteAppGroup:", e);
        }
    }

    @Override
    @WebMethod(operationName="getAllAppGroups")
    @WebResult(name="result", partName="result")
    public DBEntryDO getAllAppGroups() throws SanServiceException {
        try {
            return AppGroupUtil.getInstance().getAllGroups();
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in createAppGroup():", e);
            throw new SanServiceException("Cannot createAppGroup:", e);
        }
    }

    @Override
    @WebMethod(operationName="getInterfaceListBySwitch")
    @WebResult(name="result", partName="result")
    public DBEntryDO getInterfaceListBySwitch(DbFilterDO dbFilter) throws SanServiceException, InvalidArgumentException {
        try {
            DBEntryDO list = EndDeviceHandler.getInstance().getInterfaceListBySwitch(dbFilter);
            if (list == null) {
                return null;
            }
            return list;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getSwitchByDbId():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getSwitchByDbId():", e);
            throw new SanServiceException("Cannot get switch by switch key:" + dbFilter.getSwitchDbId(), e);
        }
    }

    @Override
    @WebMethod(operationName="updateInterfaceSelection")
    @WebResult(name="result", partName="result")
    public CallResultDO updateInterfaceSelection(int gId, String[] infSelection) throws SanServiceException, InvalidArgumentException {
        try {
            return AppGroupUtil.getInstance().updateGroupSelection(gId, infSelection);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in updateInterfaceSelection():", e);
            throw new SanServiceException("Cannot update interface selection", e);
        }
    }

    @Override
    @WebMethod(operationName="createGroupWithMember")
    @WebResult(name="result", partName="result")
    public CallResultDO createGroupWithMember(String gName, String[] infSelection) throws SanServiceException, InvalidArgumentException {
        try {
            return AppGroupUtil.getInstance().createGroupWithMember(gName, infSelection);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in createGroupWithMember():", e);
            throw new SanServiceException("Cannot update interface selection", e);
        }
    }

    @Override
    @WebMethod(operationName="insertGroupMember")
    @WebResult(name="result", partName="result")
    public CallResultDO insertGroupMember(int gId, String[] infSelection) throws SanServiceException, InvalidArgumentException {
        try {
            return AppGroupUtil.getInstance().insertGroupMember(gId, infSelection);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in createGroupWithMember():", e);
            throw new SanServiceException("Cannot update interface selection", e);
        }
    }

    @Override
    @WebMethod(operationName="getPortGroupMember")
    @WebResult(name="result", partName="result")
    public DBEntryDO getPortGroupMember(int gId) throws SanServiceException, InvalidArgumentException {
        try {
            return AppGroupUtil.getInstance().getPortGroupMember(gId);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getPortGroupMember():", e);
            throw new SanServiceException("Cannot run getPortGroupMember", e);
        }
    }

    @Override
    @WebMethod(operationName="removeGroupMember")
    @WebResult(name="result", partName="result")
    public CallResultDO removeGroupMember(long memId) throws SanServiceException, InvalidArgumentException {
        try {
            return AppGroupUtil.getInstance().removeGroupMember(memId);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in removeGroupMember():", e);
            throw new SanServiceException("Cannot remove group member", e);
        }
    }

    @Override
    @WebMethod(operationName="getFabricOrLanID")
    @WebResult(name="result", partName="result")
    public Long[] getFabricOrLanID(long swDbID, boolean isLan) throws SanServiceException {
        return SwitchHandler.getInstance().getSwitchFabricOrLanID(swDbID, isLan);
    }

    @Override
    @WebMethod(operationName="getEndDeviceList")
    @WebResult(name="result", partName="result")
    public EndPortDO[] getEndDeviceList(DbFilterDO dbFilter, String type, String status, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<EndPortDO> endPortList = EndDeviceHandler.getInstance().getEndDeviceList(dbFilter, type, status, startIdx, recordSize);
            if (endPortList.size() < recordSize) {
                recordSize = endPortList.size();
            }
            EndPortDO[] retEP = new EndPortDO[recordSize];
            for (int i = 0; i < recordSize; ++i) {
                retEP[i] = endPortList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getEndDeviceList():", e);
            throw new SanServiceException("Cannot get all endports in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getEndDevicesDataLength")
    @WebResult(name="result", partName="result")
    public int getEndDevicesDataLength(DbFilterDO dbFilter, String type, String status) throws SanServiceException {
        try {
            return EndDeviceHandler.getInstance().getEndDevicesDataLength(dbFilter, type, status);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getEndDevicesDataLength():", e);
            throw new SanServiceException("Cannot get all endports length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getZoneList")
    @WebResult(name="result", partName="result")
    public ZoneDO[] getZoneList(DbFilterDO dbFilter, int startIdx, int recordSize, boolean isIvr) throws SanServiceException {
        try {
            ArrayList<ZoneDO> zoneList = ZoneHandler.getInstance().getZoneList(dbFilter, startIdx, recordSize, isIvr);
            if (zoneList.size() < recordSize) {
                recordSize = zoneList.size();
            }
            ZoneDO[] retEP = new ZoneDO[recordSize];
            for (int i = 0; i < recordSize; ++i) {
                retEP[i] = zoneList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getZoneList():", e);
            throw new SanServiceException("Cannot get all zones in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getZonesDataLength")
    @WebResult(name="result", partName="result")
    public int getZonesDataLength(DbFilterDO dbFilter, boolean isIvr) throws SanServiceException {
        try {
            return ZoneHandler.getInstance().getZoneDataLength(dbFilter, isIvr);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getZonesDataLength():", e);
            throw new SanServiceException("Cannot get all endports length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="sendDebugInfo")
    @WebResult(name="result", partName="result")
    public int sendDebugInfo(String memoryUsage) throws SanServiceException {
        try {
            logger.info((Object)("Flex Debug Info: " + memoryUsage));
            return 0;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in sendDebugInfo():", e);
            throw new SanServiceException("Failed to show the flex debug info", e);
        }
    }

    @Override
    @WebMethod(operationName="getAllSwitches")
    @WebResult(name="result", partName="result")
    public SwitchDO[] getAllSwitches() throws SanServiceException {
        try {
            DbFilterDO dbFilter = new DbFilterDO(-1L, -1L, "", "ASC");
            dbFilter.setNetworkType("Data Center");
            int recordSize = SwitchHandler.getInstance().getSwitchDataLength(dbFilter, "All");
            ArrayList<SwitchDO> switchList = SwitchHandler.getInstance().getSwitchList(dbFilter, "All", 0, recordSize);
            if (switchList.size() < recordSize) {
                recordSize = switchList.size();
            }
            SwitchDO[] retEP = new SwitchDO[recordSize];
            for (int i = 0; i < recordSize; ++i) {
                retEP[i] = switchList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getAllSwitches():", e);
            throw new SanServiceException("Cannot get all switches in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getSwitchList")
    @WebResult(name="result", partName="result")
    public SwitchDO[] getSwitchList(DbFilterDO dbFilter, String status, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<SwitchDO> switchList = SwitchHandler.getInstance().getSwitchList(dbFilter, status, startIdx, recordSize);
            if (switchList.size() < recordSize) {
                recordSize = switchList.size();
            }
            SwitchDO[] retEP = new SwitchDO[recordSize];
            for (int i = 0; i < recordSize; ++i) {
                retEP[i] = switchList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getSwitchList():", e);
            throw new SanServiceException("Cannot get all endports in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getSwitchsDataLength")
    @WebResult(name="result", partName="result")
    public int getSwitchsDataLength(DbFilterDO dbFilter, String status) throws SanServiceException {
        try {
            return SwitchHandler.getInstance().getSwitchDataLength(dbFilter, status);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getSwitchsDataLength():", e);
            throw new SanServiceException("Cannot get all endports length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getCapacityBySwitchId")
    @WebResult(name="result", partName="result")
    public CapacityDO getCapacityBySwitchId(long switchId, int type) throws SanServiceException {
        try {
            return CapacityMgrHandler.getInstance().getCapacityBySwitchId(switchId, type);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getCapacityBySwitchId():", e);
            throw new SanServiceException("Cannot get Capacity by switch Id in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getOtherVDCList")
    @WebResult(name="result", partName="result")
    public SwitchDO[] getOtherVDCList(long switchDbId, String serialNumber) throws SanServiceException {
        try {
            SwitchDO[] vdcList = SwitchHandler.getInstance().getOtherVDCList(switchDbId, serialNumber);
            return vdcList;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getOtherVDCList():", e);
            throw new SanServiceException("Cannot get all VDCs for switch", e);
        }
    }

    @Override
    @WebMethod(operationName="getBlades")
    @WebResult(name="result", partName="result")
    public BladeDO[] getBlades(long switchDbId) throws SanServiceException {
        try {
            BladeDO[] blades = SwitchHandler.getInstance().getBlades(switchDbId);
            return blades;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getBlades():", e);
            throw new SanServiceException("Cannot get all blades or switch", e);
        }
    }

    @Override
    @WebMethod(operationName="getFeatures")
    @WebResult(name="result", partName="result")
    public NameValueDO[] getFeatures(long switchDbId, boolean isLAN) throws SanServiceException {
        try {
            NameValueDO[] featurelist = SwitchHandler.getInstance().getFeatures(switchDbId, isLAN);
            return featurelist;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getEnabledFeatures():", e);
            throw new SanServiceException("Cannot get all enabled features for switch ", e);
        }
    }

    @Override
    @WebMethod(operationName="getVsanList")
    @WebResult(name="result", partName="result")
    public VsanDO[] getVsanList(DbFilterDO dbFilter, String status, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<VsanDO> vsanList = VsanHandler.getInstance().getVsanList(dbFilter, status, startIdx, recordSize);
            if (vsanList.size() < recordSize) {
                recordSize = vsanList.size();
            }
            VsanDO[] retEP = new VsanDO[recordSize];
            for (int i = 0; i < recordSize; ++i) {
                retEP[i] = vsanList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getVsanList():", e);
            throw new SanServiceException("Cannot get all vsans in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getVsanDataLength")
    @WebResult(name="result", partName="result")
    public int getVsanDataLength(DbFilterDO dbFilter, String status) throws SanServiceException {
        try {
            return VsanHandler.getInstance().getVsanDataLength(dbFilter, status);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getVsanDataLength():", e);
            throw new SanServiceException("Cannot get all vsans length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getIslList")
    @WebResult(name="result", partName="result")
    public IslDO[] getIslList(DbFilterDO dbFilter, String status, int startIdx, int recordSize) throws SanServiceException {
        try {
            ArrayList<IslDO> islList = IslHandler.getInstance().getIslList(dbFilter, status, startIdx, recordSize);
            if (islList.size() < recordSize) {
                recordSize = islList.size();
            }
            IslDO[] retEP = new IslDO[recordSize];
            for (int i = 0; i < recordSize; ++i) {
                retEP[i] = islList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getIslList():", e);
            throw new SanServiceException("Cannot get all isls in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getIslDataLength")
    @WebResult(name="result", partName="result")
    public int getIslDataLength(DbFilterDO dbFilter, String status) throws SanServiceException {
        try {
            return IslHandler.getInstance().getIslDataLength(dbFilter, status);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getIslDataLength():", e);
            throw new SanServiceException("Cannot get all isl length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getVmHostLength")
    @WebResult(name="result", partName="result")
    public int getVmHostLength(boolean isHost) throws SanServiceException {
        try {
            return HostEnclHandler.getInstance().getVmHostDataLength(isHost);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getHostEnclDataLength():", e);
            throw new SanServiceException("Cannot get all host enclosure length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getVmHostData")
    @WebResult(name="result", partName="result")
    public VmDO[] getVmHostData(DbFilterDO dbFilter, int startIdx, int recordSize, boolean isHost) throws SanServiceException {
        try {
            ArrayList<VmDO> rstList = HostEnclHandler.getInstance().getVmHostData(dbFilter, startIdx, recordSize, isHost, null, null);
            if (rstList.size() < recordSize) {
                recordSize = rstList.size();
            }
            VmDO[] retEP = new VmDO[recordSize];
            for (int i = 0; i < recordSize; ++i) {
                retEP[i] = rstList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getVmHostData():", e);
            throw new SanServiceException("Cannot get all vm host length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getVHostDetail")
    @WebResult(name="result", partName="result")
    public VmDO getVHostDetail(long enclId, long vhostId, boolean isHost) throws SanServiceException {
        try {
            VmDO vhostObj = HostEnclHandler.getInstance().getVHostDetail(enclId, vhostId, isHost);
            return vhostObj;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getVHostDetail():", e);
            throw new SanServiceException("Cannot get all vhost detail in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getHostEnclList")
    @WebResult(name="result", partName="result")
    public EnclosureDO[] getHostEnclList(DbFilterDO dbFilter, int startIdx, int recordSize, boolean isHost) throws SanServiceException {
        try {
            ArrayList<EnclosureDO> hostEnclList = HostEnclHandler.getInstance().getHostEnclList(dbFilter, startIdx, recordSize, isHost);
            if (hostEnclList.size() < recordSize) {
                recordSize = hostEnclList.size();
            }
            EnclosureDO[] retEP = new EnclosureDO[recordSize];
            for (int i = 0; i < recordSize; ++i) {
                retEP[i] = hostEnclList.get(i);
            }
            return retEP;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getHostEnclList():", e);
            throw new SanServiceException("Cannot get all host enclosures in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getHostTrafficUtilization")
    @WebResult(name="result", partName="result")
    public TopoTrafficDO getHostTrafficUtilization(int type, long id, String name) throws SanServiceException {
        try {
            return HostEnclHandler.getInstance().getHostTrafficUtilization(type, id, name);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getHostTrafficUtilization():", e);
            throw new SanServiceException("Cannot getHostTrafficUtilization", e);
        }
    }

    @Override
    @WebMethod(operationName="getHostTrafficUtilizationAtOtherEnd")
    @WebResult(name="result", partName="result")
    public TopoTrafficDO getHostTrafficUtilizationAtOtherEnd(int type, long id, String name, int traffic_direction) throws SanServiceException {
        try {
            return HostEnclHandler.getInstance().getHostTrafficUtilizationAtOtherEnd(type, id, name, traffic_direction);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getHostTrafficUtilizationAtOtherEnd():", e);
            throw new SanServiceException("Cannot getHostTrafficUtilizationAtOtherEnd", e);
        }
    }

    @Override
    @WebMethod(operationName="renameHost")
    @WebResult(name="result", partName="result")
    public void renameHost(long id, String name) throws SanServiceException {
        try {
            HostEnclHandler.getInstance().renameHost(id, name);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in renameHost():", e);
            throw new SanServiceException("Cannot rename host", e);
        }
    }

    @Override
    @WebMethod(operationName="printHostEnclList")
    @WebResult(name="result", partName="result")
    public String printHostEnclList(String title, String[] columnHeader, DbFilterDO dbFilter, int startIdx, int recordSize, boolean isHost) throws SanServiceException {
        EnclosureDO[] rst = this.getHostEnclList(dbFilter, startIdx, recordSize, isHost);
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, Arrays.asList(rst));
    }

    @Override
    @WebMethod(operationName="exportHostEnclList")
    @WebResult(name="result", partName="result")
    public String exportHostEnclList(String title, String[] columnHeader, DbFilterDO dbFilter, int startIdx, int recordSize, boolean isHost) throws SanServiceException {
        EnclosureDO[] rst = this.getHostEnclList(dbFilter, startIdx, recordSize, isHost);
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, Arrays.asList(rst));
    }

    @Override
    @WebMethod(operationName="getHostEnclEvts")
    @WebResult(name="result", partName="result")
    public DBEntryDO getHostEnclEvts(long encId, int startIdx, int recordSize, boolean isHost) throws SanServiceException {
        try {
            return HostEnclHandler.getInstance().getHostEnclEvts(encId, startIdx, recordSize, isHost);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getHostEnclEvts():", e);
            throw new SanServiceException("Cannot get all host enclosures in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getLanEvts")
    @WebResult(name="result", partName="result")
    public DBEntryDO getLanEvts(long lanHostId, int startIdx, int recordSize) throws SanServiceException {
        try {
            return HostEnclHandler.getInstance().getLanEvts(lanHostId, startIdx, recordSize);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getLanEvts():", e);
            throw new SanServiceException("Cannot get all host enclosures in san", e);
        }
    }

    @Override
    @WebMethod(operationName="printHostEnclEvts")
    @WebResult(name="result", partName="result")
    public String printHostEnclEvts(String title, String[] columnHeader, long encId, int startIdx, int recordSize, boolean isHost) throws SanServiceException {
        DBEntryDO dbEntryDO = HostEnclHandler.getInstance().getHostEnclEvts(encId, startIdx, recordSize, isHost);
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, dbEntryDO);
    }

    @Override
    @WebMethod(operationName="printLanEvts")
    @WebResult(name="result", partName="result")
    public String printLanEvts(String title, String[] columnHeader, long lanHostId, int startIdx, int recordSize) throws SanServiceException {
        DBEntryDO dbEntryDO = HostEnclHandler.getInstance().getLanEvts(lanHostId, startIdx, recordSize);
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, dbEntryDO);
    }

    @Override
    @WebMethod(operationName="exportHostEnclEvts")
    @WebResult(name="result", partName="result")
    public String exportHostEnclEvts(String title, String[] columnHeader, long encId, int startIdx, int recordSize, boolean isHost) throws SanServiceException {
        DBEntryDO dbEntryDO = HostEnclHandler.getInstance().getHostEnclEvts(encId, startIdx, recordSize, isHost);
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, dbEntryDO);
    }

    @Override
    @WebMethod(operationName="exportLanEvts")
    @WebResult(name="result", partName="result")
    public String exportLanEvts(String title, String[] columnHeader, long lanHostId, int startIdx, int recordSize) throws SanServiceException {
        DBEntryDO dbEntryDO = HostEnclHandler.getInstance().getLanEvts(lanHostId, startIdx, recordSize);
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, dbEntryDO);
    }

    @Override
    @WebMethod(operationName="getHostEnclEvtsLength")
    @WebResult(name="result", partName="result")
    public long getHostEnclEvtsLength(long encId, boolean isHost) throws SanServiceException {
        try {
            return HostEnclHandler.getInstance().getHostEnclEvtsLength(encId, isHost);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getHostEnclEvtsLength():", e);
            throw new SanServiceException("Cannot get all host enclosures in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getLanEvtsLength")
    @WebResult(name="result", partName="result")
    public long getLanEvtsLength(long lanHostId) throws SanServiceException {
        try {
            return HostEnclHandler.getInstance().getLanEvtsLength(lanHostId);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getLanEvtsLength():", e);
            throw new SanServiceException("Cannot get all host enclosures in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getHostEnclDataLength")
    @WebResult(name="result", partName="result")
    public int getHostEnclDataLength(DbFilterDO dbFilter, boolean isHost) throws SanServiceException {
        try {
            return HostEnclHandler.getInstance().getHostEnclDataLength(dbFilter, isHost);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getHostEnclDataLength():", e);
            throw new SanServiceException("Cannot get all host enclosure length in san", e);
        }
    }

    @Override
    @WebMethod(operationName="getHostEnclGraph")
    @WebResult(name="result", partName="result")
    public TopoDO getHostEnclGraph(String[] encNames, Long[] encIds, long width, long height, boolean isHost) throws SanServiceException, InvalidArgumentException {
        return this.getHostOrStorageEnclGraph(encNames, encIds, null, null, width, height, isHost);
    }

    @Override
    @WebMethod(operationName="getHostEnclGraph")
    @WebResult(name="result", partName="result")
    public TopoDO getHostOrStorageEnclGraph(String[] encNames, Long[] encIds, Long[] hostIds, Long[] vhostIds, long width, long height, boolean isHost) throws SanServiceException, InvalidArgumentException {
        try {
            return HostEnclTopology.getInstance().getHostOrStorageEnclGraph(encNames, encIds, hostIds, vhostIds, width, height, isHost);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"DbInventoryWS caught exception in getHostEnclGraph():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getHostEnclGraph():", e);
            throw new SanServiceException("DbInventoryWS caught exception in getHostEnclGraph():" + e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="printHostOrStorageEnclGrid")
    @WebResult(name="result", partName="result")
    public String printHostOrStorageEnclGrid(String title, String[] columnHeader, TopoPathDO[] data) throws SanServiceException {
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "hostPortName", "hostPortNameDisplayStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "stgPortName", "stgPortNameDisplayStr");
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, Arrays.asList(data));
    }

    @Override
    @WebMethod(operationName="exportHostOrStorageEnclGrid")
    @WebResult(name="result", partName="result")
    public String exportHostOrStorageEnclGrid(String title, String[] columnHeader, TopoPathDO[] data) throws SanServiceException {
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "hostPortName", "hostPortNameDisplayStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "stgPortName", "stgPortNameDisplayStr");
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, Arrays.asList(data));
    }

    @Override
    @WebMethod(operationName="getNpvLinkList")
    @WebResult(name="result", partName="result")
    public NpvLinkDO[] getNpvLinkList(DbFilterDO dbFilter, String status, int startIdx, int recordSize) throws SanServiceException {
        try {
            List<NpvLinkDO> npvLinkList = NpvLinkHandler.getInstance().getList(dbFilter, status, startIdx, recordSize);
            if (npvLinkList == null) {
                return new NpvLinkDO[0];
            }
            return npvLinkList.toArray(new NpvLinkDO[0]);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getNpvLinkList():", e);
            throw new SanServiceException("Cannot get all NPV links in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="getNpvLinkDataLength")
    @WebResult(name="result", partName="result")
    public int getNpvLinkDataLength(DbFilterDO dbFilter, String status) throws SanServiceException {
        try {
            return NpvLinkHandler.getInstance().getDataLength(dbFilter, status);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getNpvLinkDataLength():", e);
            throw new SanServiceException("Cannot get NPV link data length in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="getLicenseList")
    @WebResult(name="result", partName="result")
    public DBEntryDO getLicenseList(DbFilterDO dbFilter, String status, int startIdx, int recordSize) throws SanServiceException, SanNotFoundException {
        try {
            DBEntryDO list = LicenseHandler.getInstance().getList(dbFilter, status, startIdx, recordSize);
            if (list == null) {
                throw new SanNotFoundException("can not get License list  :" + list);
            }
            return list;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getLicenseList():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getNpvLinkList():", e);
            throw new SanServiceException("Cannot get all license in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="getLicenseBySwitch")
    @WebResult(name="result", partName="result")
    public DBEntryDO getLicenseBySwitch(DbFilterDO dbFilter) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            DBEntryDO list = LicenseHandler.getInstance().getList(dbFilter);
            if (list == null) {
                throw new SanNotFoundException("can not get License Switch  :" + list);
            }
            return list;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getLicenseBySwitch():", (Throwable)e);
            throw e;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getLicenseBySwitch():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getLicenseBySwitch():", e);
            throw new SanServiceException("Cannot get license by switch", e);
        }
    }

    @Override
    @WebMethod(operationName="getLicenseDataLength")
    @WebResult(name="result", partName="result")
    public int getLicenseDataLength(DbFilterDO dbFilter, String status) throws SanServiceException {
        try {
            return LicenseHandler.getInstance().getDataLength(dbFilter, status);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getLicenseDataLength():", e);
            throw new SanServiceException("Cannot get license data length in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="getModuleList")
    @WebResult(name="result", partName="result")
    public DBEntryDO getModuleList(DbFilterDO dbFilter, String status, int startIdx, int recordSize) throws SanServiceException, SanNotFoundException {
        try {
            DBEntryDO list = ModuleHandler.getInstance().getList(dbFilter, status, startIdx, recordSize);
            if (list == null) {
                throw new SanNotFoundException("can not get Module list  :" + list);
            }
            return list;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getModuleList():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getModuleList():", e);
            throw new SanServiceException("Cannot get all module in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="getModulesBySwitch")
    @WebResult(name="result", partName="result")
    public DBEntryDO getModulesBySwitch(DbFilterDO dbFilter) throws SanServiceException, SanNotFoundException {
        try {
            DBEntryDO list = ModuleHandler.getInstance().getListBySwitch(dbFilter);
            if (list == null) {
                throw new SanNotFoundException("can not get Modules by switch  :" + list);
            }
            return list;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getModulesBySwitch():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getModuleList():", e);
            throw new SanServiceException("Cannot get modules by switch", e);
        }
    }

    @Override
    @WebMethod(operationName="getModuleDataLength")
    @WebResult(name="result", partName="result")
    public int getModuleDataLength(DbFilterDO dbFilter, String status) throws SanServiceException {
        try {
            return ModuleHandler.getInstance().getDataLength(dbFilter, status);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getModuleDataLength():", e);
            throw new SanServiceException("Cannot get module data length in SAN", e);
        }
    }

    @Override
    @WebMethod(operationName="renewServerSession")
    @WebResult(name="result", partName="result")
    public int renewServerSession(String fmSessionId) throws SanServiceException, InvalidArgumentException {
        try {
            if (fmSessionId != null && fmSessionId.length() > 0) {
                FMServerImpl.getInstance().whereami(Integer.parseInt(fmSessionId));
            }
            return 0;
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"DbInventoryWS caught exception in renewServerSession():", (Throwable)e);
            return -1;
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in renewServerSession():", e);
            return -2;
        }
    }

    @Override
    @WebMethod(operationName="getStartupStatus")
    @WebResult(name="result", partName="result")
    public int getStartupStatus() throws SanServiceException, InvalidArgumentException {
        int status = 0;
        try {
            return DbUtil.getPostgresPerfStatus();
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"DbInventoryWS caught exception in getStartupStatus():", (Throwable)e);
        }
        catch (Throwable e) {
            logger.warn((Object)"DbInventoryWS caught exception in getStartupStatus():", e);
        }
        return status;
    }

    @Override
    public String printIslTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return IslHandler.getInstance().printIslTable(dbFilter, status, startIdx, recordSize, columnHeader);
    }

    @Override
    public String exportIslTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return IslHandler.getInstance().exportIslTable(dbFilter, status, startIdx, recordSize, columnHeader);
    }

    @Override
    public String printModuleTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            return ModuleHandler.getInstance().printModuleTable(dbFilter, status, startIdx, recordSize, columnHeader);
        }
        catch (Exception e) {
            logger.warn((Object)"DbInventoryWS caught exception in printModuleTable():", (Throwable)e);
            throw new SanServiceException("Cannot print modules", e);
        }
    }

    @Override
    public String exportModuleTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            return ModuleHandler.getInstance().exportModuleTable(dbFilter, status, startIdx, recordSize, columnHeader);
        }
        catch (Exception e) {
            logger.warn((Object)"DbInventoryWS caught exception in exportModuleTable():", (Throwable)e);
            throw new SanServiceException("Cannot export modules", e);
        }
    }

    @Override
    public String printSwitchTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return SwitchHandler.getInstance().printSwitchTable(dbFilter, status, startIdx, recordSize, columnHeader);
    }

    @Override
    public String exportSwitchTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return SwitchHandler.getInstance().exportSwitchTable(dbFilter, status, startIdx, recordSize, columnHeader);
    }

    @Override
    public String printLicenseTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            return LicenseHandler.getInstance().printLicenseTable(dbFilter, status, startIdx, recordSize, columnHeader);
        }
        catch (Exception e) {
            logger.warn((Object)"DbInventoryWS caught exception in printLicenseTable():", (Throwable)e);
            throw new SanServiceException("Cannot print license", e);
        }
    }

    @Override
    public String exportLicenseTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            return LicenseHandler.getInstance().exportLicenseTable(dbFilter, status, startIdx, recordSize, columnHeader);
        }
        catch (Exception e) {
            logger.warn((Object)"DbInventoryWS caught exception in exportLicenseTable():", (Throwable)e);
            throw new SanServiceException("Cannot export license", e);
        }
    }

    @Override
    public String printNpvLinkTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            return NpvLinkHandler.getInstance().printNpvLinkTable(dbFilter, status, startIdx, recordSize, columnHeader);
        }
        catch (Exception e) {
            logger.warn((Object)"DbInventoryWS caught exception in printNpvLinkTable():", (Throwable)e);
            throw new SanServiceException("Cannot print NpvLink Table", e);
        }
    }

    @Override
    public String exportNpvLinkTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        try {
            return NpvLinkHandler.getInstance().exportNpvLinkTable(dbFilter, status, startIdx, recordSize, columnHeader);
        }
        catch (Exception e) {
            logger.warn((Object)"DbInventoryWS caught exception in exportNpvLinkTable():", (Throwable)e);
            throw new SanServiceException("Cannot export NpvLink Table", e);
        }
    }

    @Override
    public String printVsanTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return VsanHandler.getInstance().printVsanTable(dbFilter, status, startIdx, recordSize, columnHeader);
    }

    @Override
    public String exportVsanTable(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return VsanHandler.getInstance().exportVsanTable(dbFilter, status, startIdx, recordSize, columnHeader);
    }

    @Override
    public String printZoneTable(DbFilterDO dbFilter, int startIdx, int recordSize, boolean isIvr, String[] columnHeader) throws SanServiceException {
        return ZoneHandler.getInstance().printZoneTable(dbFilter, startIdx, recordSize, isIvr, columnHeader);
    }

    @Override
    public String exportZoneTable(DbFilterDO dbFilter, int startIdx, int recordSize, boolean isIvr, String[] columnHeader) throws SanServiceException {
        return ZoneHandler.getInstance().exportZoneTable(dbFilter, startIdx, recordSize, isIvr, columnHeader);
    }

    @Override
    public String printEndDeviceTable(DbFilterDO dbFilter, String edType, String edStatus, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return EndDeviceHandler.getInstance().printEndDeviceTable(dbFilter, edType, edStatus, startIdx, recordSize, columnHeader);
    }

    @Override
    public String exportEndDeviceTable(DbFilterDO dbFilter, String edType, String edStatus, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        return EndDeviceHandler.getInstance().exportEndDeviceTable(dbFilter, edType, edStatus, startIdx, recordSize, columnHeader);
    }
}

