/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.jaxws.ep.InvalidArgumentException;
import com.cisco.dcbu.jaxws.ep.SanNotFoundException;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.ep.WSSnmpException;
import com.cisco.dcbu.jaxws.san.ep.ProtocolSEI;
import com.cisco.dcbu.jaxws.san.helper.SanHelper;
import com.cisco.dcbu.jaxws.san.helper.SnmpHelper;
import com.cisco.dcbu.jaxws.san.wo.CfsFeatureOpShowCfgOptionDO;
import com.cisco.dcbu.jaxws.san.wo.FabricKeyDO;
import com.cisco.dcbu.jaxws.san.wo.FcipProfileDO;
import com.cisco.dcbu.jaxws.san.wo.FcipTunnelDO;
import com.cisco.dcbu.jaxws.san.wo.FcipTunnelErrorDO;
import com.cisco.dcbu.jaxws.san.wo.FspfConfigDO;
import com.cisco.dcbu.jaxws.san.wo.FspfInterfaceConfigDO;
import com.cisco.dcbu.jaxws.san.wo.IPSettingsDO;
import com.cisco.dcbu.jaxws.san.wo.NtpPeerInfoDO;
import com.cisco.dcbu.jaxws.san.wo.NtpSysInfoDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchIntKeyDO;
import com.cisco.dcbu.jaxws.san.wo.TCPSettingsDO;
import com.cisco.dcbu.jaxws.san.wo.WwnKeyDO;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/ProtocolWSService", urlPattern="/ProtocolWS")
@WebService(name="Protocol", serviceName="ProtocolService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.ProtocolSEI")
@Stateless
public class ProtocolWS
implements ProtocolSEI {
    static Logger logger = LogManager.getLogger((String)"fms.ws");

    @Override
    @WebMethod(operationName="getNtpPeers")
    @WebResult(name="result", partName="result")
    public NtpPeerInfoDO[] getNtpPeers(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey, @WebParam(name="cfsView", partName="cfsView") CfsFeatureOpShowCfgOptionDO cfsView) throws WSSnmpException, InvalidArgumentException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryNTPPeers(sw, cfsView);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getNtpInfo")
    @WebResult(name="result", partName="result")
    public NtpSysInfoDO getNtpInfo(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryNTPSystem(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getFspfConfig")
    @WebResult(name="result", partName="result")
    public FspfConfigDO[] getFspfConfig(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.querySFPF(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getInterfaceFspfConfig")
    @WebResult(name="result", partName="result")
    public FspfInterfaceConfigDO[] queryInterfaceFspf(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey, @WebParam(name="vsanId", partName="vsanId") short vsanId) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryInterfaceFSPF(sw, vsanId);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getFcipProfiles")
    @WebResult(name="result", partName="result")
    public FcipProfileDO[] getFcipProfiles(@WebParam(name="key", partName="key") FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricPK pk = new FabricPK(key.getFid());
            SwitchImpl[] sw = SanManager.getInstance().getSwitchesForFabric(pk);
            if (sw == null) {
                throw new SanNotFoundException("Cannot get switch with the fabric key");
            }
            ArrayList<FcipProfileDO> retList = new ArrayList<FcipProfileDO>();
            for (int i = 0; i < sw.length; ++i) {
                ArrayList<FcipProfileDO> profiles = SnmpHelper.queryFCIPProfiles(sw[i]);
                retList.addAll(profiles);
            }
            if (retList.size() == 0) {
                return new FcipProfileDO[0];
            }
            return retList.toArray(new FcipProfileDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcipProfiles():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcipProfiles():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcipProfiles():", e);
            throw new SanServiceException("Cannot get FCIP profile information by fabric key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcipProfilesBySwitch")
    @WebResult(name="result", partName="result")
    public FcipProfileDO[] getFcipProfilesBySwitch(@WebParam(name="key", partName="key") WwnKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw != null) {
                ArrayList<FcipProfileDO> retList = SnmpHelper.queryFCIPProfiles(sw);
                return retList.toArray(new FcipProfileDO[0]);
            }
            throw new SanNotFoundException("Unable to get fcip profile");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcipProfiles():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcipProfiles():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcipProfiles():", e);
            throw new SanServiceException("Cannot get FCIP profile information by switch key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcipProfile")
    @WebResult(name="result", partName="result")
    public FcipProfileDO getFcipProfile(@WebParam(name="key", partName="key") WwnKeyDO key, @WebParam(name="entityId", partName="entityId") int entityId) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw != null) {
                return SnmpHelper.queryFCIPProfile(sw, entityId);
            }
            throw new SanNotFoundException("cannot find switch");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcipProfile():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcipProfile():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcipProfile():", e);
            throw new SanServiceException("Cannot get FCIP profile information by switch key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcipTunnels")
    @WebResult(name="result", partName="result")
    public FcipTunnelDO[] getFcipTunnels(@WebParam(name="key", partName="key") FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricPK pk = new FabricPK(key.getFid());
            SwitchImpl[] sw = SanManager.getInstance().getSwitchesForFabric(pk);
            if (sw == null) {
                throw new SanNotFoundException("Cannot get switch for fabric");
            }
            ArrayList<FcipTunnelDO> retList = new ArrayList<FcipTunnelDO>();
            for (int i = 0; i < sw.length; ++i) {
                ArrayList<FcipTunnelDO> tunnels = SnmpHelper.queryFCIPTunnels(sw[i]);
                retList.addAll(tunnels);
            }
            if (retList.size() == 0) {
                return new FcipTunnelDO[0];
            }
            return retList.toArray(new FcipTunnelDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcipTunnels():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcipTunnels():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcipTunnels():", e);
            throw new SanServiceException("Cannot get FCIP Tunnel information by fabric key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcipTunnelsBySwitch")
    @WebResult(name="result", partName="result")
    public FcipTunnelDO[] getFcipTunnelsBySwitch(@WebParam(name="key", partName="key") WwnKeyDO key) throws SanServiceException, InvalidArgumentException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw != null) {
                ArrayList<FcipTunnelDO> retList = SnmpHelper.queryFCIPTunnels(sw);
                return retList.toArray(new FcipTunnelDO[0]);
            }
            return new FcipTunnelDO[0];
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcipTunnelsBySwitch():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcipTunnelsBySwitch():", e);
            throw new SanServiceException("Cannot get FCIP Tunnel information by fabric key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcipTunnelByLinkIndex")
    @WebResult(name="result", partName="result")
    public FcipTunnelDO getFcipTunnelByLinkIndex(@WebParam(name="key", partName="key") WwnKeyDO key, @WebParam(name="linkIndex", partName="linkIndex") int linkIndex) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            FcipTunnelDO[] tunnels = this.getFcipTunnelsBySwitch(key);
            if (tunnels == null) {
                throw new SanNotFoundException("Couldn't get tunnels");
            }
            for (FcipTunnelDO t : tunnels) {
                if (t.getLinkIndex() != linkIndex) continue;
                return t;
            }
            throw new SanNotFoundException("Couldn't get tunnels");
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"Exception caught in getFcipTunnelByLinkIndex(key,linkIndex");
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"Exception caught in getFcipTunnelByLinkIndex(key,linkIndex");
            throw new SanServiceException("Exception caught in getFcipTunnelByLinkIndex(key,linkIndex)");
        }
    }

    @Override
    @WebMethod(operationName="getFcipTunnelByLinkIfIndex")
    @WebResult(name="result", partName="result")
    public FcipTunnelDO getFcipTunnelByLinkIfIndex(@WebParam(name="key", partName="key") WwnKeyDO key, @WebParam(name="linkIfIndex", partName="linkIfIndex") int linkIfIndex) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            FcipTunnelDO[] tunnels = this.getFcipTunnelsBySwitch(key);
            if (tunnels == null) {
                throw new SanNotFoundException("Couldn't get tunnels");
            }
            for (FcipTunnelDO t : tunnels) {
                if (t.getLinkIfIndex() != linkIfIndex) continue;
                return t;
            }
            throw new SanNotFoundException("Couldn't get tunnels");
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"Exception caught in getFcipTunnelByLinkIndex(key,linkIfndex");
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"Exception caught in getFcipTunnelByLinkIndex(key,linkIfndex");
            throw new SanServiceException("Exception caught in getFcipTunnelByLinkIndex(key,linkIfndex)");
        }
    }

    @Override
    @WebMethod(operationName="getFcipTunnelErrors")
    @WebResult(name="result", partName="result")
    public FcipTunnelErrorDO[] getFcipTunnelErrors(@WebParam(name="key", partName="key") FabricKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid fabric key:" + key);
            }
            FabricPK pk = new FabricPK(key.getFid());
            SwitchImpl[] sw = SanManager.getInstance().getSwitchesForFabric(pk);
            if (sw == null) {
                throw new SanNotFoundException("Cannot find switch");
            }
            ArrayList<FcipTunnelErrorDO> retList = new ArrayList<FcipTunnelErrorDO>();
            for (int i = 0; i < sw.length; ++i) {
                ArrayList<FcipTunnelErrorDO> errors = SnmpHelper.queryFCIPTunnelErrors(sw[i]);
                retList.addAll(errors);
            }
            if (retList.size() == 0) {
                return new FcipTunnelErrorDO[0];
            }
            return retList.toArray(new FcipTunnelErrorDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcipTunnelErrors():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getFcipTunnelErrors():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcipTunnelErrors():", e);
            throw new SanServiceException("Cannot get FCIP Tunnel Error information by fabric key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getFcipTunnelErrorsBySwitch")
    @WebResult(name="result", partName="result")
    public FcipTunnelErrorDO[] getFcipTunnelErrorsBySwitch(@WebParam(name="key", partName="key") WwnKeyDO key) throws SanServiceException, InvalidArgumentException {
        try {
            ArrayList<FcipTunnelErrorDO> retList = null;
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch key:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw != null) {
                retList = SnmpHelper.queryFCIPTunnelErrors(sw);
                return retList.toArray(new FcipTunnelErrorDO[0]);
            }
            return new FcipTunnelErrorDO[0];
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getFcipTunnelErrors():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getFcipTunnelErrors():", e);
            throw new SanServiceException("Cannot get FCIP Tunnel Error information by fabric key:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getIpSettingsBySwitch")
    @WebResult(name="result", partName="result")
    public IPSettingsDO[] getIpSettingsBySwitch(@WebParam(name="key", partName="key") WwnKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch wwn:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw == null) {
                throw new SanNotFoundException("Cannot find switch by switch wwn");
            }
            ArrayList<IPSettingsDO> retList = new ArrayList<IPSettingsDO>();
            IPSettingsDO ipsetting = SnmpHelper.queryIPSettings(sw);
            if (ipsetting != null) {
                List<FcPortBase> fcipPorts = sw.findFcipPorts();
                for (FcPortBase fcb : fcipPorts) {
                    IPSettingsDO ips = new IPSettingsDO(fcb);
                    ips.setDefaultTimeToLive(ipsetting.getDefaultTimeToLive());
                    ips.setFragmentationTimeout(ipsetting.getFragmentationTimeout());
                    ips.setEnableForwarding(ipsetting.isEnableForwarding());
                    retList.add(ips);
                }
            }
            if (retList.size() == 0) {
                return new IPSettingsDO[0];
            }
            return retList.toArray(new IPSettingsDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getIpSettingsBySwitch():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getIpSettingsBySwitch():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getIpSettingsBySwitch:", e);
            throw new SanServiceException("Cannot get fcip ports by switch wwn:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getIpSettings")
    @WebResult(name="result", partName="result")
    public IPSettingsDO getIpSettings(@WebParam(name="portKey", partName="portKey") SwitchIntKeyDO fcipPortKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            FcPortBase fpb;
            if (fcipPortKey == null) {
                throw new InvalidArgumentException("Invalid switch interface key:" + fcipPortKey);
            }
            WwnKey wwnKey = new WwnKey(new Wwn(fcipPortKey.getSwKey()));
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                logger.warn((Object)("Cannot find switch by switch wwn:" + wwnKey));
                throw new SanNotFoundException("Cannot Find Switch");
            }
            IPSettingsDO ips = SnmpHelper.queryIPSettings(sw);
            if (ips != null && (fpb = sw.findPort(fcipPortKey.getIndex())) != null) {
                ips.setPortKey(fcipPortKey);
                return ips;
            }
            throw new SanNotFoundException("Cannot find IpSettings");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getIpSettings():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getIpSettings():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getIpSettings():", e);
            throw new SanServiceException("Cannot get FCIP port by key:" + fcipPortKey, e);
        }
    }

    @Override
    @WebMethod(operationName="getTcpSettingsBySwitch")
    @WebResult(name="result", partName="result")
    public TCPSettingsDO[] getTcpSettingsBySwitch(@WebParam(name="key", partName="key") WwnKeyDO key) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (key == null) {
                throw new InvalidArgumentException("Invalid switch wwn:" + key);
            }
            SwitchImpl sw = SanHelper.findSwitch(key.toWwnKey());
            if (sw == null) {
                throw new SanNotFoundException("Cannot find switch by switch wwn");
            }
            List<FcPortBase> fcipPorts = sw.findFcipPorts();
            ArrayList<TCPSettingsDO> retList = new ArrayList<TCPSettingsDO>();
            for (FcPortBase fcb : fcipPorts) {
                TCPSettingsDO tcps = new TCPSettingsDO(fcb);
                retList.add(tcps);
            }
            if (retList.size() == 0) {
                return new TCPSettingsDO[0];
            }
            return retList.toArray(new TCPSettingsDO[0]);
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getTcpSettingsBySwitch():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getTcpSettingsBySwitch():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getTcpSettingsBySwitch:", e);
            throw new SanServiceException("Cannot get fcip ports by switch wwn:" + key, e);
        }
    }

    @Override
    @WebMethod(operationName="getTcpSettings")
    @WebResult(name="result", partName="result")
    public TCPSettingsDO getTcpSettings(@WebParam(name="portKey", partName="portKey") SwitchIntKeyDO fcipPortKey) throws SanServiceException, InvalidArgumentException, SanNotFoundException {
        try {
            if (fcipPortKey == null) {
                throw new InvalidArgumentException("Invalid switch interface key:" + fcipPortKey);
            }
            WwnKey wwnKey = new WwnKey(new Wwn(fcipPortKey.getSwKey()));
            SwitchImpl sw = SanHelper.findSwitch(wwnKey);
            if (sw == null) {
                logger.warn((Object)("Cannot find switch by switch wwn:" + wwnKey));
                throw new SanNotFoundException("Cannot find switch");
            }
            TCPSettingsDO tcps = null;
            FcPortBase fpb = sw.findPort(fcipPortKey.getIndex());
            if (fpb != null) {
                tcps = new TCPSettingsDO(fpb);
            }
            if (tcps != null) {
                return tcps;
            }
            throw new SanNotFoundException("Exception caught in getTcpSettings");
        }
        catch (InvalidArgumentException e) {
            logger.warn((Object)"SanWS caught exception in getTcpSettings():", (Throwable)e);
            throw e;
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SanWS caught exception in getTcpSettings():", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.warn((Object)"SanWS caught exception in getTcpSettings():", e);
            throw new SanServiceException("Cannot get FCIP port by key:" + fcipPortKey, e);
        }
    }
}

