/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.jaxws.san.ep;

import com.cisco.dcbu.jaxws.ep.SanNotFoundException;
import com.cisco.dcbu.jaxws.ep.WSSnmpException;
import com.cisco.dcbu.jaxws.san.ep.SecuritySEI;
import com.cisco.dcbu.jaxws.san.helper.SanHelper;
import com.cisco.dcbu.jaxws.san.helper.SnmpHelper;
import com.cisco.dcbu.jaxws.san.wo.AaaAppServerGroupDO;
import com.cisco.dcbu.jaxws.san.wo.AaaProtocolDO;
import com.cisco.dcbu.jaxws.san.wo.AaaServerGroupDO;
import com.cisco.dcbu.jaxws.san.wo.FeatureControlDO;
import com.cisco.dcbu.jaxws.san.wo.IPProfileDO;
import com.cisco.dcbu.jaxws.san.wo.IPsecCryptoMapSetDO;
import com.cisco.dcbu.jaxws.san.wo.IPsecTunnelConfigDO;
import com.cisco.dcbu.jaxws.san.wo.IPsecTunnelDO;
import com.cisco.dcbu.jaxws.san.wo.IPsecXformSetDO;
import com.cisco.dcbu.jaxws.san.wo.IkeInitiatorConfigDO;
import com.cisco.dcbu.jaxws.san.wo.IkePolicyConfigDO;
import com.cisco.dcbu.jaxws.san.wo.IkeRecoveryConfigDO;
import com.cisco.dcbu.jaxws.san.wo.IkeTunnelDO;
import com.cisco.dcbu.jaxws.san.wo.PkiActionInfoDO;
import com.cisco.dcbu.jaxws.san.wo.PkiCertInfoDO;
import com.cisco.dcbu.jaxws.san.wo.PkiRsaKeyPairDO;
import com.cisco.dcbu.jaxws.san.wo.PkiTrustPointDO;
import com.cisco.dcbu.jaxws.san.wo.SshInfoDO;
import com.cisco.dcbu.jaxws.san.wo.SwSnmpUserInfoDO;
import com.cisco.dcbu.jaxws.san.wo.WwnKeyDO;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import javax.ejb.Stateless;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.ws.api.annotation.WebContext;

@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
@HandlerChain(file="../../ep/fms-jaxws-handlers.xml")
@WebContext(contextRoot="/SecurityWSService", urlPattern="/SecurityWS")
@WebService(name="Security", serviceName="SecurityService", endpointInterface="com.cisco.dcbu.jaxws.san.ep.SecuritySEI")
@Stateless
public class SecurityWS
implements SecuritySEI {
    static Logger logger = LogManager.getLogger((String)"fms.ws");

    @Override
    @WebMethod(operationName="getAaaAppServer")
    @WebResult(name="result", partName="result")
    public int getAaaMaxServer(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryAAAMaxServers(sw);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getAaaMaxAppServer")
    @WebResult(name="result", partName="result")
    public int getAaaMaxAppServer(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryAAAMaxAppServers(sw);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="isClearAcctLogSet")
    @WebResult(name="result", partName="result")
    public boolean isClearAcctLogSet(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.isClearAccLogSet(sw);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="isMSCHAPRequired")
    @WebResult(name="result", partName="result")
    public boolean isMSCHAPRequired(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.isMSCHAPRequired(sw);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e.getMessage());
        }
    }

    @Override
    @WebMethod(operationName="getAaaSetup")
    @WebResult(name="result", partName="result")
    public AaaProtocolDO[] getAaaSetup(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryAAA(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getAaaAppServerGroups")
    @WebResult(name="result", partName="result")
    public AaaAppServerGroupDO[] getAaaAppServerGroups(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryAAAAppServerGroup(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getAaaServerGroups")
    @WebResult(name="result", partName="result")
    public AaaServerGroupDO[] getAaaServerGroups(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryAAAServerGroup(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getSnmpUsers")
    @WebResult(name="result", partName="result")
    public SwSnmpUserInfoDO[] getSnmpUsers(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.querySnmpUser(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getIPACLProfiles")
    @WebResult(name="result", partName="result")
    public IPProfileDO[] getIPACLProfiles(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryIPACLProfiles(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getSSHConfig")
    @WebResult(name="result", partName="result")
    public SshInfoDO getSSHConfig(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException, SanNotFoundException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            if (SnmpHelper.querySsh(sw) == null) {
                throw new SanNotFoundException("Cannot get ssh config ");
            }
            return SnmpHelper.querySsh(sw);
        }
        catch (SanNotFoundException e) {
            logger.warn((Object)"SecurityWS caught exception in getComponent():", (Throwable)e);
            throw e;
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="isSSHEnabled")
    @WebResult(name="result", partName="result")
    public boolean getSSHEnabled(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.isSSHEnabled(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="isTelnetEnabled")
    @WebResult(name="result", partName="result")
    public boolean isTelnetEnabled(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.isTelnetEnabled(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getPkiRsaKeys")
    @WebResult(name="result", partName="result")
    public PkiRsaKeyPairDO[] getPkiRsaKeys(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryRSAKeyPair(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getPkiTrustPointNames")
    @WebResult(name="result", partName="result")
    public String[] getPkiTrustPointNames(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryPKITrustPointNames(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getPkiCert")
    @WebResult(name="result", partName="result")
    public PkiCertInfoDO getPkiCert(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey, @WebParam(name="trustPointName", partName="trustPointName") String name) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryPKICert(sw, name);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getPkiAction")
    @WebResult(name="result", partName="result")
    public PkiActionInfoDO getPkiAction(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey, @WebParam(name="trustPointName", partName="trustPointName") String name) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryPKIAction(sw, name);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getPkiTrustPoint")
    @WebResult(name="result", partName="result")
    public PkiTrustPointDO getPkiTrustPoint(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey, @WebParam(name="trustPointName", partName="trustPointName") String name) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryPKITrustPoint(sw, name);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getFeatureControls")
    @WebResult(name="result", partName="result")
    public FeatureControlDO[] getFeatureControls(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryFeatureCtrl(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getIkeFailRecoveryCfg")
    @WebResult(name="result", partName="result")
    public IkeRecoveryConfigDO getIkeFailRecoveryCfg(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryIKEFailureRecoveryCfg(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getIkeCfgPolicies")
    @WebResult(name="result", partName="result")
    public IkePolicyConfigDO[] getIkeCfgPolicies(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryIKECfgPolicies(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getIkeCfgInitiators")
    @WebResult(name="result", partName="result")
    public IkeInitiatorConfigDO[] getIkeCfgInitiators(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryIKECfgInitiators(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getIkeTunnels")
    @WebResult(name="result", partName="result")
    public IkeTunnelDO[] getIkeTunnels(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryIKETunnels(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getIPsecGlobalCfg")
    @WebResult(name="result", partName="result")
    public IPsecTunnelConfigDO getIPsecGlobalCfg(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryIPsecGlobal(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getIPsecXformSets")
    @WebResult(name="result", partName="result")
    public IPsecXformSetDO[] getIPsecXformSets(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryIPsecXform(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getIPsecCryptoMaps")
    @WebResult(name="result", partName="result")
    public IPsecCryptoMapSetDO[] getIPsecCryptoMaps(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryIPsecCryptMaps(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getIfsFromCryptoMap")
    @WebResult(name="result", partName="result")
    public String[] getIfsFromCryptoMap(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey, @WebParam(name="cryptoMapName", partName="cryptoMapName") String cryptoMapName) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryIfFromCryptMap(sw, cryptoMapName);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="getIPsecTunnels")
    @WebResult(name="result", partName="result")
    public IPsecTunnelDO[] getIPsecTunnels(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryIPsecTunnels(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }

    @Override
    @WebMethod(operationName="isFipsModeEnabled")
    @WebResult(name="result", partName="result")
    public boolean isFipsModeEnabled(@WebParam(name="swKey", partName="swKey") WwnKeyDO swKey) throws WSSnmpException {
        try {
            SwitchImpl sw = SanHelper.findSwitch(swKey.toWwnKey());
            return SnmpHelper.queryFIPSModeEnabled(sw);
        }
        catch (SnmpException e) {
            logger.error((Object)e.getMessage());
            throw new WSSnmpException(e);
        }
    }
}

